/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.prePlan;

import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.rqp.RQPPrePlan;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.CubeContextManager;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.PrePlanUtilities;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.SetOfTables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public final class PrePlanResult {
    private volatile PrePlanResultState state = PrePlanResultState.PREPLAN_STATE_UNINITIALIZED;
    private final HashMap<String, SetOfTables> result = new HashMap();
    private final List<IMetadata> joins = new ArrayList<IMetadata>();
    private boolean bridgeQuery = false;
    private volatile CountDownLatch gate = null;
    private Map<String, Boolean> objs = null;
    private Set<String> dims = null;
    private HashMap<String, List<IEmbeddedFilter>> dimEmbeddedFilterMap = new HashMap();
    private TreeMap<String, String> macroMap;
    List<IEmbeddedFilter> embeddedFilters;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrePlanResultState startCaching(IPlanningEnvironment planEnv, Map<String, Boolean> requiredTables, Set<String> requiredDims) {
        if (this.state == PrePlanResultState.PREPLAN_STATE_CACHED || this.state == PrePlanResultState.PREPLAN_STATE_INVALID) {
            return this.state;
        }
        PrePlanResult prePlanResult = this;
        synchronized (prePlanResult) {
            if (this.state == PrePlanResultState.PREPLAN_STATE_UNINITIALIZED) {
                this.state = PrePlanResultState.PREPLAN_STATE_PLANNING_INPROGRESS;
                this.gate = new CountDownLatch(1);
                this.objs = requiredTables;
                this.dims = requiredDims;
                this.macroMap = (TreeMap)planEnv.getRequestEnvironment().getResolvedMacros().clone();
                return this.state;
            }
        }
        if (this.state == PrePlanResultState.PREPLAN_STATE_PLANNING_INPROGRESS) {
            boolean good = false;
            try {
                good = this.gate.await(4L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                good = false;
            }
            if (good && this.state == PrePlanResultState.PREPLAN_STATE_CACHED) {
                if (!MacroExpander.macrosResolveToSameValues(this.getMacros(), planEnv)) {
                    CubeContextManager.getCubeContextManager().incrementPreplanCacheMisses();
                    return PrePlanResultState.PREPLAN_STATE_NOT_REUSABLE;
                }
                CubeContextManager.getCubeContextManager().incrementPreplanCacheHits();
            }
            if (!good) {
                PrePlanResult prePlanResult2 = this;
                synchronized (prePlanResult2) {
                    this.state = PrePlanResultState.PREPLAN_STATE_INVALID;
                    return this.state;
                }
            }
            return this.state;
        }
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCaching(IPlanningEnvironment environment, RQPPrePlan prePlan) {
        List<String> promts = PrePlanUtilities.getInvolvedPrompts(prePlan);
        if (!promts.isEmpty()) {
            PrePlanResult prePlanResult = this;
            synchronized (prePlanResult) {
                this.state = PrePlanResultState.PREPLAN_STATE_INVALID;
                this.gate.countDown();
            }
        }
        this.bridgeQuery = PrePlanUtilities.isBridgeQuery(prePlan);
        this.joins.addAll(PrePlanUtilities.getAllJoins(prePlan));
        this.embeddedFilters = PrePlanUtilities.getInvolvedEmbeddedFilters(prePlan);
        ArrayList<String> originalMetadataIdentifiers = new ArrayList<String>();
        for (Map.Entry<String, Boolean> entry : this.objs.entrySet()) {
            originalMetadataIdentifiers.clear();
            originalMetadataIdentifiers.add(entry.getKey());
            this.result.put(entry.getKey(), PrePlanUtilities.getInvolvedTablesFromOriginalIdentifiers(prePlan, originalMetadataIdentifiers, entry.getValue()));
        }
        this.saveMacrosResolvedDuringPreplanning(environment);
        for (String dim : this.dims) {
            this.dimEmbeddedFilterMap.put(dim, PrePlanUtilities.getInvolvedEmbeddedFiltersByDimension(prePlan, dim));
        }
        PrePlanResult prePlanResult = this;
        synchronized (prePlanResult) {
            this.state = PrePlanResultState.PREPLAN_STATE_CACHED;
            this.gate.countDown();
        }
    }

    public void saveMacrosResolvedDuringPreplanning(IPlanningEnvironment environment) {
        TreeMap<String, String> allMacros = environment.getRequestEnvironment().getResolvedMacros();
        TreeMap<String, String> addedMacros = new TreeMap<String, String>();
        for (Map.Entry<String, String> entry : allMacros.entrySet()) {
            if (this.macroMap.containsKey(entry.getKey())) continue;
            addedMacros.put(entry.getKey(), entry.getValue());
        }
        this.macroMap = addedMacros;
    }

    public SetOfTables getInvolvedTablesFromOriginalIdentifiers(List<String> originalMetadataIdentifiers) {
        SetOfTables r = new SetOfTables();
        for (String name : originalMetadataIdentifiers) {
            SetOfTables tb = this.result.get(name);
            if (tb == null) continue;
            r.append(tb);
        }
        return r;
    }

    public List<IEmbeddedFilter> getInvolvedEmbeddedFiltersByDimension(String originalMetadataIdentifiers) {
        if (this.dimEmbeddedFilterMap.containsKey(originalMetadataIdentifiers)) {
            return this.dimEmbeddedFilterMap.get(originalMetadataIdentifiers);
        }
        return Collections.emptyList();
    }

    public List<IEmbeddedFilter> getInvolvedEmbeddedFilters() {
        return this.embeddedFilters;
    }

    public void getAllJoins(List<IMetadata> allJoins) {
        allJoins.addAll(this.joins);
    }

    public PrePlanResultState getState() {
        return this.state;
    }

    public TreeMap<String, String> getMacros() {
        return this.macroMap;
    }

    public boolean isBridgeQuery() {
        return this.bridgeQuery;
    }

    public static enum PrePlanResultState {
        PREPLAN_STATE_INVALID,
        PREPLAN_STATE_UNINITIALIZED,
        PREPLAN_STATE_PLANNING_INPROGRESS,
        PREPLAN_STATE_CACHED,
        PREPLAN_STATE_NOT_REUSABLE;

    }
}

