/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.prePlan;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryItem;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPPrePlan;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundParameter;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.PrePlanResult;
import com.cognos.xqe.transformation.v5tocogsql.prePlan.SetOfTables;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;

public class PrePlanUtilities {
    public static SetOfTables getInvolvedTables(RQPPrePlan prePlan, List<IMetadata> passedInQueryItems, boolean unwindASViewQS) {
        ArrayList<String> queryItems = new ArrayList<String>();
        for (IMetadata metadata : passedInQueryItems) {
            queryItems.add(metadata.getV5UniqueName());
        }
        return PrePlanUtilities.getInvolvedTablesFromOriginalIdentifiers(prePlan, queryItems, unwindASViewQS);
    }

    public static SetOfTables getInvolvedTablesFromOriginalIdentifiers(RQPPrePlan prePlan, List<String> originalMetadataIdentifiers, boolean unwindASViewQS) {
        boolean notReady = false;
        if (notReady) {
            SetOfTables setOfTables = new SetOfTables();
            return setOfTables;
        }
        Object cache = prePlan.getPropertyValue("cachedResult");
        if (cache != null) {
            return ((PrePlanResult)cache).getInvolvedTablesFromOriginalIdentifiers(originalMetadataIdentifiers);
        }
        RQPQuery rqpQuery = (RQPQuery)prePlan.getFirstDescendantOfTypeOrdered(801017, false);
        TreeSet<String> unwoundDSQS = new TreeSet<String>();
        List<IMetadata> queryItems = PrePlanUtilities.preProcessQueryItemsFromOriginalIdentifiers(rqpQuery, originalMetadataIdentifiers, unwoundDSQS);
        SetOfTables setOfTables = PrePlanUtilities.executeGetInvolvedTables(rqpQuery, queryItems, unwindASViewQS);
        for (String dsqs : unwoundDSQS) {
            setOfTables.add(dsqs);
        }
        return setOfTables;
    }

    public static List<IEmbeddedFilter> getInvolvedEmbeddedFiltersByDimension(RQPPrePlan prePlan, String originalMetadataIdentifiers) {
        ArrayList<IEmbeddedFilter> embeddedFilters = new ArrayList<IEmbeddedFilter>();
        if (prePlan == null) {
            return embeddedFilters;
        }
        Object cache = prePlan.getPropertyValue("cachedResult");
        if (cache != null) {
            return ((PrePlanResult)cache).getInvolvedEmbeddedFiltersByDimension(originalMetadataIdentifiers);
        }
        RQPQuery rqpQuery = (RQPQuery)prePlan.getFirstDescendantOfTypeOrdered(801017, false);
        if (rqpQuery == null) {
            return embeddedFilters;
        }
        ArrayList<IMetadata> queryItems = new ArrayList<IMetadata>();
        RQPProjectionList rqpProjectionList = (RQPProjectionList)rqpQuery.getFirstChildByType(801016);
        IXQEQueryNode[] projections = rqpProjectionList.getChildren();
        for (IXQEQueryNode projection : projections) {
            RQPDataItem dataItem = (RQPDataItem)projection;
            String originalMetadataIdentifierValue = (String)dataItem.getPropertyValue("originalMetadataIdentifier");
            if (originalMetadataIdentifierValue == null || !originalMetadataIdentifierValue.startsWith(originalMetadataIdentifiers)) continue;
            PrePlanUtilities.collectAllMetadata(dataItem, queryItems);
        }
        for (IMetadata queryItem : queryItems) {
            if (!(queryItem instanceof IQueryItem) || ((IQueryItem)queryItem).getQuerySubject() == null) continue;
            embeddedFilters.addAll(((IQueryItem)queryItem).getQuerySubject().getFilters());
        }
        return embeddedFilters;
    }

    public static List<IEmbeddedFilter> getInvolvedEmbeddedFilters(RQPPrePlan prePlan) {
        ArrayList<IEmbeddedFilter> embeddedFilters = new ArrayList<IEmbeddedFilter>();
        if (prePlan == null) {
            return embeddedFilters;
        }
        Object cache = prePlan.getPropertyValue("cachedResult");
        if (cache != null) {
            return ((PrePlanResult)cache).getInvolvedEmbeddedFilters();
        }
        RQPQuery rqpQuery = (RQPQuery)prePlan.getFirstDescendantOfTypeOrdered(801017, false);
        if (rqpQuery == null) {
            return embeddedFilters;
        }
        ArrayList<IMetadata> queryItems = new ArrayList<IMetadata>();
        RQPProjectionList rqpProjectionList = (RQPProjectionList)rqpQuery.getFirstChildByType(801016);
        IXQEQueryNode[] projections = rqpProjectionList.getChildren();
        for (IXQEQueryNode projection : projections) {
            RQPDataItem dataItem = (RQPDataItem)projection;
            PrePlanUtilities.collectAllMetadata(dataItem, queryItems);
        }
        for (IMetadata queryItem : queryItems) {
            if (!(queryItem instanceof IQueryItem)) continue;
            embeddedFilters.addAll(((IQueryItem)queryItem).getQuerySubject().getFilters());
        }
        return embeddedFilters;
    }

    private static SetOfTables executeGetInvolvedTables(RQPQuery rqpQuery, List<IMetadata> queryItems, boolean unwindASViewQS) {
        SetOfTables setOfTables = new SetOfTables();
        IXQEQueryNode[] listOfRmQueryList = rqpQuery.getDescendantsOfType(801032, false);
        block0: for (IMetadata queryItem : queryItems) {
            for (IXQEQueryNode rmQueryList : listOfRmQueryList) {
                TreeSet<String> tables = new TreeSet<String>();
                PrePlanUtilities.getTables(queryItem, rmQueryList, tables, unwindASViewQS);
                if (tables.size() <= 0) continue;
                for (String table : tables) {
                    setOfTables.add(table);
                }
                continue block0;
            }
        }
        return setOfTables;
    }

    private static void getTables(IMetadata metadata, IXQEQueryNode rmQueryList, TreeSet<String> tables, boolean unwindASViewQS) {
        block12: {
            RMQuery rmQuery;
            block13: {
                IXQEQueryNode[] items;
                rmQuery = null;
                String uniqueName = null;
                if (metadata instanceof IMeasure) {
                    IMeasure measure = (IMeasure)metadata;
                    rmQuery = ((RMQueryList)rmQueryList).getRMQuery(measure.getDimension());
                    uniqueName = metadata.getV5UniqueName();
                } else {
                    IQueryItem queryItem = (IQueryItem)metadata;
                    IQuerySubject querySubject = queryItem.getQuerySubject();
                    rmQuery = ((RMQueryList)rmQueryList).getRMQuery(querySubject);
                    uniqueName = queryItem.getV5UniqueName();
                }
                if (rmQuery == null) {
                    return;
                }
                if (rmQuery.getType() != 801029) break block13;
                if (!unwindASViewQS || rmQuery.getChildrenOfType(801036).length > 0) {
                    tables.add(rmQuery.getName());
                    return;
                }
                IXQEQueryNode rmQueryItemList = rmQuery.getFirstChildByType(801034);
                for (IXQEQueryNode rmItem : items = rmQueryItemList.getChildren()) {
                    IXQEQueryNode[] identifiers;
                    RMQueryItem rmQI = (RMQueryItem)rmItem;
                    String rmQIName = rmQI.getV5UniqueName();
                    if (!rmQIName.equals(uniqueName)) continue;
                    for (IXQEQueryNode id : identifiers = rmQI.getDescendantsOfType(201116, false)) {
                        V5BoundModelIdentifier v5BMId = (V5BoundModelIdentifier)id;
                        IMetadata met = v5BMId.getMetadata();
                        PrePlanUtilities.getTables(met, rmQueryList, tables, unwindASViewQS);
                    }
                    break block12;
                }
                break block12;
            }
            if (rmQuery.getType() != 801028 && rmQuery.getType() != 801027) break block12;
            if (!unwindASViewQS || rmQuery.getChildrenOfType(801036).length > 0) {
                tables.add(rmQuery.getName());
                return;
            }
            IXQEQueryNode[] sqlRelations = rmQuery.getDescendantsOfType(301016, false);
            if (sqlRelations.length == 0) {
                IXQEQueryNode[] sqlRangeVars;
                IXQEQueryNode[] iXQEQueryNodeArray = sqlRangeVars = rmQuery.getDescendantsOfType(301007, false);
                int n = iXQEQueryNodeArray.length;
                for (int i = 0; i < n; ++i) {
                    IXQEQueryNode sqlRangeVar = iXQEQueryNodeArray[i];
                    SQLRangeVar rangeVar = (SQLRangeVar)sqlRangeVar;
                    tables.add(rangeVar.getName());
                }
            }
            for (IXQEQueryNode sqlRelation : sqlRelations) {
                SQLRelation relation = (SQLRelation)sqlRelation;
                String dbName = relation.getDatabaseName();
                String catalogName = relation.getCatalogName();
                String schemaName = relation.getSchemaName();
                String tableName = relation.getName();
                String dot = ".";
                StringBuilder qualifiedTableName = new StringBuilder();
                qualifiedTableName.append(dbName);
                qualifiedTableName.append(dot);
                if (catalogName != null) {
                    qualifiedTableName.append(catalogName);
                }
                qualifiedTableName.append(dot);
                if (schemaName != null) {
                    qualifiedTableName.append(schemaName);
                }
                qualifiedTableName.append(dot);
                qualifiedTableName.append(tableName);
                tables.add(qualifiedTableName.toString());
            }
        }
    }

    private static List<IMetadata> preProcessQueryItemsFromOriginalIdentifiers(RQPQuery rootQuery, List<String> originalMetadataIdentifiers, TreeSet<String> unwoundDSQS) {
        ArrayList<IMetadata> queryItems = new ArrayList<IMetadata>();
        RQPProjectionList rqpProjectionList = (RQPProjectionList)rootQuery.getFirstChildByType(801016);
        for (String omi : originalMetadataIdentifiers) {
            RQPDataItem dataItem = PrePlanUtilities.findDataItemByName(rqpProjectionList, omi);
            if (dataItem == null) continue;
            PrePlanUtilities.collectAllMetadata(dataItem, queryItems);
            TreeSet propDSQS = (TreeSet)dataItem.getPropertyValue("prePlanUnwoundDSQS");
            if (propDSQS == null) continue;
            unwoundDSQS.addAll(propDSQS);
        }
        return queryItems;
    }

    private static RQPDataItem findDataItemByName(RQPProjectionList rqpProjectionList, String originalMetadataIdentifier) {
        String originalMetadataIdentifierValue;
        RQPDataItem dataItem;
        IXQEQueryNode[] projections;
        for (IXQEQueryNode projection : projections = rqpProjectionList.getChildren()) {
            dataItem = (RQPDataItem)projection;
            originalMetadataIdentifierValue = (String)dataItem.getPropertyValue("originalMetadataIdentifier");
            if (originalMetadataIdentifierValue == null || !originalMetadataIdentifierValue.equals(originalMetadataIdentifier)) continue;
            return dataItem;
        }
        for (IXQEQueryNode projection : projections) {
            dataItem = (RQPDataItem)projection;
            originalMetadataIdentifierValue = (String)dataItem.getPropertyValue("originalMetadataIdentifier");
            if (originalMetadataIdentifierValue == null) continue;
            int size = originalMetadataIdentifierValue.length();
            if (size > originalMetadataIdentifier.length()) {
                return null;
            }
            if (!originalMetadataIdentifierValue.regionMatches(0, originalMetadataIdentifier, 0, size)) continue;
            return dataItem;
        }
        return null;
    }

    private static void collectAllMetadata(IXQEQueryNode node, List<IMetadata> queryItems) {
        List<IXQEQueryNode> allDescendants = node.getDescendantsOfTypesOrdered(new int[]{201116, 801009}, false);
        for (IXQEQueryNode descendant : allDescendants) {
            if (descendant.getType() == 201116) {
                V5BoundModelIdentifier boundModelIdentifier = (V5BoundModelIdentifier)descendant;
                queryItems.add(boundModelIdentifier.getMetadata());
                continue;
            }
            RQPDataItemRef dataItemRef = (RQPDataItemRef)descendant;
            RQPDataItem dataItem = dataItemRef.getNextReferencedItem();
            PrePlanUtilities.collectAllMetadata(dataItem, queryItems);
        }
    }

    public static List<String> getInvolvedPrompts(RQPPrePlan prePlan) {
        IXQEQueryNode[] listOfRmQueryList;
        ArrayList<String> promptNames = new ArrayList<String>();
        Object cache = prePlan.getPropertyValue("cachedResult");
        if (cache != null) {
            return promptNames;
        }
        RQPQuery rqpQuery = (RQPQuery)prePlan.getFirstDescendantOfTypeOrdered(801017, false);
        for (IXQEQueryNode rmQueryList : listOfRmQueryList = rqpQuery.getDescendantsOfType(801032, false)) {
            IXQEQueryNode[] listOfV5BoundParameter;
            for (IXQEQueryNode v5BoundParameter : listOfV5BoundParameter = rmQueryList.getDescendantsOfType(201127, false)) {
                V5BoundParameter prompt = (V5BoundParameter)v5BoundParameter;
                String promptName = prompt.getParameterName();
                if (promptName == null || promptName.isEmpty()) continue;
                promptNames.add(promptName);
            }
        }
        return promptNames;
    }

    public static List<IMetadata> getAllJoins(RQPPrePlan prePlan) {
        ArrayList<IMetadata> allJoins = new ArrayList<IMetadata>();
        Object cache = prePlan.getPropertyValue("cachedResult");
        if (cache != null) {
            ((PrePlanResult)cache).getAllJoins(allJoins);
        } else {
            IXQEQueryNode[] listOfRQPJoinPaths;
            RQPQuery rqpQuery = (RQPQuery)prePlan.getFirstDescendantOfTypeOrdered(801017, false);
            for (IXQEQueryNode jp : listOfRQPJoinPaths = rqpQuery.getDescendantsOfType(801039, false)) {
                if (jp.getAncestorOfType(801032) != null) continue;
                RQPJoinPath joinPath = (RQPJoinPath)jp;
                List<IMetadata> joins = joinPath.getJoinPath();
                allJoins.addAll(joins);
            }
        }
        return allJoins;
    }

    public static boolean isBridgeQuery(RQPPrePlan prePlan) {
        IXQEQueryNode[] factManagers;
        Object cache = prePlan.getPropertyValue("cachedResult");
        if (cache != null) {
            return ((PrePlanResult)cache).isBridgeQuery();
        }
        for (IXQEQueryNode fm : factManagers = prePlan.getDescendantsOfType(801042, false)) {
            RQPFactManager factManager = (RQPFactManager)fm;
            if (!factManager.isUsingBridge()) continue;
            return true;
        }
        return false;
    }
}

