/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.prePlan;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp.V5BoundMemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundToMetadata;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.wrapper.IMeasureWrapper;
import com.cognos.xqe.metadata.wrapper.MeasureWrapper;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.trace.XQETrace;
import com.cognos.xqe.transformation.dmr.DMRUtilities;
import com.cognos.xqe.transformation.dmr.ReplaceDMRBoundIdentifierWithExpression;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqeqte.QTEAbstractTransformation;

public class ReplaceDimensionalReferencesByRelationalReferences
extends Transformation {
    String localExpression = "expression";

    public ReplaceDimensionalReferencesByRelationalReferences(int[] passNumbers) {
        this.mName = "ReplaceDimensionalReferencesByRelationalReferences";
        this.mPassNumbers = passNumbers;
        this.mTypes = new int[]{201116, 201117};
        this.mApplicableIterations = QTEAbstractTransformation.ApplicableIterations.UNLIMITED;
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        IHierarchy hier;
        V5DataItem dataItem = (V5DataItem)node.getAncestorOfType(101003);
        IXQEQueryNode theNode = node;
        IDimension dim = null;
        if (node.getType() == 201116) {
            hier = ((V5BoundModelIdentifier)node).getHierarchy();
            if (hier != null) {
                dim = hier.getDimension();
            }
        } else {
            hier = ((V5BoundMemberUniqueName)node).getHierarchy();
            if (hier != null) {
                dim = hier.getDimension();
            }
        }
        V5BoundToMetadata boundToMetadata = (V5BoundToMetadata)node;
        IMetadata metadata = boundToMetadata.getMetadata();
        String originalMetadataIdentifierValue = metadata.getV5UniqueName();
        String defaultRoleType = ReplaceDMRBoundIdentifierWithExpression.resolveRoleType(boundToMetadata);
        if (ReplaceDMRBoundIdentifierWithExpression.isConvertibleToRelational(metadata)) {
            String expression = ReplaceDMRBoundIdentifierWithExpression.getModelIdentifierExpression(environment, boundToMetadata, defaultRoleType);
            if (expression != null) {
                IXQEQueryNode tree = RQPUtilities.createV5ValueExpressionMetadata(expression, environment, null, DMRUtilities.getWrapped(metadata));
                node.exchange(tree);
                theNode = tree;
            }
            if (expression == null && metadata instanceof IMeasureWrapper) {
                MeasureWrapper mw = (MeasureWrapper)metadata;
                IMeasure wrapped = mw.getWrapped();
                XQENodeFactory nodeFactory = environment.getNodeFactory();
                V5BoundModelIdentifier newNode = (V5BoundModelIdentifier)nodeFactory.createNode(201116);
                newNode.setIdentifier(wrapped.getV5UniqueName());
                newNode.setMetadata(wrapped);
                node.exchange(newNode);
                theNode = newNode;
            }
        }
        if (dataItem != null && dataItem.getPropertyValue("originalMetadataIdentifier") == null) {
            dataItem.setPropertyValue("originalMetadataIdentifier", originalMetadataIdentifierValue);
        }
        MetadataContext.flagMetadataObjectIfRequired(dim, theNode);
    }

    @Override
    public boolean passesNodeCondition(IXQEQueryNode node, PlanningEnvironment environment) {
        XQETrace trace = environment.getTrace();
        V5BoundToMetadata boundToMetadata = (V5BoundToMetadata)node;
        IMetadata metadata = boundToMetadata.getMetadata();
        if (metadata == null) {
            this.traceNodeCondition(false, "Identifier is not bound to metadata.", trace);
            return false;
        }
        V5DataItem dataItem = (V5DataItem)node.getAncestorOfType(101003);
        if (!ReplaceDMRBoundIdentifierWithExpression.isConvertibleToRelational(metadata)) {
            if (dataItem != null && dataItem.getPropertyValue("originalMetadataIdentifier") == null) {
                this.traceNodeCondition(true, "Must stamp with identifier", trace);
                return true;
            }
            this.traceNodeCondition(false, "There is no need to replace such an item", trace);
            return false;
        }
        String defaultRoleType = ReplaceDMRBoundIdentifierWithExpression.resolveRoleType(boundToMetadata);
        String expression = ReplaceDMRBoundIdentifierWithExpression.getModelIdentifierExpression(environment, boundToMetadata, defaultRoleType);
        if (expression != null && expression.equals(boundToMetadata.getIdentifier())) {
            if (dataItem != null && dataItem.getPropertyValue("originalMetadataIdentifier") == null) {
                this.traceNodeCondition(true, "Must stamp with identifier.", trace);
                return true;
            }
            this.traceNodeCondition(false, "There is no need to replace such an item.", trace);
            return false;
        }
        if (metadata instanceof IMeasureWrapper && metadata.getProperty(this.localExpression) == null) {
            this.traceNodeCondition(true, "Replace the MeasureWrapper by the measure", trace);
            return true;
        }
        if (metadata instanceof IMeasure && metadata.getProperty(this.localExpression) == null) {
            this.traceNodeCondition(false, "Do not replace null measures.", trace);
            return false;
        }
        this.traceNodeCondition(true, "Replace dimensional references by relational references.", trace);
        return true;
    }
}

