/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.provider.IMetadataConnection;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class FJOCache {
    ConcurrentMap<Set<String>, List<IXQEQueryNode>> filterCache = new ConcurrentHashMap<Set<String>, List<IXQEQueryNode>>();
    boolean isEnabled = false;
    private IUsageIndicator cacheHits;
    private IUsageIndicator cacheMisses;
    private IUsageIndicator cacheCalls;
    private IUsageIndicator cacheTime;

    public FJOCache() {
        XQEConfiguration cfg = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.isEnabled = cfg.getBooleanProperty("general.FJOCache", true);
        if (this.isEnabled) {
            this.cacheHits = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.JOINFILTERCACHE, "cacheHits");
            this.cacheMisses = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.JOINFILTERCACHE, "cacheMisses");
            this.cacheCalls = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.JOINFILTERCACHE, "cacheCalls");
            this.cacheTime = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.JOINFILTERCACHE, "cacheTime");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IXQEQueryNode> getJoinFilter(IXQENodeFactory nodeFactory, IXQEQueryNode sqlJoin, IMetadataConnection metadataConnection, List<IXQEQueryNode> queryFilters, Parameters parameters) {
        if (!this.isEnabled) {
            return null;
        }
        HighPrecisionStopWatch timer = new HighPrecisionStopWatch(true);
        this.cacheCalls.increment();
        try {
            IRelationship relationship = (IRelationship)sqlJoin.getPropertyValue("joinRelationship");
            if (relationship == null) {
                List<IXQEQueryNode> list = null;
                return list;
            }
            Set<String> key = this.constructKey(metadataConnection, relationship, queryFilters, parameters);
            List filters = (List)this.filterCache.get(key);
            if (filters == null) {
                this.cacheMisses.increment();
                List<IXQEQueryNode> list = null;
                return list;
            }
            ArrayList<IXQEQueryNode> clonedFilters = new ArrayList<IXQEQueryNode>(filters.size());
            for (IXQEQueryNode f : filters) {
                clonedFilters.add(nodeFactory.deepCopyNode(f));
            }
            this.cacheHits.increment();
            ArrayList<IXQEQueryNode> arrayList = clonedFilters;
            return arrayList;
        }
        finally {
            this.cacheTime.add(timer.getElapsedTimeInMilliseconds());
        }
    }

    private Set<String> constructKey(IMetadataConnection metadataConnection, IRelationship relationship, List<IXQEQueryNode> queryFilters, Parameters parameters) {
        TreeSet<String> key = new TreeSet<String>();
        key.add(metadataConnection.toString());
        key.add(relationship.toString());
        for (IXQEQueryNode filter : queryFilters) {
            key.add(filter.dumpToString(false));
            List<IXQEQueryNode> sqlParameters = filter.getDescendantsOfTypeOrdered(301051, false);
            for (IXQEQueryNode p : sqlParameters) {
                SQLParameter sqlParameter = (SQLParameter)p;
                String parameterName = sqlParameter.getName();
                key.add(parameterName);
                Parameter parameter = parameters.getParameter(parameterName);
                key.add(parameter.getParameterValueItems().asDOMString("values"));
            }
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJoinFilter(IXQENodeFactory nodeFactory, List<IXQEQueryNode> filters, IXQEQueryNode sqlJoin, IMetadataConnection metadataConnection, List<IXQEQueryNode> queryFilters, Parameters parameters) {
        if (!this.isEnabled) {
            return;
        }
        HighPrecisionStopWatch timer = new HighPrecisionStopWatch(true);
        this.cacheCalls.increment();
        try {
            IRelationship relationship = (IRelationship)sqlJoin.getPropertyValue("joinRelationship");
            if (relationship == null) {
                return;
            }
            Set<String> key = this.constructKey(metadataConnection, relationship, queryFilters, parameters);
            ArrayList<IXQEQueryNode> clonedFilters = new ArrayList<IXQEQueryNode>();
            for (IXQEQueryNode f : filters) {
                clonedFilters.add(nodeFactory.deepCopyNode(f));
            }
            this.filterCache.put(key, clonedFilters);
        }
        finally {
            this.cacheTime.add(timer.getElapsedTimeInMilliseconds());
        }
    }
}

