/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPSqlKeyword;
import com.cognos.xqemoser.MoserQueryItem;
import java.io.UnsupportedEncodingException;
import java.util.Set;

public class RQPNameGenerator {
    public static final String PREFERRED_ALIAS = "preferredAlias";
    public static final String DEFAULT_COLUMN_PREFIX = "C";
    public static final String DEFAULT_TABLE_PREFIX = "T";
    private static final String UTF8 = "UTF-8";
    public static final String UNDERSCORE = "_";
    public static final int MAX_TRIES = 10000;
    public static final int MAX_ALIAS_LENGTH = 18;
    private static final int MAKE_UNIQUE_NAME_MAX_LOOPS_1 = 10;
    private static final int MAKE_UNIQUE_NAME_MAX_LOOPS_2 = 240;

    public static String generateUniqueRQPDataItemName(RQPQuery rqpQuery, String preferredName) {
        if (rqpQuery.findProjection(preferredName) == null) {
            return preferredName;
        }
        for (int i = 1; i < 10000; ++i) {
            StringBuilder newName = new StringBuilder(preferredName);
            newName.append(i);
            String newNameString = newName.toString();
            if (rqpQuery.findProjection(newNameString) != null) continue;
            return newNameString;
        }
        return null;
    }

    public static String generateUniqueAliasQueryItem(IMetadata qi) {
        if (qi instanceof MoserQueryItem) {
            return ((MoserQueryItem)qi).getName();
        }
        return qi.getCaption();
    }

    public static String generateUniqueDataItemName(V5Selection selection, String preferredName) {
        if (selection.getDataItemByRefName(preferredName) == null) {
            return preferredName;
        }
        for (int i = 1; i < 10000; ++i) {
            StringBuilder newName = new StringBuilder(preferredName);
            newName.append(i);
            String newNameString = newName.toString();
            if (selection.getDataItemByRefName(newNameString) != null) continue;
            return newNameString;
        }
        return null;
    }

    public static String generateNameForNewRQPDataItem(IXQEQueryNode node, RQPQuery summaryQuery) {
        RQPDataItem rqpDataItemAncestor;
        IXQEQueryNode parent = node.getParent();
        String rqpDataItemName = parent.getType() == 801008 ? ((RQPDataItem)parent).getName() : ((rqpDataItemAncestor = (RQPDataItem)node.getAncestorOfType(801008)) != null ? RQPNameGenerator.generateUniqueRQPDataItemName(summaryQuery, rqpDataItemAncestor.getName()) : RQPNameGenerator.generateUniqueRQPDataItemName(summaryQuery, RQPDataItem.getRQPDataItemNameForAggregateType(((V5AggregateFunction)node).getSubType())));
        return rqpDataItemName;
    }

    public static boolean isAlphaNumericUnderScore(String theString) {
        int underScoreCodePoint = UNDERSCORE.codePointAt(0);
        int numCodePoints = theString.length();
        for (int i = 0; i < numCodePoints; ++i) {
            int codePoint = theString.codePointAt(i);
            if (Character.isLetterOrDigit(codePoint) || underScoreCodePoint == codePoint) continue;
            return false;
        }
        return true;
    }

    public static String replaceNonAlphaNumericWithUnderScore(String theString) {
        StringBuilder sBuffer = new StringBuilder(theString.length());
        int underScoreCodePoint = UNDERSCORE.codePointAt(0);
        for (int i = 0; i < theString.length(); ++i) {
            int codePoint = theString.codePointAt(i);
            if (Character.isLetterOrDigit(codePoint) || underScoreCodePoint == codePoint) {
                sBuffer.append(theString.charAt(i));
                continue;
            }
            sBuffer.append(UNDERSCORE);
        }
        return sBuffer.toString();
    }

    public static String makeValidSqlIdentifier(String name) {
        name = RQPNameGenerator.replaceNonAlphaNumericWithUnderScore(name);
        StringBuilder sbName = new StringBuilder(name);
        if (name == null || name.isEmpty() || !Character.isLetter(name.codePointAt(0))) {
            sbName.insert(0, DEFAULT_COLUMN_PREFIX);
        }
        if (RQPSqlKeyword.isKeyword(sbName.toString())) {
            sbName.append("0");
        }
        return sbName.toString();
    }

    public static boolean isValidSqlIdentifier(String name, int maxLength) {
        try {
            if (name.getBytes(UTF8).length > maxLength) {
                return false;
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
        }
        if (!RQPNameGenerator.isAlphaNumericUnderScore(name)) {
            return false;
        }
        if (!Character.isLetter(name.codePointAt(0))) {
            return false;
        }
        return !RQPSqlKeyword.isKeyword(name);
    }

    public static String generateUniqueAliasName(RQPQuery query, String preferredAliasName, int maxColumnNameLength) {
        IXQEQueryNode projList = query.getFirstChildByType(801016);
        if (projList != null) {
            return RQPNameGenerator.generateUniqueAliasName(projList.getChildren(), preferredAliasName, maxColumnNameLength);
        }
        return null;
    }

    public static String generateUniqueAliasName(RMQuery query, String preferredAliasName, int maxColumnNameLength) {
        IXQEQueryNode sqlValueList = query.getFirstDescendantOfTypeOrdered(801038, false);
        if (sqlValueList == null) {
            sqlValueList = query.getFirstDescendantOfTypeOrdered(301030, false);
        }
        if (sqlValueList != null) {
            return RQPNameGenerator.generateUniqueAliasName(sqlValueList.getChildren(), preferredAliasName, maxColumnNameLength);
        }
        return null;
    }

    public static String generateUniqueAliasName(IXQEQueryNode[] projectionNodes, String preferredAliasName, int maxColumnNameLength) {
        String aliasName;
        boolean useDefault = false;
        try {
            if (preferredAliasName.getBytes(UTF8).length > maxColumnNameLength) {
                preferredAliasName = DEFAULT_COLUMN_PREFIX;
                aliasName = preferredAliasName + '1';
                useDefault = true;
            } else {
                aliasName = preferredAliasName;
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
        }
        for (int i = 1; i < 10000; ++i) {
            boolean found = false;
            for (int j = 0; j < projectionNodes.length; ++j) {
                IXQEQueryNode projection = projectionNodes[j];
                if (projection.getType() != 301028 || !((SQLAlias)projection).getName().equalsIgnoreCase(aliasName)) continue;
                aliasName = preferredAliasName + (j + 1 + i);
                found = true;
                break;
            }
            if (!found) break;
        }
        try {
            if (!useDefault && aliasName.getBytes(UTF8).length > maxColumnNameLength) {
                aliasName = RQPNameGenerator.generateUniqueAliasName(projectionNodes, preferredAliasName, 0);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
        }
        return aliasName;
    }

    public static String generateUniqueAliasName(Set<String> aliases, String preferredAliasName, int maxColumnNameLength) {
        return RQPNameGenerator.generateUniqueAliasName(aliases, preferredAliasName, maxColumnNameLength, null);
    }

    public static String generateUniqueAliasName(Set<String> aliases, String preferredAliasName, int maxColumnNameLength, String prefer) {
        String aliasName;
        boolean useDefault = false;
        try {
            if (preferredAliasName.getBytes(UTF8).length > maxColumnNameLength) {
                if (prefer != null) {
                    aliasName = prefer;
                } else {
                    preferredAliasName = DEFAULT_COLUMN_PREFIX;
                    aliasName = preferredAliasName + (aliases.size() + 1);
                }
                useDefault = true;
            } else {
                aliasName = preferredAliasName;
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
        }
        for (int i = 1; i < 10000 && aliases.contains(aliasName.toUpperCase()); ++i) {
            aliasName = preferredAliasName + (aliases.size() + i);
        }
        try {
            if (!useDefault && aliasName.getBytes(UTF8).length > maxColumnNameLength) {
                aliasName = RQPNameGenerator.generateUniqueAliasName(aliases, preferredAliasName, 0, null);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
        }
        return aliasName;
    }

    public static String getUniqueColumnOrTableName(Set<String> names, String originalName, int index, int maxLength, boolean useTablePrefix) {
        String aliasName;
        boolean useDefault = false;
        try {
            if (originalName.getBytes(UTF8).length > maxLength) {
                originalName = useTablePrefix ? DEFAULT_TABLE_PREFIX : DEFAULT_COLUMN_PREFIX;
                aliasName = originalName + index;
                useDefault = true;
            } else {
                aliasName = RQPNameGenerator.makeValidSqlIdentifier(originalName);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
        }
        if (names != null && names.contains(aliasName)) {
            aliasName = RQPNameGenerator.makeUniqueName(aliasName, names, index);
        }
        try {
            if (!useDefault && aliasName.getBytes(UTF8).length > maxLength) {
                aliasName = RQPNameGenerator.getUniqueColumnOrTableName(names, originalName, index, 0, useTablePrefix);
            }
        }
        catch (UnsupportedEncodingException ex) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)ex);
        }
        names.add(aliasName);
        return aliasName;
    }

    public static String makeUniqueName(String preferredName, Set<String> names, int index) {
        String tempStr;
        int i;
        if (!names.contains(preferredName)) {
            return preferredName;
        }
        String strIndex = preferredName + index;
        if (!names.contains(strIndex)) {
            return strIndex;
        }
        for (i = 1; i <= 10; ++i) {
            tempStr = strIndex + i;
            if (names.contains(tempStr)) continue;
            return tempStr;
        }
        strIndex = "X_";
        for (i = 1; i <= 240; ++i) {
            tempStr = strIndex + i;
            if (names.contains(tempStr)) continue;
            return tempStr;
        }
        return preferredName;
    }
}

