/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util;

import com.cognos.xqe.ast.IXQENodeFactory;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQEBaseQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPDataItemRef;
import com.cognos.xqe.ast.rqp.RQPDataItemSelfRef;
import com.cognos.xqe.ast.rqp.RQPFactManager;
import com.cognos.xqe.ast.rqp.RQPJoinInfo;
import com.cognos.xqe.ast.rqp.RQPJoinPath;
import com.cognos.xqe.ast.rqp.RQPNode;
import com.cognos.xqe.ast.rqp.RQPProjectionList;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPSql;
import com.cognos.xqe.ast.rqp.RQPSummaryQuery;
import com.cognos.xqe.ast.rqp.RQPTNode;
import com.cognos.xqe.ast.sql.SQLAlias;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLFromClause;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLProject;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLRelation;
import com.cognos.xqe.ast.sql.SQLSelect;
import com.cognos.xqe.ast.sql.SQLSetOperator;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.ast.v5.V5QueryNode;
import com.cognos.xqe.ast.v5.V5QuerySet;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5.query.V5Query;
import com.cognos.xqe.ast.v5.query.V5QueryOperation;
import com.cognos.xqe.ast.v5.query.V5Selection;
import com.cognos.xqe.ast.v5.query.V5Source;
import com.cognos.xqe.ast.v5.result.V5DataItemRef;
import com.cognos.xqe.ast.v5.result.V5ValueSet;
import com.cognos.xqe.ast.v5Exp.V5AggregateFunction;
import com.cognos.xqe.ast.v5Exp.V5BoundDataItemReference;
import com.cognos.xqe.ast.v5Exp.V5BoundModelIdentifier;
import com.cognos.xqe.ast.v5Exp.V5BoundQueryItemReference;
import com.cognos.xqe.ast.v5Exp.V5CaseExpression;
import com.cognos.xqe.ast.v5Exp.V5CastTarget;
import com.cognos.xqe.ast.v5Exp.V5ExpressionProcessor;
import com.cognos.xqe.ast.v5Exp.V5IfExpression;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp.V5SimpleNode;
import com.cognos.xqe.ast.v5Exp.V5ValueSummaryFunction;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.MultisetType;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IEmbeddedFilter;
import com.cognos.xqe.metadata.IFilter;
import com.cognos.xqe.metadata.IFolder;
import com.cognos.xqe.metadata.IMeasure;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQueryItemFolder;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IRelationshipShortcut;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.dynamic.DMQuerySubject;
import com.cognos.xqe.metadata.dynamic.DMRelationship;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.query.engine.MetadataConnectionContext;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.rsapi.RSAPIDataItem;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.v5.binding.BindV5MultiPartIdentifierToModel;
import com.cognos.xqe.transformation.v5.unwinding.UnwindV5BoundModelId;
import com.cognos.xqe.transformation.v5.util.V5FormatResolver;
import com.cognos.xqe.transformation.v5tocogsql.RQPQueryFormulation.UnwindV5BoundMultipartIdentifier;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPNameGenerator;
import com.cognos.xqe.transformation.v5tocogsql.util.itemNormalization.ItemNormalization;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.RQPJoinPathFinder;
import com.cognos.xqe.transformation.v5tocogsql.util.metadataContext.MetadataContext;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.IUndirectedGraph;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.UndirectedGraph;
import com.cognos.xqe.util.Governors;
import com.cognos.xqe.util.Timer;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.pool.XQESAXReaderPool;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqemoser.MoserMetadataConnection;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserQuerySubject;
import com.cognos.xqemoser.MoserRelationship;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class RQPUtilities {
    private static final String POUND = "#";
    private static final String COLON = ":";
    private static final String DOUBLE_COLON = "::";
    private static final int THREE = 3;
    public static final String DOT_OPEN_SQUARE_BRACKET = ".[";
    public static final String OPEN_SQUARE_BRACKET = "[";
    public static final String CLOSE_SQUARE_BRACKET = "]";
    public static final String CLOSE_OPEN_SQUARE_BRACKET = "].[";
    public static final String PROP_BOOLEAN_DISTINCT = "distinct";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    public static final int MAX_UNSIGNED_16BIT_INTEGER = 65535;
    public static final String UPPER_CASE_E = "E";
    public static final String LOWER_CASE_E = "e";
    public static final String SPLIT_CHARACTER = "\\.";
    static final Pattern PATTERN_FIXED_POINT = Pattern.compile("(-|\\+)?([0-9]+(\\.[0-9]*)?|\\.[0-9]+)");

    public static RMQueryList getRMQueryList(IXQEQueryNode node) {
        RQPQuery rqpQuery = null;
        rqpQuery = node.getType() == 801017 ? (RQPQuery)node : (RQPQuery)node.getAncestorOfType(801017);
        if (rqpQuery == null) {
            return null;
        }
        RMQueryList rmQueryList = rqpQuery.getRMQueryList();
        RQPQuery currentQuery = rqpQuery;
        while (rmQueryList == null) {
            if ((currentQuery = (RQPQuery)currentQuery.getAncestorOfType(801017)) == null) {
                return null;
            }
            rmQueryList = currentQuery.getRMQueryList();
        }
        return rmQueryList;
    }

    public static RQPFactManager getRQPFactManager(IXQEQueryNode node) {
        RQPQuery rqpQuery = null;
        rqpQuery = node.getType() == 801017 ? (RQPQuery)node : (RQPQuery)node.getAncestorOfType(801017);
        if (rqpQuery == null) {
            return null;
        }
        RQPFactManager rqpFactManager = rqpQuery.getFactManager();
        RQPQuery currentQuery = rqpQuery;
        while (rqpFactManager == null) {
            if ((currentQuery = (RQPQuery)currentQuery.getAncestorOfType(801017)) == null) {
                return null;
            }
            rqpFactManager = currentQuery.getFactManager();
        }
        return rqpFactManager;
    }

    public static V5Query getRefV5Query(IXQEQueryNode node) {
        SQLSelect sqlSelect = null;
        sqlSelect = node.getType() == 301023 ? (SQLSelect)node : (SQLSelect)node.getAncestorOfType(301023);
        String refquery = (String)sqlSelect.getPropertyValue("refQuery");
        V5QuerySet v5QuerySet = (V5QuerySet)node.getAncestorOfType(101002);
        return v5QuerySet.getV5Query(refquery);
    }

    public static void addToGroupByList(IXQEQueryNode sqlSelect, PlanningEnvironment environment, IXQEQueryNode groupingItem) {
        RQPUtilities.addToListNodeOfType(sqlSelect, environment, groupingItem, 301010, 301029);
    }

    public static void addToOrderByList(IXQEQueryNode sqlSelect, PlanningEnvironment environment, IXQEQueryNode orderByItem) {
        RQPUtilities.addToListNodeOfType(sqlSelect, environment, orderByItem, 301019, 301021);
    }

    public static void addToProjectionList(IXQEQueryNode sqlSelect, PlanningEnvironment environment, IXQEQueryNode projectionItem) {
        RQPUtilities.addToListNodeOfType(sqlSelect, environment, projectionItem, 301015, 301030);
    }

    public static IModelDataSource getModelDataSource(IQuerySubject qs) {
        String[] parts;
        String dsRef = (String)qs.getProperty("dataSourceRef");
        try {
            parts = UniqueNameParser.parse(dsRef, -1);
        }
        catch (UniqueNameParserException e) {
            return null;
        }
        dsRef = parts[parts.length - 1];
        return RQPUtilities.getModelDataSource(qs, dsRef);
    }

    public static IModelDataSource getModelDataSource(IQuerySubject qs, String dsRef) {
        MetadataConnection mdConnection = qs.getConnection();
        List<IModelDataSource> dataSources = mdConnection.getModelDataSources();
        return RQPUtilities.getModelDataSource(dataSources, dsRef);
    }

    public static IModelDataSource getModelDataSource(List<IModelDataSource> dataSources, String dsRef) {
        Iterator<IModelDataSource> dsIter = dataSources.iterator();
        IModelDataSource qsDataSource = null;
        while (dsIter.hasNext()) {
            IModelDataSource dataSource = dsIter.next();
            if (!dataSource.getName().equals(dsRef)) continue;
            qsDataSource = dataSource;
            break;
        }
        return qsDataSource;
    }

    public static IModelDataSource getModelDataSourceUsingSchemaName(List<IModelDataSource> dataSources, String schemaName, String catalogName) {
        Iterator<IModelDataSource> dsIter = dataSources.iterator();
        ArrayList<IModelDataSource> qsDataSources = new ArrayList<IModelDataSource>();
        while (dsIter.hasNext()) {
            IModelDataSource dataSource = dsIter.next();
            if (dataSource.getSchema() == null || !dataSource.getSchema().equals(schemaName) || catalogName != null && (dataSource.getCatalog() == null || dataSource.getCatalog().getName() == null || !dataSource.getCatalog().getName().equals(catalogName))) continue;
            qsDataSources.add(dataSource);
        }
        if (qsDataSources.size() == 1) {
            return (IModelDataSource)qsDataSources.get(0);
        }
        return null;
    }

    private static void addToListNodeOfType(IXQEQueryNode sqlSelect, PlanningEnvironment environment, IXQEQueryNode childNode, int nodeType, int listNodeType) {
        IXQEQueryNode node = sqlSelect.getFirstChildByType(nodeType);
        IXQEQueryNode listNode = null;
        if (node == null) {
            node = environment.getNodeFactory().createNode(nodeType);
            listNode = environment.getNodeFactory().createNode(listNodeType);
            sqlSelect.addChild(node);
            node.addChild(listNode);
        } else {
            listNode = node.getFirstChildByType(listNodeType);
        }
        listNode.addChild(childNode);
    }

    public static String getDefaultAggregateNameBasedOnDataType(IDataType dataType) {
        if (dataType == null) {
            return "count";
        }
        switch (dataType.getCCLTypeCode()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 54: 
            case 60: {
                return "total";
            }
            case 13: 
            case 14: 
            case 15: 
            case 52: 
            case 53: 
            case 57: 
            case 58: 
            case 59: {
                return "maximum";
            }
        }
        return "count";
    }

    public static int getDefaultAggregateBasedOnDataType(IDataType dataType) {
        if (dataType == null) {
            return 2;
        }
        switch (dataType.getCCLTypeCode()) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 54: 
            case 60: {
                return 9;
            }
            case 13: 
            case 14: 
            case 15: 
            case 52: 
            case 53: 
            case 57: 
            case 58: 
            case 59: {
                return 4;
            }
        }
        return 2;
    }

    public static int convertAggregateNameToV5AggregateFunctionSubtype(String aggregateName) {
        if (aggregateName.equals("sum") || aggregateName.equals("total")) {
            return 9;
        }
        if (aggregateName.equals("count") || aggregateName.equals("countDistinct")) {
            return 2;
        }
        if (aggregateName.equals("min") || aggregateName.equals("minimum") || aggregateName.equals("none")) {
            return 6;
        }
        if (aggregateName.equals("max") || aggregateName.equals("maximum")) {
            return 4;
        }
        if (aggregateName.equals("avg") || aggregateName.equals("average")) {
            return 1;
        }
        if (aggregateName.equals("median")) {
            return 5;
        }
        if (aggregateName.equals("standardDeviation")) {
            return 7;
        }
        if (aggregateName.equals("variance")) {
            return 10;
        }
        return 43;
    }

    public static boolean isGroupAggrationFunction(int aggType) {
        switch (aggType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                return true;
            }
        }
        return false;
    }

    public static IXQEQueryNode findTargetDataItem(IXQEQueryNode node, String name) {
        V5Selection selectionNode = RQPUtilities.getV5Selection(node);
        IXQEQueryNode[] dataItems = selectionNode.getChildrenOfType(101003);
        for (int i = 0; i < dataItems.length; ++i) {
            if (!name.equals(((V5DataItem)dataItems[i]).getNameProperty()) || dataItems[i] == node || null == ((V5DataItem)dataItems[i]).getAggregateExpression()) continue;
            return dataItems[i];
        }
        return null;
    }

    public static V5Selection getV5Selection(IXQEQueryNode node) {
        IXQEQueryNode queryNode = node.getAncestorOfType(101006);
        if (queryNode != null) {
            return (V5Selection)queryNode.getFirstChildByType(101009);
        }
        return null;
    }

    public static V5DataItem getV5DataItem(IXQEQueryNode node) {
        if (node.getType() == 101015) {
            V5DataItemRef dataItemRef = (V5DataItemRef)node;
            String refDataItem = dataItemRef.getDataItemRefProperty();
            return RQPUtilities.getV5DataItemInSelection(node, refDataItem);
        }
        if (node.getType() == 101003) {
            return (V5DataItem)node;
        }
        return null;
    }

    public static V5DataItem getV5DataItemInSelection(IXQEQueryNode node, String dataItemName) {
        RQPQuery rootQuery = (RQPQuery)node.getAncestorOfType(801017);
        V5Selection v5Selection = rootQuery.getRefV5Query().getV5Selection();
        return v5Selection.getDataItemByRefName(dataItemName);
    }

    public static boolean hasAggregateInExpression(IXQEQueryNode expressionNode) {
        if (expressionNode == null) {
            return false;
        }
        switch (expressionNode.getType()) {
            case 201031: 
            case 201033: 
            case 201035: 
            case 301034: {
                return true;
            }
        }
        int[] descendantTypes = new int[]{201031, 201033, 201035, 301034};
        return expressionNode.getDescendantsOfTypes(descendantTypes, false, 801017).length > 0;
    }

    public static boolean hasMovingRunningInExpression(IXQEQueryNode expressionNode) {
        if (expressionNode.getType() == 201035) {
            return true;
        }
        return expressionNode.getDescendantsOfType(201035, false).length > 0;
    }

    public static IXQEQueryNode createV5ValueExpression(IRelationship relationship, PlanningEnvironment environment, IXQEQueryNode parentNode) {
        IXQEQueryNode enode = RQPUtilities.createV5ValueExpressionMetadata(relationship.getExpression(), environment, parentNode, relationship);
        if (enode != null) {
            if (relationship instanceof IRelationshipShortcut) {
                IMetadata rightQuerySubject;
                IRelationship targetRelationship = ((IRelationshipShortcut)relationship).getRelationshipRefObject();
                IMetadata leftQuerySubject = relationship.getLeftRefObject();
                if (leftQuerySubject instanceof IShortcut) {
                    RQPUtilities.replaceQuerySubjectNameByShortcutName(enode, targetRelationship.getLeftRefObject().getID(), leftQuerySubject.getID());
                }
                if ((rightQuerySubject = relationship.getRightRefObject()) instanceof IShortcut) {
                    RQPUtilities.replaceQuerySubjectNameByShortcutName(enode, targetRelationship.getRightRefObject().getID(), rightQuerySubject.getID());
                }
            }
            MetadataContext.flagMetadataObjectIfRequired(relationship, enode);
        }
        return enode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IXQEQueryNode createV5ValueExpressionMetadata(String expression, PlanningEnvironment environment, Object parentNode, IMetadata meta) {
        try (MetadataConnectionContext metadataConnectionContext = null;){
            MetadataConnection conn;
            if (environment.isMultiModelForQueryEnabled() && (conn = meta.getConnection()) != null) {
                String modelPath = conn.getModelName();
                environment.setMetdataConnection(conn);
                metadataConnectionContext = environment.pushMetadataConnectionContext(modelPath);
            }
            if (expression == null) {
                conn = null;
                return conn;
            }
            if ((expression = MetadataUtil.extractExpressionFromModelString(expression, environment)).length() == 0) {
                conn = null;
                return conn;
            }
            if (expression.contains(POUND)) {
                MacroExpander expander = new MacroExpander();
                if (meta != null) {
                    MetadataContext mc = (MetadataContext)meta.getProperty("metadataContext");
                    if (mc == null) {
                        mc = MetadataContext.getMetadataContextForDynamicMetadata(meta);
                    }
                    if (mc != null) {
                        expander.setLocalParameters(mc.getParameters());
                    }
                }
                expression = parentNode != null ? expander.expand(parentNode, environment, expression) : expander.expand(meta, environment, expression);
            }
            IXQEQueryNode parsedExpr = V5ExpressionProcessor.parse(expression, environment, environment.getMetadataConnection().getDefaultLocale(meta));
            RQPUtilities.addAliasToMultiPartIdentifier(environment, parsedExpr, meta);
            IXQEQueryNode iXQEQueryNode = parsedExpr;
            return iXQEQueryNode;
        }
    }

    private static void addAliasToMultiPartIdentifier(PlanningEnvironment environment, IXQEQueryNode parsedExpr, IMetadata metadata) {
        if (environment == null || parsedExpr == null || metadata == null) {
            return;
        }
        MetadataConnection mdConnection = environment.getMetadataConnection();
        if (!(mdConnection instanceof MoserMetadataConnection)) {
            return;
        }
        MetadataConnection metadataMDConnection = metadata.getConnection();
        if (metadataMDConnection == null || metadataMDConnection instanceof MoserMetadataConnection) {
            return;
        }
        IXQEQueryNode[] mpIDs = parsedExpr.getDescendantsOfType(201030, true);
        if (mpIDs == null || mpIDs.length == 0) {
            return;
        }
        String alias = ((MoserMetadataConnection)mdConnection).getAliasMFWMetadataConnection(metadataMDConnection);
        if (alias == null || alias.isEmpty()) {
            return;
        }
        for (IXQEQueryNode id : mpIDs) {
            V5MultiPartIdentifier mpID = (V5MultiPartIdentifier)id;
            String[] nameParts = mpID.getNameParts();
            String[] newNameParts = new String[nameParts.length + 1];
            newNameParts[0] = alias;
            System.arraycopy(nameParts, 0, newNameParts, 1, nameParts.length);
            String newName = UniqueNameGenerator.createUniqueName(newNameParts);
            mpID.setNativeName(newName);
            mpID.setIdentifier(newName);
            mpID.setNameParts(newNameParts);
        }
    }

    public static IXQEQueryNode createV5ValueExpression(String expression, PlanningEnvironment environment, IXQEQueryNode parentNode) {
        return RQPUtilities.createV5ValueExpressionMetadata(expression, environment, parentNode, null);
    }

    public static IXQEQueryNode createV5ValueExpression(String expression, PlanningEnvironment environment, IXQEQueryNode parentNode, Locale expressionLocale) {
        if (expression == null) {
            return null;
        }
        if ((expression = MetadataUtil.extractExpressionFromModelString(expression, environment)).length() == 0) {
            return null;
        }
        if (expression.contains(POUND)) {
            MacroExpander expander = new MacroExpander();
            expression = expander.expand(parentNode, environment, expression);
        }
        return V5ExpressionProcessor.parse(expression, environment, expressionLocale);
    }

    public static IXQEQueryNode getV5ValueExpression(IMetadata metadata, PlanningEnvironment environment) {
        return RQPUtilities.getV5ValueExpression(metadata, environment, null);
    }

    public static IXQEQueryNode getV5ValueExpression(IMetadata metadata, PlanningEnvironment environment, IXQEQueryNode parentNode) {
        IXQEQueryNode node = null;
        if (metadata == null) {
            return null;
        }
        String untaggedExpression = null;
        switch (metadata.getObjectType()) {
            case QUERY_ITEM: {
                MoserQueryItem moserQI;
                if (metadata instanceof MoserQueryItem && (moserQI = (MoserQueryItem)metadata).getBinaryExpression() != null) {
                    return environment.getNodeFactory().deepCopyNode((IXQEQueryNode)moserQI.getBinaryExpression());
                }
                untaggedExpression = ((IQueryItem)metadata).getExpression();
                break;
            }
            case CALCULATION: {
                untaggedExpression = ((ICalculation)metadata).getExpression();
                break;
            }
            case EMBEDDED_FILTER: {
                untaggedExpression = ((IEmbeddedFilter)metadata).getExpression();
                break;
            }
            case FILTER: {
                untaggedExpression = ((IFilter)metadata).getExpression();
                break;
            }
            case SHORTCUT: {
                return RQPUtilities.getV5ValueExpression(((IShortcut)metadata).getTarget(), environment);
            }
            case MEMBER: {
                if (metadata instanceof IMeasure) {
                    untaggedExpression = ((IMeasure)metadata).getExpression();
                    break;
                }
                return null;
            }
            default: {
                return null;
            }
        }
        node = RQPUtilities.createV5ValueExpressionMetadata(untaggedExpression, environment, parentNode, metadata);
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Element parseString(String expressionString) {
        Element rootElement;
        XQELogger spLogger;
        SAXReader reader = null;
        Document doc = null;
        boolean bMergeAdjacentText = false;
        try {
            reader = XQESAXReaderPool.getInstance().borrowReader();
            bMergeAdjacentText = reader.isMergeAdjacentText();
            reader.setMergeAdjacentText(true);
            doc = reader.read((Reader)new StringReader(expressionString));
        }
        catch (Exception e) {
            reader.setMergeAdjacentText(bMergeAdjacentText);
            spLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
            spLogger.log(LogLevel.ERROR, (Throwable)e);
            if (doc == null) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_ParsingException, (Throwable)e, expressionString);
            }
        }
        finally {
            reader.setMergeAdjacentText(bMergeAdjacentText);
            try {
                XQESAXReaderPool.getInstance().returnReader(reader);
            }
            catch (Exception e) {
                spLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
                spLogger.log(LogLevel.ERROR, (Throwable)e);
            }
        }
        if ((rootElement = doc.getRootElement()) == null) {
            return null;
        }
        return rootElement;
    }

    public static void updateModelIDsToReferenceCurrentAlias(RMQuery rmQuery, IXQEQueryNode expr) {
        IXQEQueryNode[] modelIds;
        if (null == rmQuery.getPropertyValue("isAlias")) {
            return;
        }
        IQuerySubject qs = rmQuery.getQuerySubject();
        String qsName = qs.getV5UniqueName();
        String[] qsNameParts = null;
        try {
            qsNameParts = UniqueNameParser.parse(qsName);
        }
        catch (UniqueNameParserException e) {
            throw new XQERuntimeException(e);
        }
        String pkgAlias = RQPUtilities.getPKGAlias(rmQuery.getPlanningEnvironment(), qs.getConnection());
        for (IXQEQueryNode modelId : modelIds = expr.getDescendantsOfType(201030, true)) {
            V5MultiPartIdentifier multiPartIdentifier = (V5MultiPartIdentifier)modelId;
            String[] nameParts = multiPartIdentifier.getNameParts();
            int offset = 0;
            if (pkgAlias != null && pkgAlias.equals(nameParts[0])) {
                offset = 1;
            }
            if (!qsNameParts[0].equals(nameParts[offset]) || !qsNameParts[1].equals(nameParts[1 + offset])) continue;
            String[] aliasNameParts = rmQuery.getNameParts();
            nameParts[offset] = aliasNameParts[offset];
            nameParts[1 + offset] = aliasNameParts[1 + offset];
            multiPartIdentifier.setIdentifier(rmQuery.getName() + DOT_OPEN_SQUARE_BRACKET + nameParts[2 + offset] + CLOSE_SQUARE_BRACKET);
        }
    }

    protected static String getPKGAlias(IPlanningEnvironment environment, MetadataConnection qsMC) {
        if (environment == null) {
            return null;
        }
        MetadataConnection mc = (MetadataConnection)environment.getMetadataConnection();
        if (!(mc instanceof MoserMetadataConnection)) {
            return null;
        }
        MoserMetadataConnection moserMC = (MoserMetadataConnection)mc;
        return moserMC.getAliasMFWMetadataConnection(qsMC);
    }

    public static IXQEQueryNode createV5ExpressionFromFilter(PlanningEnvironment environment, IEmbeddedFilter filter, IXQEQueryNode rmQuery, IXQEQueryNode parentNode) {
        IMetadata standAloneFilter;
        IXQEQueryNode expr = RQPUtilities.getV5ValueExpression(filter, environment, parentNode);
        if (expr == null && (standAloneFilter = filter.getRefObject()) instanceof IFilter) {
            expr = RQPUtilities.getV5ValueExpression(standAloneFilter, environment, parentNode);
        }
        if (expr != null && rmQuery instanceof RMQuery) {
            RQPUtilities.updateModelIDsToReferenceCurrentAlias((RMQuery)rmQuery, expr);
        }
        return expr;
    }

    public static IXQEQueryNode createV5ExpressionFromFilter(PlanningEnvironment environment, IEmbeddedFilter filter, IXQEQueryNode rmQuery) {
        return RQPUtilities.createV5ExpressionFromFilter(environment, filter, rmQuery, null);
    }

    public static IXQEQueryNode createV5ExpressionFromFilter(PlanningEnvironment environment, IEmbeddedFilter filter) {
        return RQPUtilities.createV5ExpressionFromFilter(environment, filter, null, null);
    }

    public static boolean isShortcutTreatedAsAliasForUnwinding(String shortcutName, PlanningEnvironment environment) {
        MetadataConnection mdConnection = environment.getMetadataConnection();
        IMetadata metadata = null;
        try {
            metadata = mdConnection.bindMetadataReference(shortcutName);
        }
        catch (XQERuntimeException e) {
            mErrorLogger.log(e);
            return false;
        }
        IDataSourceCapabilities providerCapabilities = ProviderCapabilites.getInstance().getOrAddProviderCapabilities("DMR");
        String keepDimensionShortcut = providerCapabilities.getStringValue("keepDimensionShortcutInModelCalculation", "true");
        boolean bKeepDimensionShortcut = "true".equalsIgnoreCase(keepDimensionShortcut);
        boolean explicitShortcutProcessing = RQPUtilities.getShortcutProcessing(environment);
        return RQPUtilities.isShortcutTreatedAsAlias(metadata, explicitShortcutProcessing) || RQPUtilities.shortcutHasJoin(metadata, RQPUtilities.getRQPJoinInfo(environment)) || bKeepDimensionShortcut && RQPUtilities.isTargetNonMeasureDimension(metadata);
    }

    public static boolean isTargetNonMeasureDimension(IMetadata metadata) {
        if (metadata.getObjectType() != MetadataType.SHORTCUT) {
            return false;
        }
        IShortcut sc = (IShortcut)metadata;
        IMetadata target = sc.getTarget();
        if (target.getObjectType() == MetadataType.SHORTCUT) {
            return RQPUtilities.isTargetNonMeasureDimension(target);
        }
        return target.getObjectType() == MetadataType.DIMENSION && !((IDimension)target).isMeasuresDimension();
    }

    public static boolean isShortcutTreatedAsAlias(IMetadata metadata, boolean explicitShortcutProcessing) {
        if (!(metadata instanceof IShortcut)) {
            return false;
        }
        IShortcut sc = (IShortcut)metadata;
        return sc.isShorcutTreatedAsAlias(explicitShortcutProcessing);
    }

    public static IMetadata getTarget(IMetadata metadata) {
        if (!(metadata instanceof IShortcut)) {
            return metadata;
        }
        IMetadata sc = metadata;
        while (sc instanceof IShortcut) {
            sc = ((IShortcut)sc).getTarget();
        }
        return sc;
    }

    public static boolean shortcutHasJoin(IMetadata metadata, RQPJoinInfo rqpJoinInfo) {
        if (!(metadata instanceof IShortcut) || rqpJoinInfo == null) {
            return false;
        }
        IShortcut sc = (IShortcut)metadata;
        return RQPUtilities.querySubjectIsPartOfRepositoryJoins(rqpJoinInfo.getJoinsForQuerySubject(sc));
    }

    public static RQPJoinInfo getRQPJoinInfo(PlanningEnvironment environment) {
        XQEBaseQueryNode query = null;
        IXQEQueryNode root = environment.getRoot();
        if (root != null) {
            query = (V5Query)root.getFirstDescendantOfTypeOrdered(101006, false);
        }
        if (query == null) {
            return null;
        }
        RQPJoinInfo joinInfo = (RQPJoinInfo)query.getFirstChildByType(801046);
        if (joinInfo != null) {
            if (!joinInfo.hasRepositoryInfo()) {
                joinInfo.createRepositoryInfo(environment.getMetadataConnection());
            }
            return joinInfo;
        }
        joinInfo = (RQPJoinInfo)environment.getNodeFactory().createNode(801046);
        query.addChild(joinInfo);
        joinInfo.createRepositoryInfo(environment.getMetadataConnection());
        return joinInfo;
    }

    public static boolean getShortcutProcessing(PlanningEnvironment environment) {
        boolean explicitShortcutProcessing = true;
        String value = environment.getPlanningPAC().get("_governor", "shortcutProcessing");
        if (value != null && !value.equals("explicit")) {
            explicitShortcutProcessing = false;
        }
        return explicitShortcutProcessing;
    }

    public static boolean isUnderRQPSummaryQueryOrRootQueryProjectionList(IXQEQueryNode node) {
        IXQEQueryNode query;
        RQPSummaryQuery rqpSummaryQuery = (RQPSummaryQuery)node.getAncestorOfTypes(new int[]{801024, 801012});
        if (rqpSummaryQuery != null) {
            return true;
        }
        IXQEQueryNode projectionList = node.getAncestorOfType(801016);
        return projectionList != null && (query = projectionList.getParent()) != null && query.isOfTypes(new int[]{801017});
    }

    public static void logicalAndChildNodes(IXQEQueryNode node, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        while (node.getNumberChildren() > 1) {
            SQLLogical logicalExpr = (SQLLogical)factory.createNode(301027);
            logicalExpr.setSubType(SQLLogical.SubType.AND);
            node.getChild(0).insertParent(logicalExpr);
            node.getChild(1).move(logicalExpr);
        }
    }

    public static boolean hasStandardAggregateInExpression(IXQEQueryNode expr) {
        return expr != null && expr.getDescendantsOfType(201031, true).length > 0;
    }

    public static IDataType getNodeDataType(IXQEQueryNode node) {
        return V5SimpleNode.getNodeDataType(node);
    }

    public static SQLRangeVar getRangeVar(IXQEQueryNode ancestor, String name) {
        SQLRangeVar rangeVar = null;
        HashMap<String, SQLRangeVar> nameToSQLRangeVar = null;
        Object property = ancestor.getPropertyValue("SQLRangeVarCache");
        if (property != null && (rangeVar = (SQLRangeVar)(nameToSQLRangeVar = (HashMap<String, SQLRangeVar>)property).get(name)) != null) {
            return rangeVar;
        }
        for (IXQEQueryNode d : ancestor.getDescendantsOfTypeOrdered(301007, false, 301059)) {
            IXQEQueryNode parentRangeVar;
            SQLRangeVar s = (SQLRangeVar)d;
            String rangeVarName = s.getName();
            if (!rangeVarName.equals(name) || (parentRangeVar = s.getAncestorOfType(301007)) != null && parentRangeVar.isAncestor(ancestor)) continue;
            if (nameToSQLRangeVar == null) {
                nameToSQLRangeVar = new HashMap<String, SQLRangeVar>();
                ancestor.setPropertyValue("SQLRangeVarCache", nameToSQLRangeVar);
            }
            nameToSQLRangeVar.put(name, s);
            return s;
        }
        return null;
    }

    public static IXQEQueryNode getSQLRelationForJoin(IXQEQueryNode ancestorOfsqlRelation, IMetadata qs, RMQueryList rmQueryList) {
        String rangeVarName = null;
        if (qs instanceof DMQuerySubject) {
            rangeVarName = qs.getName();
            return RQPUtilities.getRangeVarForSQLJoin(ancestorOfsqlRelation, rangeVarName, false, null);
        }
        RMQuery query = rmQueryList.getRMQuery(qs);
        if (query == null) {
            RQPUtilities.throwExceptionForUnsupportedJoin(ancestorOfsqlRelation, qs);
        }
        rangeVarName = query.getCorrelationName();
        if (query.getType() == 801029) {
            return RQPUtilities.getRangeVarForSQLJoin(ancestorOfsqlRelation, rangeVarName, false, null);
        }
        SQLRangeVar rangeVar = (SQLRangeVar)query.getFirstChildByType(301007);
        return RQPUtilities.getRangeVarForSQLJoin(ancestorOfsqlRelation, rangeVarName, true, rangeVar);
    }

    public static SQLRangeVar getRangeVarForSQLJoin(IXQEQueryNode ancestor, String name, boolean compareExpression, SQLRangeVar rangeVar) {
        for (int i = 0; i < ancestor.getNumberChildren(); ++i) {
            SQLRangeVar s;
            String sqlRangeVarName;
            IXQEQueryNode c = ancestor.getChild(i);
            if (c.getType() != 301007 || !name.equals(sqlRangeVarName = (String)(s = (SQLRangeVar)c).getPropertyValue("name"))) continue;
            return s;
        }
        if (ancestor.getType() == 301011) {
            IXQEQueryNode childJoin = ancestor.getFirstChildByType(301011);
            if (childJoin == null) {
                return null;
            }
            return RQPUtilities.getRangeVarForSQLJoin(childJoin, name, compareExpression, rangeVar);
        }
        return null;
    }

    public static SQLFromClause getFromClauseNode(IXQEQueryNode rqpQuery, IXQENodeFactory factory) {
        IXQEQueryNode fromClause = rqpQuery.getFirstChildByType(301043);
        if (fromClause == null) {
            fromClause = factory.createNode(301043);
            rqpQuery.addChild(fromClause);
        }
        return (SQLFromClause)fromClause;
    }

    public static boolean isAutoSortItem(V5DataItem v5DataItem) {
        String aggregateAttr = v5DataItem.getAggregateProperty();
        if (aggregateAttr == null) {
            return false;
        }
        if (!aggregateAttr.equals("none")) {
            return false;
        }
        if (RQPUtilities.hasMovingRunningInExpression(v5DataItem)) {
            return false;
        }
        int[] aggrTypes = new int[]{201031, 201033};
        IXQEQueryNode[] aggrNodes = v5DataItem.getDescendantsOfTypes(aggrTypes, true);
        if (aggrNodes.length == 0) {
            return true;
        }
        for (IXQEQueryNode aggrNode : aggrNodes) {
            IXQEQueryNode[] forClauses = aggrNode.getDescendantsOfType(201037, false);
            if (forClauses.length <= 0) continue;
            return true;
        }
        return false;
    }

    public static HashSet<V5DataItem> getV5ProjectionItems(RQPQuery rootQuery) {
        HashSet<V5DataItem> v5DataItemSet = new HashSet<V5DataItem>();
        V5Selection v5Selection = rootQuery.getRefV5Query().getV5Selection();
        IXQEQueryNode[] vSets = rootQuery.getDescendantsOfType(101057, false);
        for (int i = 0; i < vSets.length; ++i) {
            V5ValueSet valueSet = (V5ValueSet)vSets[i];
            String refDataItem = valueSet.getRefDataItemProperty();
            if (refDataItem == null) continue;
            v5DataItemSet.add(v5Selection.getDataItemByRefName(refDataItem));
        }
        IXQEQueryNode[] diRefs = rootQuery.getDescendantsOfType(101015, false);
        for (int j = 0; j < diRefs.length; ++j) {
            V5DataItemRef dataItemRef = (V5DataItemRef)diRefs[j];
            String refDataItem = dataItemRef.getDataItemRefProperty();
            if (refDataItem == null) continue;
            v5DataItemSet.add(v5Selection.getDataItemByRefName(refDataItem));
        }
        return v5DataItemSet;
    }

    public static boolean isIdentifierInAggregateFunction(IXQEQueryNode identifier) {
        return RQPUtilities.isIdentifierInAggregateFunction(identifier, null);
    }

    public static boolean isIdentifierInAggregateFunction(IXQEQueryNode identifier, IXQEQueryNode topExprNode) {
        int[] types = new int[]{201034, 201032, 201035, 201033, 201031, 301034, 801008, 101011};
        IXQEQueryNode node = identifier.getAncestorOfTypes(types);
        return node != null && node.getType() != 801008 && node.getType() != 101011 && node != topExprNode;
    }

    public static boolean isIdentifierUnderBreakClause(IXQEQueryNode identifier) {
        int[] types = new int[]{201037, 801008, 101011};
        IXQEQueryNode node = identifier.getAncestorOfTypes(types);
        return node != null && node.getType() != 801008 && node.getType() != 101011;
    }

    public static void setFormatOfRSAPIDataItem(String format, RSAPIDataItem rsapiDataItem, IXQEQueryNode rqpDataItem) {
        rsapiDataItem.setFormat(format);
        FormatId id = V5FormatResolver.getFormatId(format);
        rsapiDataItem.setFormatID(id);
        rqpDataItem.setPropertyValue("formatResolved", "true");
        rqpDataItem.setPropertyValue("RSAPIRefDataItem", rsapiDataItem);
    }

    public static SQLSetOperator.SubType getSQLSubType(String setOperation) {
        if (null == setOperation || setOperation.equals("UNION")) {
            return SQLSetOperator.SubType.UNION;
        }
        if (setOperation.equals("INTERSECT")) {
            return SQLSetOperator.SubType.INTERSECT;
        }
        if (setOperation.equals("EXCEPT")) {
            return SQLSetOperator.SubType.EXCEPT;
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unknown setOperation attribute value: " + setOperation);
    }

    public static boolean isDetailExpression(IXQEQueryNode expr) {
        RQPQuery refQuery;
        switch (expr.getType()) {
            case 201018: {
                return RQPUtilities.isDetailCaseExpr((V5CaseExpression)expr);
            }
            case 201017: {
                return RQPUtilities.isDetailIfExpr((V5IfExpression)expr);
            }
            case 201031: {
                return false;
            }
        }
        if (expr.getNumberChildren() > 0) {
            for (IXQEQueryNode child : expr.getChildren()) {
                if (RQPUtilities.isDetailExpression(child)) continue;
                return false;
            }
        } else if (expr.getType() == 801009 && (refQuery = ((RQPDataItemRef)expr).getQuery()).getType() != 801025) {
            return false;
        }
        return true;
    }

    public static boolean isDetailCaseExpr(V5CaseExpression caseExpr) {
        for (int i = 0; i < caseExpr.getNumberChildren(); ++i) {
            IXQEQueryNode result;
            IXQEQueryNode caseExprChild = caseExpr.getChild(i);
            if (caseExprChild.getType() != 201019 || RQPUtilities.isDetailExpression(result = caseExprChild.getChild(1))) continue;
            return false;
        }
        IXQEQueryNode lastChild = caseExpr.getChild(caseExpr.getNumberChildren() - 1);
        if (201019 != lastChild.getType()) {
            return RQPUtilities.isDetailExpression(lastChild);
        }
        return true;
    }

    public static boolean isDetailIfExpr(V5IfExpression ifExpr) {
        for (int i = 1; i < ifExpr.getNumberChildren(); ++i) {
            if (RQPUtilities.isDetailExpression(ifExpr.getChild(i))) continue;
            return false;
        }
        return true;
    }

    private static void replaceQuerySubjectNameByShortcutName(IXQEQueryNode expressionRoot, String querySubjectName, String shortcutName) {
        IXQEQueryNode[] v5MPI;
        for (IXQEQueryNode d : v5MPI = expressionRoot.getDescendantsOfType(201030, false)) {
            String[] parts;
            V5MultiPartIdentifier id = (V5MultiPartIdentifier)d;
            try {
                parts = UniqueNameParser.parse(id.getIdentifier(), -1);
            }
            catch (UniqueNameParserException e) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_ParsingException, (Throwable)e, id.getIdentifier());
            }
            if (parts.length != 3) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(OPEN_SQUARE_BRACKET);
            sb.append(parts[0]);
            sb.append(CLOSE_OPEN_SQUARE_BRACKET);
            sb.append(parts[1]);
            sb.append(CLOSE_SQUARE_BRACKET);
            String qsName = sb.toString();
            if (!qsName.equals(querySubjectName)) continue;
            StringBuilder sb1 = new StringBuilder(shortcutName);
            sb1.append(DOT_OPEN_SQUARE_BRACKET);
            sb1.append(parts[2]);
            sb1.append(CLOSE_SQUARE_BRACKET);
            id.setIdentifier(sb1.toString());
        }
    }

    public static SQLColumn createSQLColumn(IXQENodeFactory factory, String tableName, String columnName) {
        SQLColumn newNode = (SQLColumn)factory.createNode(301005);
        newNode.setTableName(tableName);
        newNode.setName(columnName);
        return newNode;
    }

    public static String getAliasName(SQLRangeVar rangeVar, String queryItemName, IXQEQueryNode node) {
        if (rangeVar == null) {
            return null;
        }
        IXQEQueryNode child = rangeVar.getChild(0);
        if (child == null) {
            return null;
        }
        if (child.getType() == 801017) {
            RQPQuery referencedQuery = (RQPQuery)child;
            return RQPUtilities.getAliasName(referencedQuery, queryItemName);
        }
        if (child instanceof SQLProject) {
            return RQPUtilities.getAliasName((SQLProject)child, queryItemName);
        }
        if (child.getType() == 301018) {
            return queryItemName;
        }
        if (node.getType() == 801009) {
            Map<String, String> names;
            if (child.getType() == 301092) {
                child = child.getChild(0);
            }
            if (child.getType() == 301016 && (names = ((SQLRelation)child).getProjectedItems()).containsKey(queryItemName)) {
                return names.get(queryItemName);
            }
        }
        return null;
    }

    public static String getAliasName(RQPQuery rqpQuery, String queryItemName) {
        RQPProjectionList projList = rqpQuery.getProjectionList();
        IXQEQueryNode[] projections = projList.getChildren();
        for (int i = 0; i < projections.length; ++i) {
            RQPDataItem dataItem;
            SQLColumn column;
            if (projections[i].getType() != 301028) continue;
            SQLAlias alias = (SQLAlias)projections[i];
            String aliasName = alias.getName();
            if (aliasName.equals(queryItemName)) {
                return aliasName;
            }
            String origName = alias.getOrigColumnName();
            if (origName != null && origName.equals(queryItemName)) {
                return aliasName;
            }
            IXQEQueryNode aliasChild = alias.getChild(0);
            if (aliasChild.getType() == 301005 && (column = (SQLColumn)aliasChild).getName().equals(queryItemName)) {
                return aliasName;
            }
            if (aliasChild.getType() != 801008 || !(dataItem = (RQPDataItem)aliasChild).getName().equals(queryItemName)) continue;
            return aliasName;
        }
        return null;
    }

    public static String getAliasName(SQLProject sqlProject, String queryItemName) {
        IXQEQueryNode[] valueListList = sqlProject.getChildrenOfType(301030);
        if (valueListList.length > 0) {
            SQLValueList valueList = (SQLValueList)valueListList[0];
            for (int i = 0; i < valueList.getNumberChildren(); ++i) {
                SQLColumn column;
                IXQEQueryNode child = valueList.getChild(i);
                if (child.getType() == 301028) {
                    SQLAlias alias = (SQLAlias)child;
                    if (alias.getName().equals(queryItemName)) {
                        return alias.getName();
                    }
                    if (alias.getOrigColumnName() == null || !alias.getOrigColumnName().equals(queryItemName)) continue;
                    return alias.getName();
                }
                if (child.getType() != 301005 || !(column = (SQLColumn)child).getName().equals(queryItemName)) continue;
                return column.getName();
            }
        }
        return null;
    }

    public static V5ValueSet getNestedValueSet(RQPQuery rootQuery, V5ValueSet currentValueSet) {
        List<IXQEQueryNode> valueSets = rootQuery.getDescendantsOfTypeOrdered(101057, false);
        for (int i = 0; i < valueSets.size(); ++i) {
            if (valueSets.get(i) != currentValueSet) continue;
            if (i == valueSets.size() - 1) {
                return null;
            }
            return (V5ValueSet)valueSets.get(i + 1);
        }
        return null;
    }

    public static boolean containsDetailExpr(IXQEQueryNode expression) {
        IXQEQueryNode[] allDetailExpNodes;
        for (IXQEQueryNode b : allDetailExpNodes = RQPUtilities.getDetailExprNodes(expression)) {
            if (b.getType() == 201060 && !((V5BoundDataItemReference)b).isQueryRefItem() || RQPUtilities.isIdentifierInAggregateFunction(b, expression) || RQPUtilities.isIdentifierUnderBreakClause(b)) continue;
            return true;
        }
        return false;
    }

    public static IXQEQueryNode[] getDetailExprNodes(IXQEQueryNode expression) {
        int[] detailExpNodeTypes = new int[]{201116, 201060, 201103, 201097};
        return expression.getDescendantsOfTypes(detailExpNodeTypes, false);
    }

    public static boolean containsAnalyticOrMovingRunningOnDetailExpr(IXQEQueryNode expr) {
        int[] v5ExpNodeTypes = new int[]{201033, 201035};
        IXQEQueryNode[] functionList = expr.getDescendantsOfTypes(v5ExpNodeTypes, true);
        if (functionList.length == 0) {
            return false;
        }
        for (IXQEQueryNode function : functionList) {
            IXQEQueryNode operand = function.getChild(0);
            if (function.getAncestorOfType(201031) == null && operand.getDescendantsOfType(201031, true).length <= 0 && !RQPUtilities.containsReferenceToSummaryFunction(operand)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasOnlyAnalyticInExpression(IXQEQueryNode expr) {
        if (expr.getDescendantsOfType(201033, true).length == 0) {
            return false;
        }
        int[] descendantTypes = new int[]{201031, 201035, 301034};
        return expr.getDescendantsOfTypes(descendantTypes, true).length <= 0;
    }

    private static boolean containsReferenceToSummaryFunction(IXQEQueryNode node) {
        IXQEQueryNode[] refs;
        for (IXQEQueryNode r : refs = node.getDescendantsOfType(801009, true)) {
            RQPDataItemRef ref = (RQPDataItemRef)r;
            if (ref.getReferencedItem().getDescendantsOfType(201031, true).length <= 0) continue;
            return true;
        }
        return false;
    }

    public static boolean querySubjectIsPartOfRepositoryJoins(List<IMetadata> joins) {
        if (joins != null) {
            for (IMetadata j : joins) {
                IRelationship join;
                if (!(j instanceof IRelationship) || (join = (IRelationship)j).isDummy()) continue;
                return true;
            }
        }
        return false;
    }

    public static String findProjectionAlias(String subQueryName, String nodeName, IXQEQueryNode node) {
        RQPQuery parentRQPQuery = (RQPQuery)node.getAncestorOfTypes(new int[]{801017, 801012, 801024, 801025});
        if (parentRQPQuery == null) {
            return null;
        }
        SQLFromClause sqlFromClause = (SQLFromClause)parentRQPQuery.getFirstChildByType(301043);
        if (sqlFromClause == null) {
            return null;
        }
        SQLRangeVar rangeVar = RQPUtilities.getRangeVar(sqlFromClause, subQueryName);
        String aliasName = RQPUtilities.getAliasName(rangeVar, nodeName, node);
        if (aliasName != null) {
            return aliasName;
        }
        return null;
    }

    public static IMetadata getShortcutTarget(IMetadata sc) {
        while (sc instanceof IShortcut) {
            sc = ((IShortcut)sc).getTarget();
        }
        return sc;
    }

    public static boolean isAggregateToBeAdjustedForDetailContext(V5AggregateFunction aggregate) {
        int v5AggregateFunctionSubtype = aggregate.getSubType();
        switch (v5AggregateFunctionSubtype) {
            case 0: 
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 12: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public static boolean isConstantGroupingItem(IXQEQueryNode node) {
        int[] types = new int[]{201116, 201115, 201103, 201033, 201035, 201117, 201138};
        IXQEQueryNode[] refs = node.getDescendantsOfTypes(types, true);
        if (refs.length != 0) {
            return false;
        }
        int[] types1 = new int[]{201097, 201060, 801009, 801010};
        refs = node.getDescendantsOfTypes(types1, true);
        IXQEQueryNode exp = null;
        for (IXQEQueryNode ref : refs) {
            if (ref.getType() == 201097) {
                if (RQPUtilities.hasUnionQueryAsSource(ref)) {
                    return false;
                }
                exp = ((V5BoundQueryItemReference)ref).getRefDataItem();
            }
            if (ref.getType() == 201060) {
                exp = ((V5BoundDataItemReference)ref).getReferencedExpression();
            }
            if (ref.getType() == 801009) {
                exp = ((RQPDataItemRef)ref).getReferencedItem();
            }
            if (ref.getType() == 801010) {
                exp = ((RQPDataItemSelfRef)ref).getExpression();
            }
            if (exp == null || RQPUtilities.isConstantGroupingItem(exp)) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasUnionQueryAsSource(IXQEQueryNode node) {
        IXQEQueryNode[] queryOperations;
        RQPQuery rqpQuery = RQPNode.getRQPQuery(node);
        V5Query v5Query = null;
        if (rqpQuery == null) {
            IXQEQueryNode selection = node.getAncestorOfType(101009);
            if (selection == null) return false;
            v5Query = (V5Query)selection.getParent();
        } else {
            v5Query = (rqpQuery = rqpQuery.getRootRQPQuery()).getRefV5Query();
            if (v5Query == null) {
                return false;
            }
        }
        V5Source v5Source = v5Query.getV5Source();
        for (IXQEQueryNode queryOperation : queryOperations = v5Source.getChildrenOfType(101018)) {
            V5QueryOperation queryOp = (V5QueryOperation)queryOperation;
            String setOperation = (String)queryOp.getPropertyValue("setOperation");
            if (RQPUtilities.getSQLSubType(setOperation) != SQLSetOperator.SubType.UNION) continue;
            return true;
        }
        return false;
    }

    public static void appendDefaultToAutomaticWarningMessage(PlanningEnvironment planningEnvironment, String itemName, IXQEQueryNode xqeQueryNode) {
        planningEnvironment.getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(1, ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT, XQEMessageKeys.WRN_DefaultToAutomatic, itemName), xqeQueryNode, planningEnvironment.getRoot());
    }

    public static void throwExceptionForUnsupportedJoin(IXQEQueryNode ancestorOfsqlRelation, IMetadata qs) {
        IXQEQueryNode[] allPaths = ancestorOfsqlRelation.getChildrenOfType(801039);
        RQPJoinPath path = (RQPJoinPath)allPaths[0];
        String joinName = "-unknown join-";
        List<IMetadata> joinPath = path.getJoinPath();
        for (IMetadata jn : joinPath) {
            IRelationship join = (IRelationship)jn;
            if (!qs.getV5UniqueName().equals(join.getLeftRefObjectId()) && !qs.getV5UniqueName().equals(join.getRightRefObjectId())) continue;
            joinName = join.getV5UniqueName();
            break;
        }
        throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedJoinByRelationalPlanning, joinName, qs.getV5UniqueName());
    }

    public static IXQEQueryNode getProjectionNode(IXQEQueryNode sqlAST) {
        SQLValueList sqlValueList = RQPUtilities.getTopSQLValueList(sqlAST);
        if (sqlValueList != null) {
            return sqlValueList.getParent();
        }
        return null;
    }

    public static SQLValueList getTopSQLValueList(IXQEQueryNode sqlAST) {
        if (!(sqlAST instanceof SQLQueryNode)) {
            if (sqlAST.getNumberChildren() > 0) {
                return RQPUtilities.getTopSQLValueList(sqlAST.getChild(0));
            }
            return null;
        }
        return ((SQLQueryNode)sqlAST).getOutputList();
    }

    public static boolean isRelationalSubquery(RQPQuery query) {
        Object propRelSubquery = null;
        RQPSql rqpSql = (RQPSql)query.getAncestorOfType(801041);
        if (rqpSql != null) {
            propRelSubquery = rqpSql.getPropertyValue("relationalSubquery");
        }
        Boolean isRelationalSubquery = false;
        if (propRelSubquery != null) {
            isRelationalSubquery = (Boolean)propRelSubquery;
        }
        return isRelationalSubquery;
    }

    public static void removeRQPQueryNodes(IXQEQueryNode node) {
        IXQEQueryNode[] allRqps;
        for (IXQEQueryNode rqp : allRqps = RQPQuery.getAllDescendantsOfTypeRQPQueryAndItsSubTypes(node, false)) {
            rqp.extract();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IUndirectedGraph buildGraph(PlanningEnvironment environment, List<IMetadata> allJoins, HashMap<String, IMetadata> idToJoin, List<IMetadata> querySubjectsInQuery) {
        UndirectedGraph newGraph = null;
        Timer timer = null;
        if (UsageTrackingService.isEnabled()) {
            timer = new Timer();
            timer.start();
        }
        try {
            MetadataConnection mdConn = environment.getMetadataConnection();
            newGraph = new UndirectedGraph(environment.getMetadataConnection().getModelPath());
            ArrayList<IMetadata> shortcuts = new ArrayList<IMetadata>();
            for (IMetadata mdObj : allJoins) {
                if (!(mdObj instanceof IRelationship)) continue;
                IRelationship joinObj = (IRelationship)mdObj;
                String joinId = joinObj.getV5UniqueName();
                idToJoin.put(joinId, joinObj);
                IMetadata left = joinObj.getLeftRefObject();
                IMetadata right = joinObj.getRightRefObject();
                if (left instanceof IShortcut) {
                    shortcuts.add(left);
                }
                if (right instanceof IShortcut) {
                    shortcuts.add(right);
                }
                String[] ids = ItemNormalization.getLeftRightIdsFromSourceRelationship(mdConn, joinObj);
                String leftID = ids[0];
                String rightID = ids[1];
                newGraph.addNode(leftID);
                newGraph.addNode(rightID);
                RQPJoinPathFinder.Weight w = RQPJoinPathFinder.Weight.Default;
                if (mdObj instanceof MoserRelationship) {
                    w = ((MoserRelationship)mdObj).getJoinWeight();
                }
                newGraph.addEdge(joinObj.getV5UniqueName(), leftID, rightID, w.getWeight(), false);
            }
            if (querySubjectsInQuery != null) {
                Iterator<IMetadata> iterator = querySubjectsInQuery.iterator();
                while (iterator.hasNext()) {
                    IAccessedViaShortcut asc;
                    IMetadata querySubjectInQuery;
                    IMetadata shortcut = querySubjectInQuery = iterator.next();
                    if (!(querySubjectInQuery instanceof IAccessedViaShortcut) || !(asc = (IAccessedViaShortcut)querySubjectInQuery).isAccessedViaShortcut()) continue;
                    shortcut = asc.getShortcut();
                    shortcuts.add(shortcut);
                }
            }
            if (shortcuts.size() > 0) {
                List<IMetadata> dummyRelationships = RQPUtilities.createDummyRelationships(environment, shortcuts);
                for (IMetadata mdObj : dummyRelationships) {
                    IRelationship joinObj = (IRelationship)mdObj;
                    String joinId = joinObj.getV5UniqueName();
                    idToJoin.put(joinId, joinObj);
                    String leftID = mdConn.getID(joinObj.getLeftRefObject());
                    String rightID = mdConn.getID(joinObj.getRightRefObject());
                    newGraph.addNode(leftID);
                    newGraph.addNode(rightID);
                    newGraph.addEdge(joinObj.getV5UniqueName(), leftID, rightID, RQPJoinPathFinder.Weight.Shortcut.getWeight(), false);
                }
            }
        }
        finally {
            if (timer != null) {
                timer.stop();
                if (newGraph != null) {
                    newGraph.recordBuildTime(timer.getElapsedTimeInMilliseconds());
                    newGraph.recordNodesEdgesCount();
                }
            }
        }
        return newGraph;
    }

    private static List<IMetadata> createDummyRelationships(PlanningEnvironment environment, List<IMetadata> shortcuts) {
        ArrayList<IMetadata> relations = new ArrayList<IMetadata>();
        boolean explicitShortcutProcessing = RQPUtilities.getShortcutProcessing(environment);
        for (IMetadata obj : shortcuts) {
            IMetadata parent;
            IShortcut sc = (IShortcut)obj;
            IMetadata target = sc.getTarget();
            String targetNS = null;
            String shortcutNS = null;
            String targetFolder = null;
            String shortcutFolder = null;
            StringBuilder joinV5UniqueName = new StringBuilder();
            for (parent = target.getParentObject(); parent != null; parent = parent.getParentObject()) {
                if (targetFolder == null && parent instanceof IFolder) {
                    targetFolder = parent.getName();
                }
                if (!(parent instanceof INamespace)) continue;
                targetNS = parent.getName();
                break;
            }
            for (parent = sc.getParentObject(); parent != null; parent = parent.getParentObject()) {
                if (shortcutFolder == null && parent instanceof IFolder) {
                    shortcutFolder = parent.getName();
                }
                if (!(parent instanceof INamespace)) continue;
                shortcutNS = parent.getName();
                break;
            }
            if (RQPUtilities.isShortcutTreatedAsAlias(sc, explicitShortcutProcessing)) continue;
            joinV5UniqueName.append('[');
            joinV5UniqueName.append(targetNS);
            joinV5UniqueName.append('-');
            joinV5UniqueName.append(shortcutNS);
            joinV5UniqueName.append(CLOSE_OPEN_SQUARE_BRACKET);
            joinV5UniqueName.append(target.getName());
            joinV5UniqueName.append(" <--> ");
            joinV5UniqueName.append(sc.getName());
            joinV5UniqueName.append(']');
            DMRelationship aDummyJoin = new DMRelationship(joinV5UniqueName.toString(), target, sc, "one", "one", "one", "one");
            relations.add(aDummyJoin);
        }
        return relations;
    }

    public static boolean isUnderRelationalQuery(IXQEQueryNode node) {
        if (node.getAncestorOfType(801017) != null) {
            return true;
        }
        V5Query v5Query = (V5Query)node.getAncestorOfType(101006);
        return RQPUtilities.isRelationalQuery(v5Query);
    }

    public static boolean isRelationalQuery(V5Query v5Query) {
        if (v5Query != null) {
            if (v5Query.isTabular()) {
                return true;
            }
            if (v5Query.isRelStyle()) {
                return true;
            }
            if (v5Query.isRelationalSubquery()) {
                return true;
            }
        }
        return false;
    }

    public static String generateSQLParameterMarkerString(String paramName) {
        return COLON + paramName.replace(COLON, DOUBLE_COLON) + COLON;
    }

    public static boolean getShortenIdentifierName(IPlanningEnvironment environment) {
        MultiRequestContext mrcEnv = environment.getMultiRequestContext();
        return mrcEnv.fetchBooleanConfiguration("queryPlanning.shortenIdentifierName[@enabled]", false);
    }

    public static int getMaxColumnNameLength(PlanningEnvironment environment) {
        if (RQPUtilities.getShortenIdentifierName(environment)) {
            return 0;
        }
        V5QuerySet rootQuerySet = null;
        int maxColumnNameLength = 18;
        if (environment.getRoot().getType() == 101002) {
            rootQuerySet = (V5QuerySet)environment.getRoot();
            maxColumnNameLength = rootQuerySet.getMaxColumnNameLength();
        }
        return maxColumnNameLength;
    }

    public static int getMaxTableNameLength(PlanningEnvironment environment) {
        if (RQPUtilities.getShortenIdentifierName(environment)) {
            return 0;
        }
        V5QuerySet rootQuerySet = null;
        int maxTableNameLength = 18;
        if (environment.getRoot().getType() == 101002) {
            rootQuerySet = (V5QuerySet)environment.getRoot();
            maxTableNameLength = rootQuerySet.getMaxTableNameLength();
        }
        return maxTableNameLength;
    }

    public static Governors.LocalCachePolicy getLocalCachePolicyFromGovernors(IPlanningEnvironment environment, IXQEQueryNode node) {
        Governors governor = node.getGovernors();
        if (governor != null) {
            return governor.getLocalCachePolicy();
        }
        ExecutionEnvironment execEnv = (ExecutionEnvironment)environment.getExecutionEnvironment();
        if (execEnv != null && (governor = execEnv.getGovernors()) != null) {
            return governor.getLocalCachePolicy();
        }
        return Governors.LocalCachePolicy.LOWEST_SUMMARY_SUBQUERY;
    }

    public static long getDataCacheExpiryFromGovernors(IPlanningEnvironment environment, IXQEQueryNode inputQuery) {
        Governors governor = inputQuery.getGovernors();
        if (governor != null) {
            return governor.getDataCacheEffectiveExpiry(environment);
        }
        ExecutionEnvironment execEnv = (ExecutionEnvironment)environment.getExecutionEnvironment();
        if (execEnv != null && (governor = execEnv.getGovernors()) != null) {
            return governor.getDataCacheEffectiveExpiry(environment);
        }
        return 0L;
    }

    public static Governors.DataCacheUsePolicy getDataCacheUsePolicyFromGovernors(IPlanningEnvironment environment, IXQEQueryNode inputQuery) {
        Governors governor = inputQuery.getGovernors();
        if (governor != null) {
            return governor.getDataCacheUsePolicy();
        }
        ExecutionEnvironment execEnv = (ExecutionEnvironment)environment.getExecutionEnvironment();
        if (execEnv != null && (governor = execEnv.getGovernors()) != null) {
            return governor.getDataCacheUsePolicy();
        }
        return Governors.DataCacheUsePolicy.USE_IT;
    }

    public static boolean isDataCacheExpiryEnabledFromGovernors(IPlanningEnvironment environment, IXQEQueryNode node) {
        Governors governor = node.getGovernors();
        if (governor != null) {
            return governor.isDataCacheExpiryEnabled();
        }
        ExecutionEnvironment execEnv = (ExecutionEnvironment)environment.getExecutionEnvironment();
        if (execEnv != null && (governor = execEnv.getGovernors()) != null) {
            return governor.isDataCacheExpiryEnabled();
        }
        return false;
    }

    public static void setQuerySubjectInvolvedInJoins(RQPJoinInfo joinInfo, IQuerySubject querySubject) {
        IAccessedViaShortcut asc;
        IMetadata metadata = querySubject;
        if (querySubject instanceof IAccessedViaShortcut && (asc = (IAccessedViaShortcut)((Object)querySubject)).isAccessedViaShortcut()) {
            IShortcut shortcut = asc.getShortcut();
            if (RQPUtilities.querySubjectIsPartOfRepositoryJoins(joinInfo.getJoinsForQuerySubject(shortcut))) {
                querySubject.setInvolvedInJoins(true);
                return;
            }
            metadata = shortcut;
        }
        if (joinInfo.otherShortcutsToSameTargetHaveJoins(metadata)) {
            querySubject.setInvolvedInJoins(true);
            return;
        }
        if (RQPUtilities.querySubjectIsPartOfRepositoryJoins(joinInfo.getJoinsForQuerySubject(querySubject))) {
            querySubject.setInvolvedInJoins(true);
            return;
        }
        querySubject.setInvolvedInJoins(false);
    }

    public static IXQEQueryNode[] getV5BoundIdentifiersFromRelationshipExpression(IRelationship relationship, PlanningEnvironment environment) {
        IXQEQueryNode boundRelationshipExpression = RQPUtilities.getV5BoundRelationshipExpression(relationship, environment);
        if (boundRelationshipExpression == null) {
            return null;
        }
        return boundRelationshipExpression.getDescendantsOfType(201116, true);
    }

    public static IXQEQueryNode getV5BoundRelationshipExpression(IRelationship relationship, PlanningEnvironment environment) {
        IXQEQueryNode node = RQPUtilities.createV5ValueExpression(relationship, environment, null);
        if (node != null) {
            return RQPUtilities.bindV5MultiPartIdentifierToModel(node, environment);
        }
        return null;
    }

    public static IXQEQueryNode bindV5MultiPartIdentifierToModel(IXQEQueryNode node, PlanningEnvironment environment) {
        int[] pn = new int[]{1};
        BindV5MultiPartIdentifierToModel transformation = new BindV5MultiPartIdentifierToModel(pn);
        List<IXQEQueryNode> allV5NodesToBind = node.getDescendantsOfTypeOrdered(201030, true);
        for (IXQEQueryNode v5Node : allV5NodesToBind) {
            if (!((Transformation)transformation).passesQueryCondition(v5Node, environment)) continue;
            ((Transformation)transformation).apply(v5Node, environment);
        }
        return node;
    }

    public static String getExpressionName(IXQEQueryNode item) {
        V5BoundModelIdentifier bId = (V5BoundModelIdentifier)item.getFirstDescendantOfTypeOrdered(201116, true);
        if (bId != null) {
            String[] parts = null;
            try {
                parts = UniqueNameParser.parse(bId.getIdentifier(), -1);
            }
            catch (UniqueNameParserException e) {
                throw new XQERuntimeException(XQEMessageKeys.PLN_ParsingException, (Throwable)e, bId.getIdentifier());
            }
            if (parts != null && parts.length >= 3) {
                return parts[2];
            }
        }
        return "ID";
    }

    public static String buildIdentifier(String firstPart, String secondPart) {
        StringBuilder identifier = new StringBuilder();
        identifier.append('[');
        identifier.append(RQPNameGenerator.makeValidSqlIdentifier(firstPart));
        identifier.append(CLOSE_OPEN_SQUARE_BRACKET);
        identifier.append(RQPNameGenerator.makeValidSqlIdentifier(secondPart));
        identifier.append(']');
        return identifier.toString();
    }

    public static List<IMetadata> getListOfMultisetItems(IMetadata metadata) {
        ArrayList<IMetadata> listOfMultisetItems = new ArrayList<IMetadata>();
        for (IMetadata parent = metadata.getParentObject(); parent != null && parent instanceof IQueryItemFolder; parent = parent.getParentObject()) {
            IDataType dataType = parent.getDataType();
            if (dataType == null || !dataType.equals(MultisetType.MULTISETTYPE)) continue;
            listOfMultisetItems.add(parent);
        }
        Collections.reverse(listOfMultisetItems);
        return listOfMultisetItems;
    }

    public static String getNameListFromSetOfString(TreeSet<String> names) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = names.iterator();
        boolean isTopElement = true;
        while (iter.hasNext()) {
            if (!isTopElement) {
                sb.append(", ");
            } else {
                isTopElement = false;
            }
            sb.append(iter.next());
        }
        return sb.toString();
    }

    public static IDataType promoteDataType(IDataType dType, String value) {
        IDataType dataType = dType;
        if (value == null || value.compareTo("") == 0) {
            return dataType;
        }
        if (dType == null) {
            return null;
        }
        switch (dataType.getCCLTypeCode()) {
            case 4: {
                try {
                    Value dataValue = (Value)dataType.createValue();
                    dataValue.set(value);
                    break;
                }
                catch (ValueConversionException e) {
                    dataType = DataTypeFactory.getIntegerType();
                }
            }
            case 6: {
                try {
                    Value dataValue = (Value)dataType.createValue();
                    dataValue.set(value);
                    break;
                }
                catch (ValueConversionException e) {
                    dataType = DataTypeFactory.getLongType();
                }
            }
            case 8: {
                try {
                    Value dataValue = (Value)dataType.createValue();
                    dataValue.set(value);
                    break;
                }
                catch (ValueConversionException dataValue) {
                    // empty catch block
                }
            }
            case 12: {
                try {
                    Value dataValue = (Value)dataType.createValue();
                    dataValue.set(value);
                }
                catch (ValueConversionException e) {
                    if (value.contains(UPPER_CASE_E) || value.contains(LOWER_CASE_E)) {
                        dataType = DataTypeFactory.getDoubleType();
                        break;
                    }
                    Matcher match = PATTERN_FIXED_POINT.matcher(value);
                    if (!match.matches()) break;
                    int precision = 0;
                    int scale = 0;
                    String[] parts = value.split(SPLIT_CHARACTER);
                    parts[0] = parts[0].replace('-', ' ');
                    parts[0] = parts[0].replace('+', ' ').trim();
                    if (parts.length > 1) {
                        scale = parts[1].length();
                    }
                    precision = parts[0].length() + scale;
                    dataType = DataTypeFactory.getDecimalType(precision, scale);
                }
                break;
            }
            case 45: {
                try {
                    Value dataValue = (Value)dataType.createValue();
                    dataValue.set(value);
                }
                catch (ValueConversionException e) {
                    dataType = DataTypeFactory.getVarcharType(value.length());
                }
                break;
            }
            case 56: {
                try {
                    Value dataValue = (Value)dataType.createValue();
                    dataValue.set(value);
                }
                catch (ValueConversionException e) {
                    dataType = DataTypeFactory.getNVarcharType(value.length());
                }
                break;
            }
            case 55: {
                try {
                    Value dataValue = (Value)dataType.createValue();
                    dataValue.set(value);
                }
                catch (ValueConversionException e) {
                    dataType = DataTypeFactory.getNCharType(value.length());
                }
                break;
            }
            default: {
                dataType = dType;
            }
        }
        return dataType;
    }

    public static IXQEQueryNode buildCastNode(IPlanningEnvironment environment, IXQEQueryNode exprNode, IDataType dataType) {
        XQENodeFactory factory = environment.getNodeFactory();
        if ((dataType.isTextType() || dataType.isDecimal()) && (dataType.getPrecision() == -1 || dataType.getPrecision() == 0)) {
            dataType = DataTypeFactory.getDataType(dataType.getCCLTypeCode(), 1, 0);
        }
        IXQEQueryNode castNode = factory.createNode(201051);
        V5CastTarget dType = (V5CastTarget)factory.createNode(201052);
        dType.setDataType(dataType.getBaseDataType());
        exprNode.insertParent(castNode);
        castNode.addChild(dType);
        return castNode;
    }

    public static void unwindAndBindModelIdentifiers(PlanningEnvironment environment, IXQEQueryNode node) {
        do {
            RQPUtilities.bindV5MultiPartIdentifierToModel(node, environment);
        } while (RQPUtilities.unwindBoundV5MultiPartIdentifiers(node, environment));
    }

    private static boolean unwindBoundV5MultiPartIdentifiers(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] allV5NodesToBind;
        int[] pn = new int[]{1};
        UnwindV5BoundModelId transformation = new UnwindV5BoundModelId(pn);
        boolean unwound = false;
        for (IXQEQueryNode v5Node : allV5NodesToBind = node.getDescendantsOfTypes(new int[]{201115, 201116}, true)) {
            if (!((Transformation)transformation).passesNodeCondition(v5Node, environment)) continue;
            unwound = true;
            ((Transformation)transformation).apply(v5Node, environment);
        }
        return unwound;
    }

    public static String getExpressionString(IXQEQueryNode expr) {
        StringBuilder sb = new StringBuilder();
        expr.writeFormattedText(sb);
        String expression = sb.toString();
        return expression;
    }

    public static RQPQuery getRQPQueryForV5Query(String v5QueryName, PlanningEnvironment environment) {
        V5QuerySet queryset;
        V5Query v5Query;
        IXQEQueryNode rootNode = environment.getRoot();
        if (rootNode.getType() == 101002 && (v5Query = (queryset = (V5QuerySet)rootNode).getV5Query(v5QueryName)) != null) {
            IXQEQueryNode[] rqpQueries;
            for (IXQEQueryNode rqpQueryNode : rqpQueries = rootNode.getDescendantsOfType(801017, false)) {
                RQPQuery rqpQuery = (RQPQuery)rqpQueryNode;
                if (rqpQuery.getRefV5Query() != v5Query) continue;
                return rqpQuery;
            }
        }
        return null;
    }

    public static boolean hasDistinctAggregateInProjection(RQPQuery query) {
        RQPProjectionList projList = query.getProjectionList();
        if (projList == null) {
            return false;
        }
        for (IXQEQueryNode a : projList.getDescendantsOfType(201031, false)) {
            V5ValueSummaryFunction aggr = (V5ValueSummaryFunction)a;
            if (!aggr.getDistinct()) continue;
            return true;
        }
        return false;
    }

    public static void unwindAndBindModelIdentifiers(PlanningEnvironment environment, IXQEQueryNode toUnwind, V5Query v5Query) {
        RQPTNode tempExprNode = (RQPTNode)environment.getNodeFactory().createNode(801043);
        v5Query.addChild(tempExprNode);
        tempExprNode.addChild(toUnwind);
        RQPUtilities.unwindAndBindModelIdentifiers(environment, tempExprNode);
        tempExprNode.detachChildren();
        tempExprNode.detach();
    }

    public static MoserQuerySubject getMinimizedQS(PlanningEnvironment environment, V5BoundModelIdentifier v5BoundID) {
        IQuerySubject remappedQS = null;
        V5Query rootQRDV5Query = RQPNode.getV5Query(v5BoundID);
        if (rootQRDV5Query == null) {
            return null;
        }
        Map asViewMap = (Map)rootQRDV5Query.getPropertyValue("minimizedQSMap");
        if (asViewMap == null) {
            return null;
        }
        IMetadata qs = v5BoundID.getQuerySubject();
        if (qs instanceof IAccessedViaShortcut && ((IAccessedViaShortcut)qs).isAccessedViaShortcut()) {
            qs = ((IAccessedViaShortcut)qs).getShortcut();
        }
        remappedQS = (IQuerySubject)asViewMap.get(environment.getMetadataConnection().getID(qs));
        return (MoserQuerySubject)remappedQS;
    }

    public static IXQEQueryNode createQueryItemInMiniQS(PlanningEnvironment environment, IXQEQueryNode expr, V5BoundModelIdentifier v5BoundID, MoserQuerySubject miniQS) {
        String expression = null;
        if (expr.getNodeType() == 201116) {
            V5BoundModelIdentifier bmID = (V5BoundModelIdentifier)expr;
            IMetadata md = bmID.getMetadata();
            IMetadata qs = RQPUtilities.getQSOrShortcut(md);
            expression = UniqueNameGenerator.appendUniqueName(qs.getV5UniqueName(), md.getName());
        }
        if (expression == null) {
            StringBuilder sb = new StringBuilder();
            expr.writeFormattedText(sb);
            expression = sb.toString();
        }
        String aggregate = "none";
        String usage = "identifier";
        IMetadata md = v5BoundID.getMetadata();
        if (md instanceof IQueryItem) {
            usage = ((IQueryItem)md).getUsage();
            aggregate = ((IQueryItem)md).getRegularAggregate();
        } else if (md instanceof ICalculation) {
            usage = ((ICalculation)md).getUsage();
            aggregate = ((ICalculation)md).getRegularAggregate();
        }
        IQueryItem qi = miniQS.getOrCreateQueryItem(aggregate, usage, expression, expr, v5BoundID.getColumnName());
        V5BoundModelIdentifier boundIDToRemappedQS = (V5BoundModelIdentifier)environment.getNodeFactory().createNode(201116);
        boundIDToRemappedQS.setMetadata(qi);
        boundIDToRemappedQS.setIdentifier(qi.getV5UniqueName());
        return boundIDToRemappedQS;
    }

    public static IMetadata getQSOrShortcut(IMetadata md) {
        IMetadata qs = null;
        if (md instanceof IQueryItem) {
            qs = ((IQueryItem)md).getQuerySubject();
        }
        if (qs instanceof IAccessedViaShortcut && ((IAccessedViaShortcut)qs).isAccessedViaShortcut()) {
            qs = ((IAccessedViaShortcut)qs).getShortcut();
        }
        return qs;
    }

    public static String getTrimmedModelItemWithAlias(IExecutionEnvironment execEnv, String modelItem) {
        String alias;
        MoserMetadataConnection mdConn;
        IMetadata md;
        MetadataConnection mdMC;
        String trimmedModelItem = modelItem.toString().trim();
        if (execEnv instanceof ExecutionEnvironment && ((ExecutionEnvironment)execEnv).getMetadataConnection() instanceof MoserMetadataConnection && (mdMC = (md = (mdConn = (MoserMetadataConnection)((ExecutionEnvironment)execEnv).getMetadataConnection()).bindMetadataReference(trimmedModelItem)).getConnection()) != null && (alias = mdConn.getAliasMFWMetadataConnection(mdMC)) != null) {
            String[] nameParts = UniqueNameParser.parseNoThrow(trimmedModelItem);
            if (nameParts.length == 4 && alias.equals(nameParts[0])) {
                return trimmedModelItem;
            }
            trimmedModelItem = alias + "." + trimmedModelItem;
        }
        return trimmedModelItem;
    }

    public static boolean exprInOLAPContext(IXQEQueryNode expr) {
        for (IXQEQueryNode currExpr = expr; currExpr != null && currExpr.getType() != 101003; currExpr = currExpr.getParent()) {
            if (!(currExpr instanceof V5QueryNode) || !((V5QueryNode)currExpr).isOLAPConstruct()) continue;
            return true;
        }
        return false;
    }

    public static boolean dataItemReferencesAMeasure(RQPDataItemRef dataItemRef) {
        RQPDataItem dataItem = dataItemRef.getReferencedItem();
        IXQEQueryNode expression = dataItem.getExpression();
        if (expression instanceof V5BoundModelIdentifier && ((V5BoundModelIdentifier)expression).isFactUsage()) {
            return true;
        }
        int parentNodeType = dataItemRef.getParent().getType();
        if (parentNodeType == 201031 || parentNodeType == 201033 || parentNodeType == 201035 || parentNodeType == 301034) {
            return true;
        }
        int[] ancestorTypes = new int[]{201031, 201033, 201035, 301034, 201018, 201011, 201013, 201008, 201004, 201006, 201007, 201005, 201012, 201009, 201010, 801008};
        IXQEQueryNode ancestor = dataItemRef.getAncestorOfTypes(ancestorTypes);
        int nodeType = ancestor.getType();
        return nodeType == 201031 || nodeType == 201033 || nodeType == 201035 || nodeType == 301034;
    }

    public static List<IXQEQueryNode> getAllV5BoundReferences(IXQEQueryNode expr) {
        ArrayList<IXQEQueryNode> refs = new ArrayList<IXQEQueryNode>();
        RQPUtilities.getAllV5BoundReferencesRecursive(expr, refs);
        return refs;
    }

    private static void getAllV5BoundReferencesRecursive(IXQEQueryNode expr, List<IXQEQueryNode> ids) {
        ids.addAll(expr.getDescendantsOfTypeOrdered(201116, true));
        IXQEQueryNode[] refs = expr.getDescendantsOfType(801009, true);
        if (refs != null && refs.length > 0) {
            for (IXQEQueryNode r : refs) {
                RQPDataItemRef ref = (RQPDataItemRef)r;
                RQPUtilities.getAllV5BoundReferencesRecursive(ref.getReferencedItem().getExpression(), ids);
            }
        }
    }

    public static Set<IMetadata> getUnwoundQSInExpression(PlanningEnvironment environment, String expression, RQPQuery rqpQuery) {
        IXQEQueryNode itemExpr = RQPUtilities.createV5ValueExpression(expression, environment, null);
        return RQPUtilities.getUnwoundQSInExpression(environment, rqpQuery, itemExpr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<IMetadata> getUnwoundQSInExpression(PlanningEnvironment environment, RQPQuery rqpQuery, IXQEQueryNode expr) {
        HashSet<IMetadata> unwoundQS = new HashSet<IMetadata>();
        RQPTNode tempExprNode = (RQPTNode)environment.getNodeFactory().createNode(801043);
        rqpQuery.addChild(tempExprNode);
        try {
            tempExprNode.addChild(expr);
            RQPUtilities.unwindAndBindMultiPartIdentifiersInExpression(environment, tempExprNode);
            for (IXQEQueryNode bmID : tempExprNode.getDescendantsOfType(201116, true)) {
                V5BoundModelIdentifier boundID = (V5BoundModelIdentifier)bmID;
                IQuerySubject qs = boundID.getQuerySubject();
                if (qs == null) continue;
                unwoundQS.add(qs);
            }
        }
        finally {
            tempExprNode.detachChildren();
            tempExprNode.detach();
        }
        return unwoundQS;
    }

    private static void unwindAndBindMultiPartIdentifiersInExpression(PlanningEnvironment environment, IXQEQueryNode node) {
        do {
            RQPUtilities.bindV5MultiPartIdentifierToModel(node, environment);
        } while (RQPUtilities.unwindV5MultipartIdentifiersInExpression(node, environment));
    }

    private static boolean unwindV5MultipartIdentifiersInExpression(IXQEQueryNode node, PlanningEnvironment environment) {
        IXQEQueryNode[] allV5NodesToBind;
        int[] pn = new int[]{1};
        UnwindV5BoundMultipartIdentifier transformation = new UnwindV5BoundMultipartIdentifier(pn);
        boolean unwound = false;
        for (IXQEQueryNode v5Node : allV5NodesToBind = node.getDescendantsOfTypes(new int[]{201115, 201116}, true)) {
            if (!transformation.passesNodeCondition(v5Node, environment)) continue;
            unwound = true;
            transformation.apply(v5Node, environment);
        }
        return unwound;
    }
}

