/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util.itemNormalization;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.rqp.RMQuery;
import com.cognos.xqe.ast.rqp.RMQueryList;
import com.cognos.xqe.ast.rqp.RMQueryOperation;
import com.cognos.xqe.ast.rqp.RQPDataItem;
import com.cognos.xqe.ast.rqp.RQPQuery;
import com.cognos.xqe.ast.rqp.RQPTNode;
import com.cognos.xqe.ast.sql.SQLAggregate;
import com.cognos.xqe.ast.sql.SQLPartition;
import com.cognos.xqe.ast.sql.SQLRangeVar;
import com.cognos.xqe.ast.sql.SQLWindow;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.util.Pair;
import com.cognos.xqemoser.MoserItemNormalization;
import com.cognos.xqemoser.MoserQueryItem;
import com.cognos.xqemoser.MoserQuerySubject;
import com.cognos.xqemoser.MoserQuerySubjectWrapper;
import com.cognos.xqemoser.MoserRelationshipWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class ItemNormalization {
    public static boolean addDummyJoinsForItemNormalization(PlanningEnvironment environment, List<List<IMetadata>> allJoinPaths, HashMap<IMetadata, Set<IMetadata>> inputQSToQI) {
        boolean bl;
        HashMap<IMetadata, Set<IMetadata>> qsToJoins = new HashMap<IMetadata, Set<IMetadata>>();
        for (List<IMetadata> list : allJoinPaths) {
            for (IMetadata r : list) {
                IRelationship iRelationship = (IRelationship)r;
                IMetadata left = iRelationship.getLeftRefObject();
                IMetadata right = iRelationship.getRightRefObject();
                Set<IMetadata> joinQS = (HashSet<IMetadata>)qsToJoins.get(left);
                if (joinQS == null) {
                    joinQS = new HashSet<IMetadata>();
                    qsToJoins.put(left, joinQS);
                }
                joinQS.add(r);
                joinQS = (Set)qsToJoins.get(right);
                if (joinQS == null) {
                    joinQS = new HashSet();
                    qsToJoins.put(right, joinQS);
                }
                joinQS.add(r);
            }
        }
        HashMap<Object, Set<IMetadata>> qsItemNorm = new HashMap<Object, Set<IMetadata>>();
        for (Map.Entry<IMetadata, Set<IMetadata>> entry : inputQSToQI.entrySet()) {
            MoserQuerySubject moserQuerySubject;
            MoserItemNormalization moserItemNorm;
            IMetadata qs = entry.getKey();
            if (!(qs instanceof MoserQuerySubject) || (moserItemNorm = (moserQuerySubject = (MoserQuerySubject)qs).getItemNormalization()) == null || moserItemNorm.isGeneratedFromPrimaryKey()) continue;
            if (!moserItemNorm.queryItemsInGroups(entry.getValue())) {
                ExecutionEnvironment ee = (ExecutionEnvironment)environment.getExecutionEnvironment();
                String nagMsg = XQEMessages.getMessage(XQEMessageKeys.WRN_IgnoreItemNormalization, XQEMessages.getCurrProductLocale(), moserQuerySubject.getLabel());
                ee.addNag(nagMsg);
                continue;
            }
            qsItemNorm.put(qs, entry.getValue());
        }
        if (qsItemNorm.isEmpty()) {
            return false;
        }
        boolean bl2 = false;
        HashMap<IMetadata, HashSet<IMetadata>> hashMap = new HashMap<IMetadata, HashSet<IMetadata>>();
        for (List list : allJoinPaths) {
            for (int i = 0; i < list.size(); ++i) {
                LinkedList<IMetadata> stack;
                MoserQuerySubject moserQS;
                Pair p;
                IRelationship jn = (IRelationship)list.get(i);
                IMetadata left = jn.getLeftRefObject();
                IMetadata right = jn.getRightRefObject();
                if (qsItemNorm.containsKey(left) && qsItemNorm.containsKey(right) || !qsItemNorm.containsKey(left) && !qsItemNorm.containsKey(right)) continue;
                IMetadata qs = left;
                Set usedQIs = (Set)qsItemNorm.get(left);
                if (usedQIs == null) {
                    qs = right;
                    usedQIs = (Set)qsItemNorm.get(right);
                }
                if ((p = (moserQS = (MoserQuerySubject)qs).getDummyJoinForItemNormalization(jn, environment)) == null || !ItemNormalization.hasNSideQuerySubject(qs, qsToJoins, stack = new LinkedList<IMetadata>())) continue;
                list.set(i, (IMetadata)p.getFirst());
                HashSet<IMetadata> wrappers = (HashSet<IMetadata>)hashMap.get(qs);
                if (wrappers == null) {
                    wrappers = new HashSet<IMetadata>();
                    hashMap.put(qs, wrappers);
                }
                wrappers.add((IMetadata)p.getSecond());
                bl = true;
            }
        }
        ArrayList<IRelationship> extraPath = new ArrayList<IRelationship>();
        for (Map.Entry e : hashMap.entrySet()) {
            MoserQuerySubject moserQS = (MoserQuerySubject)e.getKey();
            Set<IRelationship> extra = moserQS.getInternalDummyJoins((Set)e.getValue(), (Set)qsItemNorm.get(moserQS));
            extraPath.addAll(extra);
        }
        if (!extraPath.isEmpty()) {
            allJoinPaths.add(extraPath);
        }
        return bl;
    }

    protected static boolean hasNSideQuerySubject(IMetadata qsTop, HashMap<IMetadata, Set<IMetadata>> qsToJoins, LinkedList<IMetadata> stack) {
        if (stack.contains(qsTop)) {
            return false;
        }
        Set<IMetadata> joins = qsToJoins.get(qsTop);
        stack.addLast(qsTop);
        for (IMetadata r : joins) {
            IRelationship jn = (IRelationship)r;
            IMetadata left = jn.getLeftRefObject();
            Enum<IRelationship.Cardinality> cardinality = null;
            IMetadata other = null;
            if (qsTop.equals(left)) {
                cardinality = jn.getRightCardinality();
                other = jn.getRightRefObject();
            } else {
                cardinality = jn.getLeftCardinality();
                other = left;
            }
            if (cardinality == IRelationship.Cardinality.ZERO_MANY || cardinality == IRelationship.Cardinality.ONE_MANY) {
                stack.removeLast();
                return true;
            }
            if (!ItemNormalization.hasNSideQuerySubject(other, qsToJoins, stack)) continue;
            stack.removeLast();
            return true;
        }
        stack.removeLast();
        return false;
    }

    public static boolean checkStream(RQPTNode streamNode, TreeMap<String, TreeSet<IMetadata>> qsInMainItem) {
        HashSet<String> allQSs = new HashSet<String>();
        HashSet<String> itemNormalizationQSs = new HashSet<String>();
        IXQEQueryNode[] allNodes = streamNode.getDescendantsOfType(801043, false);
        for (IXQEQueryNode node : allNodes) {
            RQPTNode sNode = (RQPTNode)node;
            String v5Name = sNode.getV5Name();
            allQSs.add(v5Name);
            String name = (String)sNode.getPropertyValue("name");
            int idx = name.lastIndexOf("_itemNormalGenerated");
            if (idx == -1) continue;
            itemNormalizationQSs.add(name);
        }
        for (Map.Entry entry : qsInMainItem.entrySet()) {
            String qsName = (String)entry.getKey();
            if (allQSs.contains(qsName) || ItemNormalization.isInItemNormalization(itemNormalizationQSs, (TreeSet)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    protected static boolean isInItemNormalization(HashSet<String> itemNormalizationQSs, TreeSet<IMetadata> queryItems) {
        if (itemNormalizationQSs.isEmpty() || queryItems.isEmpty()) {
            return false;
        }
        IMetadata md = queryItems.iterator().next();
        if (!(md instanceof MoserQueryItem)) {
            return false;
        }
        MoserQuerySubject qs = (MoserQuerySubject)((MoserQueryItem)md).getQuerySubject();
        MoserItemNormalization itemNorm = qs.getItemNormalization();
        if (itemNorm == null) {
            return false;
        }
        return itemNorm.checkSupport(itemNormalizationQSs, queryItems);
    }

    public static String[] getLeftRightIdsFromSourceRelationship(MetadataConnection mdConn, IRelationship joinObj) {
        String[] ret = new String[]{null, null};
        ret[0] = mdConn.getID(joinObj.getLeftRefObject());
        ret[1] = mdConn.getID(joinObj.getRightRefObject());
        if (joinObj instanceof MoserRelationshipWrapper && joinObj.getExpression() != null) {
            IMetadata left = joinObj.getLeftRefObject();
            IMetadata right = joinObj.getRightRefObject();
            if (left instanceof MoserQuerySubjectWrapper) {
                ret[0] = ((MoserQuerySubjectWrapper)left).getSourceQS().getID();
            }
            if (right instanceof MoserQuerySubjectWrapper) {
                ret[1] = ((MoserQuerySubjectWrapper)right).getSourceQS().getID();
            }
        }
        return ret;
    }

    public static IMetadata[] getLeftRightObjFromSourceRelationship(MetadataConnection mdConn, IRelationship joinObj) {
        IMetadata[] ret = new IMetadata[]{null, null};
        ret[0] = joinObj.getLeftRefObject();
        ret[1] = joinObj.getRightRefObject();
        if (joinObj instanceof MoserRelationshipWrapper && joinObj.getExpression() != null) {
            IMetadata left = joinObj.getLeftRefObject();
            IMetadata right = joinObj.getRightRefObject();
            if (left instanceof MoserQuerySubjectWrapper) {
                ret[0] = ((MoserQuerySubjectWrapper)left).getSourceQS();
            }
            if (right instanceof MoserQuerySubjectWrapper) {
                ret[1] = ((MoserQuerySubjectWrapper)right).getSourceQS();
            }
        }
        return ret;
    }

    public static IMetadata getSourceQuerySubject(IMetadata qs, Map<IMetadata, IMetadata> joinedEntity2Target) {
        IMetadata targetQS = joinedEntity2Target.get(qs);
        if (targetQS instanceof MoserQuerySubjectWrapper) {
            targetQS = ((MoserQuerySubjectWrapper)targetQS).getSourceQS();
        }
        return targetQS;
    }

    public static String getRMQueryQSName(RMQuery rmQuery) {
        String qsname = rmQuery.getName();
        IQuerySubject wrapper = rmQuery.getWrapperQuerySubject();
        if (wrapper != null) {
            qsname = wrapper.getV5UniqueName();
        }
        return qsname;
    }

    public static void markRMQueryWithMoserQuerySubjectWrapper(RMQueryList rmQueryList, RMQuery rmQuery, IQuerySubject qs) {
        HashSet st = (HashSet)rmQueryList.getPropertyValue("wrapperQuerySubjects");
        if (st == null) {
            return;
        }
        for (IQuerySubject q : st) {
            MoserQuerySubjectWrapper wrapper;
            if (!(q instanceof MoserQuerySubjectWrapper) || !qs.equals((wrapper = (MoserQuerySubjectWrapper)q).getSourceQS())) continue;
            rmQuery.setWrapperQuerySubject(q);
            if (!(rmQuery instanceof RMQueryOperation)) continue;
            String qsName = wrapper.getV5UniqueName();
            IXQEQueryNode[] children = rmQuery.getChildrenOfType(301007);
            if (children.length == 1) {
                SQLRangeVar sqlRangeVar = (SQLRangeVar)children[0];
                sqlRangeVar.setPropertyValue("fullQSName", qsName);
                sqlRangeVar.setName(wrapper.getName());
            }
            rmQuery.setPropertyValue("sqsOwner", wrapper);
        }
    }

    public static void recordMoserRelationshipWrapper(Set<IRelationship> moserRelationships, List<IMetadata> joins) {
        if (joins == null) {
            return;
        }
        HashMap<IQuerySubject, HashSet<MoserRelationshipWrapper>> moserQSToRelationships = new HashMap<IQuerySubject, HashSet<MoserRelationshipWrapper>>();
        for (IMetadata iMetadata : joins) {
            if (!(iMetadata instanceof MoserRelationshipWrapper)) continue;
            MoserRelationshipWrapper currentRelationship = (MoserRelationshipWrapper)iMetadata;
            IMetadata left = currentRelationship.getLeftRefObject();
            IMetadata right = currentRelationship.getRightRefObject();
            Set<MoserRelationshipWrapper> st = null;
            if (left instanceof MoserQuerySubjectWrapper) {
                st = (HashSet<MoserRelationshipWrapper>)moserQSToRelationships.get(left);
                if (st == null) {
                    st = new HashSet<MoserRelationshipWrapper>();
                    moserQSToRelationships.put((IQuerySubject)left, (HashSet<MoserRelationshipWrapper>)st);
                }
                st.add(currentRelationship);
            }
            if (!(right instanceof MoserQuerySubjectWrapper)) continue;
            st = (Set)moserQSToRelationships.get(right);
            if (st == null) {
                st = new HashSet();
                moserQSToRelationships.put((IQuerySubject)right, (HashSet<MoserRelationshipWrapper>)st);
            }
            st.add(currentRelationship);
        }
        for (Map.Entry entry : moserQSToRelationships.entrySet()) {
            Set<IQuerySubject> top = ItemNormalization.getTopQSs((Set)entry.getValue());
            if (top == null) {
                moserRelationships.addAll((Collection)entry.getValue());
                continue;
            }
            for (IRelationship r : (Set)entry.getValue()) {
                if (r.getExpression() == null || !top.contains(r.getLeftRefObject()) && !top.contains(r.getRightRefObject())) continue;
                moserRelationships.add(r);
            }
        }
    }

    private static Set<IQuerySubject> getTopQSs(Set<MoserRelationshipWrapper> js) {
        HashSet<IQuerySubject> lefts = new HashSet<IQuerySubject>();
        HashSet<IQuerySubject> rights = new HashSet<IQuerySubject>();
        for (IRelationship iRelationship : js) {
            if (iRelationship.getExpression() != null) continue;
            lefts.add((IQuerySubject)iRelationship.getLeftRefObject());
            rights.add((IQuerySubject)iRelationship.getRightRefObject());
        }
        if (lefts.isEmpty()) {
            return null;
        }
        lefts.removeAll(rights);
        return lefts;
    }

    public static void markRMQueryListWithMoserQuerySubjectWrapper(RQPQuery parentRqpQuery, IRelationship dummyJoin) {
        if (parentRqpQuery == null) {
            return;
        }
        IMetadata left = dummyJoin.getLeftRefObject();
        IMetadata right = dummyJoin.getRightRefObject();
        if (left instanceof MoserQuerySubjectWrapper) {
            ItemNormalization.addMoserQuerySubjectWrapperToRMQueryList(left, parentRqpQuery);
        }
        if (right instanceof MoserQuerySubjectWrapper) {
            ItemNormalization.addMoserQuerySubjectWrapperToRMQueryList(right, parentRqpQuery);
        }
    }

    private static void addMoserQuerySubjectWrapperToRMQueryList(IMetadata qs, RQPQuery parentRqpQuery) {
        MoserQuerySubjectWrapper moserQSWrapper = (MoserQuerySubjectWrapper)qs;
        RMQueryList rmList = parentRqpQuery.getRMQueryList();
        if (rmList == null) {
            return;
        }
        rmList.addWrapperQuerySubject(moserQSWrapper);
    }

    public static boolean namesEquals(Set<String> src, Set<String> target) {
        if (src.equals(target)) {
            return true;
        }
        Set<String> s1 = ItemNormalization.getNormalizationNameSet(src);
        Set<String> s2 = ItemNormalization.getNormalizationNameSet(target);
        return s1.equals(s2);
    }

    private static Set<String> getNormalizationNameSet(Set<String> src) {
        HashSet<String> ret = new HashSet<String>();
        for (String s : src) {
            int idx = s.lastIndexOf("_itemNormalGenerated");
            if (idx != -1) {
                String norm = s.substring(0, idx);
                ret.add(norm + "]");
                continue;
            }
            ret.add(s);
        }
        return ret;
    }

    public static boolean applySQLOperator(PlanningEnvironment environment, RQPDataItem rqpDataItem, List<RQPDataItem> keyItems, Map<IMetadata, Integer> qiToPos, IQuerySubject wrapper, IMetadata queryItem) {
        if (!(wrapper instanceof MoserQuerySubjectWrapper)) {
            return false;
        }
        MoserQuerySubjectWrapper qs = (MoserQuerySubjectWrapper)wrapper;
        String strSQLOp = qs.getSQLOperator(queryItem);
        if (strSQLOp == null) {
            return false;
        }
        int subType = RQPUtilities.convertAggregateNameToV5AggregateFunctionSubtype(strSQLOp);
        if (subType != 6 && subType != 4 && subType != 1) {
            return false;
        }
        XQENodeFactory nodeFactory = environment.getNodeFactory();
        SQLAggregate sqlNode = (SQLAggregate)nodeFactory.createNode(301034);
        if (subType == 6) {
            sqlNode.setSubType(SQLAggregate.SubType.MIN);
        } else if (subType == 4) {
            sqlNode.setSubType(SQLAggregate.SubType.MAX);
        } else {
            sqlNode.setSubType(SQLAggregate.SubType.AVG);
        }
        rqpDataItem.getChild(0).insertParent(sqlNode);
        HashSet<IMetadata> scope = new HashSet<IMetadata>();
        if (subType == 1 && qs.getSQLOperatorScope(queryItem, scope)) {
            SQLWindow window = sqlNode.createOrGetWindow(nodeFactory);
            SQLPartition partition = window.createOrGetPartition(nodeFactory);
            for (IMetadata m : scope) {
                Integer pos = qiToPos.get(m);
                if (pos == null) continue;
                RQPDataItem kDI = keyItems.get(pos);
                partition.addChild(nodeFactory.deepCopyNode(kDI.getChild(0)));
            }
        }
        return true;
    }

    public static boolean isGroupKey(IQuerySubject wrapper, IMetadata queryItem) {
        if (!(wrapper instanceof MoserQuerySubjectWrapper)) {
            return false;
        }
        return ((MoserQuerySubjectWrapper)wrapper).isGroupKey(queryItem);
    }

    public static boolean isWrappedQueryItem(IQuerySubject wrapper, IMetadata queryItem) {
        if (!(wrapper instanceof MoserQuerySubjectWrapper)) {
            return false;
        }
        return ((MoserQuerySubjectWrapper)wrapper).isWrappedQueryItem(queryItem);
    }

    public static RMQueryOperation getRMQueryOperation(RMQueryList rmQueryList, IQuerySubject qs) {
        RMQueryOperation r = null;
        if (qs instanceof MoserQuerySubjectWrapper) {
            for (int i = 0; i < rmQueryList.getNumberChildren(); ++i) {
                RMQuery rmQuery = (RMQuery)rmQueryList.getChild(i);
                if (!(rmQuery instanceof RMQueryOperation) || !qs.equals(rmQuery.getWrapperQuerySubject())) continue;
                r = (RMQueryOperation)rmQuery;
                break;
            }
        }
        return r;
    }
}

