/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement;

import com.cognos.xqe.metadata.IMetadata;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class FFNode
implements Comparable<FFNode> {
    TreeSet<FFNode> mParents = new TreeSet();
    TreeSet<IMetadata> mAliasIds = new TreeSet();
    TreeSet<IMetadata> mAliasJoins = new TreeSet();
    TreeMap<FFNode, TreeSet<IMetadata>> mBranches = new TreeMap();
    private int mId;
    private boolean mIsForDetQS;

    public FFNode(IMetadata entity, int id) {
        this.mAliasIds.add(entity);
        this.mId = id;
        this.mIsForDetQS = false;
    }

    @Override
    public int compareTo(FFNode that) {
        if (this.mId < that.mId) {
            return -1;
        }
        if (this.mId > that.mId) {
            return 1;
        }
        return 0;
    }

    public void addAlias(IMetadata entity, IMetadata join) {
        this.mAliasIds.add(entity);
        this.mAliasJoins.add(join);
    }

    public void getBranches(TreeSet<FFNode> branches) {
        Set<FFNode> branchKeySet = this.mBranches.keySet();
        for (FFNode branchKey : branchKeySet) {
            branches.add(branchKey);
            branchKey.getBranches(branches);
        }
    }

    public TreeMap<FFNode, TreeSet<IMetadata>> getDirectBranches() {
        return this.mBranches;
    }

    public void getParents(TreeSet<FFNode> parents) {
        for (FFNode parent : this.mParents) {
            parents.add(parent);
            parent.getParents(parents);
        }
    }

    public void getBranchesInfoForTheBridge(TreeSet<IMetadata> aliases) {
        Set<FFNode> branchKeySet = this.mBranches.keySet();
        for (FFNode branchKey : branchKeySet) {
            aliases.addAll(branchKey.mAliasIds);
        }
    }

    public void getBranchesInfo(TreeSet<IMetadata> aliases) {
        Set<FFNode> branchKeySet = this.mBranches.keySet();
        for (FFNode branchKey : branchKeySet) {
            aliases.addAll(branchKey.mAliasIds);
            branchKey.getBranchesInfo(aliases);
        }
    }

    public void getAliasIds(TreeSet<IMetadata> aliases) {
        aliases.addAll(this.mAliasIds);
    }

    public boolean isParentsEmpty() {
        return this.mParents.isEmpty();
    }

    public TreeSet<IMetadata> getJoinsForChild(FFNode child) {
        return this.mBranches.get(child);
    }

    public void getAllJoinsForTheBridge(List<IMetadata> allJoins) {
        allJoins.addAll(this.mAliasJoins);
        for (FFNode branch : this.mBranches.keySet()) {
            TreeSet<IMetadata> joinsToBranch = this.getJoinsForChild(branch);
            allJoins.addAll(joinsToBranch);
        }
    }

    public void getAllJoins(List<IMetadata> allJoins) {
        allJoins.addAll(this.mAliasJoins);
        for (FFNode branch : this.mBranches.keySet()) {
            TreeSet<IMetadata> joinsToBranch = this.getJoinsForChild(branch);
            allJoins.addAll(joinsToBranch);
            branch.getAllJoins(allJoins);
        }
    }

    public IMetadata getEntity() {
        return this.mAliasIds.first();
    }

    public void setIsForDetQS(boolean isForDetQS) {
        this.mIsForDetQS = isForDetQS;
    }

    public boolean getIsForDetQS() {
        return this.mIsForDetQS;
    }

    public String getNodeName() {
        String name = null;
        for (IMetadata id : this.mAliasIds) {
            if (name != null && name.compareTo(id.getV5UniqueName()) <= 0) continue;
            name = id.getName();
        }
        return name;
    }
}

