/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.v5Exp.V5ComparisonExpression;
import com.cognos.xqe.ast.v5Exp.V5LogicalExpression;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IAccessedViaShortcut;
import com.cognos.xqe.metadata.IDeterminant;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.IQueryItemFolder;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.IRelationshipShortcut;
import com.cognos.xqe.metadata.IShortcut;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.dynamic.DMQuerySubject;
import com.cognos.xqe.metadata.dynamic.DMRelationship;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.transformation.v5tocogsql.util.RQPUtilities;
import com.cognos.xqe.transformation.v5tocogsql.util.StringSetComparator;
import com.cognos.xqe.transformation.v5tocogsql.util.determinants.Determinants;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.FFNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;

public class FactFinder {
    public static final String COMMA_SPACE = ", ";
    private List<FFNode> mTreeRoots = new ArrayList<FFNode>();
    HashMap<IMetadata, FFNode> mNodeMap = new HashMap();
    boolean mIsValid = true;
    private boolean mIsFirstFactRetained = false;
    private ResponseMessage mRetainAlphaFirstFactWarningMsg = null;
    private int mNodeCount = 0;
    public static final String SEMI_COLON_SPACE = "; ";
    public static final String CLOSE_PAREN = ")";
    public static final String NEW_LINE_CHARACTER = "\n";
    public static final String NEW_TAB_CHARACTER = "\t";
    HashMap<IMetadata, DETQuerySubjectInfo> mDETQuerySubjects;
    List<HashMap<IMetadata, DETQuerySubjectInfo>> mDETQuerySubjectsFacts = new ArrayList<HashMap<IMetadata, DETQuerySubjectInfo>>();
    List<HashMap<IMetadata, List<IMetadata>>> mDETQuerySubjectsKeysFacts = new ArrayList<HashMap<IMetadata, List<IMetadata>>>();
    HashMap<FFNode, HashMap<IMetadata, List<IMetadata>>> mSupportedDetQueryItems;
    boolean mFactHasDetQS = false;
    PlanningEnvironment mEnv;
    private static Boolean factFinderUsesEquiJoins = null;

    public FactFinder(PlanningEnvironment environment) {
        this.mDETQuerySubjects = new HashMap();
        this.mSupportedDetQueryItems = new HashMap();
        this.mEnv = environment;
    }

    public void addJoinPath(List<IMetadata> path) {
        if (path == null) {
            return;
        }
        for (IMetadata pathMember : path) {
            if (!(pathMember instanceof IRelationship)) continue;
            IRelationship join = (IRelationship)pathMember;
            this.addRelationship(join, join.getLeftCardinality(), join.getRightCardinality());
        }
    }

    public void addJoinPaths(List<List<IMetadata>> joinPaths) {
        List<List<IMetadata>> nonDuplicatePaths = this.filterOutDuplicatePaths(joinPaths);
        for (List<IMetadata> path : nonDuplicatePaths) {
            this.addJoinPath(path);
        }
    }

    public TreeSet<IMetadata> getPhysicalEntities(List<IMetadata> entities) {
        TreeSet<IMetadata> physicalEntities = new TreeSet<IMetadata>();
        for (IMetadata ent : entities) {
            if (ent instanceof IAccessedViaShortcut) {
                IAccessedViaShortcut sc = (IAccessedViaShortcut)ent;
                if (sc.isAccessedViaShortcut()) {
                    physicalEntities.add(sc.getShortcut());
                    continue;
                }
                physicalEntities.add(ent);
                continue;
            }
            physicalEntities.add(ent);
        }
        return physicalEntities;
    }

    public int getFactsInEntitiesToJoin(List<IMetadata> entitiesToJoin) {
        TreeSet<IMetadata> setFactQuerySubjects = new TreeSet<IMetadata>();
        this.getFactQuerySubjects(setFactQuerySubjects);
        TreeSet<IMetadata> setEntitiesToJoin = this.getPhysicalEntities(entitiesToJoin);
        setEntitiesToJoin.retainAll(setFactQuerySubjects);
        return setEntitiesToJoin.size();
    }

    public boolean isValid() {
        return this.mIsValid;
    }

    public boolean hasFactWithDetQS() {
        return this.mFactHasDetQS;
    }

    public List<IMetadata> getSupportedQueryItems(FFNode node) {
        HashMap<IMetadata, List<IMetadata>> qs2Items = this.mSupportedDetQueryItems.get(node);
        if (qs2Items == null || qs2Items.size() == 0) {
            return null;
        }
        ArrayList<IMetadata> supportedQIs = new ArrayList<IMetadata>();
        for (IMetadata qs : qs2Items.keySet()) {
            supportedQIs.addAll((Collection<IMetadata>)qs2Items.get(qs));
        }
        return supportedQIs;
    }

    public void getFactNodes(TreeSet<FFNode> factNodes) {
        factNodes.addAll(this.mTreeRoots);
    }

    public void getDimensionNodes(TreeSet<FFNode> dimensionNodes) {
        for (FFNode factNode : this.mTreeRoots) {
            factNode.getBranches(dimensionNodes);
        }
    }

    public void getFactQuerySubjects(TreeSet<IMetadata> factQuerySubjects) {
        TreeSet<FFNode> factNodes = new TreeSet<FFNode>();
        this.getFactNodes(factNodes);
        this.getNodeEntities(factNodes, factQuerySubjects);
    }

    public void getDimensionQuerySubjects(TreeSet<IMetadata> dimensionQuerySubjects) {
        TreeSet<FFNode> dimensionNodes = new TreeSet<FFNode>();
        this.getDimensionNodes(dimensionNodes);
        this.getNodeEntities(dimensionNodes, dimensionQuerySubjects);
    }

    public int getNumberOfFacts() {
        return this.mTreeRoots.size();
    }

    public int getNumberOfAliases(FFNode node) {
        int numOfAliases = node.mAliasIds.size();
        return numOfAliases;
    }

    public void getJoins(FFNode node, TreeSet<IMetadata> joins) {
        joins.addAll(node.mAliasJoins);
        Set<FFNode> branchKeySet = node.mBranches.keySet();
        for (FFNode branchKey : branchKeySet) {
            Set branchJoinSet = node.mBranches.get(branchKey);
            joins.addAll(branchJoinSet);
            this.getJoins(branchKey, joins);
        }
    }

    public Set<FFNode> getBranches(FFNode node) {
        Set<FFNode> branchKeySet = node.mBranches.keySet();
        return branchKeySet;
    }

    public void dump(StringBuilder msg, boolean doDumpJoins, boolean doDumpSharedDimensions) {
        Stack<FFNode> pathFromRoot;
        Locale locale;
        IMessageKey.Param0 messageKey;
        if (doDumpJoins) {
            messageKey = XQEMessageKeys.PLN_MultifactJoinInfoHeader;
            locale = XQEMessages.getCurrProductLocale();
            String joinMessage = XQEMessages.getMessage(messageKey, locale);
            msg.append(joinMessage);
            msg.append(NEW_LINE_CHARACTER);
            msg.append(NEW_LINE_CHARACTER);
        }
        messageKey = XQEMessageKeys.PLN_MultifactFactStreamHeader;
        locale = XQEMessages.getCurrProductLocale();
        String factStream = XQEMessages.getMessage(messageKey, locale);
        int iCount = 0;
        TreeSet<FFNode> shared = new TreeSet<FFNode>();
        for (FFNode root : this.mTreeRoots) {
            msg.append(factStream);
            msg.append(NEW_LINE_CHARACTER);
            pathFromRoot = new Stack<FFNode>();
            this.dumpNodeTree(msg, root, 0, pathFromRoot, doDumpJoins);
            TreeSet<FFNode> branches = new TreeSet<FFNode>();
            root.getBranches(branches);
            if (iCount == 0) {
                shared.addAll(branches);
            } else {
                TreeSet<FFNode> results = new TreeSet<FFNode>((SortedSet<FFNode>)branches);
                results.retainAll(shared);
                shared = results;
            }
            ++iCount;
        }
        if (doDumpSharedDimensions) {
            msg.append("\nShared Dimensions:\n");
            for (FFNode sharedElement : shared) {
                pathFromRoot = new Stack();
                this.dumpNodeTree(msg, sharedElement, 0, pathFromRoot, doDumpJoins);
            }
        }
        msg.append(NEW_LINE_CHARACTER);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addRelationship(IRelationship join, Enum<IRelationship.Cardinality> fromCard, Enum<IRelationship.Cardinality> toCard) {
        IMetadata leftRefObj = join.getLeftRefObject();
        IMetadata rightRefObj = join.getRightRefObject();
        if (join instanceof IRelationshipShortcut) {
            IShortcut shortcut;
            IRelationship targetRelationship = ((IRelationshipShortcut)join).getRelationshipRefObject();
            IMetadata targetLeftRefObj = targetRelationship.getLeftRefObject();
            IMetadata targetRightRefObj = targetRelationship.getRightRefObject();
            IMetadata tempLeftRefObj = leftRefObj;
            IMetadata tempRightRefObj = rightRefObj;
            if (tempLeftRefObj instanceof IShortcut) {
                shortcut = (IShortcut)leftRefObj;
                tempLeftRefObj = shortcut.getTarget();
            }
            if (tempRightRefObj instanceof IShortcut) {
                shortcut = (IShortcut)rightRefObj;
                tempRightRefObj = shortcut.getTarget();
            }
            if (targetLeftRefObj == tempRightRefObj && targetRightRefObj == tempLeftRefObj) {
                leftRefObj = join.getRightRefObject();
                rightRefObj = join.getLeftRefObject();
            }
        }
        if (join.isOne(fromCard)) {
            if (join.isOne(toCard)) {
                this.addOneToOneRelationship(leftRefObj, rightRefObj, join);
                return;
            } else {
                if (!join.isMany(toCard)) throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "addRelationship():  Illegal toCard encountered.");
                this.addOneToManyRelationship(leftRefObj, rightRefObj, join);
            }
            return;
        } else {
            if (!join.isMany(fromCard)) throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "addRelationship():  Illegal fromCard encountered.");
            if (join.isOne(toCard)) {
                this.addOneToManyRelationship(rightRefObj, leftRefObj, join);
                return;
            } else {
                if (!join.isMany(toCard)) return;
                throw new XQERuntimeException(XQEMessageKeys.PLN_IllegalN2NRelationship, join.getLeftRefObjectId(), join.getRightRefObjectId());
            }
        }
    }

    private void addOneToOneRelationship(IMetadata idOne, IMetadata idTwo, IMetadata join) {
        FFNode idOneNode = this.mNodeMap.get(idOne);
        FFNode idTwoNode = this.mNodeMap.get(idTwo);
        if (idOneNode == null && idTwoNode == null) {
            idOneNode = new FFNode(idOne, this.mNodeCount++);
            idOneNode.addAlias(idTwo, join);
            this.mNodeMap.put(idOne, idOneNode);
            this.mNodeMap.put(idTwo, idOneNode);
            this.mTreeRoots.add(idOneNode);
        } else if (idOneNode != null && idTwoNode != null) {
            if (idOneNode == idTwoNode) {
                idOneNode.addAlias(idOne, join);
            } else if (idOneNode.isParentsEmpty() && !idTwoNode.isParentsEmpty()) {
                this.copyNodeAndUpdateNodeMap(idOneNode, idTwoNode, idOne, join);
            } else {
                this.copyNodeAndUpdateNodeMap(idTwoNode, idOneNode, idTwo, join);
            }
        } else if (idOneNode != null) {
            idOneNode.addAlias(idTwo, join);
            this.mNodeMap.put(idTwo, idOneNode);
        } else {
            idTwoNode.addAlias(idOne, join);
            this.mNodeMap.put(idOne, idTwoNode);
        }
    }

    private void addOneToManyRelationship(IMetadata oneSide, IMetadata manySide, IRelationship join) {
        FFNode oneNode;
        boolean manySideWasPresent = true;
        FFNode manyNode = this.mNodeMap.get(manySide);
        if (manyNode == null) {
            manySideWasPresent = false;
            manyNode = new FFNode(manySide, this.mNodeCount++);
            this.mNodeMap.put(manySide, manyNode);
        }
        if ((oneNode = this.mNodeMap.get(oneSide)) == null) {
            oneNode = new FFNode(oneSide, this.mNodeCount++);
            this.mNodeMap.put(oneSide, oneNode);
        }
        oneNode.mParents.add(manyNode);
        TreeSet<IMetadata> branchJoinSet = manyNode.mBranches.get(oneNode);
        if (branchJoinSet != null) {
            branchJoinSet.add(join);
            return;
        }
        branchJoinSet = new TreeSet();
        branchJoinSet.add(join);
        manyNode.mBranches.put(oneNode, branchJoinSet);
        if (this.mTreeRoots.contains(oneNode)) {
            this.mTreeRoots.remove(oneNode);
        }
        if (!manySideWasPresent) {
            this.mTreeRoots.add(manyNode);
        }
        ArrayList<FFNode> visitedNodes = new ArrayList<FFNode>();
        this.checkManyToManyLoop(manySide, manyNode, visitedNodes);
        visitedNodes.clear();
        this.checkManyToManyLoop(oneSide, oneNode, visitedNodes);
    }

    private void checkManyToManyLoop(IMetadata startingEntity, FFNode currentNode, List<FFNode> visitedNodes) {
        if (currentNode == null || !this.mIsValid) {
            return;
        }
        visitedNodes.add(currentNode);
        for (FFNode nodeParent : currentNode.mParents) {
            if (!this.mIsValid) {
                return;
            }
            if (nodeParent.mAliasIds.contains(startingEntity)) {
                visitedNodes.add(nodeParent);
                this.nagLoopInJoinPath(visitedNodes);
                this.mIsValid = false;
                return;
            }
            this.checkManyToManyLoop(startingEntity, nodeParent, visitedNodes);
        }
    }

    private void nagLoopInJoinPath(List<FFNode> nodes) {
        TreeSet<String> qsNames = this.getNamesFromListOrdered(nodes);
        StringBuilder s = new StringBuilder();
        for (String name : qsNames) {
            if (s.length() > 0) {
                s.append(COMMA_SPACE);
            }
            s.append(name);
        }
        if (this.mEnv != null) {
            ResponseMessage responseMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT, XQEMessageKeys.WRN_LoopDetecedInJoinPath, s.toString());
            this.mEnv.getResponseMessageFolder().appendPlanningResponseMessage(responseMsg);
        }
    }

    private TreeSet<String> getNamesFromListOrdered(List<FFNode> nodes) {
        TreeSet<String> names = new TreeSet<String>();
        for (FFNode node : nodes) {
            for (IMetadata entity : node.mAliasIds) {
                names.add(entity.getV5UniqueName());
            }
        }
        return names;
    }

    private void copyNodeAndUpdateNodeMap(FFNode nodeFrom, FFNode nodeTo, IMetadata idFrom, IMetadata join) {
        nodeTo.mParents.addAll(nodeFrom.mParents);
        nodeTo.mAliasIds.addAll(nodeFrom.mAliasIds);
        nodeTo.mAliasJoins.addAll(nodeFrom.mAliasJoins);
        nodeTo.mAliasJoins.add(join);
        Set<FFNode> fromBranchKeySet = nodeFrom.mBranches.keySet();
        for (FFNode fromBranch : fromBranchKeySet) {
            TreeSet<IMetadata> fromBranchJoinSet = nodeFrom.mBranches.get(fromBranch);
            if (fromBranch == nodeTo) {
                this.mIsValid = false;
                return;
            }
            TreeSet<IMetadata> toBranchJoinSet = nodeTo.mBranches.get(fromBranch);
            if (toBranchJoinSet == null) {
                nodeTo.mBranches.put(fromBranch, fromBranchJoinSet);
            } else {
                toBranchJoinSet.addAll(fromBranchJoinSet);
            }
            Iterator<FFNode> fromBranchParentIter = fromBranch.mParents.iterator();
            while (fromBranchParentIter.hasNext()) {
                FFNode fromBranchParent = fromBranchParentIter.next();
                if (fromBranchParent != nodeFrom) continue;
                fromBranchParentIter.remove();
            }
            fromBranch.mParents.add(nodeTo);
        }
        Set<IMetadata> mapKeys = this.mNodeMap.keySet();
        for (IMetadata mapKey : mapKeys) {
            FFNode mapValue = this.mNodeMap.get(mapKey);
            if (mapValue != nodeFrom) continue;
            this.mNodeMap.put(mapKey, nodeTo);
        }
        if (this.mTreeRoots.contains(nodeFrom)) {
            this.mTreeRoots.remove(nodeFrom);
        }
        for (FFNode root : this.mTreeRoots) {
            ArrayList<FFNode> pathFromRoot = new ArrayList<FFNode>();
            this.fixBranchesAfterMerge2Aliases(root, nodeFrom, nodeTo, pathFromRoot);
            if (this.mIsValid) continue;
            return;
        }
    }

    public void fixBranchesAfterMerge2Aliases(FFNode node, FFNode from, FFNode to, List<FFNode> pathFromRoot) {
        if (pathFromRoot.contains(node)) {
            this.nagLoopInJoinPath(pathFromRoot);
            this.mIsValid = false;
            return;
        }
        pathFromRoot.add(node);
        TreeSet<IMetadata> combinedJoinSet = node.mBranches.get(from);
        if (combinedJoinSet != null) {
            if (node.mBranches.get(to) != null) {
                combinedJoinSet.addAll((Collection<IMetadata>)node.mBranches.get(to));
            }
            node.mBranches.put(to, combinedJoinSet);
            node.mBranches.remove(from);
        }
        Set<FFNode> keySet = node.mBranches.keySet();
        for (FFNode key : keySet) {
            this.fixBranchesAfterMerge2Aliases(key, from, to, pathFromRoot);
            if (this.mIsValid) continue;
            break;
        }
    }

    private void getNodeEntities(TreeSet<FFNode> nodes, TreeSet<IMetadata> entities) {
        for (FFNode node : nodes) {
            entities.addAll(node.mAliasIds);
        }
    }

    private void dumpNodeTree(StringBuilder msg, FFNode node, int indentLevel, Stack<FFNode> pathFromRoot, boolean dumpJoins) {
        if (!dumpJoins) {
            for (int iLevel = 0; iLevel < indentLevel; ++iLevel) {
                msg.append(NEW_TAB_CHARACTER);
            }
        }
        StringBuilder s = new StringBuilder();
        if (node.mAliasIds.size() > 1) {
            s.append("(Alias entities: ");
        } else {
            s.append("(");
        }
        int iCount = 0;
        for (IMetadata entity : node.mAliasIds) {
            if (iCount > 0) {
                s.append(SEMI_COLON_SPACE);
            }
            s.append(entity.getV5UniqueName());
            ++iCount;
        }
        s.append(CLOSE_PAREN);
        if (dumpJoins) {
            FactFinder.dumpJoins(node.mAliasJoins, 0, s, true);
        }
        s.append(NEW_LINE_CHARACTER);
        msg.append((CharSequence)s);
        if (pathFromRoot.contains(node)) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "dumpNodeTree():  Loop detected.");
        }
        pathFromRoot.push(node);
        Set<FFNode> branchKeySet = node.mBranches.keySet();
        for (FFNode branchKey : branchKeySet) {
            TreeSet<IMetadata> branchJoinSet = node.mBranches.get(branchKey);
            if (dumpJoins) {
                FactFinder.dumpJoins(branchJoinSet, indentLevel + 1, msg, false);
            }
            this.dumpNodeTree(msg, branchKey, indentLevel + 1, pathFromRoot, dumpJoins);
        }
        pathFromRoot.pop();
    }

    public static void dumpJoins(TreeSet<IMetadata> joinSet, int indentLevel, StringBuilder str, boolean isAliasJoinSet) {
        if (!joinSet.isEmpty()) {
            for (int iLevel = 0; iLevel < indentLevel; ++iLevel) {
                str.append(NEW_TAB_CHARACTER);
            }
        }
        if (isAliasJoinSet && !joinSet.isEmpty()) {
            str.append(" (Alias joins: ");
        } else if (!joinSet.isEmpty()) {
            str.append(" [");
        }
        int iCount = 0;
        for (IMetadata join : joinSet) {
            if (iCount > 0) {
                str.append(SEMI_COLON_SPACE);
            }
            str.append(join.getName());
            ++iCount;
        }
        if (isAliasJoinSet && !joinSet.isEmpty()) {
            str.append(CLOSE_PAREN);
        } else if (!joinSet.isEmpty()) {
            str.append("] ");
        }
    }

    public void addFactsToAvoidDoubleCounting(PlanningEnvironment environment, TreeMap<IMetadata, List<IMetadata>> entityToItems) {
        if (!this.isValid()) {
            return;
        }
        this.addFacts4DETQuerySubjects(environment, entityToItems);
    }

    private void addFacts4DETQuerySubjects(PlanningEnvironment environment, TreeMap<IMetadata, List<IMetadata>> entityToItems) {
        this.findDETQuerySubjectsInFacts(environment);
        this.createDeterminantFacts(environment, entityToItems);
    }

    private void findDETQuerySubjectsInFacts(PlanningEnvironment environment) {
        for (FFNode node : this.mTreeRoots) {
            this.findDETQuerySubjectsInOneFact(node, environment);
        }
    }

    private void findDETQuerySubjectsInOneFact(FFNode node, PlanningEnvironment environment) {
        HashMap<IMetadata, DETQuerySubjectInfo> detQSToDetInfo = new HashMap<IMetadata, DETQuerySubjectInfo>();
        HashMap<IMetadata, List<IMetadata>> detQSToKeys = new HashMap<IMetadata, List<IMetadata>>();
        this.getDETQuerySubjects(node, detQSToDetInfo, detQSToKeys, environment);
        if (detQSToDetInfo.isEmpty()) {
            return;
        }
        this.mFactHasDetQS = true;
        this.mDETQuerySubjectsFacts.add(detQSToDetInfo);
        this.mDETQuerySubjectsKeysFacts.add(detQSToKeys);
        this.mSupportedDetQueryItems.put(node, this.getQs2QueryItems(detQSToDetInfo));
        for (IMetadata qs : detQSToDetInfo.keySet()) {
            IDeterminant det1;
            IDeterminant det2;
            if (this.mDETQuerySubjects.containsKey(qs) && Determinants.determinantAtHigherLevel(det2 = detQSToDetInfo.get((Object)qs).mDeterminant, det1 = this.mDETQuerySubjects.get((Object)qs).mDeterminant)) continue;
            this.mDETQuerySubjects.put(qs, detQSToDetInfo.get(qs));
        }
    }

    HashMap<IMetadata, List<IMetadata>> getQs2QueryItems(HashMap<IMetadata, DETQuerySubjectInfo> detQSToDetInfo) {
        HashMap<IMetadata, List<IMetadata>> qs2QueryItems = new HashMap<IMetadata, List<IMetadata>>();
        for (IMetadata qs : detQSToDetInfo.keySet()) {
            qs2QueryItems.put(qs, detQSToDetInfo.get((Object)qs).mColIds);
        }
        return qs2QueryItems;
    }

    private void getDETQuerySubjects(FFNode node, HashMap<IMetadata, DETQuerySubjectInfo> detQSToDetInfo, HashMap<IMetadata, List<IMetadata>> detQSToKeys, PlanningEnvironment environment) {
        TreeMap<FFNode, TreeSet<IMetadata>> branches = node.getDirectBranches();
        Set<FFNode> branchKeys = branches.keySet();
        for (FFNode branch : branchKeys) {
            IMetadata entity;
            IDeterminant det;
            this.getDETQuerySubjects(branch, detQSToDetInfo, detQSToKeys, environment);
            TreeSet<IMetadata> joins = node.getJoinsForChild(branch);
            if (1 != joins.size() || (det = (IDeterminant)this.findDeterminantForTheJoin(entity = branch.getEntity(), joins.first(), environment)) == null) continue;
            ArrayList<IMetadata> keys = new ArrayList<IMetadata>();
            ArrayList<IMetadata> items = new ArrayList<IMetadata>();
            Determinants.getQueryItemsAtOrAboveTheDeterminant(entity, det, items, keys);
            DETQuerySubjectInfo detInfo = new DETQuerySubjectInfo();
            detInfo.mBranchNode = branch;
            detInfo.mDeterminant = det;
            detInfo.mKeys = keys;
            detInfo.mColIds = items;
            detInfo.mUniqueRow = det.getIdentifiesRow();
            if (detQSToDetInfo.containsKey(entity) && Determinants.determinantAtHigherLevel(det, detQSToDetInfo.get((Object)entity).mDeterminant)) continue;
            detQSToDetInfo.put(entity, detInfo);
            detQSToKeys.put(entity, keys);
        }
    }

    private IMetadata findDeterminantForTheJoin(IMetadata entity, IMetadata join, PlanningEnvironment environment) {
        if (entity instanceof IDimension) {
            return null;
        }
        IQuerySubject qs = null;
        qs = entity.getObjectType() == MetadataType.SHORTCUT ? (IQuerySubject)((IShortcut)entity).getTarget() : (entity.getObjectType() == MetadataType.FOLDER ? ((IQueryItemFolder)entity).getQuerySubject() : (IQuerySubject)entity);
        if (qs.getDeterminants() == null || qs.getDeterminants().isEmpty()) {
            return null;
        }
        List<IMetadata> queryItems = this.getQueryItemsFromJoin((IRelationship)join, environment);
        Iterator<IMetadata> iter = queryItems.iterator();
        while (iter.hasNext()) {
            IMetadata obj = iter.next();
            if (!(obj instanceof IQueryItem)) {
                iter.remove();
                continue;
            }
            IQueryItem qi = (IQueryItem)obj;
            IQuerySubject qs2 = qi.getQuerySubject();
            if (qs2 == null) {
                iter.remove();
                continue;
            }
            if (qs.getV5UniqueName().equals(qs2.getV5UniqueName())) continue;
            iter.remove();
        }
        if (queryItems.size() > 0) {
            Determinants detInfo = new Determinants();
            detInfo.instantiate(new HashSet<IMetadata>(queryItems), true);
            return detInfo.getOneDeterminant();
        }
        return null;
    }

    private List<IMetadata> getQueryItemsFromJoin(IRelationship join, PlanningEnvironment environment) {
        IXQEQueryNode enode = RQPUtilities.createV5ValueExpression(join, environment, null);
        if (enode == null) {
            return new ArrayList<IMetadata>();
        }
        List<Object> metadata = null;
        if (factFinderUsesEquiJoins == null) {
            factFinderUsesEquiJoins = environment.getMultiRequestContext().fetchBooleanConfiguration("queryPlanning.FactFinderUsesEquiJoins.[@enabled]", true);
        }
        if (factFinderUsesEquiJoins.booleanValue()) {
            metadata = new ArrayList();
            if (!this.getQueryItemsFromEquiJoinExpression(enode, environment, metadata)) {
                metadata.clear();
            }
        } else {
            metadata = this.getQueryItemsFromV5ExpressionNode(enode, environment);
        }
        enode.detach();
        return metadata;
    }

    private boolean getQueryItemsFromEquiJoinExpression(IXQEQueryNode exprNode, PlanningEnvironment environment, List<IMetadata> metadata) {
        IXQEQueryNode[] children;
        MetadataConnection mc = environment.getMetadataConnection();
        switch (exprNode.getNodeType()) {
            case 201030: {
                IMetadata md = mc.bindMetadataReference(((V5MultiPartIdentifier)exprNode).getIdentifier());
                if (this.isStandaloneFilterOrCalc(md)) {
                    IXQEQueryNode expr = RQPUtilities.getV5ValueExpression(md, environment);
                    if (!this.getQueryItemsFromEquiJoinExpression(expr, environment, metadata)) {
                        expr.detach();
                        return false;
                    }
                    expr.detach();
                } else {
                    metadata.add(md);
                }
                return true;
            }
            case 201003: {
                if (((V5LogicalExpression)exprNode).getSubType() == 0) break;
                return false;
            }
            case 201013: {
                if (((V5ComparisonExpression)exprNode).getSubType() == 2) break;
                return false;
            }
            default: {
                return false;
            }
        }
        for (IXQEQueryNode c : children = exprNode.getChildren()) {
            if (this.getQueryItemsFromEquiJoinExpression(c, environment, metadata)) continue;
            return false;
        }
        return true;
    }

    private List<IMetadata> getQueryItemsFromV5ExpressionNode(IXQEQueryNode exprNode, PlanningEnvironment environment) {
        IXQEQueryNode[] identifiers = exprNode.getDescendantsOfType(201030, false);
        MetadataConnection mc = environment.getMetadataConnection();
        ArrayList<IMetadata> metaData = new ArrayList<IMetadata>();
        for (IXQEQueryNode id : identifiers) {
            IMetadata md = mc.bindMetadataReference(((V5MultiPartIdentifier)id).getIdentifier());
            if (this.isStandaloneFilterOrCalc(md)) {
                IXQEQueryNode expr = RQPUtilities.getV5ValueExpression(md, environment);
                metaData.addAll(this.getQueryItemsFromV5ExpressionNode(expr, environment));
                expr.detach();
                continue;
            }
            metaData.add(md);
        }
        return metaData;
    }

    private boolean isStandaloneFilterOrCalc(IMetadata metadata) {
        IMetadata md = metadata;
        while (MetadataType.SHORTCUT == md.getObjectType()) {
            md = ((IShortcut)md).getTarget();
        }
        return MetadataType.FILTER == md.getObjectType() || MetadataType.CALCULATION == md.getObjectType();
    }

    void createDeterminantFacts(PlanningEnvironment environment, TreeMap<IMetadata, List<IMetadata>> entityToItems) {
        ArrayList<IMetadata> usedItems = new ArrayList<IMetadata>();
        for (IMetadata qs : this.mDETQuerySubjects.keySet()) {
            usedItems.clear();
            if (entityToItems.get(qs) == null) continue;
            usedItems.addAll((Collection)entityToItems.get(qs));
            List<IMetadata> detItems = this.mDETQuerySubjects.get((Object)qs).mColIds;
            usedItems.removeAll(detItems);
            if (usedItems.isEmpty()) continue;
            Determinants detInfo = new Determinants();
            detInfo.instantiate(new HashSet<IMetadata>(usedItems), true);
            ArrayList<IMetadata> keys = new ArrayList<IMetadata>();
            ArrayList<IMetadata> items = new ArrayList<IMetadata>();
            Determinants.getQueryItemsAtOrAboveTheDeterminant(qs, detInfo.getOneDeterminant(), items, keys);
            keys.addAll(this.mDETQuerySubjects.get((Object)qs).mKeys);
            usedItems.clear();
            usedItems.addAll((Collection)entityToItems.get(qs));
            usedItems.addAll(keys);
            DMQuerySubject detQS = new DMQuerySubject("det_" + qs.getName());
            FFNode newFact = new FFNode(detQS, this.mNodeCount++);
            newFact.setIsForDetQS(true);
            DMRelationship join = new DMRelationship("join4fact", qs, detQS, null);
            TreeSet<DMRelationship> branchJoinSet = new TreeSet<DMRelationship>();
            branchJoinSet.add(join);
            newFact.mBranches.put(this.mDETQuerySubjects.get((Object)qs).mBranchNode, branchJoinSet);
            this.mTreeRoots.add(newFact);
            HashMap<IMetadata, ArrayList<IMetadata>> qs2Items = new HashMap<IMetadata, ArrayList<IMetadata>>();
            qs2Items.put(qs, usedItems);
            this.mSupportedDetQueryItems.put(newFact, qs2Items);
            DETQuerySubjectInfo info = new DETQuerySubjectInfo();
            info.mDeterminant = detInfo.getOneDeterminant();
            info.mColIds = usedItems;
            info.mBranchNode = this.mDETQuerySubjects.get((Object)qs).mBranchNode;
            HashMap<IMetadata, DETQuerySubjectInfo> d1 = new HashMap<IMetadata, DETQuerySubjectInfo>();
            d1.put(qs, info);
            this.mDETQuerySubjectsFacts.add(d1);
            HashMap<IMetadata, ArrayList<IMetadata>> d2 = new HashMap<IMetadata, ArrayList<IMetadata>>();
            d2.put(qs, keys);
            this.mDETQuerySubjectsKeysFacts.add(d2);
        }
    }

    public List<List<IMetadata>> filterOutDuplicatePaths(List<List<IMetadata>> joinPaths) {
        if (joinPaths.size() < 2) {
            return joinPaths;
        }
        TreeSet<PathInfo> seenPaths = new TreeSet<PathInfo>();
        boolean bDuplicateFound = false;
        for (List<IMetadata> path : joinPaths) {
            PathInfo newPath = new PathInfo(path);
            if (seenPaths.contains(newPath)) {
                bDuplicateFound = true;
                continue;
            }
            seenPaths.add(newPath);
        }
        if (bDuplicateFound) {
            ArrayList<List<IMetadata>> nonDuplicatePaths = new ArrayList<List<IMetadata>>();
            for (PathInfo pi : seenPaths) {
                nonDuplicatePaths.add(pi.getInputPath());
            }
            return nonDuplicatePaths;
        }
        return joinPaths;
    }

    public FFNode getAlphabeticalFirstFact() {
        String name = null;
        FFNode firstFact = null;
        for (FFNode rootNode : this.mTreeRoots) {
            String nodeName = rootNode.getNodeName();
            if (name != null && name.compareTo(nodeName) <= 0) continue;
            firstFact = rootNode;
            name = nodeName;
        }
        return firstFact;
    }

    public void retainOnlyAlphabeticalFirstFact(PlanningEnvironment environment) {
        if (this.mTreeRoots.size() == 0) {
            return;
        }
        this.mIsFirstFactRetained = true;
        if (this.mTreeRoots.size() == 1) {
            this.issuesWarningUseRetainedFactTable(environment);
            return;
        }
        FFNode alphaFirstFact = this.getAlphabeticalFirstFact();
        Iterator<FFNode> iter = this.mTreeRoots.iterator();
        TreeSet<String> acceptableFacts = new TreeSet<String>();
        while (iter.hasNext()) {
            FFNode fact = iter.next();
            acceptableFacts.add(fact.getNodeName());
            if (fact == alphaFirstFact) continue;
            iter.remove();
        }
        this.generateWarningRetainOnlyAlphabeticalFirstFact(alphaFirstFact.getNodeName(), acceptableFacts, environment);
    }

    public boolean getIsFirstFactRetained() {
        return this.mIsFirstFactRetained;
    }

    public ResponseMessage getAlphaFirstFactRetainedMessage() {
        return this.mRetainAlphaFirstFactWarningMsg;
    }

    public void filterOutNonOptimalFactStreams(TreeMap<IMetadata, List<IMetadata>> qs2QsItems, PlanningEnvironment environment, boolean isPrePlan) {
        this.filterOutFactStreamsThatDoNotCoverAllRequestedEntities(qs2QsItems, environment, isPrePlan);
        this.filterOutFactStreamsThatJoinToDimTablesAtHigherGranularityThanUsedItems(qs2QsItems, environment);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void filterOutFactStreamsThatDoNotCoverAllRequestedEntities(TreeMap<IMetadata, List<IMetadata>> qs2QsItems, PlanningEnvironment environment, boolean isPrePlan) {
        ArrayList<FFNode> factsToRemove = new ArrayList<FFNode>();
        block0: for (FFNode fact : this.mTreeRoots) {
            TreeSet<IMetadata> factEntities = new TreeSet<IMetadata>();
            fact.getBranchesInfo(factEntities);
            for (IMetadata entity : qs2QsItems.keySet()) {
                if (factEntities.contains(entity)) continue;
                factsToRemove.add(fact);
                continue block0;
            }
        }
        if (factsToRemove.size() > 0) {
            if (factsToRemove.size() == this.mTreeRoots.size()) {
                if (!isPrePlan) throw new XQERuntimeException(XQEMessageKeys.PLN_UnsupportedDimOnly_NoFactStreamForAllEntities, this.getSortedFactNamesInAString(factsToRemove));
                ResponseMessage responseMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT, XQEMessageKeys.PLN_UnsupportedDimOnly_NoFactStreamForAllEntities, this.getSortedFactNamesInAString(factsToRemove));
                environment.getResponseMessageFolder().appendPlanningResponseMessage(responseMsg);
            } else {
                this.issuesWarningEliminateFactsNotCoveringUsedEntities(factsToRemove, environment);
            }
            this.removeNonOptimalFacts(factsToRemove);
        }
        factsToRemove.clear();
    }

    public boolean containsBridge() {
        for (FFNode factNode : this.mTreeRoots) {
            TreeSet<IMetadata> factAliases = new TreeSet<IMetadata>();
            factNode.getAliasIds(factAliases);
            for (IMetadata factEntity : factAliases) {
                IQuerySubject qs;
                if (!(factEntity instanceof IQuerySubject) || !(qs = (IQuerySubject)factEntity).getQuerySubjectUsage().equals((Object)IQuerySubject.QuerySubjectUsageEnum.BRIDGE)) continue;
                return true;
            }
        }
        return false;
    }

    private void filterOutFactStreamsThatJoinToDimTablesAtHigherGranularityThanUsedItems(TreeMap<IMetadata, List<IMetadata>> qs2QsItems, PlanningEnvironment environment) {
        if (this.mTreeRoots.size() == 1) {
            return;
        }
        if (this.mSupportedDetQueryItems.size() == 0) {
            return;
        }
        ArrayList<FFNode> factsToRemove = new ArrayList<FFNode>();
        for (FFNode fact : this.mTreeRoots) {
            if (!this.factJoinsToDETQSAtHigherGranularity(fact, qs2QsItems)) continue;
            factsToRemove.add(fact);
        }
        if (factsToRemove.size() > 0 && factsToRemove.size() < this.mTreeRoots.size()) {
            this.removeNonOptimalFacts(factsToRemove);
            this.issuesWarningEliminateFactsThatHaveJoinATHigherGranularityThanUsedItems(factsToRemove, environment);
        }
        factsToRemove.clear();
    }

    private boolean factJoinsToDETQSAtHigherGranularity(FFNode fact, TreeMap<IMetadata, List<IMetadata>> qs2QsItems) {
        HashMap<IMetadata, List<IMetadata>> qs2ItemsCoveredByFact = this.mSupportedDetQueryItems.get(fact);
        if (qs2ItemsCoveredByFact == null || qs2ItemsCoveredByFact.size() == 0) {
            return false;
        }
        for (IMetadata qs : qs2ItemsCoveredByFact.keySet()) {
            if (!qs2QsItems.keySet().contains(qs)) continue;
            List<IMetadata> itemsInRequest = qs2QsItems.get(qs);
            List<IMetadata> itemsCoveredByFact = qs2ItemsCoveredByFact.get(qs);
            if (itemsCoveredByFact.containsAll(itemsInRequest)) continue;
            return true;
        }
        return false;
    }

    private void removeNonOptimalFacts(List<FFNode> factsToRemove) {
        Iterator<FFNode> iter = this.mTreeRoots.iterator();
        while (iter.hasNext()) {
            FFNode fact = iter.next();
            if (!factsToRemove.contains(fact)) continue;
            iter.remove();
        }
    }

    private void issuesWarningUseRetainedFactTable(PlanningEnvironment environment) {
        ResponseMessage responseMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT, XQEMessageKeys.WRN_UseRetainedFactTable, this.mTreeRoots.get(0).getNodeName());
        environment.getResponseMessageFolder().appendPlanningResponseMessage(responseMsg);
    }

    private void generateWarningRetainOnlyAlphabeticalFirstFact(String retainedFact, TreeSet<String> acceptableFacts, PlanningEnvironment environment) {
        ResponseMessage responseMsg;
        StringBuilder sb = new StringBuilder();
        for (String factName : acceptableFacts) {
            if (sb.length() > 0) {
                sb.append(COMMA_SPACE);
            }
            sb.append(factName);
        }
        this.mRetainAlphaFirstFactWarningMsg = responseMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT, XQEMessageKeys.WRN_UseAlphabeticallyFirstFactTable, retainedFact, sb.toString());
    }

    private void issuesWarningEliminateFactsNotCoveringUsedEntities(List<FFNode> factsToRemove, PlanningEnvironment environment) {
        ResponseMessage responseMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT, XQEMessageKeys.WRN_EliminateFactsNotCoveringUsedEntities, this.getSortedFactNamesInAString(factsToRemove));
        environment.getResponseMessageFolder().appendPlanningResponseMessage(responseMsg);
    }

    private void issuesWarningEliminateFactsThatHaveJoinATHigherGranularityThanUsedItems(List<FFNode> factsToRemove, PlanningEnvironment environment) {
        ResponseMessage responseMsg = new ResponseMessage(1, ResponseMessage.ResponseMessageType.RQP_NODE_TYPE_INT, XQEMessageKeys.WRN_EliminateFactsThatHaveJoinsAtHigherGranularityDET, this.getSortedFactNamesInAString(factsToRemove));
        environment.getResponseMessageFolder().appendPlanningResponseMessage(responseMsg);
    }

    private String getSortedFactNamesInAString(List<FFNode> factsToRemove) {
        TreeSet<String> sortedFacts = new TreeSet<String>();
        for (FFNode fact : factsToRemove) {
            sortedFacts.add(fact.getNodeName());
        }
        StringBuilder sb = new StringBuilder();
        for (String factName : sortedFacts) {
            if (sb.length() > 0) {
                sb.append(COMMA_SPACE);
            }
            sb.append(factName);
        }
        return sb.toString();
    }

    public FFNode getFFNodeByMetadata(IMetadata key) {
        return this.mNodeMap.get(key);
    }

    class PathInfo
    implements Comparable<PathInfo> {
        private TreeSet<String> mJoinEntityNames = new TreeSet();
        private List<IMetadata> mInputPath = null;

        PathInfo(List<IMetadata> joinPath) {
            this.mInputPath = joinPath;
            for (IMetadata jn : joinPath) {
                IRelationship join = (IRelationship)jn;
                JoinInfo jnInfo = new JoinInfo(join.getLeftRefObjectId(), join.getRightRefObjectId());
                String joinEntityNames = jnInfo.mLeftNode.concat(jnInfo.mRightNode);
                this.mJoinEntityNames.add(joinEntityNames);
            }
        }

        public List<IMetadata> getInputPath() {
            return this.mInputPath;
        }

        @Override
        public int compareTo(PathInfo that) {
            StringSetComparator strSetComparator = new StringSetComparator();
            return strSetComparator.compare(this.mJoinEntityNames, that.mJoinEntityNames);
        }
    }

    class JoinInfo {
        String mLeftNode;
        String mRightNode;

        JoinInfo(String node1, String node2) {
            if (node1.compareTo(node2) < 0) {
                this.mLeftNode = node1;
                this.mRightNode = node2;
            } else {
                this.mLeftNode = node2;
                this.mRightNode = node1;
            }
        }
    }

    class DETQuerySubjectInfo {
        IDeterminant mDeterminant;
        boolean mUniqueRow;
        List<IMetadata> mKeys;
        List<IMetadata> mColIds;
        FFNode mBranchNode;

        DETQuerySubjectInfo() {
        }
    }
}

