/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.v5tocogsql.util.StringSetComparator;
import com.cognos.xqe.transformation.v5tocogsql.util.joinRefinement.FactFinder;
import java.util.List;
import java.util.TreeSet;

public class RQPPathInfo
implements Comparable<RQPPathInfo> {
    List<IMetadata> mPath = null;
    boolean compareNumberOfFacts = true;
    int mFacts = 0;
    TreeSet<String> mJoinNames = null;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public RQPPathInfo(List<IMetadata> path) {
        this.mPath = path;
        this.populateJoinNameSet();
        this.computeFactsInPath();
    }

    public RQPPathInfo(List<IMetadata> path, boolean useNumberOfFactsAsCriteria) {
        this.mPath = path;
        this.populateJoinNameSet();
        if (useNumberOfFactsAsCriteria) {
            this.compareNumberOfFacts = useNumberOfFactsAsCriteria;
            this.computeFactsInPath();
        }
    }

    @Override
    public int compareTo(RQPPathInfo that) {
        if (this.compareNumberOfFacts) {
            if (this.mFacts < that.mFacts) {
                return -1;
            }
            if (this.mFacts > that.mFacts) {
                return 1;
            }
        }
        StringSetComparator strSetComparator = new StringSetComparator();
        return strSetComparator.compare(this.mJoinNames, that.mJoinNames);
    }

    private void populateJoinNameSet() {
        this.mJoinNames = new TreeSet();
        for (IMetadata join : this.mPath) {
            this.mJoinNames.add(join.getName());
        }
    }

    private void computeFactsInPath() {
        FactFinder factFinder = new FactFinder(null);
        try {
            factFinder.addJoinPath(this.mPath);
            this.mFacts = factFinder.getNumberOfFacts();
        }
        catch (XQERuntimeException theException) {
            mErrorLogger.log(theException);
            this.mFacts = 0;
        }
    }

    public int getNumberFacts() {
        return this.mFacts;
    }
}

