/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.GraphEdge;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.GraphEdgeList;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.GraphEdgeListNode;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.IUndirectedGraph;
import com.cognos.xqe.transformation.v5tocogsql.util.undirectedgraph.ShortestDistance4Forest;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.pool.XQELongPool;
import com.cognos.xqe.util.primitive.LongArrayList;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.IUsageIndicator;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorType;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class UndirectedGraph
implements IUndirectedGraph {
    private final int mAllPathsLimit = 100;
    private final int mGraphEdgeWeight = 5;
    private final int mShortestDistance = 99999999;
    private static final int mMaxVertice = 50000000;
    private static final int mMinWeight = 100000000;
    private final byte mAllBitsOff = 0;
    private final byte mVertexGoingFringe = 1;
    private final byte mVertexInFringe = (byte)2;
    private final byte mVertexInTree = (byte)4;
    private final byte mVertexPrefer = (byte)8;
    private Map<String, Integer> mEdgeNumbers = new HashMap<String, Integer>();
    private Map<String, Integer> mNodeNumbers = new HashMap<String, Integer>();
    private ArrayList<GraphEdge> mEdges = new ArrayList();
    private ArrayList<String> mNodes = new ArrayList();
    private boolean mChanged = true;
    private ArrayList<ArrayList<GraphEdge>> mAdjacency = null;
    private ArrayList<ArrayList<Integer>> mForest = null;
    private ArrayList<ArrayList<Integer>> mForestEdges = null;
    private TreeSet<Integer> mEdges4BFS = null;
    private byte[] mNodeStatus = null;
    private int[] mLabel = null;
    private int[] mFromNode = null;
    private String[] mPath = null;
    private String[] mEmptyPath = null;
    private int[] mPreferNodePos = null;
    private Fringe mFringe = null;
    private LongArrayList mNewFringe = null;
    private boolean mGetAllShortestPathTrees3LikeClassic = false;
    private byte[] mDefaultByteArray = null;
    private int[] mDefaultIntArray = null;
    private static final int MAXIMUM_100 = 100;
    private boolean mJustTheBestStarts = false;
    private static final int DEFAULT_BEST_START_LIMIT = 10000;
    private int mBestStartLimit = 10000;
    private static final XQELogger INFO_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "JoinPath", LogLevel.INFO);
    private static final String MS_UOM = "(ms)";
    private IUsageIndicator graphBuildCountIndicator = null;
    private IUsageIndicator graphBuildTimeIndicator = null;
    private IUsageIndicator graphNodesCountIndicator = null;
    private IUsageIndicator graphEdgesCountIndicator = null;
    private IUsageIndicator graphGetShortestPathCountIndicator = null;
    private IUsageIndicator graphGetShortestPathTimeIndicator = null;

    public UndirectedGraph(String modelPath) {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        int bestStartLimit = config.getIntProperty("general.joinpath[@bestStartLimit]", 10000);
        if (bestStartLimit < 0) {
            this.mJustTheBestStarts = true;
            this.mBestStartLimit = -bestStartLimit - 1;
        } else {
            this.mBestStartLimit = bestStartLimit - 1;
        }
        this.initUsageIndicators(modelPath);
    }

    private void initUsageIndicators(String modelPath) {
        if (modelPath != null && UsageTrackingService.isEnabled()) {
            this.graphBuildCountIndicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.UDGRAPHBUILDCOUNT, modelPath);
            this.graphBuildTimeIndicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.UDGRAPHBUILDTIME, modelPath);
            this.graphNodesCountIndicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.UDGRAPHNODESCOUNT, modelPath);
            this.graphEdgesCountIndicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.UDGRAPHEDGESCOUNT, modelPath);
            this.graphGetShortestPathCountIndicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.UDGRAPHGETSHORTESTPATHCOUNT, modelPath);
            this.graphGetShortestPathTimeIndicator = UsageTrackingService.getIndicator(UsageIndicatorType.SIMPLE_INDICATOR, UsageIndicatorCategory.UDGRAPHGETSHORTESTPATHTIME, modelPath);
        }
    }

    @Override
    public void recordBuildTime(long time) {
        if (this.graphBuildCountIndicator != null) {
            this.graphBuildCountIndicator.increment();
        }
        if (this.graphBuildTimeIndicator != null) {
            this.graphBuildTimeIndicator.add(time);
        }
    }

    @Override
    public void recordNodesEdgesCount() {
        if (this.graphNodesCountIndicator != null && this.graphNodesCountIndicator.getValue() < (long)this.mNodes.size()) {
            this.graphNodesCountIndicator.setValue(this.mNodes.size());
        }
        if (this.graphEdgesCountIndicator != null && this.graphEdgesCountIndicator.getValue() < (long)this.mEdges.size()) {
            this.graphEdgesCountIndicator.setValue(this.mEdges.size());
        }
    }

    @Override
    public void recordGetShortestPathTime(long time) {
        if (this.graphGetShortestPathCountIndicator != null) {
            this.graphGetShortestPathCountIndicator.increment();
        }
        if (this.graphGetShortestPathTimeIndicator != null) {
            this.graphGetShortestPathTimeIndicator.add(time);
        }
    }

    @Override
    public void addNode(String node) {
        if (this.getNodeNumber(node) < 0) {
            Integer nodeIdx = XQEIntegerPool.getInteger(this.mNodes.size());
            this.mNodeNumbers.put(node, nodeIdx);
            this.mNodes.add(node);
            this.markAsChanged();
        }
    }

    @Override
    public void addEdge(String e, String v1, String v2, int weight, boolean mandatory) {
        int v1Idx = this.getNodeNumber(v1);
        int v2Idx = this.getNodeNumber(v2);
        if (v1Idx < 0 || v1Idx >= this.mNodes.size() || v2Idx < 0 || v2Idx >= this.mNodes.size()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "addEdge():  Unable to process the join. One of the nodes is missing from the graph.");
        }
        if (this.getEdgeNumber(e) < 0) {
            int idx;
            int edgeNumber = this.mEdges.size();
            this.mEdgeNumbers.put(e, XQEIntegerPool.getInteger(edgeNumber));
            if (this.mAdjacency == null) {
                this.mAdjacency = new ArrayList(this.mNodes.size());
                for (idx = 0; idx < this.mNodes.size(); ++idx) {
                    this.mAdjacency.add(new ArrayList());
                }
            } else if (this.mNodes.size() > this.mAdjacency.size()) {
                this.mAdjacency.ensureCapacity(this.mNodes.size());
                for (idx = this.mAdjacency.size(); idx < this.mNodes.size(); ++idx) {
                    this.mAdjacency.add(idx, new ArrayList());
                }
            }
            GraphEdge toV2 = new GraphEdge(e, edgeNumber, v1Idx, v2Idx, weight, mandatory);
            GraphEdge toV1 = new GraphEdge(e, edgeNumber, v2Idx, v1Idx, weight, mandatory);
            toV1.setCounterpart(toV2);
            toV2.setCounterpart(toV1);
            ArrayList<GraphEdge> v1List = this.mAdjacency.get(v1Idx);
            v1List.add(toV2);
            ArrayList<GraphEdge> v2List = this.mAdjacency.get(v2Idx);
            v2List.add(toV1);
            this.mEdges.add(toV1);
            this.markAsChanged();
        }
    }

    @Override
    public boolean getAllShortestPathTrees(ArrayList<String> nodes, ArrayList<ArrayList<String>> allShortestPaths, int[] totalWeight, boolean isRecursive) {
        allShortestPaths.clear();
        totalWeight[0] = -1;
        if (nodes.size() < 2) {
            return true;
        }
        if (this.mAdjacency == null) {
            return false;
        }
        if (2 == nodes.size()) {
            ArrayList<ArrayList<String>> dummy = new ArrayList<ArrayList<String>>();
            this.getAllShortestPaths(nodes.get(0), nodes.get(1), dummy, allShortestPaths, totalWeight);
            return -1 != totalWeight[0];
        }
        long startTime = System.currentTimeMillis();
        if (INFO_LOGGER.isOn()) {
            INFO_LOGGER.log("gaspt-01: graph: n= " + this.mNodes.size() + " e= " + this.mEdges.size());
        }
        boolean isConnected = this.getAllShortestPathTrees3(nodes, allShortestPaths, totalWeight);
        if (INFO_LOGGER.isOn()) {
            INFO_LOGGER.log("gaspt-02: elapsed=" + (System.currentTimeMillis() - startTime) + MS_UOM + " nodes.size= " + nodes.size() + " allShortestPaths.size= " + allShortestPaths.size() + " w=" + totalWeight[0]);
            for (int i = 0; i < allShortestPaths.size(); ++i) {
                INFO_LOGGER.log("gaspt-03:     path " + Integer.toString(i + 1) + " : " + allShortestPaths.get(i));
            }
        }
        if (isConnected) {
            return true;
        }
        if (isRecursive) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unexpected flag = true.");
        }
        this.calculateConnectedComponents();
        TreeMap<Integer, ShortestDistance4Forest> forest2ShortestDistance = new TreeMap<Integer, ShortestDistance4Forest>();
        for (int i = 0; i < nodes.size(); ++i) {
            ShortestDistance4Forest forest;
            String nId = nodes.get(i);
            int nodeIdx = this.getNodeNumber(nId);
            Integer intNodeIdx = XQEIntegerPool.getInteger(nodeIdx);
            int forestPos = -1;
            forestPos = ShortestDistance4Forest.getForestPos(this.mForest, intNodeIdx);
            if (-1 == forestPos) {
                return false;
            }
            Integer intForestPos = XQEIntegerPool.getInteger(forestPos);
            if (forest2ShortestDistance.containsKey(intForestPos)) {
                forest = (ShortestDistance4Forest)forest2ShortestDistance.get(intForestPos);
                forest.addToNodeIdx2BaseId(intNodeIdx, nId);
                continue;
            }
            forest = new ShortestDistance4Forest();
            forest.setForestId(forestPos);
            ArrayList<Integer> nodesForest = this.mForest.get(forestPos);
            for (int j = 0; j < nodesForest.size(); ++j) {
                Integer nodeInForest = nodesForest.get(j);
                String nodeId = this.getNodeId(nodeInForest);
                forest.addToNodeBaseId2Idx(nodeId, nodeInForest);
            }
            forest.addToNodeIdx2BaseId(intNodeIdx, nId);
            forest2ShortestDistance.put(intForestPos, forest);
        }
        Collection allForests = forest2ShortestDistance.values();
        for (ShortestDistance4Forest forest : allForests) {
            ArrayList<String> forest2joinNodes = new ArrayList<String>();
            forest.getToJoinNodes(forest2joinNodes);
            ArrayList<ArrayList<String>> allJoinPathsForest = new ArrayList<ArrayList<String>>();
            int[] weightForest = new int[1];
            boolean bConnected = this.getAllShortestPathTrees(forest2joinNodes, allJoinPathsForest, weightForest, true);
            if (!bConnected) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Nodes in the forest are not connected.");
            }
            forest.addToAllShortestPaths(allJoinPathsForest);
            forest.setWeight(weightForest[0]);
        }
        allForests = forest2ShortestDistance.values();
        Iterator itForest = allForests.iterator();
        ArrayList<ArrayList<ArrayList<String>>> allps = new ArrayList<ArrayList<ArrayList<String>>>();
        while (itForest.hasNext()) {
            ShortestDistance4Forest forest = (ShortestDistance4Forest)itForest.next();
            if (-1 == forest.getWeight()) continue;
            totalWeight[0] = -1 == totalWeight[0] ? forest.getWeight() : totalWeight[0] + forest.getWeight();
            allps.add(forest.getAllShortestPaths());
        }
        ShortestDistance4Forest.crossProduct(allShortestPaths, allps, 100);
        return 1 == forest2ShortestDistance.size();
    }

    @Override
    public void getShortestPathTree(ArrayList<String> nodes, ArrayList<String> treeNodes, ArrayList<String> treeEdges, int[] totalWeight) {
        treeNodes.clear();
        treeEdges.clear();
        totalWeight[0] = -1;
        if (this.mAdjacency == null) {
            return;
        }
        int nodeCount = nodes.size();
        if (nodeCount < 2) {
            return;
        }
        this.resetOrAllocateTempArrays(nodeCount);
        boolean[] visitedEdges = new boolean[this.mEdges.size()];
        int startPos = 0;
        for (int i = 0; i < nodeCount; ++i) {
            String nodeId = nodes.get(i);
            int nPos = this.getNodeNumber(nodeId);
            if (-1 == nPos) {
                return;
            }
            this.mPreferNodePos[i] = nPos;
            this.mNodeStatus[nPos] = 8;
            if (0 != i) continue;
            startPos = nPos;
        }
        totalWeight[0] = 0;
        int nNodeInTree = 0;
        this.mNodeStatus[startPos] = (byte)(this.mNodeStatus[startPos] | 2);
        this.mFringe.add(startPos);
        while (this.mFringe.size() != 0) {
            long firstValue = this.mFringe.getTop();
            int topPos = (int)(firstValue % 100000000L);
            if (topPos >= 50000000) {
                topPos -= 50000000;
            }
            this.mFringe.popTop();
            if ((this.mNodeStatus[topPos] & 8) != 0) {
                ++nNodeInTree;
            }
            if (nNodeInTree == nodeCount) break;
            this.mNodeStatus[topPos] = 4;
            this.resetNewFringe();
            ArrayList<GraphEdge> edgeList = this.mAdjacency.get(topPos);
            for (GraphEdge edgePtr : edgeList) {
                int edgePos = this.getEdgeNumber(edgePtr.getEdgeId());
                if (visitedEdges[edgePos]) continue;
                visitedEdges[edgePos] = true;
                int toNodePos = edgePtr.getToNode();
                if (4 == this.mNodeStatus[toNodePos]) continue;
                int weight = this.mLabel[topPos] + edgePtr.getWeight();
                if ((2 & this.mNodeStatus[toNodePos]) != 0) {
                    if (weight >= this.mLabel[toNodePos]) continue;
                    long k = this.mLabel[toNodePos];
                    int endValue = 0;
                    if ((this.mNodeStatus[toNodePos] & 8) == 0) {
                        endValue = 50000000;
                    }
                    k = k * 100000000L + (long)toNodePos + (long)endValue;
                    this.mFringe.remove(k);
                    this.mNodeStatus[toNodePos] = (byte)(this.mNodeStatus[toNodePos] & 8);
                    this.mNodeStatus[toNodePos] = (byte)(this.mNodeStatus[toNodePos] | 1);
                    this.mLabel[toNodePos] = weight;
                    this.mFromNode[toNodePos] = topPos;
                    this.mPath[toNodePos] = edgePtr.getEdgeId();
                    this.mNewFringe.add(toNodePos);
                    continue;
                }
                if ((1 & this.mNodeStatus[toNodePos]) != 0) {
                    if (weight >= this.mLabel[toNodePos]) continue;
                    this.mLabel[toNodePos] = weight;
                    this.mFromNode[toNodePos] = topPos;
                    this.mPath[toNodePos] = edgePtr.getEdgeId();
                    continue;
                }
                this.mNodeStatus[toNodePos] = (byte)(this.mNodeStatus[toNodePos] & 8);
                this.mNodeStatus[toNodePos] = (byte)(this.mNodeStatus[toNodePos] | 1);
                this.mLabel[toNodePos] = weight;
                this.mFromNode[toNodePos] = topPos;
                this.mPath[toNodePos] = edgePtr.getEdgeId();
                this.mNewFringe.add(toNodePos);
            }
            for (int i = 0; i < this.mNewFringe.size(); ++i) {
                int newNodePos = (int)this.mNewFringe.getFast(i);
                this.mNodeStatus[newNodePos] = (byte)(this.mNodeStatus[newNodePos] & 8);
                this.mNodeStatus[newNodePos] = (byte)(this.mNodeStatus[newNodePos] | 2);
                long k = this.mLabel[newNodePos];
                int endValue = 0;
                if ((this.mNodeStatus[newNodePos] & 8) == 0) {
                    endValue = 50000000;
                }
                k = k * 100000000L + (long)newNodePos + (long)endValue;
                this.mFringe.add(k);
            }
        }
        if (nNodeInTree != nodeCount) {
            totalWeight[0] = -1;
            return;
        }
        TreeSet<String> ps = new TreeSet<String>();
        for (int i = nodeCount - 1; i > 0; --i) {
            int pos = this.mPreferNodePos[i];
            do {
                ps.add(this.mPath[pos]);
            } while ((pos = this.mFromNode[pos]) != startPos);
        }
        TreeSet<String> ns = new TreeSet<String>();
        for (String edgeId : ps) {
            treeEdges.add(edgeId);
            GraphEdge ped = this.getGraphEdge(this.getEdgeNumber(edgeId));
            ns.add(this.getNodeId(ped.getFromNode()));
            ns.add(this.getNodeId(ped.getToNode()));
            totalWeight[0] = totalWeight[0] + ped.getWeight();
        }
        treeNodes.ensureCapacity(ns.size());
        treeNodes.addAll(ns);
    }

    private void resetNewFringe() {
        this.mNewFringe.clear();
    }

    @Override
    public void getAllShortestPaths(String fromNodeId, String toNodeId, ArrayList<ArrayList<String>> allNodes, ArrayList<ArrayList<String>> allShortestPaths, int[] totalWeight) {
        allNodes.clear();
        allShortestPaths.clear();
        totalWeight[0] = -1;
        int frmIdx = this.getNodeNumber(fromNodeId);
        int toIdx = this.getNodeNumber(toNodeId);
        if (frmIdx < 0 || frmIdx >= this.mNodes.size() || toIdx < 0 || toIdx >= this.mNodes.size()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "The graph is missing nodes.");
        }
        if (frmIdx == toIdx) {
            totalWeight[0] = 0;
            return;
        }
        if (this.mAdjacency == null || !this.isSameTree(frmIdx, toIdx)) {
            return;
        }
        int nPaths2find = 100;
        byte[] nodeStatus = new byte[this.mNodes.size()];
        int[] label = new int[this.mNodes.size()];
        for (int l = 0; l < this.mNodes.size(); ++l) {
            label[l] = -1;
        }
        ArrayList<ArrayList<Integer>> fromNode = new ArrayList<ArrayList<Integer>>(this.mNodes.size());
        ArrayList<ArrayList<String>> path = new ArrayList<ArrayList<String>>(this.mNodes.size());
        for (int iNode = 0; iNode < this.mNodes.size(); ++iNode) {
            fromNode.add(new ArrayList());
            path.add(new ArrayList());
        }
        boolean[] visitedEdges = new boolean[this.mEdges.size()];
        TreeSet<Long> fringe = new TreeSet<Long>();
        nodeStatus[frmIdx] = 2;
        label[frmIdx] = 0;
        fringe.add(XQELongPool.getLong(frmIdx));
        while (fringe.size() != 0) {
            Iterator iterTop = fringe.iterator();
            Long topValue = (Long)iterTop.next();
            int topPos = (int)(topValue % 100000000L);
            if (topPos >= 50000000) {
                topPos -= 50000000;
            }
            iterTop.remove();
            nodeStatus[topPos] = 4;
            if (topPos == toIdx) {
                int nP;
                if (nPaths2find <= 0 || (nP = this.getPathNumber(fromNode, toIdx, frmIdx, nPaths2find)) < nPaths2find) continue;
                break;
            }
            ArrayList<Integer> newFringe = new ArrayList<Integer>();
            ArrayList<GraphEdge> edgeList = this.mAdjacency.get(topPos);
            for (GraphEdge edgePtr : edgeList) {
                ArrayList<String> aPath;
                ArrayList<String> innerPath;
                int edgePos = this.getEdgeNumber(edgePtr.getEdgeId());
                if (visitedEdges[edgePos]) continue;
                visitedEdges[edgePos] = true;
                int toNodePos = edgePtr.getToNode();
                int weight = label[topPos] + edgePtr.getWeight();
                if (-1 != label[toIdx] && (toIdx != toNodePos && weight >= label[toIdx] || toIdx == toNodePos && weight > label[toIdx])) continue;
                if (4 == nodeStatus[toNodePos]) {
                    if (weight != label[toNodePos]) continue;
                    ArrayList<Integer> innerFromNode = fromNode.get(toNodePos);
                    innerFromNode.add(XQEIntegerPool.getInteger(topPos));
                    innerPath = path.get(toNodePos);
                    innerPath.add(edgePtr.getEdgeId());
                    continue;
                }
                if ((2 & nodeStatus[toNodePos]) != 0) {
                    if (weight >= label[toNodePos]) {
                        if (weight != label[toNodePos]) continue;
                        ArrayList<Integer> innerFromNode = fromNode.get(toNodePos);
                        innerFromNode.add(XQEIntegerPool.getInteger(topPos));
                        innerPath = path.get(toNodePos);
                        innerPath.add(edgePtr.getEdgeId());
                        continue;
                    }
                    long k = label[toNodePos];
                    int endValue = 0;
                    if (toNodePos != toIdx) {
                        endValue = 50000000;
                    }
                    k = k * 100000000L + (long)toNodePos + (long)endValue;
                    fringe.remove(XQELongPool.getLong(k));
                    nodeStatus[toNodePos] = 1;
                    label[toNodePos] = weight;
                    ArrayList<Integer> frNode = fromNode.get(toNodePos);
                    frNode.clear();
                    frNode.add(XQEIntegerPool.getInteger(topPos));
                    ArrayList<String> aPath2 = path.get(toNodePos);
                    aPath2.clear();
                    aPath2.add(edgePtr.getEdgeId());
                    newFringe.add(XQEIntegerPool.getInteger(toNodePos));
                    continue;
                }
                if ((1 & nodeStatus[toNodePos]) != 0) {
                    if (weight >= label[toNodePos]) {
                        if (weight != label[toNodePos]) continue;
                        ArrayList<Integer> frNode = fromNode.get(toNodePos);
                        frNode.add(XQEIntegerPool.getInteger(topPos));
                        aPath = path.get(toNodePos);
                        aPath.add(edgePtr.getEdgeId());
                        continue;
                    }
                    label[toNodePos] = weight;
                    ArrayList<Integer> frNode = fromNode.get(toNodePos);
                    frNode.clear();
                    frNode.add(XQEIntegerPool.getInteger(topPos));
                    aPath = path.get(toNodePos);
                    aPath.clear();
                    aPath.add(edgePtr.getEdgeId());
                    continue;
                }
                nodeStatus[toNodePos] = 1;
                label[toNodePos] = weight;
                ArrayList<Integer> frNode = fromNode.get(toNodePos);
                frNode.clear();
                frNode.add(XQEIntegerPool.getInteger(topPos));
                aPath = path.get(toNodePos);
                aPath.clear();
                aPath.add(edgePtr.getEdgeId());
                newFringe.add(XQEIntegerPool.getInteger(toNodePos));
            }
            for (int i = 0; i < newFringe.size(); ++i) {
                Integer intObj = (Integer)newFringe.get(i);
                int newNodePos = intObj;
                nodeStatus[newNodePos] = 2;
                long k = label[newNodePos];
                int endValue = 0;
                if (newNodePos != toIdx) {
                    endValue = 50000000;
                }
                k = k * 100000000L + (long)newNodePos + (long)endValue;
                fringe.add(XQELongPool.getLong(k));
            }
        }
        if (-1 == label[toIdx]) {
            return;
        }
        totalWeight[0] = label[toIdx];
        LinkedList<String> stack = new LinkedList<String>();
        this.retrieveAllShortestPaths(fromNode, path, toIdx, frmIdx, nPaths2find, allShortestPaths, stack);
        for (int l = 0; l < allShortestPaths.size(); ++l) {
            TreeSet<String> nodeIdSet = new TreeSet<String>();
            ArrayList<String> aShortestPath = allShortestPaths.get(l);
            for (int k = 0; k < aShortestPath.size(); ++k) {
                String edgeId = aShortestPath.get(k);
                GraphEdge ped = this.getGraphEdge(this.getEdgeNumber(edgeId));
                nodeIdSet.add(this.getNodeId(ped.getFromNode()));
                nodeIdSet.add(this.getNodeId(ped.getToNode()));
            }
            ArrayList<String> nodeIdVec = new ArrayList<String>();
            nodeIdVec.addAll(nodeIdSet);
            allNodes.add(nodeIdVec);
        }
    }

    @Override
    public void getShortestPath(String node1, String node2, ArrayList<String> edges, int[] totalWeight) {
        edges.clear();
        totalWeight[0] = -1;
        int n1Idx = this.getNodeNumber(node1);
        int n2Idx = this.getNodeNumber(node2);
        if (n1Idx < 0 || n1Idx >= this.mNodes.size() || n2Idx < 0 || n2Idx >= this.mNodes.size()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "One of the nodes is missing from the graph.");
        }
        ArrayList<Integer> internalEdges = new ArrayList<Integer>();
        this.getShortestPath(n1Idx, n2Idx, internalEdges, totalWeight);
        for (Integer edgeIdx : internalEdges) {
            edges.add(this.getEdgeId(edgeIdx));
        }
    }

    @Override
    public void getConnectedComponents(ArrayList<ArrayList<String>> nodeVectors, ArrayList<ArrayList<String>> edgeVectors) {
        nodeVectors.clear();
        edgeVectors.clear();
        this.calculateConnectedComponents();
        if (this.mForest == null) {
            return;
        }
        for (int i = 0; i < this.mForest.size(); ++i) {
            ArrayList<String> baseIdVector = new ArrayList<String>();
            ArrayList<Integer> tree = this.mForest.get(i);
            for (int j = 0; j < tree.size(); ++j) {
                Integer nodeNum = tree.get(j);
                baseIdVector.add(this.getNodeId(nodeNum));
            }
            nodeVectors.add(baseIdVector);
            ArrayList<String> edgeIdVector = new ArrayList<String>();
            ArrayList<Integer> edges = this.mForestEdges.get(i);
            for (Integer eId : edges) {
                edgeIdVector.add(this.getEdgeId(eId));
            }
            edgeVectors.add(edgeIdVector);
        }
    }

    @Override
    public void setEdgeWeight(String e, int weight) {
        int edgeIdx = this.getEdgeNumber(e);
        GraphEdge edge = this.getGraphEdge(edgeIdx);
        edge.setWeight(weight);
        edge.getCounterpart().setWeight(weight);
    }

    @Override
    public ArrayList<GraphEdge> getEdges() {
        return this.mEdges;
    }

    @Override
    public boolean isConnected() {
        if (this.mChanged) {
            this.calculateConnectedComponents();
        }
        return this.mForest != null && 1 == this.mForest.size();
    }

    @Override
    public int getWeight(ArrayList<String> edges) {
        int totalWeight = 0;
        for (int i = 0; i < edges.size(); ++i) {
            String edge = edges.get(i);
            int edgeIdx = this.getEdgeNumber(edge);
            if (edgeIdx < 0) continue;
            GraphEdge graphEdge = this.getGraphEdge(edgeIdx);
            totalWeight += graphEdge.getWeight();
        }
        return totalWeight;
    }

    public void getAllShortestPathTrees3LikeClassic() {
        if (this.mNodeNumbers.size() <= 100) {
            this.mGetAllShortestPathTrees3LikeClassic = true;
        }
    }

    public void getShortestPathTrees(ArrayList<String> nodes, ArrayList<ArrayList<String>> shortestPaths, Set<String> facts) {
        shortestPaths.clear();
        if (nodes.size() < 2) {
            return;
        }
        if (this.mAdjacency == null) {
            return;
        }
        int[] totalWeight = new int[]{-1};
        ArrayList<ArrayList<String>> dummy = new ArrayList<ArrayList<String>>();
        if (2 == nodes.size()) {
            this.getAllShortestPaths(nodes.get(0), nodes.get(1), dummy, shortestPaths, totalWeight);
            return;
        }
        if (this.isConnected()) {
            HashSet<String> uJoins = new HashSet<String>();
            this.getShortestPathForStarts(nodes, facts, false, uJoins);
            shortestPaths.add(new ArrayList<String>(uJoins));
            return;
        }
        TreeMap<Integer, ArrayList<String>> forest2NodesToJoin = new TreeMap<Integer, ArrayList<String>>();
        HashMap<Integer, Integer> nodeToForest = new HashMap<Integer, Integer>();
        for (int idx = 0; idx < this.mForest.size(); ++idx) {
            ArrayList<Integer> arrayList = this.mForest.get(idx);
            for (Integer nId : arrayList) {
                nodeToForest.put(nId, XQEIntegerPool.getInteger(idx));
            }
        }
        for (String string : nodes) {
            int nodeIdx = this.getNodeNumber(string);
            Integer intNodeIdx = XQEIntegerPool.getInteger(nodeIdx);
            Integer intForestPos = (Integer)nodeToForest.get(intNodeIdx);
            if (null == intForestPos) continue;
            ArrayList<String> forest = (ArrayList<String>)forest2NodesToJoin.get(intForestPos);
            if (forest == null) {
                forest = new ArrayList<String>();
                forest2NodesToJoin.put(intForestPos, forest);
            }
            forest.add(string);
        }
        HashSet<String> uJoins = new HashSet<String>();
        for (ArrayList forest2joinNodes : forest2NodesToJoin.values()) {
            if (forest2joinNodes.size() < 2) continue;
            this.getShortestPathForStarts(forest2joinNodes, facts, true, uJoins);
        }
        ArrayList arrayList = new ArrayList(uJoins);
        shortestPaths.add(arrayList);
    }

    protected void getShortestPathForStarts(ArrayList<String> nodes, Set<String> facts, boolean check, HashSet<String> uJoins) {
        boolean bdone = false;
        HashSet<String> allNodes = new HashSet<String>(nodes);
        int[] totalWeight = new int[]{-1};
        for (String st : facts) {
            if (check && !allNodes.contains(st)) continue;
            bdone = true;
            HashSet<String> nodeset = new HashSet<String>(allNodes);
            nodeset.remove(st);
            ArrayList<String> tmpNodes = new ArrayList<String>();
            tmpNodes.add(st);
            tmpNodes.addAll(nodeset);
            ArrayList<String> treeNodes = new ArrayList<String>();
            ArrayList<String> treeEdges = new ArrayList<String>();
            totalWeight[0] = -1;
            this.getShortestPathTree(tmpNodes, treeNodes, treeEdges, totalWeight);
            uJoins.addAll(treeEdges);
        }
        if (!bdone) {
            ArrayList<String> treeNodes = new ArrayList<String>();
            ArrayList<String> treeEdges = new ArrayList<String>();
            totalWeight[0] = -1;
            this.getShortestPathTree(nodes, treeNodes, treeEdges, totalWeight);
            uJoins.addAll(treeEdges);
        }
    }

    private void logPath(String msg, ShortestPath p) {
        if (INFO_LOGGER.isOn() && p != null) {
            INFO_LOGGER.log(msg + p.toString());
        }
    }

    private boolean getAllShortestPathTrees3(ArrayList<String> nodes, ArrayList<ArrayList<String>> pAllShortestPaths, int[] pathWeight) {
        int numAttempts = 0;
        TreeSet<ShortestPath> allShortestPaths = new TreeSet<ShortestPath>();
        int startNode = 0;
        int lastNodeOpen = nodes.size();
        int optPasses = 0;
        if (optPasses > 0 && optPasses < lastNodeOpen) {
            lastNodeOpen = optPasses;
        }
        boolean optLowestCost = true;
        boolean optIncMulti = true;
        if (this.mGetAllShortestPathTrees3LikeClassic) {
            optIncMulti = false;
        }
        boolean optIncAltEdgesAlways = true;
        boolean useBestStarts = true;
        if (this.mGetAllShortestPathTrees3LikeClassic) {
            useBestStarts = false;
        }
        int[] pWeights = new int[nodes.size()];
        ShortestPath[] pPaths = new ShortestPath[nodes.size()];
        long startTime = System.currentTimeMillis();
        if (useBestStarts) {
            int bestNode = 0;
            for (startNode = 0; startNode < nodes.size(); ++startNode) {
                ShortestPath tPath = new ShortestPath();
                int[] tWeight = new int[1];
                ++numAttempts;
                long gspStart = System.currentTimeMillis();
                this.getShortestPath(nodes, startNode, (ArrayList<String>)tPath, tWeight);
                if (INFO_LOGGER.isOn(LogLevel.TRACE)) {
                    INFO_LOGGER.log(LogLevel.TRACE, "gaspt3-01: elapsed=" + (System.currentTimeMillis() - gspStart) + MS_UOM + " w=" + tWeight[0]);
                }
                if (0 == startNode) {
                    pathWeight[0] = tWeight[0];
                }
                if (tWeight[0] < 0) {
                    return false;
                }
                if (tWeight[0] < pathWeight[0]) {
                    pathWeight[0] = tWeight[0];
                    bestNode = startNode;
                }
                pWeights[startNode] = tWeight[0];
                pPaths[startNode] = tPath;
                this.logPath("gaspt3-02: bestStart for node=" + startNode, tPath);
                if (startNode >= this.mBestStartLimit) break;
            }
            startNode = bestNode;
            lastNodeOpen = bestNode + 1;
        }
        if (INFO_LOGGER.isOn()) {
            INFO_LOGGER.log("gaspt3-03: useBestStarts=" + Boolean.toString(useBestStarts) + " elapsed=" + (System.currentTimeMillis() - startTime) + MS_UOM + " bestNode=" + startNode + " numAttempts=" + numAttempts + " optIncAltEdgesAlways=" + Boolean.valueOf(optIncAltEdgesAlways));
        }
        int bestWeight = pathWeight[0];
        boolean justTheBestStarts = this.mJustTheBestStarts;
        String firstUnique = "";
        int numGoodStarts = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            if (pWeights[i] != bestWeight) continue;
            ++numGoodStarts;
            boolean wasAdded = allShortestPaths.add(pPaths[i]);
            if (!wasAdded) continue;
            firstUnique = firstUnique + String.valueOf(i) + " ";
        }
        if (INFO_LOGGER.isOn()) {
            INFO_LOGGER.log("gaspt3-04: numGoodStarts=" + numGoodStarts + " number of paths=" + allShortestPaths.size() + " firstUnique: " + firstUnique);
        }
        if (justTheBestStarts) {
            pAllShortestPaths.addAll(allShortestPaths);
            return true;
        }
        allShortestPaths.clear();
        boolean allPathSame = true;
        if (useBestStarts) {
            startNode = 0;
            lastNodeOpen = nodes.size();
            for (int i = 1; i < pPaths.length; ++i) {
                if (pPaths[0].equals(pPaths[i])) continue;
                allPathSame = false;
                break;
            }
        }
        while (startNode < lastNodeOpen) {
            block46: {
                boolean shortCircuit;
                int[] tWeight;
                ShortestPath tPath;
                TreeSet<ShortestPath> shortestPathsThisStart;
                block47: {
                    block48: {
                        block45: {
                            shortestPathsThisStart = new TreeSet<ShortestPath>();
                            INFO_LOGGER.log("gaspt3-05: startNode =" + startNode + " " + nodes.get(startNode));
                            if (!useBestStarts || bestWeight == pWeights[startNode]) break block45;
                            if (INFO_LOGGER.isOn()) {
                                INFO_LOGGER.log("gaspt3-06: skipped starting point:" + startNode);
                            }
                            break block46;
                        }
                        tPath = new ShortestPath();
                        tWeight = new int[1];
                        if (useBestStarts) {
                            tPath = pPaths[startNode];
                            tWeight[0] = pWeights[startNode];
                        } else {
                            ++numAttempts;
                            this.getShortestPath(nodes, startNode, (ArrayList<String>)tPath, tWeight);
                        }
                        if (0 == startNode) {
                            pathWeight[0] = tWeight[0];
                        }
                        if (tWeight[0] < 0) {
                            return false;
                        }
                        if (!optLowestCost) break block47;
                        if (tWeight[0] >= pathWeight[0]) break block48;
                        pathWeight[0] = tWeight[0];
                        allShortestPaths.clear();
                        break block47;
                    }
                    if (tWeight[0] > pathWeight[0]) break block46;
                }
                if ((shortCircuit = true) && useBestStarts && allShortestPaths.contains(tPath)) {
                    INFO_LOGGER.log("gaspt3-07: shortCircuit kicked in, nothing new will be found from this starting point");
                } else {
                    allShortestPaths.add(tPath);
                    shortestPathsThisStart.add(tPath);
                    TreeSet<String> edgesToProcess = new TreeSet<String>();
                    for (String edgeId : tPath) {
                        edgesToProcess.add(edgeId);
                    }
                    TreeSet<String> adjustedEdges = new TreeSet<String>();
                    TreeSet<String> processedEdges = new TreeSet<String>();
                    this.removeUnadjustableEdges(edgesToProcess, processedEdges);
                    boolean adjustmentAmount = true;
                    while (edgesToProcess.size() != 0) {
                        int numIncEdges = 0;
                        if (optIncMulti) {
                            Iterator<String> etpIter = edgesToProcess.iterator();
                            while (etpIter.hasNext()) {
                                String cEdge = etpIter.next();
                                GraphEdge ped = this.getGraphEdge(this.getEdgeNumber(cEdge));
                                if (ped == null) {
                                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unexpected ped == NULL.");
                                }
                                String fromNode = this.getNodeId(ped.getFromNode());
                                String toNode = this.getNodeId(ped.getToNode());
                                int needCount = 0;
                                if (nodes.contains(fromNode)) {
                                    ++needCount;
                                }
                                if (nodes.contains(toNode)) {
                                    ++needCount;
                                }
                                if (1 != needCount) continue;
                                etpIter.remove();
                                processedEdges.add(cEdge);
                                ArrayList<String> vEdge = new ArrayList<String>();
                                vEdge.add(cEdge);
                                int cWeight = this.getWeight(vEdge);
                                this.setEdgeWeight(cEdge, cWeight + 1);
                                adjustedEdges.add(cEdge);
                                ++numIncEdges;
                            }
                        }
                        String cEdge = null;
                        if (edgesToProcess.size() > 0) {
                            cEdge = edgesToProcess.first();
                        }
                        if (0 == numIncEdges) {
                            Iterator<String> etpIter = edgesToProcess.iterator();
                            cEdge = etpIter.next();
                            etpIter.remove();
                            processedEdges.add(cEdge);
                            ArrayList<String> vEdge = new ArrayList<String>();
                            vEdge.add(cEdge);
                            int cWeight = this.getWeight(vEdge);
                            this.setEdgeWeight(cEdge, cWeight + 1);
                            adjustedEdges.add(cEdge);
                            ++numIncEdges;
                        }
                        ShortestPath altPath = new ShortestPath();
                        int[] altWeight = new int[1];
                        ++numAttempts;
                        this.getShortestPath(nodes, startNode, (ArrayList<String>)altPath, altWeight);
                        int stNode = startNode;
                        while (useBestStarts && stNode++ < lastNodeOpen - 1 && allPathSame && allShortestPaths.contains(altPath)) {
                            altPath.clear();
                            ++numAttempts;
                            this.getShortestPath(nodes, stNode, (ArrayList<String>)altPath, altWeight);
                        }
                        TreeSet<String> usedAdjustedEdges = new TreeSet<String>(altPath);
                        usedAdjustedEdges.retainAll(adjustedEdges);
                        int allowedExtraWeight = usedAdjustedEdges.size() * 1;
                        if (INFO_LOGGER.isOn(LogLevel.TRACE)) {
                            INFO_LOGGER.log(LogLevel.TRACE, "gaspt3-08: numIncEdges=" + numIncEdges + " altWeight[0]=" + altWeight[0] + " allowedExtraWeight=" + allowedExtraWeight + " tWeight[0]=" + tWeight[0] + " toProcess=" + edgesToProcess.size() + " numFound=" + allShortestPaths.size());
                        }
                        boolean includeAltEdges = optIncAltEdgesAlways;
                        if (altWeight[0] - allowedExtraWeight <= tWeight[0]) {
                            includeAltEdges = true;
                        }
                        if (includeAltEdges) {
                            TreeSet<String> diffSet = new TreeSet<String>(altPath);
                            diffSet.removeAll(processedEdges);
                            edgesToProcess.addAll(diffSet);
                            this.removeUnadjustableEdges(edgesToProcess, processedEdges);
                            if (optLowestCost && altWeight[0] - allowedExtraWeight < pathWeight[0]) {
                                pathWeight[0] = altWeight[0] - allowedExtraWeight;
                                tWeight[0] = pathWeight[0];
                                allShortestPaths.clear();
                                shortestPathsThisStart.clear();
                            }
                        }
                        if (altWeight[0] - allowedExtraWeight > tWeight[0]) continue;
                        allShortestPaths.add(altPath);
                        shortestPathsThisStart.add(altPath);
                    }
                    for (String cEdge : adjustedEdges) {
                        ArrayList<String> vEdge = new ArrayList<String>();
                        vEdge.add(cEdge);
                        int cWeight = this.getWeight(vEdge);
                        this.setEdgeWeight(cEdge, cWeight - 1);
                    }
                    if (INFO_LOGGER.isOn()) {
                        String noteTheDiff = "";
                        if (allShortestPaths.size() != shortestPathsThisStart.size()) {
                            noteTheDiff = " <==diff> ";
                        }
                        INFO_LOGGER.log("gaspt3-09: startNode=" + startNode + " numAttempts = " + numAttempts + " numPaths=" + allShortestPaths.size() + " numPathsThisStart=" + shortestPathsThisStart.size() + noteTheDiff + " optIncMulti=" + Boolean.valueOf(optIncMulti) + " allPathSame=" + Boolean.valueOf(allPathSame));
                    }
                }
            }
            ++startNode;
        }
        pAllShortestPaths.addAll(allShortestPaths);
        if (INFO_LOGGER.isOn()) {
            INFO_LOGGER.log("gaspt3-10: numAttempts = " + numAttempts + " number of paths=" + allShortestPaths.size() + " optIncMulti=" + Boolean.valueOf(optIncMulti) + " allPathSame=" + Boolean.valueOf(allPathSame));
        }
        return true;
    }

    private void getShortestPath(ArrayList<String> nodes, int startNode, ArrayList<String> treeEdges, int[] totalWeight) {
        totalWeight[0] = -1;
        if (nodes.size() < 2) {
            return;
        }
        if (this.mAdjacency == null) {
            return;
        }
        boolean[] island = new boolean[this.mNodes.size()];
        boolean[] path = new boolean[this.mEdges.size()];
        int[] weight = new int[1];
        if (startNode >= nodes.size()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unexpected startNode < nodes.size().");
        }
        String startNodeId = nodes.get(startNode);
        int nodeNumber = this.getNodeNumber(startNodeId);
        if (nodeNumber < 0) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Node not found in graph: " + startNodeId);
        }
        island[nodeNumber] = true;
        for (int i = 0; i < nodes.size(); ++i) {
            if (i == startNode) continue;
            this.growIslandWithClosestVertice(nodes, i, island, path, weight);
            if (weight[0] >= 0) continue;
            return;
        }
        TreeSet<String> ns = new TreeSet<String>();
        totalWeight[0] = 0;
        for (int k = 0; k < this.mEdges.size(); ++k) {
            if (!path[k]) continue;
            GraphEdge edge = this.getGraphEdge(k);
            treeEdges.add(edge.getEdgeId());
            ns.add(this.getNodeId(edge.getFromNode()));
            ns.add(this.getNodeId(edge.getToNode()));
            totalWeight[0] = totalWeight[0] + edge.getWeight();
        }
    }

    private int getEdgeNumber(String edgeId) {
        Integer value = this.mEdgeNumbers.get(edgeId);
        if (value == null) {
            return -1;
        }
        return value;
    }

    private GraphEdge getGraphEdge(int i) {
        if (i < 0 || i >= this.mEdges.size()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "1st: Unable to retrieve and process a join which is not part of the graph.");
        }
        return this.mEdges.get(i);
    }

    private String getNodeId(int i) {
        if (i < 0 || i >= this.mNodes.size()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unable to process the join. One of the nodes is missing from the graph.");
        }
        return this.mNodes.get(i);
    }

    private String getEdgeId(int i) {
        if (i < 0 || i >= this.mEdges.size()) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Missing edge encountered.");
        }
        GraphEdge gEdge = this.mEdges.get(i);
        return gEdge.getEdgeId();
    }

    private int getNodeNumber(String v) {
        Integer nodeIdx = this.mNodeNumbers.get(v);
        if (nodeIdx == null) {
            return -1;
        }
        return nodeIdx;
    }

    private void markAsChanged() {
        this.mChanged = true;
    }

    private void removeUnadjustableEdges(TreeSet<String> edgesToProcess, TreeSet<String> processedEdges) {
        Iterator<String> iter = edgesToProcess.iterator();
        while (iter.hasNext()) {
            String cEdge = iter.next();
            ArrayList<String> vEdge = new ArrayList<String>();
            vEdge.add(cEdge);
            int cWeight = this.getWeight(vEdge);
            if (2 != cWeight) continue;
            iter.remove();
            processedEdges.add(cEdge);
        }
    }

    private void growIslandWithClosestVertice(ArrayList<String> nodes, int ipos, boolean[] island, boolean[] path, int[] addedWeight) {
        int i;
        addedWeight[0] = -1;
        if (this.mAdjacency == null) {
            return;
        }
        int nodeCount = nodes.size();
        if (nodeCount < 2) {
            return;
        }
        this.resetOrAllocateTempArrays(nodeCount);
        for (i = 0; i < nodeCount; ++i) {
            String nodeId = nodes.get(i);
            int nPos = this.getNodeNumber(nodeId);
            if (-1 == nPos) {
                return;
            }
            this.mPreferNodePos[i] = nPos;
            this.mNodeStatus[nPos] = 8;
        }
        int islandSize = Array.getLength(island);
        for (i = 0; i < islandSize; ++i) {
            if (!island[i]) continue;
            this.mFringe.add(i);
            this.mNodeStatus[i] = (byte)(this.mNodeStatus[i] | 2);
        }
        if (INFO_LOGGER.isOn(LogLevel.TRACE)) {
            INFO_LOGGER.log(LogLevel.TRACE, "giwce-01: fringe=" + this.mFringe.toString(this.mNodes));
        }
        int nNodeInTree = 0;
        while (0 != this.mFringe.size()) {
            long firstValue = this.mFringe.getTop();
            int topPos = (int)(firstValue % 100000000L);
            if (topPos >= 50000000) {
                topPos -= 50000000;
            }
            this.mFringe.popTop();
            if ((this.mNodeStatus[topPos] & 8) != 0 && ++nNodeInTree == nodeCount) break;
            this.mNodeStatus[topPos] = 4;
            this.resetNewFringe();
            ArrayList<GraphEdge> edgeList = this.mAdjacency.get(topPos);
            for (int eI = 0; eI < edgeList.size(); ++eI) {
                GraphEdge edgePtr = edgeList.get(eI);
                int toNodePos = edgePtr.getToNode();
                if (4 == this.mNodeStatus[toNodePos]) continue;
                int weight = this.mLabel[topPos] + edgePtr.getWeight();
                if (island[toNodePos]) {
                    weight = 0;
                }
                if ((2 & this.mNodeStatus[toNodePos]) != 0) {
                    if (weight >= this.mLabel[toNodePos]) continue;
                    long k = this.mLabel[toNodePos];
                    int endValue = 0;
                    if ((this.mNodeStatus[toNodePos] & 8) == 0) {
                        endValue = 50000000;
                    }
                    k = k * 100000000L + (long)toNodePos + (long)endValue;
                    this.mFringe.remove(k);
                    this.mNodeStatus[toNodePos] = (byte)(this.mNodeStatus[toNodePos] & 8);
                    this.mNodeStatus[toNodePos] = (byte)(this.mNodeStatus[toNodePos] | 1);
                    this.mLabel[toNodePos] = weight;
                    this.mFromNode[toNodePos] = topPos;
                    this.mPath[toNodePos] = edgePtr.getEdgeId();
                    this.mNewFringe.add(toNodePos);
                    continue;
                }
                if ((1 & this.mNodeStatus[toNodePos]) != 0) {
                    if (weight >= this.mLabel[toNodePos]) continue;
                    this.mLabel[toNodePos] = weight;
                    this.mFromNode[toNodePos] = topPos;
                    this.mPath[toNodePos] = edgePtr.getEdgeId();
                    continue;
                }
                this.mNodeStatus[toNodePos] = (byte)(this.mNodeStatus[toNodePos] & 8);
                this.mNodeStatus[toNodePos] = (byte)(this.mNodeStatus[toNodePos] | 1);
                this.mLabel[toNodePos] = weight;
                this.mFromNode[toNodePos] = topPos;
                this.mPath[toNodePos] = edgePtr.getEdgeId();
                this.mNewFringe.add(toNodePos);
            }
            for (i = 0; i < this.mNewFringe.size(); ++i) {
                int newNodePos = (int)this.mNewFringe.getFast(i);
                this.mNodeStatus[newNodePos] = (byte)(this.mNodeStatus[newNodePos] & 8);
                this.mNodeStatus[newNodePos] = (byte)(this.mNodeStatus[newNodePos] | 2);
                long k = this.mLabel[newNodePos];
                int endValue = 0;
                if ((this.mNodeStatus[newNodePos] & 8) == 0) {
                    endValue = 50000000;
                }
                k = k * 100000000L + (long)newNodePos + (long)endValue;
                this.mFringe.add(k);
            }
        }
        if (nNodeInTree != nodeCount) {
            addedWeight[0] = -1;
            return;
        }
        int minEndPoint = -1;
        int smallestWeight = -1;
        for (i = nodeCount - 1; i >= 0; --i) {
            int pos = this.mPreferNodePos[i];
            if (island[pos] || smallestWeight != -1 && this.mLabel[pos] >= smallestWeight) continue;
            smallestWeight = this.mLabel[pos];
            minEndPoint = pos;
        }
        if (minEndPoint == -1) {
            return;
        }
        addedWeight[0] = 0;
        do {
            String edgeId;
            int edgeNumber;
            if (path[edgeNumber = this.getEdgeNumber(edgeId = this.mPath[minEndPoint])]) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unexpected path[edgeNumber] = FALSE. location(2)");
            }
            path[edgeNumber] = true;
            GraphEdge ped = this.getGraphEdge(edgeNumber);
            island[minEndPoint] = true;
            addedWeight[0] = addedWeight[0] + ped.getWeight();
        } while (!island[minEndPoint = this.mFromNode[minEndPoint]]);
    }

    private void resetOrAllocateTempArrays(int nodeCount) {
        int mNodesSize = this.mNodes.size();
        if (this.mNodeStatus == null || this.mNodeStatus.length != mNodesSize) {
            this.mNodeStatus = new byte[mNodesSize];
            this.mDefaultByteArray = new byte[mNodesSize];
            this.mLabel = new int[mNodesSize];
            this.mDefaultIntArray = new int[mNodesSize];
            this.mFromNode = new int[mNodesSize];
            this.mFringe = new Fringe();
            this.mPath = new String[mNodesSize];
            this.mEmptyPath = new String[mNodesSize];
            for (int idx = 0; idx < mNodesSize; ++idx) {
                this.mEmptyPath[idx] = new String();
            }
        }
        if (this.mNewFringe == null) {
            this.mNewFringe = new LongArrayList();
        }
        if (this.mPreferNodePos == null || this.mPreferNodePos.length != nodeCount) {
            this.mPreferNodePos = new int[nodeCount];
        }
        System.arraycopy(this.mDefaultByteArray, 0, this.mNodeStatus, 0, mNodesSize);
        System.arraycopy(this.mDefaultIntArray, 0, this.mLabel, 0, mNodesSize);
        System.arraycopy(this.mDefaultIntArray, 0, this.mFromNode, 0, mNodesSize);
        System.arraycopy(this.mEmptyPath, 0, this.mPath, 0, mNodesSize);
        this.mFringe.reset();
        for (int i = 0; i < nodeCount; ++i) {
            this.mPreferNodePos[i] = 0;
        }
    }

    private void calculateConnectedComponents() {
        if (this.mChanged) {
            if (this.mForest == null) {
                this.mForest = new ArrayList();
            } else {
                this.mForest.clear();
            }
            if (this.mForestEdges == null) {
                this.mForestEdges = new ArrayList();
            } else {
                this.mForestEdges.clear();
            }
            if (this.mEdges4BFS == null) {
                this.mEdges4BFS = new TreeSet();
            } else {
                this.mEdges4BFS.clear();
            }
            boolean[] visitedNodes = new boolean[this.mNodes.size()];
            this.resetEdges();
            ArrayList<Integer> nodes = new ArrayList<Integer>();
            for (int i = 0; i < this.mNodes.size(); ++i) {
                if (visitedNodes[i]) continue;
                this.mEdges4BFS.clear();
                this.breathFirstSearch(i, nodes, visitedNodes);
                this.mForest.add(new ArrayList<Integer>(nodes));
                ArrayList<Integer> forestEdges = new ArrayList<Integer>(this.mEdges4BFS);
                this.mForestEdges.add(forestEdges);
                nodes.clear();
            }
            this.mChanged = false;
        }
    }

    private void resetEdges() {
        if (this.mAdjacency == null) {
            return;
        }
        for (int i = 0; i < this.mAdjacency.size(); ++i) {
            ArrayList<GraphEdge> edgeList = this.mAdjacency.get(i);
            for (GraphEdge graphEdge : edgeList) {
                graphEdge.resetEdge();
            }
        }
    }

    private void breathFirstSearch(int v, ArrayList<Integer> nodes, boolean[] visitedNodes) {
        LinkedList<Integer> theQueue = new LinkedList<Integer>();
        Integer vertexIntObj = XQEIntegerPool.getInteger(v);
        theQueue.add(vertexIntObj);
        visitedNodes[v] = true;
        nodes.add(vertexIntObj);
        while (theQueue.size() != 0) {
            int currentNode = (Integer)theQueue.poll();
            if (this.mAdjacency == null) continue;
            ArrayList<GraphEdge> nodeList = this.mAdjacency.get(currentNode);
            for (GraphEdge gEdge : nodeList) {
                Integer edgeNum = XQEIntegerPool.getInteger(gEdge.getEdge());
                this.mEdges4BFS.add(edgeNum);
                if (visitedNodes[gEdge.getToNode()]) continue;
                Integer toNodeNum = XQEIntegerPool.getInteger(gEdge.getToNode());
                theQueue.add(toNodeNum);
                visitedNodes[gEdge.getToNode()] = true;
                nodes.add(toNodeNum);
                gEdge.setSelected();
                gEdge.getCounterpart().setSelected();
            }
        }
    }

    private void getShortestPath(int node1Idx, int node2Idx, ArrayList<Integer> edges, int[] totalWeight) {
        edges.clear();
        totalWeight[0] = -1;
        if (node1Idx == node2Idx) {
            totalWeight[0] = 0;
            return;
        }
        if (this.mAdjacency == null || !this.isSameTree(node1Idx, node2Idx)) {
            return;
        }
        boolean[] visitedNodes = new boolean[this.mNodes.size()];
        int[] val = new int[this.mNodes.size()];
        GraphEdgeList priorityQueue = new GraphEdgeList(this.mNodes.size());
        GraphEdge[] dad = new GraphEdge[this.mNodes.size()];
        String dummyId = new String();
        GraphEdge startEdge = new GraphEdge(dummyId, -1, -1, node1Idx, 5, false);
        priorityQueue.pushBack(startEdge);
        visitedNodes[node1Idx] = true;
        GraphEdge currentEdge = startEdge;
        while (currentEdge != null) {
            priorityQueue.remove(currentEdge);
            int index = currentEdge.getToNode();
            dad[index] = currentEdge;
            int cEdgeToNode = currentEdge.getToNode();
            ArrayList<GraphEdge> edgeList = this.mAdjacency.get(cEdgeToNode);
            for (GraphEdge edgePtr : edgeList) {
                boolean updatedDistance;
                int edgeToNode = edgePtr.getToNode();
                if (!visitedNodes[edgeToNode]) {
                    visitedNodes[edgeToNode] = true;
                    priorityQueue.pushBack(edgePtr);
                    this.calculateShortestDistanceToNode(val, edgePtr);
                    continue;
                }
                if (dad[edgePtr.getToNode()] != null || !(updatedDistance = this.calculateShortestDistanceToNode(val, edgePtr))) continue;
                GraphEdge edge = this.getEdge(priorityQueue, edgeToNode);
                if (edge == null) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unexpected null edge.");
                }
                priorityQueue.remove(edge);
                priorityQueue.pushBack(edgePtr);
            }
            currentEdge = this.getNextEdge(priorityQueue, val);
        }
        int scan = node2Idx;
        while (dad[scan].getEdge() != -1) {
            edges.add(XQEIntegerPool.getInteger(dad[scan].getEdge()));
            scan = dad[scan].getFromNode();
        }
        totalWeight[0] = val[node2Idx];
    }

    private boolean isSameTree(int node1, int node2) {
        if (this.isConnected()) {
            return true;
        }
        for (int i = 0; i < this.mForest.size(); ++i) {
            ArrayList<Integer> tree = this.mForest.get(i);
            if (!this.isInTree(node1, tree)) continue;
            return this.isInTree(node2, tree);
        }
        return false;
    }

    private boolean isInTree(int node, ArrayList<Integer> tree) {
        return tree.contains(XQEIntegerPool.getInteger(node));
    }

    private GraphEdge getEdge(GraphEdgeList priorityQueue, int node) {
        GraphEdge graphEdge = null;
        GraphEdge scan = null;
        ArrayList<GraphEdgeListNode> qNodes = priorityQueue.getQNodes();
        int i = priorityQueue.getHead();
        while (i != -1) {
            GraphEdgeListNode gelNode = qNodes.get(i);
            scan = gelNode.getData();
            if (scan.getToNode() == node) {
                graphEdge = scan;
                break;
            }
            i = gelNode.getNext();
        }
        return graphEdge;
    }

    private GraphEdge getNextEdge(GraphEdgeList priorityQueue, int[] val) {
        GraphEdge graphEdge = null;
        GraphEdge scan = null;
        int shortestDistance = 99999999;
        ArrayList<GraphEdgeListNode> qNodes = priorityQueue.getQNodes();
        int i = priorityQueue.getHead();
        while (i != -1) {
            GraphEdgeListNode curr = qNodes.get(i);
            i = curr.getNext();
            scan = curr.getData();
            int toNode = scan.getToNode();
            if (val[toNode] >= shortestDistance) continue;
            shortestDistance = val[toNode];
            graphEdge = scan;
        }
        return graphEdge;
    }

    private boolean calculateShortestDistanceToNode(int[] val, GraphEdge edge) {
        int fromNode = edge.getFromNode();
        int toNode = edge.getToNode();
        if (val[toNode] > val[fromNode] + edge.getWeight() || val[toNode] == 0) {
            val[toNode] = val[fromNode] + edge.getWeight();
            return true;
        }
        return false;
    }

    private int getPathNumber(ArrayList<ArrayList<Integer>> fromNode, int idx, int startId, int limit) {
        ArrayList<Integer> from = fromNode.get(idx);
        int nP = 0;
        for (int i = 0; i < from.size(); ++i) {
            Integer fromInt = from.get(i);
            nP = fromInt == startId ? ++nP : (nP += this.getPathNumber(fromNode, fromInt, startId, limit));
            if (nP < limit) continue;
            return nP;
        }
        return nP;
    }

    private void retrieveAllShortestPaths(ArrayList<ArrayList<Integer>> fromNode, ArrayList<ArrayList<String>> path, int idx, int startId, int limit, ArrayList<ArrayList<String>> allShortestPaths, LinkedList<String> stack) {
        ArrayList<Integer> from = fromNode.get(idx);
        ArrayList<String> ps = path.get(idx);
        for (int i = 0; i < from.size(); ++i) {
            Integer intObj = from.get(i);
            if (intObj == startId) {
                ArrayList<String> tmp = new ArrayList<String>(stack);
                tmp.add(ps.get(i));
                allShortestPaths.add(tmp);
                if (limit <= 0 || allShortestPaths.size() < limit) continue;
                return;
            }
            stack.add(ps.get(i));
            this.retrieveAllShortestPaths(fromNode, path, from.get(i), startId, limit, allShortestPaths, stack);
            stack.removeLast();
            if (limit <= 0 || allShortestPaths.size() < limit) continue;
            return;
        }
    }

    static class Fringe {
        LongArrayList mLongArray = new LongArrayList();
        int base = 0;

        Fringe() {
        }

        long getTop() {
            return this.mLongArray.getFast(this.base);
        }

        long get(int i) {
            return this.mLongArray.getFast(i);
        }

        void reset() {
            this.base = 0;
            this.mLongArray.clear();
        }

        int size() {
            return this.mLongArray.size() - this.base;
        }

        public void popTop() {
            ++this.base;
        }

        public void remove(long toDelete) {
            this.mLongArray.remove(toDelete);
        }

        public void add(long toAdd) {
            this.mLongArray.add(toAdd);
        }

        public String toString(ArrayList<String> nodes) {
            StringBuffer b = new StringBuffer();
            b.append("[");
            for (int i = this.base; i < this.mLongArray.size(); ++i) {
                if (i > this.base) {
                    b.append(",");
                }
                long val = this.mLongArray.getFast(i);
                int topPos = (int)(val % 100000000L);
                int weight = (int)(val / 100000000L);
                if (topPos >= 50000000) {
                    topPos -= 50000000;
                    b.append("P:");
                }
                b.append(topPos);
                b.append(":");
                b.append(weight);
                b.append(":");
                b.append(nodes.get(topPos));
            }
            b.append("]");
            return b.toString();
        }
    }

    static class ShortestPath
    extends ArrayList<String>
    implements Comparable<Object> {
        private static final long serialVersionUID = 1L;

        ShortestPath() {
        }

        @Override
        public int compareTo(Object that) {
            ShortestPath lhs = this;
            ShortestPath rhs = (ShortestPath)that;
            Iterator lhsIter = this.iterator();
            Iterator rhsIter = rhs.iterator();
            if (!lhsIter.hasNext() && !rhsIter.hasNext()) {
                return 0;
            }
            if (!lhsIter.hasNext()) {
                return -1;
            }
            if (!rhsIter.hasNext()) {
                return 1;
            }
            while (lhsIter.hasNext() && rhsIter.hasNext()) {
                String rhsStr;
                String lhsStr = (String)lhsIter.next();
                int comparisonResult = lhsStr.compareTo(rhsStr = (String)rhsIter.next());
                if (comparisonResult == 0) continue;
                return comparisonResult;
            }
            if (lhs.size() == rhs.size()) {
                return 0;
            }
            if (lhs.size() < rhs.size()) {
                return -1;
            }
            return 1;
        }
    }
}

