/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.transformation.v5updatetosql;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.XQENodeFactory;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.sql.SQLCall;
import com.cognos.xqe.ast.sql.SQLExpression;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLParameter;
import com.cognos.xqe.ast.sql.SQLQueryBlock;
import com.cognos.xqe.ast.v5.update.V5UpdateSet;
import com.cognos.xqe.ast.v5.update.V5UpdateSubject;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.DataSourceException;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICatalog;
import com.cognos.xqe.metadata.IModelDataSource;
import com.cognos.xqe.metadata.IProcParameter;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.ResponseMessage;
import com.cognos.xqe.query.engine.Transformation;
import com.cognos.xqe.query.parameters.Parameter;
import com.cognos.xqe.query.parameters.Parameters;
import com.cognos.xqe.transformation.v5.binding.BindIdentifierNotFoundException;
import java.util.List;
import java.util.Map;

public class V5UpdateSubjectToSQLCall
extends Transformation {
    public V5UpdateSubjectToSQLCall() {
        this.mName = "Convert Update Subject To SQL Call Node.";
        this.mPassNumbers = new int[]{0};
        this.mTypes = new int[]{101071};
    }

    @Override
    public void apply(IXQEQueryNode node, PlanningEnvironment environment) {
        String schema;
        String transaction;
        XQENodeFactory factory = environment.getNodeFactory();
        V5UpdateSubject update = (V5UpdateSubject)node;
        SQLCall call = (SQLCall)factory.createNode(301061);
        call.setUpdateSubject(Boolean.TRUE);
        MetadataConnection mdConnection = ((V5UpdateSet)update.getParent()).getMetadataConnection();
        IQuerySubject metadata = null;
        String identifier = update.getUpdateSubjectModelName();
        try {
            metadata = (IQuerySubject)mdConnection.bindMetadataReference(identifier);
        }
        catch (DataSourceException e) {
            throw e;
        }
        catch (XQERuntimeException xre) {
            ((RequestEnvironment)environment.getRequestEnvironment()).getResponseMessageFolder().appendPlanningResponseMessage(new ResponseMessage(0, ResponseMessage.ResponseMessageType.TYPE_PLAN_STAT_INT, xre));
            metadata = null;
        }
        if (metadata == null) {
            throw new BindIdentifierNotFoundException(identifier);
        }
        List<IModelDataSource> dataSources = metadata.getDataSources();
        if (dataSources == null || dataSources.size() != 1) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "dataSources.size() != 1");
        }
        IModelDataSource modelDS = dataSources.get(0);
        IDataSource dataSource = ((ExecutionEnvironment)environment.getExecutionEnvironment()).getOrAddDataSource(modelDS);
        call.setDataSource(dataSource);
        Map<String, Object> dsMetadataProperties = modelDS.getMetadataProperties();
        Object property = dsMetadataProperties.get("transactionAccessMode");
        if (property != null && (transaction = (String)property).equals("read")) {
            IMessageKey.Param2 messageKey = XQEMessageKeys.PLN_DataModificationQuerySubjectReadWrite;
            throw new XQERuntimeException(messageKey, identifier, modelDS.getName());
        }
        String catalog = null;
        ICatalog mdCatalog = modelDS.getCatalog();
        if (mdCatalog != null) {
            catalog = mdCatalog.getName();
            catalog = this.expandMacro(catalog, environment);
        }
        if ((schema = modelDS.getSchema()) != null) {
            schema = this.expandMacro(schema, environment);
        }
        String procedureName = (String)metadata.getProperty("canonicalName");
        call.setName(procedureName);
        call.setSchemaName(schema);
        call.setCatalogName(catalog);
        List<IProcParameter> params = metadata.getStoredProcArgs();
        for (IProcParameter procParameter : params) {
            if ("OUT".equalsIgnoreCase(procParameter.getMode()) || "INOUT".equalsIgnoreCase(procParameter.getMode())) {
                SQLParameter sqlParameter = (SQLParameter)factory.createNode(301051);
                sqlParameter.setName(procParameter.getName());
                sqlParameter.setDataType(procParameter.getDataType());
                sqlParameter.setMode(procParameter.getMode());
                call.addChild(sqlParameter);
                continue;
            }
            String value = procParameter.getValue();
            if (!("INOUT".equalsIgnoreCase(procParameter.getMode()) || value != null && value.length() != 0)) {
                throw new XQERuntimeException(XQEMessageKeys.MD_MissingSPParameterValue, procParameter.getParameterName(), procedureName);
            }
            value = this.expandMacro(value, environment);
            IXQEQueryNode argument = this.createNode(value, procParameter, params.indexOf(procParameter), environment);
            call.addChild(argument);
        }
        update.exchange(call);
        SQLQueryBlock qBlock = (SQLQueryBlock)factory.createNode(301004);
        call.insertParent(qBlock);
        qBlock.setForeign(true);
    }

    private IXQEQueryNode createNode(String value, IProcParameter procParameter, int paramIndex, PlanningEnvironment environment) {
        XQENodeFactory factory = environment.getNodeFactory();
        SQLExpression node = null;
        if (value.matches("\\?.+\\?")) {
            String promptName = value.substring(1, value.length() - 1);
            SQLParameter param = (SQLParameter)factory.createNode(301051);
            IDataType dataType = procParameter.getDataType();
            param.setName(promptName);
            param.setDataType(dataType);
            param.setUseParameterizedSQL(true);
            Parameters parameters = ((RequestEnvironment)environment.getRequestEnvironment()).getRequestParameters();
            Parameter envParam = parameters.getParameter(promptName);
            if (envParam != null) {
                if (envParam.getDataType() == null) {
                    envParam.setDataType(param.getDataType());
                    envParam.setOrderIndex(paramIndex);
                }
            } else {
                envParam = new Parameter(promptName);
                envParam.setDataType(dataType);
                envParam.setOrderIndex(paramIndex);
                parameters.addParameter(promptName, envParam);
            }
            node = param;
        } else {
            SQLLiteral literal = (SQLLiteral)factory.createNode(301031);
            literal.setDataType(procParameter.getDataType());
            literal.setValue(value);
            node = literal;
        }
        return node;
    }

    private String expandMacro(String macro, PlanningEnvironment environment) {
        if (MacroExpander.isMacro(macro)) {
            MacroExpander expander = new MacroExpander();
            XQENodeFactory factory = environment.getNodeFactory();
            IXQEQueryNode temp = factory.createNode(801030);
            macro = expander.expand(temp, environment, macro);
        }
        return macro;
    }
}

