/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.util.DefaultENUSLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.SingleLocaleString;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public abstract class AbstractSingleLocaleString
implements Serializable,
Comparable<Object>,
CharSequence,
ILocalizedString {
    private static final boolean SHOULDINTERN = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE) != null && XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getBooleanProperty("general.internstring[@intern]", true);
    private static final long serialVersionUID = 1L;
    protected String defaultValue = null;

    public static String getString(String str) {
        if (SHOULDINTERN && str != null) {
            return str.intern();
        }
        return str;
    }

    public static boolean hasInternString() {
        return SHOULDINTERN;
    }

    @Override
    public String[] getSupportedLocales() {
        return new String[]{this.getDefaultLocale()};
    }

    @Override
    public List<String> getAllSupportedLocales() {
        ArrayList<String> supportedLocales = new ArrayList<String>();
        supportedLocales.add(this.getDefaultLocale());
        return supportedLocales;
    }

    @Override
    public boolean isLocaleExist(String locale) {
        return this.getDefaultLocale().equals(locale);
    }

    @Override
    public void put(Locale locale, String string) {
        this.put(locale.toString(), string);
    }

    @Override
    public void put(String locale, String string) {
        throw new IllegalArgumentException("The string " + string + " for the  locale " + locale + " cannot be added to a AbstractSingleLocaleString.");
    }

    @Override
    public int compareTo(Object other) {
        if (null == other) {
            return -1;
        }
        if (this == other) {
            return 0;
        }
        if (other instanceof LocalizedString) {
            LocalizedString otherLocalizedString = (LocalizedString)other;
            int defaultComparison = this.defaultValue.compareTo(otherLocalizedString.toString());
            if (defaultComparison != 0) {
                return defaultComparison;
            }
            if (otherLocalizedString.getSupportedLocales().length > 1) {
                return -1;
            }
            return 0;
        }
        if (other instanceof AbstractSingleLocaleString) {
            AbstractSingleLocaleString otherLocalizedString = (AbstractSingleLocaleString)other;
            String thisString = this.toString();
            return thisString.compareTo(otherLocalizedString.toString());
        }
        if (other instanceof String) {
            String otherString = (String)other;
            String thisString = this.toString();
            return thisString.compareTo(otherString);
        }
        return -1;
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof LocalizedString) {
            LocalizedString otherLocalizedString = (LocalizedString)other;
            return this.defaultValue.equals(otherLocalizedString.toString());
        }
        if (other instanceof AbstractSingleLocaleString) {
            AbstractSingleLocaleString otherLocalizedString = (AbstractSingleLocaleString)other;
            return this.defaultValue.equals(otherLocalizedString.toString());
        }
        if (other instanceof String) {
            String otherString = (String)other;
            String thisString = this.toString();
            return thisString == otherString || thisString.equals(otherString);
        }
        return false;
    }

    public int hashCode() {
        return this.defaultValue.hashCode();
    }

    @Override
    public String toString(Locale locale) {
        return this.toString(LocaleConverter.toString(locale));
    }

    @Override
    public String toString(String locale) {
        if (this.isLocaleExist(locale)) {
            return this.defaultValue;
        }
        return null;
    }

    @Override
    public String toString() {
        return this.defaultValue;
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public static ILocalizedString getSingleLocaleString(Locale locale, String value) {
        return AbstractSingleLocaleString.getSingleLocaleString(LocaleConverter.localeToStr(locale), value);
    }

    public static ILocalizedString getSingleLocaleString(String locale, String value) {
        if (locale.equals(DefaultENUSLocaleString.getStaticLocale())) {
            return new DefaultENUSLocaleString(value);
        }
        return new SingleLocaleString(locale, value);
    }
}

