/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class BufferBackedBitMap {
    private static final byte[] BYTE_COUNTS = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
    private static final int MASK_FF = 255;
    private static final int INT_3 = 3;
    private static final int INT_7 = 7;
    private final ByteBuffer buffer;
    private final int byteLength;
    private int cardinality = -1;
    private final int size;

    public BufferBackedBitMap(int theSize) {
        int bytesNeeded = theSize >> 3;
        if (bytesNeeded << 3 < theSize) {
            ++bytesNeeded;
        }
        this.size = theSize;
        this.buffer = ByteBuffer.allocate(bytesNeeded);
        this.byteLength = bytesNeeded;
    }

    public BufferBackedBitMap(int theSize, byte[] theBuffer) {
        int bytesNeeded = theSize >> 3;
        if (bytesNeeded << 3 < theSize) {
            ++bytesNeeded;
        }
        if (bytesNeeded > theBuffer.length) {
            throw new RuntimeException("The buffer has an insufficient length to support the requested bitmap size.");
        }
        this.size = theSize;
        this.buffer = ByteBuffer.wrap(theBuffer);
        this.byteLength = bytesNeeded;
    }

    public BufferBackedBitMap(int theSize, ByteBuffer theBuffer) {
        int bytesNeeded = theSize >> 3;
        if (bytesNeeded << 3 < theSize) {
            ++bytesNeeded;
        }
        if (bytesNeeded > theBuffer.capacity()) {
            throw new RuntimeException("The buffer has an insufficient limit to support the requested bitmap size.");
        }
        this.size = theSize;
        this.buffer = theBuffer;
        this.byteLength = bytesNeeded;
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public int byteLength() {
        return this.byteLength;
    }

    public int size() {
        return this.size;
    }

    public int cardinality() {
        if (this.cardinality != -1) {
            return this.cardinality;
        }
        this.clearExcessBits();
        int sum = 0;
        for (int i = 0; i < this.byteLength; ++i) {
            sum += BufferBackedBitMap.bitCount(this.buffer.get(i));
        }
        this.cardinality = sum;
        return this.cardinality;
    }

    public boolean get(int index) {
        return (this.buffer.get(index >> 3) & 1 << (index & 7)) != 0;
    }

    public int nextSetBit(int fromIndex) {
        if (fromIndex >= this.size()) {
            return -1;
        }
        int index = fromIndex;
        int currentOffset = index >> 3;
        byte currentByte = this.buffer.get(currentOffset);
        while (0 == currentByte && currentOffset < this.byteLength - 1) {
            index += 8;
            currentByte = this.buffer.get(++currentOffset);
        }
        if (0 == currentByte) {
            return -1;
        }
        while (index < this.size) {
            if (index >> 3 != currentOffset) {
                currentByte = this.buffer.get(++currentOffset);
                while (0 == currentByte && currentOffset < this.byteLength - 1) {
                    index += 8;
                    currentByte = this.buffer.get(++currentOffset);
                }
                if (0 == currentByte) {
                    return -1;
                }
            }
            if ((currentByte & 1 << (index & 7)) != 0) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int nextClearBit(int fromIndex) {
        if (fromIndex >= this.size()) {
            return -1;
        }
        int index = fromIndex;
        int currentOffset = index >> 3;
        byte currentByte = ~this.buffer.get(currentOffset);
        while (0 == currentByte && currentOffset < this.byteLength - 1) {
            index += 8;
            currentByte = ~this.buffer.get(++currentOffset);
        }
        if (0 == currentByte) {
            return -1;
        }
        while (index < this.size) {
            if (index >> 3 != currentOffset) {
                currentByte = ~this.buffer.get(++currentOffset);
                while (0 == currentByte && currentOffset < this.byteLength - 1) {
                    index += 8;
                    currentByte = ~this.buffer.get(++currentOffset);
                }
                if (0 == currentByte) {
                    return -1;
                }
            }
            if ((currentByte & 1 << (index & 7)) != 0) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void set(int index) {
        byte b = this.buffer.get(index >> 3);
        b = (byte)(b | 1 << (index & 7));
        this.buffer.put(index >> 3, b);
        this.cardinality = -1;
    }

    public void set(int index, boolean value) {
        if (value) {
            this.set(index);
        } else {
            this.clear(index);
        }
    }

    public void clear() {
        for (int i = 0; i < this.byteLength; ++i) {
            this.buffer.put(i, (byte)0);
        }
        this.cardinality = -1;
    }

    public void clear(int index) {
        byte b = this.buffer.get(index >> 3);
        b = (byte)(b & ~(1 << (index & 7)));
        this.buffer.put(index >> 3, b);
        this.cardinality = -1;
    }

    public void and(BufferBackedBitMap other) {
        int n = Math.min(this.byteLength, other.byteLength);
        for (int i = 0; i < n; ++i) {
            this.buffer.put(i, (byte)(this.buffer.get(i) & other.buffer.get(i)));
        }
        this.cardinality = -1;
    }

    public void and(BitSet bitset) {
        int n = Math.min(this.size(), bitset.size());
        int i = bitset.nextClearBit(0);
        while (i != -1 && i < n) {
            this.clear(i);
            i = bitset.nextClearBit(i + 1);
        }
        this.cardinality = -1;
    }

    public void andNot(BufferBackedBitMap other) {
        int n = Math.min(this.byteLength, other.byteLength);
        for (int i = 0; i < n; ++i) {
            this.buffer.put(i, (byte)(this.buffer.get(i) & ~other.buffer.get(i)));
        }
        this.cardinality = -1;
    }

    public void andNot(BitSet bitset) {
        int n = Math.min(this.size(), bitset.size());
        BitSet negatedBitset = new BitSet(bitset.size());
        negatedBitset.or(bitset);
        negatedBitset.flip(0, negatedBitset.size());
        int i = negatedBitset.nextClearBit(0);
        while (i != -1 && i < n) {
            this.clear(i);
            i = negatedBitset.nextClearBit(i + 1);
        }
        this.cardinality = -1;
    }

    public void or(BufferBackedBitMap other) {
        int n = Math.min(this.byteLength, other.byteLength);
        for (int i = 0; i < n; ++i) {
            this.buffer.put(i, (byte)(this.buffer.get(i) | other.buffer.get(i)));
        }
        this.cardinality = -1;
    }

    public void or(BitSet bitset) {
        int n = Math.min(this.size(), bitset.size());
        int i = bitset.nextSetBit(0);
        while (i != -1 && i < n) {
            this.set(i);
            i = bitset.nextSetBit(i + 1);
        }
        this.cardinality = -1;
    }

    public boolean containsAny(BufferBackedBitMap other) {
        int n = Math.min(this.byteLength, other.byteLength);
        this.clearExcessBits();
        other.clearExcessBits();
        for (int i = 0; i < n; ++i) {
            if ((this.buffer.get(i) & other.buffer.get(i)) == 0) continue;
            return true;
        }
        return false;
    }

    public boolean containsAny(BitSet bitset) {
        int n = Math.min(this.size(), bitset.size());
        int i = bitset.nextSetBit(0);
        while (i != -1 && i < n) {
            if (this.get(i)) {
                return true;
            }
            i = bitset.nextSetBit(i + 1);
        }
        return false;
    }

    public boolean containsAll(BufferBackedBitMap other) {
        int n = Math.min(this.byteLength, other.byteLength);
        this.clearExcessBits();
        other.clearExcessBits();
        for (int i = 0; i < n; ++i) {
            if (this.buffer.get(i) != other.buffer.get(i)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(BitSet bitset) {
        int n = Math.min(this.size(), bitset.size());
        int i = bitset.nextSetBit(0);
        while (i != -1 && i < n) {
            if (!this.get(i)) {
                return false;
            }
            i = bitset.nextSetBit(i + 1);
        }
        return true;
    }

    public void copyFrom(BitSet bitset) {
        int n = Math.min(this.size(), bitset.size());
        this.clear();
        int i = bitset.nextSetBit(0);
        while (i != -1 && i < n) {
            this.set(i);
            i = bitset.nextSetBit(i + 1);
        }
        this.cardinality = -1;
    }

    public void copyTo(BitSet bitset) {
        int n = Math.min(this.size(), bitset.size());
        bitset.clear();
        int i = this.nextSetBit(0);
        while (i != -1 && i < n) {
            bitset.set(i);
            i = this.nextSetBit(i + 1);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (null == o) {
            return false;
        }
        if (o instanceof BufferBackedBitMap) {
            BufferBackedBitMap other = (BufferBackedBitMap)o;
            if (this.byteLength != other.byteLength) {
                return false;
            }
            this.clearExcessBits();
            other.clearExcessBits();
            for (int i = 0; i < this.byteLength; ++i) {
                if (this.buffer.get(i) == other.buffer.get(i)) continue;
                return false;
            }
            return true;
        }
        if (o instanceof BitSet) {
            BitSet other = (BitSet)o;
            if (this.size() != other.size()) {
                return false;
            }
            for (int i = 0; i < this.size(); ++i) {
                if (this.get(i) == other.get(i)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        this.clearExcessBits();
        for (int i = 0; i < this.byteLength; ++i) {
            hcb.append(this.buffer.get(i));
        }
        return hcb.toHashCode();
    }

    private void clearExcessBits() {
        int limit = this.byteLength << 3;
        byte lastByte = this.buffer.get(this.byteLength - 1);
        for (int i = this.size; i < limit; ++i) {
            lastByte = (byte)(lastByte & ~(1 << (i & 7)));
        }
        this.buffer.put(this.byteLength - 1, lastByte);
    }

    private static int bitCount(byte val) {
        return BYTE_COUNTS[val & 0xFF];
    }
}

