/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.IParameterMaps;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentParameterAccessCoordinator
extends ParameterAccessCoordinator {
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;

    public ConcurrentParameterAccessCoordinator() {
        ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
        this.readLock = reentrantReadWriteLock.readLock();
        this.writeLock = reentrantReadWriteLock.writeLock();
    }

    @Override
    public void addParameterAccessCoordinator(ParameterAccessCoordinator aPAC) {
        this.writeLock.lock();
        try {
            super.addParameterAccessCoordinator(aPAC);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void addParameterMap(IParameterMaps parameterMap) {
        this.writeLock.lock();
        try {
            super.addParameterMap(parameterMap);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public ArrayList<IParameterMaps> getMaps() {
        this.readLock.lock();
        try {
            ArrayList<IParameterMaps> arrayList = super.getMaps();
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ArrayList<IParameterMaps> getAllMaps() {
        this.readLock.lock();
        try {
            ArrayList<IParameterMaps> arrayList = super.getAllMaps();
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ArrayList<IParameterMaps> getAllMapsWithMapName(String mapName) {
        this.readLock.lock();
        try {
            ArrayList<IParameterMaps> arrayList = super.getAllMapsWithMapName(mapName);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String nameOfMap, String key) {
        this.readLock.lock();
        try {
            String string = super.get(nameOfMap, key);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String nameOfMap, String key, boolean useDefaultValue) {
        this.readLock.lock();
        try {
            String string = super.get(nameOfMap, key, useDefaultValue);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String get(String key) {
        this.readLock.lock();
        try {
            String string = super.get(key);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Map<String, String> getAllEntries(String nameOfMap) {
        this.readLock.lock();
        try {
            Map<String, String> map = super.getAllEntries(nameOfMap);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String[] getMapNames() {
        this.readLock.lock();
        try {
            String[] stringArray = super.getMapNames();
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public String getDefault(String nameOfMap) {
        this.readLock.lock();
        try {
            String string = super.getDefault(nameOfMap);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<String> getArray(String nameOfMap, String key) throws XQERuntimeException {
        this.readLock.lock();
        try {
            ArrayList<String> arrayList = super.getArray(nameOfMap, key);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public ArrayList<String> getArray(String key) throws XQERuntimeException {
        this.readLock.lock();
        try {
            ArrayList<String> arrayList = super.getArray(key);
            return arrayList;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Map<String, ArrayList<String>> getArrayAllEntries(String nameOfMap) {
        this.readLock.lock();
        try {
            Map<String, ArrayList<String>> map = super.getArrayAllEntries(nameOfMap);
            return map;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setPriority(int newPriority) {
        this.writeLock.lock();
        try {
            super.setPriority(newPriority);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int getPriority() {
        this.readLock.lock();
        try {
            int n = super.getPriority();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setDefault(String mapName, String value) {
        this.writeLock.lock();
        try {
            this.setDefault(mapName, value);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public String toString() {
        this.readLock.lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

