/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import org.apache.commons.configuration.ConversionException;

public class ConfigurationValues {
    public static final String GROUP_MEASURES_INTO_FEWER_DB_AGGREGATES = "GroupMeasuresIntoFewerDBAggregateQueries";
    public static final String MAX_CUBE_LOAD_THREADS_OVERRIDE = "MaxCubeLoadThreadsOverride";
    public static final String USE_STACKED_AGGREGATES = "UseStackedAggregates";
    public static final String MAX_DATACACHE_AGGREGATE_DEFINITIONS = "MaxDataCacheAggregateDefinitions";
    public static final String IN_MEM_AGGS_MUST_MATCH_IN_DB_AGGS = "qsAutomaticAggregateOptimizationMatchInDatabaseAggregates";
    public static final String ADVISOR_DELETE_AGGREGATE_PCT_SPACE_THRESHOLD = "qsAdvisorDeleteAggregatePctSpaceThreshold";
    public static final String ADVISOR_ADD_AGGREGATE_PCT_SPACE_THRESHOLD = "qsAdvisorAddAggregatePctSpaceThreshold";
    public static final String ADVISOR_MAX_PCT_SPACE_PER_AGGREGATE = "qsAdvisorMaxPctSpacePerAggregate";
    public static final String ADVISOR_REPLACE_AGGREGATES_RATING_PCT_THRESHOLD = "qsAdvisorReplaceAggregatesRatingPctThreshold";
    public static final String ADVISOR_IN_MEMORY_AGGREGATE_TO_FACT_CARDINALITY_PCT_THRESHOLD = "qsAdvisorInMemoryAggregateToFactCardinalityPctThreshold";
    public static final String ADVISOR_MAX_GET_SLICE_CARDINALITY_CALLS_WHEN_RECOMMENDING_INITIAL_AGGREGATES = "qsAdvisorMaxGetSliceCardinalityCallsWhenReccommendingInitialAggregates";
    public static final String ADVISOR_MAX_GET_SLICE_CARDINALITY_CALLS_WHEN_ADJUSTING_AGGREGATES = "qsAdvisorMaxGetSliceCardinalityCallsWhenAdjustingAggregates";
    public static final String ADVISOR_MAX_NUMBER_OF_INITIAL_AGGREGATES = "qsAdvisorMaxNumberOfInitialAggregates";
    public static final String ADVISOR_SMART_SLICE_CARDINALITY_ESTIMATE = "qsAdvisorSmartSliceCardinalityEstimate";
    private static final int ONE_HUNDRED = 100;

    public static int getInt(String valueName, int defaultValue) {
        return ConfigurationValues.getInt(valueName, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static int getZeroOrPositiveInt(String valueName, int defaultValue) {
        return ConfigurationValues.getInt(valueName, defaultValue, 0, Integer.MAX_VALUE);
    }

    public static int getInt(String valueName, int defaultValue, int minValue, int maxValue) {
        int value = defaultValue;
        try {
            MultiRequestContext mrc;
            IExecutionEnvironment ee = ExecutionEnvironmentContext.getExecutionEnvironment();
            value = ee != null ? ((mrc = ee.getMultiRequestContextNoThrow()) != null ? mrc.fetchgetIntConfiguration(valueName, defaultValue) : ConfigurationValues.getIntValueFromXQEConfiguration(valueName, defaultValue)) : ConfigurationValues.getIntValueFromXQEConfiguration(valueName, defaultValue);
            if (value < minValue || value > maxValue) {
                value = defaultValue;
            }
        }
        catch (ConversionException e) {
            value = defaultValue;
        }
        return value;
    }

    public static double getPercentFromInt(String valueName, int defaultValue) {
        int intPct = ConfigurationValues.getInt(valueName, defaultValue, 0, 100);
        double pct = (double)intPct / 100.0;
        return pct;
    }

    public static boolean getBoolean(String valueName, boolean defaultValue) {
        boolean value = defaultValue;
        try {
            MultiRequestContext mrc;
            IExecutionEnvironment ee = ExecutionEnvironmentContext.getExecutionEnvironment();
            value = ee != null ? ((mrc = ee.getMultiRequestContextNoThrow()) != null ? mrc.fetchBooleanConfiguration(valueName, defaultValue) : ConfigurationValues.getBooleanValueFromXQEConfiguration(valueName, defaultValue)) : ConfigurationValues.getBooleanValueFromXQEConfiguration(valueName, defaultValue);
        }
        catch (ConversionException e) {
            value = defaultValue;
        }
        return value;
    }

    private static int getIntValueFromXQEConfiguration(String valueName, int defaultValue) {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return configuration.getIntProperty(valueName, defaultValue);
    }

    private static boolean getBooleanValueFromXQEConfiguration(String valueName, boolean defaultValue) {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return configuration.getBooleanProperty(valueName, defaultValue);
    }
}

