/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IEncodable;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.io.BufferedDataInputStream;
import com.cognos.xqe.util.io.BufferedDataOutputStream;
import com.cognos.xqe.util.io.TempFileUtil;
import java.io.File;
import java.io.IOException;

public class FileBackedArray
implements IReleasable {
    private static final int MAX_ELEMENTS = 1000000;
    private static final int PAGE_SIZE = 4;
    private static final int LONG_SIZE = 8;
    private File dTempFile;
    private BufferedDataInputStream dInputStream;
    private BufferedDataOutputStream dOutputStream;
    private long dOffset;
    private int nElements;
    private XDataContext context;
    private int eValueSize;
    private ValueMap map;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public FileBackedArray(XDataContext theContext, IDataType dType) {
        this.context = theContext;
        this.eValueSize = dType.getEncodedValueSize();
        this.map = new ValueMap();
        try {
            this.dTempFile = TempFileUtil.createTempFile(this.getClass().getSimpleName(), ".data");
            this.dOutputStream = new BufferedDataOutputStream(this.dTempFile, 4);
            this.dInputStream = new BufferedDataInputStream(this.dTempFile);
        }
        catch (IOException e) {
            throw new XQERuntimeException(e);
        }
    }

    public void add(IEncodable element) throws IOException {
        long offset = this.dOutputStream.size();
        this.map.add(offset);
        element.encode(this.context, this.dOutputStream);
    }

    public IEncodable get(long index, IEncodable value) throws IOException {
        long offset = this.map.get(index);
        this.dOutputStream.flush();
        if (this.dOffset + (long)this.eValueSize != offset) {
            this.dInputStream.seek(offset);
        }
        this.dOffset = offset;
        value.decode(this.context, this.dInputStream);
        return value;
    }

    @Override
    public void release() {
        try {
            this.dInputStream.close();
            this.dOutputStream.close();
            TempFileUtil.deleteTempFile(this.dTempFile);
            this.map.release();
        }
        catch (IOException e) {
            mErrorLogger.log(e);
        }
    }

    private class ValueMap {
        private long[] map = new long[1000000];
        private Mode mode = new MemoryMode();

        ValueMap() {
        }

        public void add(long element) throws IOException {
            this.mode.add(element);
        }

        public long get(long index) throws IOException {
            if (index >= (long)FileBackedArray.this.nElements) {
                throw new IllegalArgumentException();
            }
            return this.mode.get(index);
        }

        public void release() {
            this.mode.release();
        }

        static /* synthetic */ long[] access$102(ValueMap x0, long[] x1) {
            x0.map = x1;
            return x1;
        }

        private class DiskMode
        implements Mode {
            private File mTempFile = TempFileUtil.createTempFile(this.getClass().getSimpleName(), ".map");
            private BufferedDataInputStream mInputStream;
            private BufferedDataOutputStream mOutputStream = new BufferedDataOutputStream(this.mTempFile);
            private long mOffset;

            DiskMode() throws IOException {
                this.mInputStream = new BufferedDataInputStream(this.mTempFile);
                for (int i = 0; i < 1000000; ++i) {
                    this.mOutputStream.writeLong(ValueMap.this.map[i]);
                }
                ValueMap.access$102(ValueMap.this, null);
            }

            @Override
            public void add(long element) throws IOException {
                this.mOutputStream.writeLong(element);
                FileBackedArray.this.nElements++;
            }

            @Override
            public long get(long index) throws IOException {
                this.mOutputStream.flush();
                long offset = index * 8L;
                if (this.mOffset + 8L != offset) {
                    this.mInputStream.seek(offset);
                }
                this.mOffset = offset;
                return this.mInputStream.readLong();
            }

            @Override
            public void release() {
                try {
                    this.mInputStream.close();
                    this.mOutputStream.close();
                    TempFileUtil.deleteTempFile(this.mTempFile);
                }
                catch (IOException e) {
                    mErrorLogger.log(e);
                }
            }
        }

        private class MemoryMode
        implements Mode {
            MemoryMode() {
            }

            @Override
            public void add(long element) throws IOException {
                if (FileBackedArray.this.nElements < 1000000) {
                    ((ValueMap)ValueMap.this).map[((FileBackedArray)FileBackedArray.this).nElements++] = element;
                } else {
                    ValueMap.this.mode = new DiskMode();
                    ValueMap.this.mode.add(element);
                }
            }

            @Override
            public long get(long index) throws IOException {
                return ValueMap.this.map[(int)index];
            }

            @Override
            public void release() {
            }
        }
    }

    private static interface Mode {
        public void add(long var1) throws IOException;

        public long get(long var1) throws IOException;

        public void release();
    }
}

