/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class FileHandler {
    private static final String UTF_8 = "UTF-8";
    private static final String BRACE = "}";
    private static final int NUM_90 = 90;
    private static final int NUM_100 = 100;
    private static final String FOUND = "} Found {";
    private static final String EXPECTED = "Expected {";
    private static final int NUM_40 = 40;
    private static final int NUM_60 = 60;
    private static final String SPACE = " ";
    private static final int NUM_10 = 10;
    private static final int NUM_50 = 50;
    private static final int NUM_8 = 8;
    private static final String ONE_FILE_IS_BIGGER_THAN_THE_OTHER = "One file is bigger than the other. ";
    private static final String FILE_DOES_NOT_EXIST = "file does not exist ";
    private static final String ERROR = "Error:";
    private static final String ERROR_MSG = "Error: ";
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
    private static final String CLASS_XMLUNIT_DIFF = "org.custommonkey.xmlunit.Diff";
    private static final String METHOD_XMLUNIT_OVERRIDEELEMENTQUALIFIER = "overrideElementQualifier";
    private static final String CLASS_XMLUNIT_ELEMENTQUALIFIER = "org.custommonkey.xmlunit.ElementQualifier";
    private static final String CLASS_XMLUNIT_RECURSIVEELEMENTNAMEANDTEXTQUALIFIER = "org.custommonkey.xmlunit.examples.RecursiveElementNameAndTextQualifier";
    private static final String METHOD_XMLUNIT_SIMILAR = "similar";
    private static final String ELEMENT_SUBQUERIES = "subqueries";
    private static final String ELEMENT_ALLSUBQUERIES = "allsubqueries";
    private static final String STRING_QUERY = "Query";
    private static final Matcher MATCHER_QUERY = Pattern.compile("Query(\\d*)").matcher("");
    private static final Matcher MATCHER_NODE_ID = Pattern.compile("nodeId=(\\d*)").matcher("");
    private static final String ELEMENT_V5FILTEREXPRESSION = "V5FilterExpression";
    private static final String IN_STRING = " in (";
    private static final String SEMI_COLON = ";";

    public static Writer createFileWriter(String fileName) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), UTF_8));
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            mErrorLogger.log(e);
        }
        return writer;
    }

    public static Writer createOrAppendFileWriter(String fileName) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName, true), UTF_8));
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            mErrorLogger.log(e);
        }
        return writer;
    }

    public static XMLWriter createXMLWriterToFile(String fileName) {
        XMLWriter xmlWriter = null;
        try {
            Writer writer = FileHandler.createFileWriter(fileName);
            xmlWriter = new XMLWriter();
            xmlWriter.addStream(writer);
        }
        catch (Exception e) {
            mErrorLogger.log(e);
        }
        return xmlWriter;
    }

    public static XMLWriter createOrAppendXMLWriterToFile(String fileName) {
        XMLWriter xmlWriter = null;
        try {
            Writer writer = FileHandler.createOrAppendFileWriter(fileName);
            xmlWriter = new XMLWriter();
            xmlWriter.addStream(writer);
        }
        catch (Exception e) {
            mErrorLogger.log(e);
        }
        return xmlWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compareFileHTMLTagContent(String newFileName, String masterFileName) {
        StringBuilder errMsg = new StringBuilder(ERROR);
        errMsg.append(FILE_DOES_NOT_EXIST);
        errMsg.append(newFileName);
        File inputFile = FileHandler.getFile(newFileName, errMsg.toString());
        errMsg = new StringBuilder(ERROR);
        errMsg.append(FILE_DOES_NOT_EXIST);
        errMsg.append(newFileName);
        File outputFile = FileHandler.getFile(masterFileName, errMsg.toString());
        FileInputStream newStream = null;
        FileInputStream masterStream = null;
        try {
            masterStream = new FileInputStream(outputFile);
            newStream = new FileInputStream(inputFile);
            BufferedInputStream is1 = new BufferedInputStream(newStream);
            BufferedInputStream is2 = new BufferedInputStream(masterStream);
            String string = FileHandler.compareFileHTMLTagContent(is1, is2);
            return string;
        }
        catch (Exception e) {
            String string = "Error during file compare " + e.toString();
            return string;
        }
        finally {
            try {
                masterStream.close();
            }
            catch (Exception e2) {
                mErrorLogger.log(e2);
            }
            try {
                newStream.close();
            }
            catch (Exception e2) {
                mErrorLogger.log(e2);
            }
        }
    }

    protected static String compareFileHTMLTagContent(BufferedInputStream is1, BufferedInputStream is2) {
        String status = "";
        int inputRead = 0;
        int outputRead = 0;
        StringBuilder is1b = new StringBuilder();
        StringBuilder is2b = new StringBuilder();
        boolean okay = true;
        try {
            inputRead = FileHandler.getByte(is1, true);
            outputRead = FileHandler.getByte(is2, true);
            String eoHead = "</head>";
            boolean seenEOHead = false;
            while (inputRead != -1 && !seenEOHead) {
                is1b.append((char)inputRead);
                if (inputRead == 62 && is1b.indexOf(eoHead) >= 0) {
                    seenEOHead = true;
                    is1b = new StringBuilder();
                    continue;
                }
                inputRead = FileHandler.getByte(is1, true);
                if (is1b.length() <= 50) continue;
                is1b.delete(0, 10);
            }
            seenEOHead = false;
            while (outputRead != -1 && !seenEOHead) {
                is2b.append((char)outputRead);
                if (outputRead == 62 && is2b.indexOf(eoHead) >= 0) {
                    seenEOHead = true;
                    is2b = new StringBuilder();
                    continue;
                }
                outputRead = FileHandler.getByte(is2, true);
                if (is2b.length() <= 50) continue;
                is2b.delete(0, 10);
            }
            inputRead = FileHandler.getByte(is1, true);
            outputRead = FileHandler.getByte(is2, true);
            while (inputRead != -1 && outputRead != -1 && okay) {
                if (inputRead == 60) {
                    inputRead = FileHandler.getByte(is1, true);
                    while (inputRead != -1 && inputRead != 62) {
                        inputRead = FileHandler.getByte(is1, true);
                    }
                    inputRead = FileHandler.getByte(is1, true);
                    if (is1b.length() > 0 && is1b.charAt(is1b.length() - 1) != ' ') {
                        is1b.append(SPACE);
                    }
                }
                if (outputRead == 60) {
                    outputRead = FileHandler.getByte(is2, true);
                    while (outputRead != -1 && outputRead != 62) {
                        outputRead = FileHandler.getByte(is2, true);
                    }
                    outputRead = FileHandler.getByte(is2, true);
                    if (is2b.length() > 0 && is2b.charAt(is2b.length() - 1) != ' ') {
                        is2b.append(SPACE);
                    }
                }
                if (inputRead != -1 && outputRead != -1 && outputRead != inputRead) {
                    int i;
                    okay = false;
                    StringBuilder buff = new StringBuilder();
                    buff.append(EXPECTED);
                    if (is1b.length() > 60) {
                        is1b.delete(0, is1b.length() - 60);
                    }
                    buff.append((CharSequence)is1b);
                    for (i = 40; i > 0 && inputRead != -1; --i) {
                        buff.append((char)inputRead);
                        inputRead = FileHandler.getByte(is1, true);
                    }
                    buff.append(FOUND);
                    if (is2b.length() > 60) {
                        is2b.delete(0, is2b.length() - 60);
                    }
                    buff.append((CharSequence)is2b);
                    for (i = 40; i > 0 && outputRead != -1; --i) {
                        buff.append((char)outputRead);
                        outputRead = FileHandler.getByte(is2, true);
                    }
                    buff.append(BRACE);
                    status = status + buff.toString();
                    continue;
                }
                is1b.append((char)inputRead);
                is2b.append((char)outputRead);
                if (is1b.length() > 100) {
                    is1b.delete(0, 90);
                }
                if (is2b.length() > 100) {
                    is2b.delete(0, 90);
                }
                inputRead = FileHandler.getByte(is1, true);
                outputRead = FileHandler.getByte(is2, true);
            }
            if (status.length() == 0 && inputRead != outputRead) {
                status = ONE_FILE_IS_BIGGER_THAN_THE_OTHER;
            }
        }
        catch (IOException e) {
            XQEDebugLog.err.println(ERROR_MSG + e.getMessage());
            status = ERROR_MSG + e.getMessage();
        }
        return status;
    }

    private static String compareFileContentDiffInfo(InputStream inputStream1, InputStream inputStream2, boolean ignoreNewLine) {
        boolean filesEqual = true;
        String status = "";
        BufferedInputStream bufferedInputStream1 = new BufferedInputStream(inputStream1);
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(inputStream2);
        try {
            bufferedInputStream1.mark(50);
            bufferedInputStream2.mark(50);
            while (filesEqual) {
                int size;
                int inputRead = 0;
                int outputRead = 0;
                inputRead = FileHandler.getByte(bufferedInputStream1, ignoreNewLine);
                boolean bl = filesEqual = inputRead == (outputRead = FileHandler.getByte(bufferedInputStream2, ignoreNewLine));
                if (inputRead == -1) {
                    if (inputRead != outputRead) {
                        status = ONE_FILE_IS_BIGGER_THAN_THE_OTHER;
                    }
                    break;
                }
                if (filesEqual) continue;
                StringBuilder buff = new StringBuilder();
                buff.append(EXPECTED);
                for (size = 0; inputRead != -1 && size < 40; ++size) {
                    buff.append((char)inputRead);
                    inputRead = FileHandler.getByte(bufferedInputStream1, ignoreNewLine);
                }
                buff.append(FOUND);
                for (size = 0; outputRead != -1 && size < 40; ++size) {
                    buff.append((char)outputRead);
                    outputRead = FileHandler.getByte(bufferedInputStream2, ignoreNewLine);
                }
                buff.append(BRACE);
                status = status + buff.toString();
                String chkSumStatus = FileHandler.processCheckSumFiles(bufferedInputStream1, bufferedInputStream2, ignoreNewLine);
                if (chkSumStatus == null) continue;
                status = chkSumStatus;
            }
        }
        catch (IOException e) {
            XQEDebugLog.err.println(ERROR_MSG + e.getMessage());
            status = ERROR_MSG + e.getMessage();
        }
        return status;
    }

    static String processCheckSumFiles(BufferedInputStream b1, BufferedInputStream b2, boolean ignoreNewLine) {
        try {
            b1.reset();
            if (b1.read() == 67 && b1.read() == 72 && b1.read() == 75) {
                BufferedReader r = new BufferedReader(new InputStreamReader(b1));
                String s = r.readLine();
                s = s.trim();
                long masterCHK = Long.parseLong(s);
                if (r.read() == -1) {
                    b2.reset();
                    int outputRead = FileHandler.getByte(b2, ignoreNewLine);
                    long outputCHK = 0L;
                    long i = 0L;
                    while (outputRead != -1) {
                        outputCHK += (long)(outputRead << (int)(i++ % 8L * 8L));
                        outputRead = FileHandler.getByte(b2, ignoreNewLine);
                    }
                    if (masterCHK != outputCHK) {
                        return "Output CHK=" + outputCHK + " does not match master CHK=" + masterCHK;
                    }
                    return "";
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static int getByte(InputStream stream, boolean ignoreNewLine) throws IOException {
        int c;
        do {
            c = stream.read();
        } while (ignoreNewLine && (c == 13 || c == 10));
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compareFileDiffInfo(String newFileName, String masterFileName, boolean ignoreNewLine) {
        StringBuilder errMsg = new StringBuilder(ERROR);
        errMsg.append(FILE_DOES_NOT_EXIST);
        errMsg.append(masterFileName);
        File masterFile = FileHandler.getFile(masterFileName, errMsg.toString());
        errMsg = new StringBuilder(ERROR);
        errMsg.append(FILE_DOES_NOT_EXIST);
        errMsg.append(newFileName);
        File newFile = FileHandler.getFile(newFileName, errMsg.toString());
        FileInputStream newStream = null;
        FileInputStream masterStream = null;
        String status = "";
        try {
            masterStream = new FileInputStream(masterFile);
            newStream = new FileInputStream(newFile);
            status = FileHandler.compareFileContentDiffInfo(newStream, masterStream, ignoreNewLine);
        }
        catch (Throwable t) {
            XQEDebugLog.err.println(ERROR_MSG + t.getMessage());
            status = ERROR_MSG + t.getMessage();
        }
        finally {
            if (newStream != null) {
                try {
                    newStream.close();
                }
                catch (IOException e) {
                    mErrorLogger.log(e);
                }
            }
            if (masterStream != null) {
                try {
                    masterStream.close();
                }
                catch (IOException e) {
                    mErrorLogger.log(e);
                }
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String compareFileXMLDiffInfo(String newFileName, String masterFileName) {
        String theDifference = FileHandler.compareFileDiffInfo(masterFileName, newFileName);
        FileReader master = null;
        InputStreamReader output = null;
        if (theDifference.length() != 0) {
            try {
                master = new FileReader(masterFileName);
                output = new FileReader(newFileName);
                String myDiff = FileHandler.getDiffSimilar(master, (FileReader)output, theDifference);
                theDifference = myDiff.isEmpty() ? "" : (FileHandler.compareFileXMLSubqueryDiffInfo(newFileName, masterFileName) ? "" : myDiff);
            }
            catch (IOException e) {
                mErrorLogger.log(e);
            }
            finally {
                if (master != null) {
                    try {
                        master.close();
                    }
                    catch (IOException e) {
                        mErrorLogger.log(e);
                    }
                }
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException e) {
                        mErrorLogger.log(e);
                    }
                }
            }
        }
        return theDifference;
    }

    private static String getDiffSimilar(FileReader master, FileReader output, String theDifference) {
        block12: {
            try {
                Class<?> classDiff = Class.forName(CLASS_XMLUNIT_DIFF);
                Class[] paramList = new Class[]{Reader.class, Reader.class};
                Object[] argList = new Object[]{master, output};
                Object myDiff = classDiff.getDeclaredConstructor(paramList).newInstance(argList);
                Class<?> classElementQualifier = Class.forName(CLASS_XMLUNIT_ELEMENTQUALIFIER);
                Class[] methodParamList = new Class[]{classElementQualifier};
                Method methodOverrideElementQualifier = classDiff.getMethod(METHOD_XMLUNIT_OVERRIDEELEMENTQUALIFIER, methodParamList);
                Class<?> classRecursiveElementNameAndTextQualifier = Class.forName(CLASS_XMLUNIT_RECURSIVEELEMENTNAMEANDTEXTQUALIFIER);
                Object recursiveElementNameAndTextQualifier = classRecursiveElementNameAndTextQualifier.newInstance();
                methodOverrideElementQualifier.invoke(myDiff, recursiveElementNameAndTextQualifier);
                Method methodSimilar = classDiff.getMethod(METHOD_XMLUNIT_SIMILAR, new Class[0]);
                Boolean isSimilar = (Boolean)methodSimilar.invoke(myDiff, new Object[0]);
                if (isSimilar.booleanValue()) {
                    theDifference = "";
                } else {
                    Method methodToString = classDiff.getMethod("toString", new Class[0]);
                    theDifference = (String)methodToString.invoke(myDiff, new Object[0]);
                }
            }
            catch (InvocationTargetException ite) {
                Throwable cause = ite.getCause();
                if (cause != null) {
                    if (cause instanceof SAXException) {
                        mErrorLogger.log(cause);
                        StringBuilder exception = new StringBuilder("XMLUnit SAXException. ");
                        exception.append(theDifference);
                        theDifference = exception.toString();
                    } else if (cause instanceof IOException) {
                        mErrorLogger.log(cause);
                        theDifference = cause.getMessage();
                    } else {
                        theDifference = cause.getMessage();
                    }
                } else {
                    theDifference = "Encountered InvocationTargetException, unknown cause";
                }
                if (theDifference == null) {
                    theDifference = "Encountered InvocationTargetException";
                }
            }
            catch (Exception e) {
                theDifference = e.getMessage();
                if (theDifference != null) break block12;
                theDifference = "Encountered an Exception";
            }
        }
        return theDifference;
    }

    private static boolean compareFileXMLSubqueryDiffInfo(String newFileName, String masterFileName) {
        boolean similar = false;
        File outputFile = null;
        File masterFile = null;
        try {
            outputFile = new File(newFileName);
            masterFile = new File(masterFileName);
            SAXReader outputReader = new SAXReader();
            SAXReader masterReader = new SAXReader();
            Document outputDocument = outputReader.read(outputFile);
            Document masterDocument = masterReader.read(masterFile);
            Element outputRootElement = outputDocument.getRootElement();
            Element masterRootElement = masterDocument.getRootElement();
            if (outputRootElement.getName().equals(ELEMENT_SUBQUERIES) && masterRootElement.getName().equals(ELEMENT_SUBQUERIES) || outputRootElement.getName().equals(ELEMENT_ALLSUBQUERIES) && masterRootElement.getName().equals(ELEMENT_ALLSUBQUERIES)) {
                List outputElements = outputRootElement.elements();
                List masterElements = masterRootElement.elements();
                if (outputElements.size() == masterElements.size()) {
                    boolean matchElements = true;
                    for (int i = 0; i < masterElements.size(); ++i) {
                        Element masterElement = (Element)masterElements.get(i);
                        String masterXML = masterElement.asXML();
                        masterXML = FileHandler.replaceQueryNames(masterXML);
                        masterXML = FileHandler.replaceNodeIds(masterXML);
                        masterXML = FileHandler.sortV5FilterExpressionItems(masterXML);
                        boolean matchElement = false;
                        for (int j = 0; j < outputElements.size(); ++j) {
                            Element outputElement = (Element)outputElements.get(j);
                            String outputXML = outputElement.asXML();
                            outputXML = FileHandler.replaceQueryNames(outputXML);
                            if (!FileHandler.isDiffSimilar(masterXML = FileHandler.replaceNodeIds(masterXML), outputXML = FileHandler.sortV5FilterExpressionItems(outputXML))) continue;
                            outputElements.remove(j);
                            matchElement = true;
                            break;
                        }
                        if (matchElement) continue;
                        matchElements = false;
                        break;
                    }
                    similar = matchElements;
                }
            }
        }
        catch (DocumentException e) {
            mErrorLogger.log(e);
        }
        return similar;
    }

    private static boolean isDiffSimilar(String masterXML, String outputXML) {
        try {
            Class<?> classDiff = Class.forName(CLASS_XMLUNIT_DIFF);
            Class[] paramList = new Class[]{String.class, String.class};
            Object[] argList = new Object[]{masterXML, outputXML};
            Object elementDiff = classDiff.getDeclaredConstructor(paramList).newInstance(argList);
            Class<?> classElementQualifier = Class.forName(CLASS_XMLUNIT_ELEMENTQUALIFIER);
            Class[] methodParamList = new Class[]{classElementQualifier};
            Method methodOverrideElementQualifier = classDiff.getMethod(METHOD_XMLUNIT_OVERRIDEELEMENTQUALIFIER, methodParamList);
            Class<?> classRecursiveElementNameAndTextQualifier = Class.forName(CLASS_XMLUNIT_RECURSIVEELEMENTNAMEANDTEXTQUALIFIER);
            Object recursiveElementNameAndTextQualifier = classRecursiveElementNameAndTextQualifier.newInstance();
            methodOverrideElementQualifier.invoke(elementDiff, recursiveElementNameAndTextQualifier);
            Method methodSimilar = classDiff.getMethod(METHOD_XMLUNIT_SIMILAR, new Class[0]);
            Boolean isSimilar = (Boolean)methodSimilar.invoke(elementDiff, new Object[0]);
            return isSimilar;
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getCause();
            if (cause != null && (cause instanceof SAXException || cause instanceof IOException)) {
                mErrorLogger.log(cause);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String replaceQueryNames(String xmlString) {
        MATCHER_QUERY.reset(xmlString);
        return MATCHER_QUERY.replaceAll(STRING_QUERY);
    }

    private static String replaceNodeIds(String xmlString) {
        MATCHER_NODE_ID.reset(xmlString);
        return MATCHER_NODE_ID.replaceAll("nodeId");
    }

    private static String sortV5FilterExpressionItems(String xmlString) {
        int filterIndex = xmlString.indexOf(ELEMENT_V5FILTEREXPRESSION);
        while (filterIndex > -1) {
            String inList;
            Object[] inItems;
            String expression = xmlString.substring(filterIndex, xmlString.indexOf("/>", filterIndex));
            int inIndex = expression.indexOf(IN_STRING);
            if (inIndex > 0 && (inItems = (inList = expression.substring(inIndex + IN_STRING.length(), expression.lastIndexOf(")") - 1)).split(SEMI_COLON)).length > 1) {
                Arrays.sort(inItems);
                StringBuilder sb = new StringBuilder();
                for (int a = 0; a < inItems.length; ++a) {
                    sb.append((String)inItems[a]);
                    sb.append(SEMI_COLON);
                }
                String sortedList = sb.toString();
                xmlString = xmlString.replace(inList, sortedList);
            }
            filterIndex = xmlString.indexOf(ELEMENT_V5FILTEREXPRESSION, filterIndex + 1);
        }
        return xmlString;
    }

    public static File getFile(String fileName, String fileNotFoundErrMsg) {
        File masterFile = new File(fileName);
        if (!masterFile.exists()) {
            if (fileNotFoundErrMsg != null) {
                XQEDebugLog.err.println();
            } else {
                return null;
            }
        }
        return masterFile;
    }

    public static boolean isEmptyFile(String fileName) {
        StringBuilder errMsg = new StringBuilder(ERROR);
        errMsg.append(FILE_DOES_NOT_EXIST);
        errMsg.append(fileName);
        File aFile = FileHandler.getFile(fileName, errMsg.toString());
        if (aFile != null) {
            return aFile.length() <= 0L;
        }
        return false;
    }

    public static void deleteFile(String fileName) {
        File file = new File(fileName);
        file.delete();
    }

    public static void createOutputFolders(String outputFileName) {
        StringBuilder errMsg = new StringBuilder(ERROR);
        errMsg.append(FILE_DOES_NOT_EXIST);
        errMsg.append(outputFileName);
        File outputFile = FileHandler.getFile(outputFileName, errMsg.toString());
        File outputDirectory = outputFile.getParentFile();
        if (outputDirectory == null) {
            XQEDebugLog.err.println("Error: Unable to determine output folder");
            return;
        }
        outputDirectory.mkdirs();
    }

    public static boolean compareFile(String outputFileName, String masterFileName) {
        return FileHandler.compareFileDiffInfo(masterFileName, outputFileName, true).length() == 0;
    }

    public static String compareFileDiffInfo(String masterFileName, String outputFileName) {
        return FileHandler.compareFileDiffInfo(masterFileName, outputFileName, true);
    }

    public static void appendToFile(String fileName, String text) {
        try {
            FileWriter writer = new FileWriter(fileName, true);
            writer.write(text);
            writer.close();
        }
        catch (Exception e) {
            XQEDebugLog.err.println(ERROR + e.getLocalizedMessage());
            mErrorLogger.log(e);
        }
    }

    public static String fileToString(String fileName) {
        return FileHandler.fileToString(fileName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fileToString(String fileName, boolean errorIfNotFound) {
        String errMsg = null;
        if (errorIfNotFound) {
            StringBuilder errMsgBuilder = new StringBuilder(ERROR);
            errMsgBuilder.append(FILE_DOES_NOT_EXIST);
            errMsgBuilder.append(fileName);
            errMsg = errMsgBuilder.toString();
        }
        File inputFile = FileHandler.getFile(fileName, errMsg);
        FileInputStream inputStream = null;
        String fileContents = null;
        try {
            inputStream = new FileInputStream(inputFile);
            fileContents = FileHandler.inputStreamToString(inputStream);
        }
        catch (Throwable t) {
            XQEDebugLog.err.println(ERROR_MSG + t.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    mErrorLogger.log(e);
                }
            }
        }
        return fileContents;
    }

    public static String inputStreamToString(InputStream inputStream) {
        StringBuilder inputStreamContent = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, UTF_8));
            while ((line = reader.readLine()) != null) {
                inputStreamContent.append(line).append("\n");
            }
        }
        catch (Throwable t) {
            XQEDebugLog.err.println(ERROR_MSG + t.getMessage());
        }
        return inputStreamContent.toString();
    }
}

