/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.query.engine.IPlanningEnvironment;
import com.cognos.xqe.util.ParameterAccessCoordinator;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;

public class Governors {
    private static final String STRING_GOVERNORS = "Governors";
    private static final String STRING_COLON = ":";
    private static final String STRING_COMMA = ",";
    private static final String OPEN_PARENTHESIS = "(";
    private static final String CLOSE_PARENTHESIS = ")";
    private static final String STRING_NEVER = "NEVER";
    private static final String STRING_ALWAYS = "ALWAYS";
    public static final String PROP_OFF = "off";
    public static final String PROP_ON = "on";
    private static final int DEFAULT_FJO_MAX_KEYS = 10000;
    private int maxTablesPerQuery = 0;
    private int maxRowsRetrieved = 0;
    private int maxQueryExecTime = 0;
    private int maxTextBlobChars = 0;
    private int maxTableNameLength = 0;
    private GovernorPermission outerJoinAllowed;
    private GovernorPermission crossProdAllowed;
    private ShortCutProcessing shortcutProcessing;
    private SqlJoinSyntax sqlJoinSyntax;
    private CatByMeasureDimQi catByMeasureDimQi;
    private SqlGenerationForAttr sqlGenerationLevAttr;
    private SqlGenerationForAttr sqlGenerationDetAttr;
    private UseSQLParameters useSQLParameters;
    private SuppressDuplicateMeasureValues suppressDuplicateMeasureValues;
    private AutoSort autoSort;
    private ExecutionOptimization executionOptimization;
    private QueryProcessing queryProcessing;
    private RollupProcessing rollupProcessing;
    private ExecutionMethod executionMethod;
    private Suppress suppress;
    private MeasureRefiner measureRefiner;
    private ExactNumericDivision exactNumericDivision;
    private GroupByOptimization groupByOptimization;
    private CachePolicyModelSecurity cachePolicyModelSecurity;
    private CachePolicyDBAccess cachePolicyDBAccess;
    private Boolean cachePolicyConnectionCommandBlocks;
    private Boolean mdCallback;
    private Boolean localCache;
    private Boolean dynamicDimInfo;
    private Boolean sqlWithClause;
    private Boolean processAllModel;
    private Boolean avoidDivByZero;
    private Boolean useV4Interpretation;
    private Boolean useForParameterInfo;
    private Boolean queryIntent;
    private Boolean noDataMode;
    private Boolean designMode;
    private Boolean datasetMode;
    private Boolean useSAPMUNAsBusinessKey;
    private Boolean useAggregateCache;
    private OptimizeMasterDetailForAllRows optimizeMasterDetailForAllRows;
    AggregateOverHigherLevelAggregate aggregateOverHigherLevelAggregate;
    private String reportMeasure = "";
    private Boolean strictGroupBy;
    private Boolean reportAsDatasource = false;
    private Boolean dashboardContext = false;
    private Boolean localCacheSpecifiedInQueryHint = false;
    private NestedAggregateHandling nestedAggregateHandling;
    private Boolean interactive;
    private DataItemLabelBehaviour dataItemLabelBehaviour;
    private Boolean generateSubqueryForCalcs = null;
    private Boolean processNullConsumersAfterJoin = null;
    private Boolean useVectorizedQueryExecution = null;
    private FormatQueryItemsForParameterMaps formatQueryItemsForParameterMaps;
    private ContextSensitiveJoinSelection contextSensitiveJoinSelection;
    private LocalCachePolicy localCachePolicy;
    private String burstKeyList;
    private String burstMasterQueryName;
    private MasterDetailOptimization masterDetailOptimization;
    private CursorMode cursorMode;
    private boolean removeAggregateOpWhenFltPAAIsFalse = false;
    private boolean removeAggregateOpWhenDataItemAggIsNone = false;
    private boolean rowStitchForFactLessQuery = false;
    private boolean stitchWithNulls = true;
    private NativeSQLInCTE nativeSQLInCTE = NativeSQLInCTE.AUTOMATIC;
    private String[] suppressMessages;
    private String tableSamplingTable = "";
    private String tableSamplingMethod = null;
    private double tableSamplingPercent = 0.0;
    private int tableSamplingRowCount = 0;
    private int tableSamplingSeed = -1;
    private Boolean tableSamplingThrowOnSubquery;
    private boolean isStatsQuery = false;
    private String datasetModuleType = "";
    private boolean ignoreFiltersNotApplicable;
    private double maxOrderOfMagnitudeMDXResult = 0.0;
    private SQLWindowFunctionGeneration sqlWindowFunctionGeneration;
    private JoinOperator summaryQueryJoinOperator;
    private JoinOperator multiFactJoinOperator;
    private DMRUseRelationalCache dmrMembersUseRelationalCache;
    private DMRUseRelationalCache dmrCellsUseRelationalCache;
    private FJOUseRelationalCache fjoUseRelationalCache;
    DMRPreloadCellsExecutionMode dmrPreloadCellsExecutionMode;
    private Boolean constantFolding;
    private static final String ZERO = "0";
    private static final String ONE = "1";
    private static final String TWO = "2";
    private static final String THREE = "3";
    private static final String ENABLED = "ENABLED";
    private static final String DISABLED = "DISABLED";
    private static final String TRUE = "TRUE";
    private static final String FALSE = "FALSE";
    private static final String VALUE = "value";
    private static final String OFF = "OFF";
    public static final String AUTOMATIC = "automatic";
    private DMREmptyMUNTreatment treatEmptyDMRMUN;
    private double enablePushdownLevelOOM = 0.0;
    private DataCacheExpiry dataCacheExpiry = null;
    private DataCacheUsePolicy dataCacheUsePolicy;
    private Boolean treatRelXTabExtAggrAsListFooter;
    private Integer fjoMaxKeys = null;

    public Governors() {
        this.outerJoinAllowed = GovernorPermission.ALLOW;
        this.crossProdAllowed = GovernorPermission.DENY;
        this.shortcutProcessing = ShortCutProcessing.EXPLICIT;
        this.sqlJoinSyntax = SqlJoinSyntax.SERVERDETERMINED;
        this.catByMeasureDimQi = CatByMeasureDimQi.SERVERDETERMINED;
        this.sqlGenerationLevAttr = SqlGenerationForAttr.SERVERDETERMINED;
        this.sqlGenerationDetAttr = SqlGenerationForAttr.SERVERDETERMINED;
        this.useSQLParameters = UseSQLParameters.SERVERDETERMINED;
        this.suppressDuplicateMeasureValues = SuppressDuplicateMeasureValues.SERVERDETERMINED;
        this.autoSort = AutoSort.MINIMAL;
        this.executionOptimization = ExecutionOptimization.FIRSTROW;
        this.queryProcessing = QueryProcessing.DATABASEONLY;
        this.rollupProcessing = RollupProcessing.UNKNOWN;
        this.executionMethod = ExecutionMethod.SEQUENTIAL;
        this.suppress = Suppress.NULLS;
        this.mdCallback = Boolean.TRUE;
        this.localCache = Boolean.TRUE;
        this.dynamicDimInfo = Boolean.FALSE;
        this.sqlWithClause = Boolean.TRUE;
        this.processAllModel = Boolean.FALSE;
        this.avoidDivByZero = Boolean.TRUE;
        this.useV4Interpretation = Boolean.FALSE;
        this.useForParameterInfo = Boolean.FALSE;
        this.useSAPMUNAsBusinessKey = Boolean.TRUE;
        this.useAggregateCache = Boolean.FALSE;
        this.queryIntent = Boolean.FALSE;
        this.noDataMode = Boolean.FALSE;
        this.designMode = Boolean.FALSE;
        this.datasetMode = Boolean.FALSE;
        this.measureRefiner = MeasureRefiner.DISABLED;
        this.optimizeMasterDetailForAllRows = OptimizeMasterDetailForAllRows.DEFAULT;
        this.aggregateOverHigherLevelAggregate = AggregateOverHigherLevelAggregate.WARN;
        this.exactNumericDivision = ExactNumericDivision.CAST_TO_DOUBLE;
        this.groupByOptimization = GroupByOptimization.SERVERDETERMINED;
        this.cachePolicyModelSecurity = CachePolicyModelSecurity.AUTOMATIC;
        this.cachePolicyDBAccess = CachePolicyDBAccess.DB_CONNECTION_SIGNON;
        this.cachePolicyConnectionCommandBlocks = Boolean.TRUE;
        this.strictGroupBy = Boolean.FALSE;
        this.contextSensitiveJoinSelection = ContextSensitiveJoinSelection.DISABLED;
        this.localCachePolicy = LocalCachePolicy.LOWEST_SUMMARY_SUBQUERY;
        this.masterDetailOptimization = MasterDetailOptimization.DISABLED;
        this.cursorMode = CursorMode.CURSOR_MODE_AUTOMATIC;
        this.nativeSQLInCTE = NativeSQLInCTE.AUTOMATIC;
        this.sqlWindowFunctionGeneration = SQLWindowFunctionGeneration.PARTITION_BY;
        this.summaryQueryJoinOperator = JoinOperator.IS_NOT_DISTINCT_FROM;
        this.multiFactJoinOperator = JoinOperator.IS_NOT_DISTINCT_FROM;
        this.dmrMembersUseRelationalCache = DMRUseRelationalCache.NEVER;
        this.dmrCellsUseRelationalCache = DMRUseRelationalCache.NEVER;
        this.fjoUseRelationalCache = FJOUseRelationalCache.NEVER;
        this.dmrPreloadCellsExecutionMode = DMRPreloadCellsExecutionMode.SERIALLY;
        this.constantFolding = Boolean.TRUE;
        this.tableSamplingThrowOnSubquery = Boolean.FALSE;
        this.ignoreFiltersNotApplicable = Boolean.FALSE;
        this.treatEmptyDMRMUN = DMREmptyMUNTreatment.ASNULL;
        this.dataCacheExpiry = new DataCacheExpiry();
        this.dataCacheUsePolicy = DataCacheUsePolicy.USE_IT;
        this.nestedAggregateHandling = NestedAggregateHandling.SERVERDETERMINED;
        this.formatQueryItemsForParameterMaps = FormatQueryItemsForParameterMaps.OFF;
        this.treatRelXTabExtAggrAsListFooter = Boolean.TRUE;
        this.interactive = Boolean.FALSE;
        this.dataItemLabelBehaviour = DataItemLabelBehaviour.SERVERDETERMINED;
    }

    public Governors copy() {
        Governors copy = new Governors();
        copy.maxTablesPerQuery = this.maxTablesPerQuery;
        copy.maxRowsRetrieved = this.maxRowsRetrieved;
        copy.maxQueryExecTime = this.maxQueryExecTime;
        copy.maxTextBlobChars = this.maxTextBlobChars;
        copy.maxTableNameLength = this.maxTableNameLength;
        copy.outerJoinAllowed = this.outerJoinAllowed;
        copy.crossProdAllowed = this.crossProdAllowed;
        copy.shortcutProcessing = this.shortcutProcessing;
        copy.sqlJoinSyntax = this.sqlJoinSyntax;
        copy.catByMeasureDimQi = this.catByMeasureDimQi;
        copy.sqlGenerationLevAttr = this.sqlGenerationLevAttr;
        copy.sqlGenerationDetAttr = this.sqlGenerationDetAttr;
        copy.useSQLParameters = this.useSQLParameters;
        copy.suppressDuplicateMeasureValues = this.suppressDuplicateMeasureValues;
        copy.autoSort = this.autoSort;
        copy.executionOptimization = this.executionOptimization;
        copy.queryProcessing = this.queryProcessing;
        copy.rollupProcessing = this.rollupProcessing;
        copy.executionMethod = this.executionMethod;
        copy.suppress = this.suppress;
        copy.mdCallback = this.mdCallback;
        copy.localCache = this.localCache;
        copy.dynamicDimInfo = this.dynamicDimInfo;
        copy.generateSubqueryForCalcs = this.generateSubqueryForCalcs;
        copy.processNullConsumersAfterJoin = this.processNullConsumersAfterJoin;
        copy.useVectorizedQueryExecution = this.useVectorizedQueryExecution;
        copy.sqlWithClause = this.sqlWithClause;
        copy.processAllModel = this.processAllModel;
        copy.avoidDivByZero = this.avoidDivByZero;
        copy.useV4Interpretation = this.useV4Interpretation;
        copy.useForParameterInfo = this.useForParameterInfo;
        copy.useSAPMUNAsBusinessKey = this.useSAPMUNAsBusinessKey;
        copy.useAggregateCache = this.useAggregateCache;
        copy.queryIntent = this.queryIntent;
        copy.noDataMode = this.noDataMode;
        copy.designMode = this.designMode;
        copy.datasetMode = this.datasetMode;
        copy.measureRefiner = this.measureRefiner;
        copy.reportMeasure = this.reportMeasure;
        copy.optimizeMasterDetailForAllRows = this.optimizeMasterDetailForAllRows;
        copy.aggregateOverHigherLevelAggregate = this.aggregateOverHigherLevelAggregate;
        copy.exactNumericDivision = this.exactNumericDivision;
        copy.groupByOptimization = this.groupByOptimization;
        copy.cachePolicyModelSecurity = this.cachePolicyModelSecurity;
        copy.cachePolicyDBAccess = this.cachePolicyDBAccess;
        copy.cachePolicyConnectionCommandBlocks = this.cachePolicyConnectionCommandBlocks;
        copy.strictGroupBy = this.strictGroupBy;
        copy.contextSensitiveJoinSelection = this.contextSensitiveJoinSelection;
        copy.localCachePolicy = this.localCachePolicy;
        copy.masterDetailOptimization = this.masterDetailOptimization;
        copy.cursorMode = this.cursorMode;
        copy.removeAggregateOpWhenFltPAAIsFalse = this.removeAggregateOpWhenFltPAAIsFalse;
        copy.removeAggregateOpWhenDataItemAggIsNone = this.removeAggregateOpWhenDataItemAggIsNone;
        copy.rowStitchForFactLessQuery = this.rowStitchForFactLessQuery;
        copy.stitchWithNulls = this.stitchWithNulls;
        copy.maxOrderOfMagnitudeMDXResult = this.maxOrderOfMagnitudeMDXResult;
        copy.reportAsDatasource = this.reportAsDatasource;
        copy.sqlWindowFunctionGeneration = this.sqlWindowFunctionGeneration;
        copy.summaryQueryJoinOperator = this.summaryQueryJoinOperator;
        copy.multiFactJoinOperator = this.multiFactJoinOperator;
        copy.dmrMembersUseRelationalCache = this.dmrMembersUseRelationalCache;
        copy.dmrCellsUseRelationalCache = this.dmrCellsUseRelationalCache;
        copy.fjoUseRelationalCache = this.fjoUseRelationalCache;
        copy.dmrPreloadCellsExecutionMode = this.dmrPreloadCellsExecutionMode;
        copy.tableSamplingTable = this.tableSamplingTable;
        copy.tableSamplingMethod = this.tableSamplingMethod;
        copy.tableSamplingPercent = this.tableSamplingPercent;
        copy.tableSamplingRowCount = this.tableSamplingRowCount;
        copy.tableSamplingSeed = this.tableSamplingSeed;
        copy.tableSamplingThrowOnSubquery = this.tableSamplingThrowOnSubquery;
        copy.isStatsQuery = this.isStatsQuery;
        copy.datasetModuleType = this.datasetModuleType;
        copy.ignoreFiltersNotApplicable = this.ignoreFiltersNotApplicable;
        copy.treatEmptyDMRMUN = this.treatEmptyDMRMUN;
        copy.enablePushdownLevelOOM = this.enablePushdownLevelOOM;
        copy.dataCacheUsePolicy = this.dataCacheUsePolicy;
        copy.dataCacheExpiry = this.dataCacheExpiry;
        copy.dashboardContext = this.dashboardContext;
        copy.localCacheSpecifiedInQueryHint = this.localCacheSpecifiedInQueryHint;
        copy.nestedAggregateHandling = this.nestedAggregateHandling;
        copy.formatQueryItemsForParameterMaps = this.formatQueryItemsForParameterMaps;
        copy.treatRelXTabExtAggrAsListFooter = this.treatRelXTabExtAggrAsListFooter;
        copy.fjoMaxKeys = this.fjoMaxKeys;
        copy.interactive = this.interactive;
        copy.dataItemLabelBehaviour = this.dataItemLabelBehaviour;
        return copy;
    }

    public void loadGovernors(ParameterAccessCoordinator pac) {
        Map<String, String> modelGovernors = pac.getAllEntries("_governor");
        block90: for (AllGovernors ag : AllGovernors.values()) {
            String name = ag.getKey();
            String value = modelGovernors.get(name);
            if (value == null) continue;
            switch (ag) {
                case MAX_TABLES_PER_QUERY: {
                    this.setMaxTablesPerQuery(Integer.parseInt(value));
                    continue block90;
                }
                case MAX_ROWS_RETRIEVED: {
                    this.setMaxRowsRetrieved(Integer.parseInt(value));
                    continue block90;
                }
                case MAX_QUERY_EXECUTION_TIME: {
                    this.setMaxQueryExecTime(Integer.parseInt(value));
                    continue block90;
                }
                case MAX_TEXT_BLOB_CHARACTERS: {
                    this.setMaxTextBlobChars(Integer.parseInt(value));
                    continue block90;
                }
                case MAX_TABLE_NAME_LENGTH: {
                    this.setMaxTableNameLength(Integer.parseInt(value));
                    continue block90;
                }
                case AUTOSORT: {
                    this.setAutoSort(value);
                    continue block90;
                }
                case OUTERJOIN_ALLOWED: {
                    this.setOuterJoinAllowed(value);
                    continue block90;
                }
                case CROSS_PRODUCT_ALLOWED: {
                    this.setCrossProdAllowed(value);
                    continue block90;
                }
                case SHORTCUTPROCESSING: {
                    this.setShortcutProcessing(value);
                    continue block90;
                }
                case SQLJOINSYNTAX: {
                    this.setSqlJoinSyntax(value);
                    continue block90;
                }
                case CATBYMEASUREDIMQI: {
                    this.setCatByMeasureDimQi(value);
                    continue block90;
                }
                case SQLGENERATIONLEVATTR: {
                    this.setSqlGenerationLevAttr(value);
                    continue block90;
                }
                case SQLGENERATIONDETATTR: {
                    this.setSqlGenerationDetAttr(value);
                    continue block90;
                }
                case USE_SQL_PARAMETERS: {
                    this.setUseSQLParameters(value);
                    continue block90;
                }
                case USE_METADATA_CALLBACK: {
                    this.setMdCallback(value);
                    continue block90;
                }
                case LOCAL_CACHE: {
                    this.setLocalCache(value);
                    continue block90;
                }
                case SUPPRESS_DUPLICATE_MEASURE_VALUES: {
                    this.setSuppressDuplicateMeasureValues(value);
                    continue block90;
                }
                case DYNAMICDIMINFO: {
                    this.setDynamicDimInfo(value);
                    continue block90;
                }
                case USE_SQL_WITH_CLAUSE: {
                    this.setSqlWithClause(value);
                    continue block90;
                }
                case SUPPRESS: {
                    this.setSuppress(value);
                    continue block90;
                }
                case PROCESSALLMODEL: {
                    this.setProcessAllModel(value);
                    continue block90;
                }
                case AVOID_ZERODIV: {
                    this.setAvoidDivisionZero(value);
                    continue block90;
                }
                case USE_V4_INTERPRETATION: {
                    this.setUseV4Interpretation(value);
                    continue block90;
                }
                case USE_FOR_PARAMETER_INFO: {
                    this.setUseForParameterInfo(value);
                    continue block90;
                }
                case EXECUTION_OPTIMIZATION: {
                    this.setExecutionOptimization(value);
                    continue block90;
                }
                case FORMAT_QUERYITEMS_FOR_PARAMETER_MAPS: {
                    this.setFormatQueryItemsForParameterMaps(value);
                    continue block90;
                }
                case QUERY_PROCESSING: {
                    this.setQueryProcessing(value);
                    continue block90;
                }
                case ROLLUP_PROCESSING: {
                    this.setRollupProcessing(value);
                    continue block90;
                }
                case EXECUTION_METHOD: {
                    this.setExecutionMethod(value);
                    continue block90;
                }
                case QUERY_INTENT: {
                    this.setQueryIntent(value);
                    continue block90;
                }
                case NO_DATA_MODE: {
                    this.setNoDataMode(value);
                    continue block90;
                }
                case DESIGN_MODE: {
                    this.setDesignMode(value);
                    continue block90;
                }
                case DATASET_MODE: {
                    this.setDatasetMode(value);
                    continue block90;
                }
                case MEASURE_REFINER: {
                    this.setMeasureRefiner(value);
                    continue block90;
                }
                case REPORT_MEASURE: {
                    this.setReportMeasure(value);
                    continue block90;
                }
                case USE_SAP_MUN_AS_BUSINESS_KEY: {
                    this.setUseSAPMUNAsBusinessKey(value);
                    continue block90;
                }
                case USE_AGGREGATE_CACHE: {
                    this.setUseAggregateCache(value);
                    continue block90;
                }
                case OPTIMIZE_MASTER_DETAIL_FOR_ALL_ROWS: {
                    this.setOptimizeMasterDetailForAllRows(value);
                    continue block90;
                }
                case AGGREGATE_OVER_HIGHER_LEVEL_AGGREGATE: {
                    this.setAggregateOverHigherLevelAggregate(value);
                    continue block90;
                }
                case EXACT_NUMERIC_DIVISION: {
                    this.setExactDivision(value);
                    continue block90;
                }
                case GROUPBY_OPTIMIZATION: {
                    this.setGroupByOptimization(value);
                    continue block90;
                }
                case CACHE_POLICY_MODEL_SECURITY: {
                    this.setCachePolicyModelSecurity(value);
                    continue block90;
                }
                case CACHE_POLICY_DB_ACCESS: {
                    this.setCachePolicyDBAccess(value);
                    continue block90;
                }
                case CACHE_POLICY_CONNECTION_COMMAND_BLOCKS: {
                    this.setCachePolicyConnectionCommandBlocks(value);
                    continue block90;
                }
                case CONTEXT_SENSITIVE_JOIN_SELECTION: {
                    this.setContextSensitiveJoinSelection(value);
                    continue block90;
                }
                case LOCAL_CACHE_POLICY: {
                    this.setLocalCachePolicy(value);
                    continue block90;
                }
                case MASTER_DETAIL_OPTIMIZATION: {
                    this.setMasterDetailOptimization(value);
                    continue block90;
                }
                case CURSOR_MODE: {
                    this.setCursorMode(value);
                    continue block90;
                }
                case BURST_KEY_LIST: {
                    this.setBurstKeyList(value);
                    continue block90;
                }
                case BURST_MASTER_QUERY_NAME: {
                    this.setBurstMasterQueryName(value);
                    continue block90;
                }
                case REMOVE_AGGOP_WHEN_FLT_PAA_IS_FALSE: {
                    this.setRemoveAggregateOpWhenFltPAAIsFalse(value);
                    continue block90;
                }
                case REMOVE_AGGOP_WHEN_DI_AGG_IS_NONE: {
                    this.setRemoveAggregateOpWhenDataItemAggIsNone(value);
                    continue block90;
                }
                case ROW_STITCH_FOR_FACT_LESS_QUERY: {
                    this.setRowStitchForFactLessQuery(value);
                    continue block90;
                }
                case STITCH_WITH_NULLS: {
                    this.setStitchWithNulls(value);
                    continue block90;
                }
                case NATIVE_SQL_IN_CTE: {
                    this.setNativeSQLInCTE(value);
                    continue block90;
                }
                case SUPPRESS_MESSAGES: {
                    this.setSuppressMessages(value);
                    continue block90;
                }
                case MAX_OOM_MDX_RESULT: {
                    this.setMaxOrderOfMagnitudeMDXResult(value);
                    continue block90;
                }
                case REPORT_AS_DATASOURCE: {
                    this.setReportAsDatasource(value);
                    continue block90;
                }
                case SQLWINDOWFUNCTION_GENERATION: {
                    this.setSQLWindowFunctionGeneration(value);
                    continue block90;
                }
                case SUMMARYQUERY_JOIN_OPERATOR: {
                    this.setSummaryQueryJoinOperator(value);
                    continue block90;
                }
                case MULTIFACT_JOIN_OPERATOR: {
                    this.setMultiFactJoinOperator(value);
                    continue block90;
                }
                case DMR_MEMBERS_USE_RELATIONAL_CACHE: {
                    this.setDMRMembersUseRelationalCache(value);
                    continue block90;
                }
                case DMR_CELLS_USE_RELATIONAL_CACHE: {
                    this.setDMRCellsUseRelationalCache(value);
                    continue block90;
                }
                case FJO_USE_RELATIONAL_CACHE: {
                    this.setFJOUseRelationalCache(value);
                    continue block90;
                }
                case DMR_PRELOAD_CELLS_EXECUTION_MODE: {
                    this.setDMRPreloadCellsExecutionMode(value);
                    continue block90;
                }
                case CONSTANT_FOLDING: {
                    this.setConstantFolding(value);
                    continue block90;
                }
                case TABLE_SAMPLING_TABLE: {
                    this.setTableSamplingTable(value);
                    continue block90;
                }
                case TABLE_SAMPLING_METHOD: {
                    this.setTableSamplingMethod(value);
                    continue block90;
                }
                case TABLE_SAMPLING_PERCENT: {
                    this.setTableSamplingPercent(Double.parseDouble(value));
                    continue block90;
                }
                case TABLE_SAMPLING_ROW_COUNT: {
                    this.setTableSamplingRowCount(Integer.parseInt(value));
                    continue block90;
                }
                case TABLE_SAMPLING_SEED: {
                    this.setTableSamplingSeed(Integer.parseInt(value));
                    continue block90;
                }
                case TABLE_SAMPLING_THROW_ON_SUBQUERY: {
                    this.setTableSamplingThrowOnSubquery(value);
                    continue block90;
                }
                case IS_STATS_QUERY: {
                    this.setIsStatsQuery(value);
                    continue block90;
                }
                case DATASET_MODULE_TYPE: {
                    this.setDatasetModuleType(value);
                    continue block90;
                }
                case IGNORE_FILTERS_NOT_APPLICABLE: {
                    this.setIgnoreFiltersNotApplicable(value);
                    continue block90;
                }
                case TREAT_EMPTY_DMR_MUN: {
                    this.setTreatEmptyDMRMUN(value);
                    continue block90;
                }
                case ENABLE_PUSHDOWN_LEVEL_LARGER_THAN: {
                    this.setEnablePushdownLevelOOM(value);
                    continue block90;
                }
                case DATA_CACHE_EXPIRY: {
                    this.setDataCacheExpiry(value);
                    continue block90;
                }
                case DATA_CACHE_USE_POLICY: {
                    this.setDataCacheUsePolicy(value);
                    continue block90;
                }
                case DASHBOARD_CONTEXT: {
                    this.setDashboardContext(value);
                    continue block90;
                }
                case NESTED_AGGREGATE_HANDLING: {
                    this.setNestedAggregateHandling(value);
                    continue block90;
                }
                case TREAT_RELATIONAL_XTAB_EXT_AGGR_AS_LIST_FOOTER: {
                    this.setTreatRelXTabExtAggrAsListFooter(value);
                    continue block90;
                }
                case FJO_MAX_KEYS: {
                    this.setFJOMaxKeys(Integer.parseInt(value));
                    continue block90;
                }
                case INTERACTIVE: {
                    this.setInteractive();
                    continue block90;
                }
                case DATAITEM_LABEL_BEHAVIOUR: {
                    this.setDataItemLabelBehaviour(value);
                    continue block90;
                }
                case GENERATE_SUBQUERY_FOR_CALCS: {
                    this.setGenerateSubqueryForCalcs(value);
                    continue block90;
                }
                case PROCESS_NULL_CONSUMERS_AFTER_JOIN: {
                    this.setProcessNullConsumersAfterJoin(value);
                    continue block90;
                }
                case USE_VECTORIZED_QUERY_EXECUTION: {
                    this.setUseVectorizedQueryExecution(value);
                    continue block90;
                }
            }
        }
        if (this.getReportAsDatasource()) {
            this.setSuppressDuplicateMeasureValues("true");
            this.setLocalCache("false");
            this.setUseSQLParameters("LITERAL");
        }
    }

    public void setFJOMaxKeys(int limit) {
        this.fjoMaxKeys = XQEIntegerPool.getInteger(limit);
    }

    public int getFJOMaxKeys() {
        if (this.fjoMaxKeys != null) {
            return this.fjoMaxKeys;
        }
        return 10000;
    }

    private void setCursorMode(String value) {
        for (CursorMode current : CursorMode.values()) {
            if (!current.fmCode.equals(value)) continue;
            this.cursorMode = current;
            return;
        }
        this.cursorMode = CursorMode.CURSOR_MODE_AUTOMATIC;
    }

    public Object getValue(String key) {
        if (key.equals(AllGovernors.MAX_TABLES_PER_QUERY.getKey())) {
            return this.getMaxTablesPerQuery();
        }
        if (key.equals(AllGovernors.MAX_ROWS_RETRIEVED.getKey())) {
            return this.getMaxRowsRetrieved();
        }
        if (key.equals(AllGovernors.MAX_QUERY_EXECUTION_TIME.getKey())) {
            return this.getMaxQueryExecTime();
        }
        if (key.equals(AllGovernors.MAX_TEXT_BLOB_CHARACTERS.getKey())) {
            return this.getMaxTextBlobChars();
        }
        if (key.equals(AllGovernors.MAX_TABLE_NAME_LENGTH.getKey())) {
            return this.getMaxTableNameLength();
        }
        if (key.equals(AllGovernors.AUTOSORT.getKey())) {
            return this.getAutoSort();
        }
        if (key.equals(AllGovernors.OUTERJOIN_ALLOWED.getKey())) {
            return this.getOuterJoinAllowed();
        }
        if (key.equals(AllGovernors.CROSS_PRODUCT_ALLOWED.getKey())) {
            return this.getCrossProdAllowed();
        }
        if (key.equals(AllGovernors.SHORTCUTPROCESSING.getKey())) {
            return this.getShortcutProcessing();
        }
        if (key.equals(AllGovernors.SQLJOINSYNTAX.getKey())) {
            return this.getSqlJoinSyntax();
        }
        if (key.equals(AllGovernors.CATBYMEASUREDIMQI.getKey())) {
            return this.getCatByMeasureDimQi();
        }
        if (key.equals(AllGovernors.SQLGENERATIONLEVATTR.getKey())) {
            return this.getSqlGenerationLevAttr();
        }
        if (key.equals(AllGovernors.USE_SQL_PARAMETERS.getKey())) {
            return this.getUseSQLParameters();
        }
        if (key.equals(AllGovernors.USE_METADATA_CALLBACK.getKey())) {
            return this.getMdCallback();
        }
        if (key.equals(AllGovernors.LOCAL_CACHE.getKey())) {
            return this.getLocalCache();
        }
        if (key.equals(AllGovernors.SUPPRESS_DUPLICATE_MEASURE_VALUES.getKey())) {
            return this.getSuppressDuplicateMeasureValues();
        }
        if (key.equals(AllGovernors.DYNAMICDIMINFO.getKey())) {
            return this.getDynamicDimInfo();
        }
        if (key.equals(AllGovernors.USE_SQL_WITH_CLAUSE.getKey())) {
            return this.getSqlWithClause();
        }
        if (key.equals(AllGovernors.SUPPRESS.getKey())) {
            return this.getSuppress();
        }
        if (key.equals(AllGovernors.PROCESSALLMODEL.getKey())) {
            return this.getProcessAllModel();
        }
        if (key.equals(AllGovernors.AVOID_ZERODIV.getKey())) {
            return this.getAvoidDivisionZero();
        }
        if (key.equals(AllGovernors.USE_V4_INTERPRETATION.getKey())) {
            return this.getUseV4Interpretation();
        }
        if (key.equals(AllGovernors.USE_FOR_PARAMETER_INFO.getKey())) {
            return this.getUseForParameterInfo();
        }
        if (key.equals(AllGovernors.EXECUTION_OPTIMIZATION.getKey())) {
            return this.getExecutionOptimization();
        }
        if (key.equals(AllGovernors.FORMAT_QUERYITEMS_FOR_PARAMETER_MAPS.getKey())) {
            return this.getFormatQueryItemsForParameterMaps();
        }
        if (key.equals(AllGovernors.QUERY_PROCESSING.getKey())) {
            return this.getQueryProcessing();
        }
        if (key.equals(AllGovernors.ROLLUP_PROCESSING.getKey())) {
            return this.getRollupProcessing();
        }
        if (key.equals(AllGovernors.EXECUTION_METHOD.getKey())) {
            return this.getExecutionMethod();
        }
        if (key.equals(AllGovernors.QUERY_INTENT.getKey())) {
            return this.getQueryIntent();
        }
        if (key.equals(AllGovernors.NO_DATA_MODE.getKey())) {
            return this.getNoDataMode();
        }
        if (key.equals(AllGovernors.DESIGN_MODE.getKey())) {
            return this.getDesignMode();
        }
        if (key.equals(AllGovernors.DATASET_MODE.getKey())) {
            return this.getDatasetMode();
        }
        if (key.equals(AllGovernors.MEASURE_REFINER.getKey())) {
            return this.getMeasureRefiner();
        }
        if (key.equals(AllGovernors.REPORT_MEASURE.getKey())) {
            return this.getReportMeasure();
        }
        if (key.equals(AllGovernors.USE_SAP_MUN_AS_BUSINESS_KEY.getKey())) {
            return this.getUseSAPMUNAsBusinessKey();
        }
        if (key.equals(AllGovernors.USE_AGGREGATE_CACHE.getKey())) {
            return this.getUseAggregateCache();
        }
        if (key.equals(AllGovernors.OPTIMIZE_MASTER_DETAIL_FOR_ALL_ROWS.getKey())) {
            return this.getOptimizeMasterDetailForAllRows();
        }
        if (key.equals(AllGovernors.AGGREGATE_OVER_HIGHER_LEVEL_AGGREGATE.getKey())) {
            return this.getAggregateOverHigherLevelAggregate();
        }
        if (key.equals(AllGovernors.EXACT_NUMERIC_DIVISION.getKey())) {
            return this.getExactNumericDivision();
        }
        if (key.equals(AllGovernors.GROUPBY_OPTIMIZATION.getKey())) {
            return this.getGroupByOptimization();
        }
        if (key.equals(AllGovernors.CACHE_POLICY_MODEL_SECURITY.getKey())) {
            return this.getCachePolicyModelSecurity();
        }
        if (key.equals(AllGovernors.CACHE_POLICY_DB_ACCESS.getKey())) {
            return this.getCachePolicyDBAccess();
        }
        if (key.equals(AllGovernors.CACHE_POLICY_CONNECTION_COMMAND_BLOCKS.getKey())) {
            return this.getCachePolicyConnectionCommandBlocks();
        }
        if (key.equals(AllGovernors.LOCAL_CACHE_POLICY.getKey())) {
            return this.getLocalCachePolicy();
        }
        if (key.equals(AllGovernors.MASTER_DETAIL_OPTIMIZATION.getKey())) {
            return this.getMasterDetailOptimization();
        }
        if (key.equals(AllGovernors.REMOVE_AGGOP_WHEN_FLT_PAA_IS_FALSE.getKey())) {
            return this.getRemoveAggregateOpWhenFltPAAIsFalse();
        }
        if (key.equals(AllGovernors.REMOVE_AGGOP_WHEN_DI_AGG_IS_NONE.getKey())) {
            return this.getRemoveAggregateOpWhenDataItemAggIsNone();
        }
        if (key.equals(AllGovernors.ROW_STITCH_FOR_FACT_LESS_QUERY.getKey())) {
            return this.getRowStitchForFactLessQuery();
        }
        if (key.equals(AllGovernors.STITCH_WITH_NULLS.getKey())) {
            return this.getStitchWithNulls();
        }
        if (key.equals(AllGovernors.NATIVE_SQL_IN_CTE.getKey())) {
            return this.getNativeSQLInCTE();
        }
        if (key.equals(AllGovernors.SUPPRESS_MESSAGES.getKey())) {
            return this.getSuppressMessages();
        }
        if (key.equals(AllGovernors.MAX_OOM_MDX_RESULT.getKey())) {
            return this.getMaxOrderOfMagnitudeMDXResult();
        }
        if (key.equals(AllGovernors.REPORT_AS_DATASOURCE.getKey())) {
            return this.getReportAsDatasource();
        }
        if (key.equals(AllGovernors.SQLWINDOWFUNCTION_GENERATION.getKey())) {
            return this.getWindowFunctionGeneration();
        }
        if (key.equals(AllGovernors.SUMMARYQUERY_JOIN_OPERATOR.getKey())) {
            return this.getSummaryQueryJoinOperator();
        }
        if (key.equals(AllGovernors.MULTIFACT_JOIN_OPERATOR.getKey())) {
            return this.getMultiFactJoinOperator();
        }
        if (key.equals(AllGovernors.DMR_MEMBERS_USE_RELATIONAL_CACHE.getKey())) {
            return this.getDMRMembersUseRelationalCache();
        }
        if (key.equals(AllGovernors.DMR_CELLS_USE_RELATIONAL_CACHE.getKey())) {
            return this.getDMRCellsUseRelationalCache();
        }
        if (key.equals(AllGovernors.FJO_USE_RELATIONAL_CACHE.getKey())) {
            return this.getFJOUseRelationalCache();
        }
        if (key.equals(AllGovernors.DMR_PRELOAD_CELLS_EXECUTION_MODE.getKey())) {
            return this.getDMRPreloadCellsExecutionMode();
        }
        if (key.equals(AllGovernors.CONSTANT_FOLDING.getKey())) {
            return this.getConstantFolding();
        }
        if (key.equals(AllGovernors.TABLE_SAMPLING_TABLE.getKey())) {
            return this.getTableSamplingTable();
        }
        if (key.equals(AllGovernors.TABLE_SAMPLING_METHOD.getKey())) {
            return this.getTableSamplingMethod();
        }
        if (key.equals(AllGovernors.TABLE_SAMPLING_PERCENT.getKey())) {
            return this.getTableSamplingPercent();
        }
        if (key.equals(AllGovernors.TABLE_SAMPLING_ROW_COUNT.getKey())) {
            return this.getTableSamplingRowCount();
        }
        if (key.equals(AllGovernors.TABLE_SAMPLING_SEED.getKey())) {
            return this.getTableSamplingSeed();
        }
        if (key.equals(AllGovernors.TABLE_SAMPLING_THROW_ON_SUBQUERY.getKey())) {
            return this.getTableSamplingThrowOnSubquery();
        }
        if (key.equals(AllGovernors.IS_STATS_QUERY.getKey())) {
            return this.isStatsQuery();
        }
        if (key.equals(AllGovernors.DATASET_MODULE_TYPE.getKey())) {
            return this.getDatasetModuleType();
        }
        if (key.equals(AllGovernors.IGNORE_FILTERS_NOT_APPLICABLE.getKey())) {
            return this.getIgnoreFiltersNotApplicable();
        }
        if (key.equals(AllGovernors.TREAT_EMPTY_DMR_MUN.getKey())) {
            return this.getTreatEmptyDMRMUN();
        }
        if (key.equals(AllGovernors.ENABLE_PUSHDOWN_LEVEL_LARGER_THAN.getKey())) {
            return this.getEnablePushdownLevelOOM();
        }
        if (key.equals(AllGovernors.DATA_CACHE_EXPIRY.getKey())) {
            return this.dataCacheExpiry.getEffectiveExpiry(null);
        }
        if (key.equals(AllGovernors.DATA_CACHE_USE_POLICY.getKey())) {
            return this.dataCacheUsePolicy;
        }
        if (key.equals(AllGovernors.DASHBOARD_CONTEXT.getKey())) {
            return this.isDashboardContext();
        }
        if (key.equals(AllGovernors.NESTED_AGGREGATE_HANDLING.getKey())) {
            return this.getNestedAggregateHandling();
        }
        if (key.equals(AllGovernors.TREAT_RELATIONAL_XTAB_EXT_AGGR_AS_LIST_FOOTER.getKey())) {
            return this.getTreatRelXTabExtAggrAsListFooter();
        }
        if (key.equals(AllGovernors.FJO_MAX_KEYS.getKey())) {
            return this.getFJOMaxKeys();
        }
        if (key.equals(AllGovernors.DATAITEM_LABEL_BEHAVIOUR.getKey())) {
            return this.getDataItemLabelBehaviour();
        }
        if (key.equals(AllGovernors.GENERATE_SUBQUERY_FOR_CALCS.getKey())) {
            return this.getGenerateSubqueryForCalcs();
        }
        if (key.equals(AllGovernors.PROCESS_NULL_CONSUMERS_AFTER_JOIN.getKey())) {
            return this.getProcessNullConsumersAfterJoin();
        }
        if (key.equals(AllGovernors.USE_VECTORIZED_QUERY_EXECUTION.getKey())) {
            return this.getUseVectorizedQueryExecution();
        }
        return "";
    }

    public LocalCachePolicy getLocalCachePolicy() {
        return this.localCachePolicy;
    }

    public MasterDetailOptimization getMasterDetailOptimization() {
        return this.masterDetailOptimization;
    }

    public AggregateOverHigherLevelAggregate getAggregateOverHigherLevelAggregate() {
        return this.aggregateOverHigherLevelAggregate;
    }

    public void setAggregateOverHigherLevelAggregate(String value) {
        String valueUpper = value.toUpperCase();
        if (AggregateOverHigherLevelAggregate.WARN.toString().equals(valueUpper)) {
            this.aggregateOverHigherLevelAggregate = AggregateOverHigherLevelAggregate.WARN;
            return;
        }
        if (AggregateOverHigherLevelAggregate.DENY.toString().equals(valueUpper)) {
            this.aggregateOverHigherLevelAggregate = AggregateOverHigherLevelAggregate.DENY;
            return;
        }
        if (AggregateOverHigherLevelAggregate.IGNORE.toString().equals(valueUpper)) {
            this.aggregateOverHigherLevelAggregate = AggregateOverHigherLevelAggregate.IGNORE;
            return;
        }
        this.aggregateOverHigherLevelAggregate = AggregateOverHigherLevelAggregate.WARN;
    }

    public int getMaxTablesPerQuery() {
        return this.maxTablesPerQuery;
    }

    public void setMaxTablesPerQuery(int n) {
        this.maxTablesPerQuery = n;
    }

    public int getMaxRowsRetrieved() {
        return this.maxRowsRetrieved;
    }

    public void setMaxRowsRetrieved(int n) {
        this.maxRowsRetrieved = n;
    }

    public int getMaxQueryExecTime() {
        return this.maxQueryExecTime;
    }

    public void setMaxQueryExecTime(int t) {
        this.maxQueryExecTime = t;
    }

    public int getMaxTextBlobChars() {
        return this.maxTextBlobChars;
    }

    public void setMaxTextBlobChars(int n) {
        this.maxTextBlobChars = n;
    }

    public int getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    public void setMaxTableNameLength(int n) {
        this.maxTableNameLength = n;
    }

    public GovernorPermission getOuterJoinAllowed() {
        return this.outerJoinAllowed;
    }

    public void setOuterJoinAllowed(String value) {
        String valueUpper = value.toUpperCase();
        if (GovernorPermission.ALLOW.toString().equals(valueUpper) || valueUpper.equals(ZERO)) {
            this.outerJoinAllowed = GovernorPermission.ALLOW;
            return;
        }
        if (GovernorPermission.WARN.toString().equals(valueUpper) || valueUpper.equals(ONE)) {
            this.outerJoinAllowed = GovernorPermission.WARN;
            return;
        }
        if (GovernorPermission.DENY.toString().equals(valueUpper) || valueUpper.equals(TWO)) {
            this.outerJoinAllowed = GovernorPermission.DENY;
            return;
        }
        this.outerJoinAllowed = GovernorPermission.ALLOW;
    }

    public GovernorPermission getCrossProdAllowed() {
        return this.crossProdAllowed;
    }

    public void setCrossProdAllowed(String value) {
        String valueUpper = value.toUpperCase();
        if (GovernorPermission.ALLOW.toString().equals(valueUpper) || valueUpper.equals(ZERO)) {
            this.crossProdAllowed = GovernorPermission.ALLOW;
            return;
        }
        if (GovernorPermission.WARN.toString().equals(valueUpper) || valueUpper.equals(ONE)) {
            this.crossProdAllowed = GovernorPermission.WARN;
            return;
        }
        if (GovernorPermission.DENY.toString().equals(valueUpper) || valueUpper.equals(TWO)) {
            this.crossProdAllowed = GovernorPermission.DENY;
            return;
        }
        this.crossProdAllowed = GovernorPermission.DENY;
    }

    public Boolean getUseSAPMUNAsBusinessKey() {
        return this.useSAPMUNAsBusinessKey;
    }

    public void setUseSAPMUNAsBusinessKey(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(TRUE)) {
            this.useSAPMUNAsBusinessKey = Boolean.TRUE;
            return;
        }
        this.useSAPMUNAsBusinessKey = Boolean.FALSE;
    }

    public String getTableSamplingTable() {
        return this.tableSamplingTable;
    }

    public void setTableSamplingTable(String value) {
        this.tableSamplingTable = value;
    }

    public String getTableSamplingMethod() {
        return this.tableSamplingMethod;
    }

    public void setTableSamplingMethod(String value) {
        this.tableSamplingMethod = value;
    }

    public double getTableSamplingPercent() {
        return this.tableSamplingPercent;
    }

    public void setTableSamplingPercent(double value) {
        this.tableSamplingPercent = value;
    }

    public int getTableSamplingSeed() {
        return this.tableSamplingSeed;
    }

    public void setTableSamplingSeed(int value) {
        this.tableSamplingSeed = value;
    }

    public int getTableSamplingRowCount() {
        return this.tableSamplingRowCount;
    }

    public void setTableSamplingRowCount(int value) {
        this.tableSamplingRowCount = value;
    }

    public Boolean getTableSamplingThrowOnSubquery() {
        return this.tableSamplingThrowOnSubquery;
    }

    public void setTableSamplingThrowOnSubquery(String value) {
        this.tableSamplingThrowOnSubquery = Boolean.parseBoolean(value);
    }

    public boolean isStatsQuery() {
        return this.isStatsQuery;
    }

    public void setIsStatsQuery(String value) {
        this.isStatsQuery = Boolean.parseBoolean(value);
    }

    public boolean getIgnoreFiltersNotApplicable() {
        return this.ignoreFiltersNotApplicable;
    }

    public void setIgnoreFiltersNotApplicable(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(TRUE)) {
            this.ignoreFiltersNotApplicable = Boolean.TRUE;
            return;
        }
        this.ignoreFiltersNotApplicable = Boolean.FALSE;
    }

    public String getDatasetModuleType() {
        return this.datasetModuleType;
    }

    public void setDatasetModuleType(String value) {
        this.datasetModuleType = value;
    }

    public Boolean getUseAggregateCache() {
        return this.useAggregateCache;
    }

    public void setUseAggregateCache(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(TRUE)) {
            this.useAggregateCache = Boolean.TRUE;
            return;
        }
        this.useAggregateCache = Boolean.FALSE;
    }

    public void setOptimizeMasterDetailForAllRows(String value) {
        String valueUpper = value.toUpperCase();
        if (OptimizeMasterDetailForAllRows.ALWAYS.toString().equals(valueUpper)) {
            this.optimizeMasterDetailForAllRows = OptimizeMasterDetailForAllRows.ALWAYS;
            return;
        }
        if (OptimizeMasterDetailForAllRows.NEVER.toString().equals(valueUpper)) {
            this.optimizeMasterDetailForAllRows = OptimizeMasterDetailForAllRows.NEVER;
            return;
        }
        if (OptimizeMasterDetailForAllRows.DEFAULT.toString().equals(valueUpper)) {
            this.optimizeMasterDetailForAllRows = OptimizeMasterDetailForAllRows.DEFAULT;
            return;
        }
        this.optimizeMasterDetailForAllRows = OptimizeMasterDetailForAllRows.DEFAULT;
    }

    public OptimizeMasterDetailForAllRows getOptimizeMasterDetailForAllRows() {
        return this.optimizeMasterDetailForAllRows;
    }

    public ShortCutProcessing getShortcutProcessing() {
        return this.shortcutProcessing;
    }

    public void setShortcutProcessing(String value) {
        String valueUpper = value.toUpperCase();
        if (ShortCutProcessing.EXPLICIT.toString().equals(valueUpper)) {
            this.shortcutProcessing = ShortCutProcessing.EXPLICIT;
            return;
        }
        if (ShortCutProcessing.AUTOMATIC.toString().equals(valueUpper)) {
            this.shortcutProcessing = ShortCutProcessing.AUTOMATIC;
            return;
        }
        this.shortcutProcessing = ShortCutProcessing.EXPLICIT;
    }

    public SqlJoinSyntax getSqlJoinSyntax() {
        return this.sqlJoinSyntax;
    }

    public void setSqlJoinSyntax(String value) {
        String valueUpper = value.toUpperCase();
        if (SqlJoinSyntax.SERVERDETERMINED.toString().equals(valueUpper)) {
            this.sqlJoinSyntax = SqlJoinSyntax.SERVERDETERMINED;
            return;
        }
        if (SqlJoinSyntax.EXPLICIT.toString().equals(valueUpper)) {
            this.sqlJoinSyntax = SqlJoinSyntax.EXPLICIT;
            return;
        }
        if (SqlJoinSyntax.IMPLICIT.toString().equals(valueUpper)) {
            this.sqlJoinSyntax = SqlJoinSyntax.IMPLICIT;
            return;
        }
        this.sqlJoinSyntax = SqlJoinSyntax.SERVERDETERMINED;
    }

    public CatByMeasureDimQi getCatByMeasureDimQi() {
        return this.catByMeasureDimQi;
    }

    public void setCatByMeasureDimQi(String value) {
        String valueUpper = value.toUpperCase();
        if (CatByMeasureDimQi.SERVERDETERMINED.toString().equals(valueUpper)) {
            this.catByMeasureDimQi = CatByMeasureDimQi.SERVERDETERMINED;
            return;
        }
        if (CatByMeasureDimQi.ENABLE.toString().equals(valueUpper) || valueUpper.equals(TRUE) || valueUpper.equals(ONE) || valueUpper.equals("ALLOW")) {
            this.catByMeasureDimQi = CatByMeasureDimQi.ENABLE;
            return;
        }
        if (CatByMeasureDimQi.DISABLE.toString().equals(valueUpper) || valueUpper.equals(FALSE) || valueUpper.equals(ZERO) || valueUpper.equals("DENY")) {
            this.catByMeasureDimQi = CatByMeasureDimQi.DISABLE;
            return;
        }
        this.catByMeasureDimQi = CatByMeasureDimQi.SERVERDETERMINED;
    }

    public SqlGenerationForAttr getSqlGenerationLevAttr() {
        return this.sqlGenerationLevAttr;
    }

    public void setSqlGenerationLevAttr(String value) {
        String valueUpper = value.toUpperCase();
        if (SqlGenerationForAttr.SERVERDETERMINED.toString().equals(valueUpper)) {
            this.sqlGenerationLevAttr = SqlGenerationForAttr.SERVERDETERMINED;
            return;
        }
        if (SqlGenerationForAttr.GROUPBY.toString().equals(valueUpper)) {
            this.sqlGenerationLevAttr = SqlGenerationForAttr.GROUPBY;
            return;
        }
        if (SqlGenerationForAttr.MINIMUM.toString().equals(valueUpper)) {
            this.sqlGenerationLevAttr = SqlGenerationForAttr.MINIMUM;
            return;
        }
        this.sqlGenerationLevAttr = SqlGenerationForAttr.SERVERDETERMINED;
    }

    public SqlGenerationForAttr getSqlGenerationDetAttr() {
        return this.sqlGenerationDetAttr;
    }

    public void setSqlGenerationDetAttr(String value) {
        String valueUpper = value.toUpperCase();
        if (SqlGenerationForAttr.SERVERDETERMINED.toString().equals(valueUpper)) {
            this.sqlGenerationDetAttr = SqlGenerationForAttr.SERVERDETERMINED;
            return;
        }
        if (SqlGenerationForAttr.GROUPBY.toString().equals(valueUpper)) {
            this.sqlGenerationDetAttr = SqlGenerationForAttr.GROUPBY;
            return;
        }
        if (SqlGenerationForAttr.MINIMUM.toString().equals(valueUpper)) {
            this.sqlGenerationDetAttr = SqlGenerationForAttr.MINIMUM;
            return;
        }
        this.sqlGenerationDetAttr = SqlGenerationForAttr.SERVERDETERMINED;
    }

    public UseSQLParameters getUseSQLParameters() {
        return this.useSQLParameters;
    }

    public void setUseSQLParameters(String value) {
        String valueUpper = value.toUpperCase();
        if (UseSQLParameters.SERVERDETERMINED.toString().equals(valueUpper)) {
            this.useSQLParameters = UseSQLParameters.SERVERDETERMINED;
            return;
        }
        if (UseSQLParameters.MARKER.toString().equals(valueUpper)) {
            this.useSQLParameters = UseSQLParameters.MARKER;
            return;
        }
        if (UseSQLParameters.LITERAL.toString().equals(valueUpper)) {
            this.useSQLParameters = UseSQLParameters.LITERAL;
            return;
        }
        this.useSQLParameters = UseSQLParameters.SERVERDETERMINED;
    }

    public SuppressDuplicateMeasureValues getSuppressDuplicateMeasureValues() {
        return this.suppressDuplicateMeasureValues;
    }

    public void setSuppressDuplicateMeasureValues(String value) {
        String valueUpper = value.toUpperCase();
        if (SuppressDuplicateMeasureValues.SERVERDETERMINED.toString().equals(valueUpper)) {
            this.suppressDuplicateMeasureValues = SuppressDuplicateMeasureValues.SERVERDETERMINED;
            return;
        }
        if (SuppressDuplicateMeasureValues.ENABLE.toString().equals(valueUpper) || TRUE.equals(valueUpper) || ONE.equals(valueUpper)) {
            this.suppressDuplicateMeasureValues = SuppressDuplicateMeasureValues.ENABLE;
            return;
        }
        if (SuppressDuplicateMeasureValues.DISABLE.toString().equals(valueUpper) || FALSE.equals(valueUpper) || ZERO.equals(valueUpper)) {
            this.suppressDuplicateMeasureValues = SuppressDuplicateMeasureValues.DISABLE;
            return;
        }
        this.suppressDuplicateMeasureValues = SuppressDuplicateMeasureValues.SERVERDETERMINED;
    }

    public AutoSort getAutoSort() {
        return this.autoSort;
    }

    public void setAutoSort(String value) {
        String valueUpper = value.toUpperCase();
        if (AutoSort.NONE.toString().equals(valueUpper)) {
            this.autoSort = AutoSort.NONE;
            return;
        }
        if (AutoSort.MINIMAL.toString().equals(valueUpper)) {
            this.autoSort = AutoSort.MINIMAL;
            return;
        }
        if (AutoSort.ALL.toString().equals(valueUpper)) {
            this.autoSort = AutoSort.ALL;
            return;
        }
        this.autoSort = AutoSort.MINIMAL;
    }

    public ExecutionOptimization getExecutionOptimization() {
        return this.executionOptimization;
    }

    public void setExecutionOptimization(String value) {
        String valueUpper = value.toUpperCase();
        if (ExecutionOptimization.FIRSTROW.toString().equals(valueUpper)) {
            this.executionOptimization = ExecutionOptimization.FIRSTROW;
            return;
        }
        if (ExecutionOptimization.ALLROWS.toString().equals(valueUpper)) {
            this.executionOptimization = ExecutionOptimization.ALLROWS;
            return;
        }
        this.executionOptimization = ExecutionOptimization.FIRSTROW;
    }

    public FormatQueryItemsForParameterMaps getFormatQueryItemsForParameterMaps() {
        return this.formatQueryItemsForParameterMaps;
    }

    public void setFormatQueryItemsForParameterMaps(String value) {
        String valueUpper = value.toUpperCase();
        if (FormatQueryItemsForParameterMaps.ON.toString().equals(valueUpper)) {
            this.formatQueryItemsForParameterMaps = FormatQueryItemsForParameterMaps.ON;
            return;
        }
        this.formatQueryItemsForParameterMaps = FormatQueryItemsForParameterMaps.OFF;
    }

    public QueryProcessing getQueryProcessing() {
        return this.queryProcessing;
    }

    public void setQueryProcessing(String value) {
        String valueUpper = value.toUpperCase();
        if (QueryProcessing.DATABASEONLY.toString().equals(valueUpper)) {
            this.queryProcessing = QueryProcessing.DATABASEONLY;
            return;
        }
        if (QueryProcessing.LIMITEDLOCAL.toString().equals(valueUpper)) {
            this.queryProcessing = QueryProcessing.LIMITEDLOCAL;
            return;
        }
        if (QueryProcessing.MINIMIZELOCAL.toString().equals(valueUpper)) {
            this.queryProcessing = QueryProcessing.LIMITEDLOCAL;
            return;
        }
        this.queryProcessing = QueryProcessing.DATABASEONLY;
    }

    public RollupProcessing getRollupProcessing() {
        return this.rollupProcessing;
    }

    public void setRollupProcessing(String value) {
        String valueUpper = value.toUpperCase();
        if (RollupProcessing.UNKNOWN.toString().equals(valueUpper) || valueUpper.equals(ZERO)) {
            this.rollupProcessing = RollupProcessing.UNKNOWN;
            return;
        }
        if (RollupProcessing.LOCAL.toString().equals(valueUpper) || valueUpper.equals(ONE)) {
            this.rollupProcessing = RollupProcessing.LOCAL;
            return;
        }
        if (RollupProcessing.DATABASE.toString().equals(valueUpper) || valueUpper.equals(TWO)) {
            this.rollupProcessing = RollupProcessing.DATABASE;
            return;
        }
        if (RollupProcessing.EXTENDED.toString().equals(valueUpper) || valueUpper.equals(THREE)) {
            this.rollupProcessing = RollupProcessing.EXTENDED;
            return;
        }
        this.rollupProcessing = RollupProcessing.UNKNOWN;
    }

    public ExecutionMethod getExecutionMethod() {
        return this.executionMethod;
    }

    public void setExecutionMethod(String value) {
        String valueUpper = value.toUpperCase();
        if (ExecutionMethod.SEQUENTIAL.toString().equals(valueUpper)) {
            this.executionMethod = ExecutionMethod.SEQUENTIAL;
            return;
        }
        if (ExecutionMethod.CONCURRENT.toString().equals(valueUpper)) {
            this.executionMethod = ExecutionMethod.CONCURRENT;
            return;
        }
        this.executionMethod = ExecutionMethod.SEQUENTIAL;
    }

    public Boolean getMdCallback() {
        return this.mdCallback;
    }

    public void setMdCallback(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(FALSE) || valueUpper.equals(ZERO)) {
            this.mdCallback = Boolean.FALSE;
            return;
        }
        this.mdCallback = Boolean.TRUE;
    }

    public Boolean getLocalCache() {
        return this.localCache;
    }

    public Boolean isLocalCacheEnabled(IPlanningEnvironment planEnv) {
        if (!this.isDataCacheExpiryEnabled()) {
            return this.getLocalCache();
        }
        return this.getDataCacheEffectiveExpiry(planEnv) > 0;
    }

    public Boolean getGenerateSubqueryForCalcs() {
        return this.generateSubqueryForCalcs;
    }

    public Boolean getProcessNullConsumersAfterJoin() {
        return this.processNullConsumersAfterJoin;
    }

    public Boolean getUseVectorizedQueryExecution() {
        return this.useVectorizedQueryExecution;
    }

    public void setQuerySubjectExpiries(ArrayList<String> theQuerySubjectExpiries) {
        this.dataCacheExpiry.setQuerySubjectExpiries(theQuerySubjectExpiries);
    }

    public void setModuleExpiries(ArrayList<String> theModuleExpiries) {
        this.dataCacheExpiry.setModuleExpiries(theModuleExpiries);
    }

    public void setLocalCache(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(FALSE) || valueUpper.equals(DISABLED) || valueUpper.equals(ZERO)) {
            this.localCache = Boolean.FALSE;
            return;
        }
        this.localCache = Boolean.TRUE;
    }

    public boolean isDataCacheExpiryEnabled() {
        return this.dataCacheExpiry.isDataCacheExpiryEnabled();
    }

    public void setGenerateSubqueryForCalcs(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(TRUE) || valueUpper.equals(ENABLED) || valueUpper.equals(ONE)) {
            this.generateSubqueryForCalcs = Boolean.TRUE;
            return;
        }
        this.generateSubqueryForCalcs = Boolean.FALSE;
    }

    public void setProcessNullConsumersAfterJoin(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(TRUE) || valueUpper.equals(ENABLED) || valueUpper.equals(ONE)) {
            this.processNullConsumersAfterJoin = Boolean.TRUE;
            return;
        }
        this.processNullConsumersAfterJoin = Boolean.FALSE;
    }

    public void setUseVectorizedQueryExecution(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(TRUE) || valueUpper.equals(ENABLED) || valueUpper.equals(ONE)) {
            this.useVectorizedQueryExecution = Boolean.TRUE;
            return;
        }
        this.useVectorizedQueryExecution = Boolean.FALSE;
    }

    public int getDataCacheEffectiveExpiry(IPlanningEnvironment planEnv) {
        return this.dataCacheExpiry.getEffectiveExpiry(planEnv);
    }

    public void setDataCacheExpiry(String value) {
        this.dataCacheExpiry.setValue(value);
    }

    public DataCacheUsePolicy getDataCacheUsePolicy() {
        return this.dataCacheUsePolicy;
    }

    public void setDataCacheUsePolicy(String value) {
        this.dataCacheUsePolicy = DataCacheUsePolicy.ONLY_FRESH_DATA.getValue().toString().equalsIgnoreCase(value) ? DataCacheUsePolicy.ONLY_FRESH_DATA : (DataCacheUsePolicy.ONLY_CACHE_DATA_OR_THROW.getValue().toString().equalsIgnoreCase(value) ? DataCacheUsePolicy.ONLY_CACHE_DATA_OR_THROW : (DataCacheUsePolicy.ONLY_CACHE_DATA_OR_EMPTY_RESULT.getValue().toString().equalsIgnoreCase(value) ? DataCacheUsePolicy.ONLY_CACHE_DATA_OR_EMPTY_RESULT : DataCacheUsePolicy.USE_IT));
    }

    public void setDashboardContext(String value) {
        String valueUpper = value.toUpperCase();
        this.dashboardContext = valueUpper.equals(TRUE) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean isDashboardContext() {
        return this.dashboardContext;
    }

    public void setLocalCacheSpecifiedInQueryHint(String value) {
        String valueUpper = value.toUpperCase();
        this.localCacheSpecifiedInQueryHint = valueUpper.equals(TRUE) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Boolean isLocalCacheSpecifiedInQueryHint() {
        return this.localCacheSpecifiedInQueryHint;
    }

    public Boolean getRemoveAggregateOpWhenFltPAAIsFalse() {
        return this.removeAggregateOpWhenFltPAAIsFalse;
    }

    public void setRemoveAggregateOpWhenFltPAAIsFalse(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(FALSE) || valueUpper.equals(DISABLED) || valueUpper.equals(ZERO)) {
            this.removeAggregateOpWhenFltPAAIsFalse = Boolean.FALSE;
            return;
        }
        this.removeAggregateOpWhenFltPAAIsFalse = Boolean.TRUE;
    }

    public Boolean getRemoveAggregateOpWhenDataItemAggIsNone() {
        return this.removeAggregateOpWhenDataItemAggIsNone;
    }

    public void setRemoveAggregateOpWhenDataItemAggIsNone(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(FALSE) || valueUpper.equals(DISABLED) || valueUpper.equals(ZERO)) {
            this.removeAggregateOpWhenDataItemAggIsNone = Boolean.FALSE;
            return;
        }
        this.removeAggregateOpWhenDataItemAggIsNone = Boolean.TRUE;
    }

    public Boolean getRowStitchForFactLessQuery() {
        return this.rowStitchForFactLessQuery;
    }

    public void setRowStitchForFactLessQuery(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(FALSE) || valueUpper.equals(DISABLED) || valueUpper.equals(ZERO)) {
            this.rowStitchForFactLessQuery = Boolean.FALSE;
            return;
        }
        this.rowStitchForFactLessQuery = Boolean.TRUE;
    }

    public Boolean getStitchWithNulls() {
        return this.stitchWithNulls;
    }

    public void setStitchWithNulls(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(FALSE) || valueUpper.equals(DISABLED) || valueUpper.equals(ZERO)) {
            this.stitchWithNulls = Boolean.FALSE;
            return;
        }
        this.stitchWithNulls = Boolean.TRUE;
    }

    public Boolean getDynamicDimInfo() {
        return this.dynamicDimInfo;
    }

    public void setDynamicDimInfo(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(TRUE) || valueUpper.equals(ENABLED) || valueUpper.equals(ONE)) {
            this.dynamicDimInfo = Boolean.TRUE;
            return;
        }
        this.dynamicDimInfo = Boolean.FALSE;
    }

    public Boolean getSqlWithClause() {
        return this.sqlWithClause;
    }

    public void setSqlWithClause(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(FALSE) || valueUpper.equals(ZERO)) {
            this.sqlWithClause = Boolean.FALSE;
            return;
        }
        this.sqlWithClause = Boolean.TRUE;
    }

    public Suppress getSuppress() {
        return this.suppress;
    }

    public void setSuppress(String value) {
        String valueUpper = value.toUpperCase();
        if (Suppress.NONE.toString().equals(valueUpper)) {
            this.suppress = Suppress.NONE;
            return;
        }
        if (Suppress.NULLS.toString().equals(valueUpper)) {
            this.suppress = Suppress.NULLS;
            return;
        }
        this.suppress = null;
    }

    public MeasureRefiner getMeasureRefiner() {
        return this.measureRefiner;
    }

    public void setMeasureRefiner(String value) {
        String valueUpper = value.toUpperCase();
        if (MeasureRefiner.ENABLED.toString().equals(valueUpper)) {
            this.measureRefiner = MeasureRefiner.ENABLED;
            return;
        }
        if (MeasureRefiner.DISABLED.toString().equals(valueUpper)) {
            this.measureRefiner = MeasureRefiner.DISABLED;
            return;
        }
        this.measureRefiner = MeasureRefiner.DISABLED;
    }

    public Boolean getProcessAllModel() {
        return this.processAllModel;
    }

    public void setProcessAllModel(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(TRUE)) {
            this.processAllModel = Boolean.TRUE;
            return;
        }
        this.processAllModel = Boolean.FALSE;
    }

    public Boolean getAvoidDivisionZero() {
        return this.avoidDivByZero;
    }

    public void setAvoidDivisionZero(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(FALSE) || valueUpper.equals(DISABLED) || valueUpper.equals(ZERO)) {
            this.avoidDivByZero = Boolean.FALSE;
            return;
        }
        this.avoidDivByZero = Boolean.TRUE;
    }

    public Boolean getUseV4Interpretation() {
        return this.useV4Interpretation;
    }

    public void setUseV4Interpretation(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(TRUE)) {
            this.useV4Interpretation = Boolean.TRUE;
            return;
        }
        this.useV4Interpretation = Boolean.FALSE;
    }

    public Boolean getUseForParameterInfo() {
        return this.useForParameterInfo;
    }

    public void setUseForParameterInfo(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(TRUE)) {
            this.useForParameterInfo = Boolean.TRUE;
            return;
        }
        this.useForParameterInfo = Boolean.FALSE;
    }

    public Boolean getQueryIntent() {
        return this.queryIntent;
    }

    public void setQueryIntent(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals("METADATA")) {
            this.queryIntent = Boolean.TRUE;
            return;
        }
        this.queryIntent = Boolean.FALSE;
    }

    public Boolean getNoDataMode() {
        return this.noDataMode;
    }

    public void setNoDataMode(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(TRUE)) {
            this.noDataMode = Boolean.TRUE;
            return;
        }
        this.noDataMode = Boolean.FALSE;
    }

    public Boolean getDesignMode() {
        return this.designMode;
    }

    public void setDesignMode(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(TRUE)) {
            this.designMode = Boolean.TRUE;
            return;
        }
        this.designMode = Boolean.FALSE;
    }

    public Boolean getDatasetMode() {
        return this.datasetMode;
    }

    public void setDatasetMode(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(TRUE)) {
            this.datasetMode = Boolean.TRUE;
            return;
        }
        this.datasetMode = Boolean.FALSE;
    }

    public String getReportMeasure() {
        return this.reportMeasure;
    }

    public void setReportMeasure(String value) {
        this.reportMeasure = value;
    }

    public ExactNumericDivision getExactNumericDivision() {
        return this.exactNumericDivision;
    }

    public void setExactDivision(String value) {
        String valueUpper = value.toUpperCase();
        if (ExactNumericDivision.CAST_TO_DOUBLE.toString().equals(valueUpper) || valueUpper.equals(ZERO)) {
            this.exactNumericDivision = ExactNumericDivision.CAST_TO_DOUBLE;
            return;
        }
        if (ExactNumericDivision.CAST_TO_DOUBLE_CONDITIONAL.toString().equals(valueUpper) || valueUpper.equals(ONE)) {
            this.exactNumericDivision = ExactNumericDivision.CAST_TO_DOUBLE_CONDITIONAL;
            return;
        }
        if (ExactNumericDivision.DO_NOT_ADJUST.toString().equals(valueUpper) || valueUpper.equals(TWO)) {
            this.exactNumericDivision = ExactNumericDivision.DO_NOT_ADJUST;
            return;
        }
        this.exactNumericDivision = ExactNumericDivision.CAST_TO_DOUBLE;
    }

    public GroupByOptimization getGroupByOptimization() {
        return this.groupByOptimization;
    }

    public void setGroupByOptimization(String value) {
        String valueUpper = value.toUpperCase();
        if (GroupByOptimization.SERVERDETERMINED.toString().equals(valueUpper)) {
            this.groupByOptimization = GroupByOptimization.SERVERDETERMINED;
            return;
        }
        if (GroupByOptimization.DISTINCT.toString().equals(valueUpper)) {
            this.groupByOptimization = GroupByOptimization.DISTINCT;
            return;
        }
        this.groupByOptimization = GroupByOptimization.SERVERDETERMINED;
    }

    public CachePolicyModelSecurity getCachePolicyModelSecurity() {
        return this.cachePolicyModelSecurity;
    }

    public void setCachePolicyModelSecurity(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(ZERO) || CachePolicyModelSecurity.AUTOMATIC.toString().equals(valueUpper)) {
            this.cachePolicyModelSecurity = CachePolicyModelSecurity.AUTOMATIC;
            return;
        }
        if (valueUpper.equals(ONE) || CachePolicyModelSecurity.USER.toString().equals(valueUpper)) {
            this.cachePolicyModelSecurity = CachePolicyModelSecurity.USER;
            return;
        }
        if (valueUpper.equals(TWO) || CachePolicyModelSecurity.USERCLASS.toString().equals(valueUpper)) {
            this.cachePolicyModelSecurity = CachePolicyModelSecurity.USERCLASS;
            return;
        }
        if (valueUpper.equals(THREE) || CachePolicyModelSecurity.NONE.toString().equals(valueUpper)) {
            this.cachePolicyModelSecurity = CachePolicyModelSecurity.NONE;
            return;
        }
        this.cachePolicyModelSecurity = CachePolicyModelSecurity.AUTOMATIC;
    }

    public CachePolicyDBAccess getCachePolicyDBAccess() {
        return this.cachePolicyDBAccess;
    }

    public void setCachePolicyDBAccess(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(ZERO) || CachePolicyDBAccess.DB_CONNECTION_SIGNON.toString().equals(valueUpper)) {
            this.cachePolicyDBAccess = CachePolicyDBAccess.DB_CONNECTION_SIGNON;
            return;
        }
        if (valueUpper.equals(ONE) || CachePolicyDBAccess.DB_CONNECTION.toString().equals(valueUpper)) {
            this.cachePolicyDBAccess = CachePolicyDBAccess.DB_CONNECTION;
            return;
        }
        if (valueUpper.equals(TWO) || CachePolicyDBAccess.DB.toString().equals(valueUpper)) {
            this.cachePolicyDBAccess = CachePolicyDBAccess.DB;
            return;
        }
        if (valueUpper.equals(THREE) || CachePolicyDBAccess.NONE.toString().equals(valueUpper)) {
            this.cachePolicyDBAccess = CachePolicyDBAccess.NONE;
            return;
        }
        this.cachePolicyDBAccess = CachePolicyDBAccess.DB_CONNECTION_SIGNON;
    }

    public void setLocalCachePolicy(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(ZERO) || LocalCachePolicy.LOWEST_SUMMARY_SUBQUERY.toString().equals(valueUpper)) {
            this.localCachePolicy = LocalCachePolicy.LOWEST_SUMMARY_SUBQUERY;
            return;
        }
        if (valueUpper.equals(ONE) || LocalCachePolicy.QUERY_REFERENCED_BY_LAYOUT.toString().equals(valueUpper)) {
            this.localCachePolicy = LocalCachePolicy.QUERY_REFERENCED_BY_LAYOUT;
            return;
        }
        if (valueUpper.equals(TWO) || LocalCachePolicy.EXPLICITLY_PER_QUERY.toString().equals(valueUpper)) {
            this.localCachePolicy = LocalCachePolicy.EXPLICITLY_PER_QUERY;
            return;
        }
        this.localCachePolicy = LocalCachePolicy.LOWEST_SUMMARY_SUBQUERY;
    }

    public void setMasterDetailOptimization(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(ZERO)) {
            this.masterDetailOptimization = MasterDetailOptimization.DISABLED;
            return;
        }
        if (valueUpper.equals(ONE)) {
            this.masterDetailOptimization = MasterDetailOptimization.CACHE_RELATIONAL_DETAIL_QUERY;
            return;
        }
        this.masterDetailOptimization = MasterDetailOptimization.DISABLED;
    }

    public boolean getCachePolicyConnectionCommandBlocks() {
        if (this.cachePolicyConnectionCommandBlocks == null) {
            return true;
        }
        boolean bVal = this.cachePolicyConnectionCommandBlocks;
        return bVal;
    }

    public void setCachePolicyConnectionCommandBlocks(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(FALSE) || valueUpper.equals(DISABLED) || valueUpper.equals(ZERO) || valueUpper.equals(OFF)) {
            this.cachePolicyConnectionCommandBlocks = Boolean.FALSE;
            return;
        }
        this.cachePolicyConnectionCommandBlocks = Boolean.TRUE;
    }

    public boolean getStrictGroupBy() {
        return this.strictGroupBy;
    }

    public void setStrictGroupBy(String value) {
        this.strictGroupBy = value.toUpperCase().equals(TRUE) ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean getReportAsDatasource() {
        return this.reportAsDatasource;
    }

    public void setReportAsDatasource(String value) {
        this.reportAsDatasource = value.toUpperCase().equals(TRUE) ? Boolean.TRUE : Boolean.FALSE;
    }

    public ContextSensitiveJoinSelection getContextSensitiveJoinSelection() {
        return this.contextSensitiveJoinSelection;
    }

    public void setContextSensitiveJoinSelection(String value) {
        String valueUpper = value.toUpperCase();
        if (ContextSensitiveJoinSelection.DISABLED.toString().equals(valueUpper)) {
            this.contextSensitiveJoinSelection = ContextSensitiveJoinSelection.DISABLED;
            return;
        }
        if (ContextSensitiveJoinSelection.AUTOMATIC.toString().equals(valueUpper)) {
            this.contextSensitiveJoinSelection = ContextSensitiveJoinSelection.AUTOMATIC;
            return;
        }
        if (ContextSensitiveJoinSelection.EXPLICIT.toString().equals(valueUpper)) {
            this.contextSensitiveJoinSelection = ContextSensitiveJoinSelection.EXPLICIT;
            return;
        }
        this.contextSensitiveJoinSelection = ContextSensitiveJoinSelection.DISABLED;
    }

    public DMREmptyMUNTreatment getTreatEmptyDMRMUN() {
        return this.treatEmptyDMRMUN;
    }

    public void setTreatEmptyDMRMUN(String value) {
        if (DMREmptyMUNTreatment.ASNULL.toString().equalsIgnoreCase(value)) {
            this.treatEmptyDMRMUN = DMREmptyMUNTreatment.ASNULL;
            return;
        }
        if (DMREmptyMUNTreatment.EMPTY_OR_NULL.toString().equalsIgnoreCase(value)) {
            this.treatEmptyDMRMUN = DMREmptyMUNTreatment.EMPTY_OR_NULL;
            return;
        }
        if (DMREmptyMUNTreatment.EMPTY_TO_NULL.toString().equalsIgnoreCase(value)) {
            this.treatEmptyDMRMUN = DMREmptyMUNTreatment.EMPTY_TO_NULL;
            return;
        }
        if (DMREmptyMUNTreatment.ASEMPTY.toString().equalsIgnoreCase(value)) {
            this.treatEmptyDMRMUN = DMREmptyMUNTreatment.ASEMPTY;
            return;
        }
        this.treatEmptyDMRMUN = DMREmptyMUNTreatment.ASNULL;
    }

    public double getEnablePushdownLevelOOM() {
        return this.enablePushdownLevelOOM;
    }

    public void setEnablePushdownLevelOOM(String value) {
        try {
            int n = Integer.parseUnsignedInt(value);
            if (n > 0) {
                this.enablePushdownLevelOOM = Math.log10(n);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public NestedAggregateHandling getNestedAggregateHandling() {
        if (NestedAggregateHandling.SERVERDETERMINED.equals((Object)this.nestedAggregateHandling)) {
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            String cfgRemoveRedundantAggs = config.getStringProperty("general.removeRedundantAggs[@value]", PROP_OFF);
            this.nestedAggregateHandling = cfgRemoveRedundantAggs.equals(PROP_ON) ? NestedAggregateHandling.REMOVE : NestedAggregateHandling.SETREPORTSCOPE;
        }
        return this.nestedAggregateHandling;
    }

    public DataItemLabelBehaviour getDataItemLabelBehaviour() {
        if (DataItemLabelBehaviour.SERVERDETERMINED.equals((Object)this.dataItemLabelBehaviour)) {
            XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            String cfgDataItemLabelBehaviour = config.getStringProperty("general.useModelLabelsForIndirectModelRefs[@value]", PROP_OFF);
            this.dataItemLabelBehaviour = cfgDataItemLabelBehaviour.equals(PROP_ON) ? DataItemLabelBehaviour.DIRECT_AND_INDIRECT_MODELREFS : DataItemLabelBehaviour.DIRECT_MODELREFS_ONLY;
        }
        return this.dataItemLabelBehaviour;
    }

    public void setDataItemLabelBehaviour(String value) {
        String valueUpper = value.toUpperCase();
        if (DataItemLabelBehaviour.SERVERDETERMINED.toString().equals(valueUpper)) {
            this.dataItemLabelBehaviour = DataItemLabelBehaviour.SERVERDETERMINED;
            return;
        }
        if (DataItemLabelBehaviour.DIRECT_MODELREFS_ONLY.toString().equals(valueUpper)) {
            this.dataItemLabelBehaviour = DataItemLabelBehaviour.DIRECT_MODELREFS_ONLY;
            return;
        }
        if (DataItemLabelBehaviour.DIRECT_AND_INDIRECT_MODELREFS.toString().equals(valueUpper)) {
            this.dataItemLabelBehaviour = DataItemLabelBehaviour.DIRECT_AND_INDIRECT_MODELREFS;
            return;
        }
        this.dataItemLabelBehaviour = DataItemLabelBehaviour.SERVERDETERMINED;
    }

    public void setNestedAggregateHandling(String value) {
        String valueUpper = value.toUpperCase();
        if (NestedAggregateHandling.SERVERDETERMINED.toString().equals(valueUpper)) {
            this.nestedAggregateHandling = NestedAggregateHandling.SERVERDETERMINED;
            return;
        }
        if (NestedAggregateHandling.REMOVE.toString().equals(valueUpper)) {
            this.nestedAggregateHandling = NestedAggregateHandling.REMOVE;
            return;
        }
        if (NestedAggregateHandling.SETREPORTSCOPE.toString().equals(valueUpper)) {
            this.nestedAggregateHandling = NestedAggregateHandling.SETREPORTSCOPE;
            return;
        }
        this.nestedAggregateHandling = NestedAggregateHandling.SERVERDETERMINED;
    }

    public String dumpToXML() {
        StringWriter stringWriter = new StringWriter();
        XMLWriter writer = new XMLWriter();
        writer.addStream(stringWriter);
        writer.setIndentString("  ");
        writer.beginElement(STRING_GOVERNORS, -1);
        this.dumpAllGovernors(writer);
        writer.endElement();
        return stringWriter.toString();
    }

    private void dumpAllGovernors(XMLWriter writer) {
        this.dumpGovernor(writer, AllGovernors.AUTOSORT.getKey(), (Object)this.autoSort);
        this.dumpGovernor(writer, AllGovernors.AVOID_ZERODIV.getKey(), this.avoidDivByZero);
        this.dumpGovernor(writer, AllGovernors.CATBYMEASUREDIMQI.getKey(), (Object)this.catByMeasureDimQi);
        this.dumpGovernor(writer, AllGovernors.CROSS_PRODUCT_ALLOWED.getKey(), (Object)this.crossProdAllowed);
        this.dumpGovernor(writer, AllGovernors.DESIGN_MODE.getKey(), this.designMode);
        this.dumpGovernor(writer, AllGovernors.DATASET_MODE.getKey(), this.datasetMode);
        this.dumpGovernor(writer, AllGovernors.DYNAMICDIMINFO.getKey(), this.dynamicDimInfo);
        this.dumpGovernor(writer, AllGovernors.EXECUTION_METHOD.getKey(), (Object)this.executionMethod);
        this.dumpGovernor(writer, AllGovernors.EXECUTION_OPTIMIZATION.getKey(), (Object)this.executionOptimization);
        this.dumpGovernor(writer, AllGovernors.LOCAL_CACHE.getKey(), this.localCache);
        this.dumpGovernor(writer, AllGovernors.MAX_QUERY_EXECUTION_TIME.getKey(), XQEIntegerPool.getInteger(this.maxQueryExecTime));
        this.dumpGovernor(writer, AllGovernors.MAX_ROWS_RETRIEVED.getKey(), XQEIntegerPool.getInteger(this.maxRowsRetrieved));
        this.dumpGovernor(writer, AllGovernors.MAX_TABLES_PER_QUERY.getKey(), XQEIntegerPool.getInteger(this.maxTablesPerQuery));
        this.dumpGovernor(writer, AllGovernors.MAX_TEXT_BLOB_CHARACTERS.getKey(), XQEIntegerPool.getInteger(this.maxTextBlobChars));
        this.dumpGovernor(writer, AllGovernors.MAX_TABLE_NAME_LENGTH.getKey(), XQEIntegerPool.getInteger(this.maxTableNameLength));
        this.dumpGovernor(writer, AllGovernors.MEASURE_REFINER.getKey(), (Object)this.measureRefiner);
        this.dumpGovernor(writer, AllGovernors.NO_DATA_MODE.getKey(), this.noDataMode);
        this.dumpGovernor(writer, AllGovernors.OUTERJOIN_ALLOWED.getKey(), (Object)this.outerJoinAllowed);
        this.dumpGovernor(writer, AllGovernors.PROCESSALLMODEL.getKey(), this.processAllModel);
        this.dumpGovernor(writer, AllGovernors.QUERY_INTENT.getKey(), this.queryIntent);
        this.dumpGovernor(writer, AllGovernors.QUERY_PROCESSING.getKey(), (Object)this.queryProcessing);
        this.dumpGovernor(writer, AllGovernors.REPORT_MEASURE.getKey(), this.reportMeasure);
        this.dumpGovernor(writer, AllGovernors.ROLLUP_PROCESSING.getKey(), (Object)this.rollupProcessing);
        this.dumpGovernor(writer, AllGovernors.SHORTCUTPROCESSING.getKey(), (Object)this.shortcutProcessing);
        this.dumpGovernor(writer, AllGovernors.SQLGENERATIONDETATTR.getKey(), (Object)this.sqlGenerationDetAttr);
        this.dumpGovernor(writer, AllGovernors.SQLGENERATIONLEVATTR.getKey(), (Object)this.sqlGenerationLevAttr);
        this.dumpGovernor(writer, AllGovernors.SQLJOINSYNTAX.getKey(), (Object)this.sqlJoinSyntax);
        this.dumpGovernor(writer, AllGovernors.SUPPRESS.getKey(), (Object)this.suppress);
        this.dumpGovernor(writer, AllGovernors.USE_FOR_PARAMETER_INFO.getKey(), this.useForParameterInfo);
        this.dumpGovernor(writer, AllGovernors.USE_METADATA_CALLBACK.getKey(), this.mdCallback);
        this.dumpGovernor(writer, AllGovernors.USE_SQL_PARAMETERS.getKey(), (Object)this.useSQLParameters);
        this.dumpGovernor(writer, AllGovernors.SUPPRESS_DUPLICATE_MEASURE_VALUES.getKey(), (Object)this.suppressDuplicateMeasureValues);
        this.dumpGovernor(writer, AllGovernors.USE_SQL_WITH_CLAUSE.getKey(), this.sqlWithClause);
        this.dumpGovernor(writer, AllGovernors.USE_V4_INTERPRETATION.getKey(), this.useV4Interpretation);
        this.dumpGovernor(writer, AllGovernors.USE_SAP_MUN_AS_BUSINESS_KEY.getKey(), this.useSAPMUNAsBusinessKey);
        this.dumpGovernor(writer, AllGovernors.USE_AGGREGATE_CACHE.getKey(), this.useAggregateCache);
        this.dumpGovernor(writer, AllGovernors.EXACT_NUMERIC_DIVISION.getKey(), (Object)this.exactNumericDivision);
        this.dumpGovernor(writer, AllGovernors.GROUPBY_OPTIMIZATION.getKey(), (Object)this.groupByOptimization);
        this.dumpGovernor(writer, AllGovernors.CACHE_POLICY_MODEL_SECURITY.getKey(), (Object)this.cachePolicyModelSecurity);
        this.dumpGovernor(writer, AllGovernors.CACHE_POLICY_DB_ACCESS.getKey(), (Object)this.cachePolicyDBAccess);
        this.dumpGovernor(writer, AllGovernors.CACHE_POLICY_CONNECTION_COMMAND_BLOCKS.getKey(), this.cachePolicyConnectionCommandBlocks);
        this.dumpGovernor(writer, AllGovernors.CONTEXT_SENSITIVE_JOIN_SELECTION.getKey(), (Object)this.contextSensitiveJoinSelection);
        this.dumpGovernor(writer, AllGovernors.LOCAL_CACHE_POLICY.getKey(), (Object)this.localCachePolicy);
        this.dumpGovernor(writer, AllGovernors.MASTER_DETAIL_OPTIMIZATION.getKey(), (Object)this.masterDetailOptimization);
        this.dumpGovernor(writer, AllGovernors.CURSOR_MODE.getKey(), (Object)this.cursorMode);
        this.dumpGovernor(writer, AllGovernors.BURST_KEY_LIST.getKey(), this.burstKeyList);
        this.dumpGovernor(writer, AllGovernors.BURST_MASTER_QUERY_NAME.getKey(), this.burstMasterQueryName);
        this.dumpGovernor(writer, AllGovernors.REMOVE_AGGOP_WHEN_FLT_PAA_IS_FALSE.getKey(), this.removeAggregateOpWhenFltPAAIsFalse);
        this.dumpGovernor(writer, AllGovernors.REMOVE_AGGOP_WHEN_DI_AGG_IS_NONE.getKey(), this.removeAggregateOpWhenDataItemAggIsNone);
        this.dumpGovernor(writer, AllGovernors.ROW_STITCH_FOR_FACT_LESS_QUERY.getKey(), this.rowStitchForFactLessQuery);
        this.dumpGovernor(writer, AllGovernors.STITCH_WITH_NULLS.getKey(), this.stitchWithNulls);
        this.dumpGovernor(writer, AllGovernors.NATIVE_SQL_IN_CTE.getKey(), (Object)this.nativeSQLInCTE);
        this.dumpGovernor(writer, AllGovernors.SUPPRESS_MESSAGES.getKey(), this.suppressMessages);
        this.dumpGovernor(writer, AllGovernors.REPORT_AS_DATASOURCE.getKey(), this.reportAsDatasource);
        this.dumpGovernor(writer, AllGovernors.FORMAT_QUERYITEMS_FOR_PARAMETER_MAPS.getKey(), (Object)this.formatQueryItemsForParameterMaps);
        if (Double.compare(this.maxOrderOfMagnitudeMDXResult, 0.0) > 0) {
            this.dumpGovernor(writer, AllGovernors.MAX_OOM_MDX_RESULT.getKey(), this.maxOrderOfMagnitudeMDXResult);
        }
        if (this.sqlWindowFunctionGeneration != SQLWindowFunctionGeneration.PARTITION_BY) {
            this.dumpGovernor(writer, AllGovernors.SQLWINDOWFUNCTION_GENERATION.getKey(), (Object)this.sqlWindowFunctionGeneration);
        }
        if (this.summaryQueryJoinOperator != JoinOperator.IS_NOT_DISTINCT_FROM) {
            this.dumpGovernor(writer, AllGovernors.SUMMARYQUERY_JOIN_OPERATOR.getKey(), (Object)this.summaryQueryJoinOperator);
        }
        if (this.multiFactJoinOperator != JoinOperator.IS_NOT_DISTINCT_FROM) {
            this.dumpGovernor(writer, AllGovernors.MULTIFACT_JOIN_OPERATOR.getKey(), (Object)this.multiFactJoinOperator);
        }
        if (this.tableSamplingTable.length() > 0 || this.tableSamplingMethod != null && this.tableSamplingMethod.length() > 0) {
            if (this.tableSamplingTable.length() > 0) {
                this.dumpGovernor(writer, AllGovernors.TABLE_SAMPLING_TABLE.getKey(), this.tableSamplingTable);
            }
            this.dumpGovernor(writer, AllGovernors.TABLE_SAMPLING_METHOD.getKey(), this.tableSamplingMethod);
            this.dumpGovernor(writer, AllGovernors.TABLE_SAMPLING_PERCENT.getKey(), this.tableSamplingPercent);
            this.dumpGovernor(writer, AllGovernors.TABLE_SAMPLING_SEED.getKey(), this.tableSamplingSeed);
        }
        if (this.isStatsQuery) {
            this.dumpGovernor(writer, AllGovernors.IS_STATS_QUERY.getKey(), this.isStatsQuery);
        }
        if (!this.datasetModuleType.isEmpty()) {
            this.dumpGovernor(writer, AllGovernors.DATASET_MODULE_TYPE.getKey(), this.datasetModuleType);
        }
        if (this.ignoreFiltersNotApplicable != Boolean.FALSE) {
            this.dumpGovernor(writer, AllGovernors.IGNORE_FILTERS_NOT_APPLICABLE.getKey(), this.ignoreFiltersNotApplicable);
        }
        if (this.treatEmptyDMRMUN != DMREmptyMUNTreatment.ASNULL) {
            this.dumpGovernor(writer, AllGovernors.TREAT_EMPTY_DMR_MUN.getKey(), (Object)this.treatEmptyDMRMUN);
        }
        if (this.enablePushdownLevelOOM > 0.0) {
            this.dumpGovernor(writer, AllGovernors.ENABLE_PUSHDOWN_LEVEL_LARGER_THAN.getKey(), this.enablePushdownLevelOOM);
        }
        this.dumpGovernor(writer, AllGovernors.DATA_CACHE_EXPIRY.getKey(), this.dataCacheExpiry);
        this.dumpGovernor(writer, AllGovernors.DATA_CACHE_USE_POLICY.getKey(), (Object)this.dataCacheUsePolicy);
        this.dumpGovernor(writer, AllGovernors.DASHBOARD_CONTEXT.getKey(), this.dashboardContext);
        this.dumpGovernor(writer, AllGovernors.NESTED_AGGREGATE_HANDLING.getKey(), (Object)this.nestedAggregateHandling);
        this.dumpGovernor(writer, AllGovernors.DATAITEM_LABEL_BEHAVIOUR.getKey(), (Object)this.dataItemLabelBehaviour);
        if (this.treatRelXTabExtAggrAsListFooter != Boolean.TRUE) {
            this.dumpGovernor(writer, AllGovernors.TREAT_RELATIONAL_XTAB_EXT_AGGR_AS_LIST_FOOTER.getKey(), this.treatRelXTabExtAggrAsListFooter);
        }
        if (this.fjoMaxKeys != null) {
            this.dumpGovernor(writer, AllGovernors.FJO_MAX_KEYS.getKey(), this.fjoMaxKeys);
        }
        if (this.interactive == Boolean.TRUE) {
            this.dumpGovernor(writer, AllGovernors.INTERACTIVE.getKey(), this.interactive);
        }
        if (this.generateSubqueryForCalcs != null) {
            this.dumpGovernor(writer, AllGovernors.GENERATE_SUBQUERY_FOR_CALCS.getKey(), this.generateSubqueryForCalcs);
        }
        if (this.processNullConsumersAfterJoin != null) {
            this.dumpGovernor(writer, AllGovernors.PROCESS_NULL_CONSUMERS_AFTER_JOIN.getKey(), this.processNullConsumersAfterJoin);
        }
        if (this.useVectorizedQueryExecution != null) {
            this.dumpGovernor(writer, AllGovernors.USE_VECTORIZED_QUERY_EXECUTION.getKey(), this.useVectorizedQueryExecution);
        }
    }

    private void dumpGovernor(XMLWriter writer, String governorKey, Object governorValue) {
        String strValue;
        if (governorValue != null && (strValue = governorValue.toString()) != null && !strValue.equals("")) {
            writer.beginElement(governorKey, -1);
            writer.attribute(VALUE, strValue);
            writer.endElement();
        }
    }

    public String toString() {
        StringBuilder governors = new StringBuilder(STRING_GOVERNORS);
        governors.append(OPEN_PARENTHESIS);
        this.governorToString(governors, AllGovernors.AUTOSORT.getKey(), (Object)this.autoSort);
        this.governorToString(governors, AllGovernors.AVOID_ZERODIV.getKey(), this.avoidDivByZero);
        this.governorToString(governors, AllGovernors.CATBYMEASUREDIMQI.getKey(), (Object)this.catByMeasureDimQi);
        this.governorToString(governors, AllGovernors.CROSS_PRODUCT_ALLOWED.getKey(), (Object)this.crossProdAllowed);
        this.governorToString(governors, AllGovernors.DESIGN_MODE.getKey(), this.designMode);
        this.governorToString(governors, AllGovernors.DATASET_MODE.getKey(), this.datasetMode);
        this.governorToString(governors, AllGovernors.DYNAMICDIMINFO.getKey(), this.dynamicDimInfo);
        this.governorToString(governors, AllGovernors.EXECUTION_METHOD.getKey(), (Object)this.executionMethod);
        this.governorToString(governors, AllGovernors.EXECUTION_OPTIMIZATION.getKey(), (Object)this.executionOptimization);
        this.governorToString(governors, AllGovernors.LOCAL_CACHE.getKey(), this.localCache);
        this.governorToString(governors, AllGovernors.SUPPRESS_DUPLICATE_MEASURE_VALUES.getKey(), (Object)this.suppressDuplicateMeasureValues);
        this.governorToString(governors, AllGovernors.MAX_QUERY_EXECUTION_TIME.getKey(), XQEIntegerPool.getInteger(this.maxQueryExecTime));
        this.governorToString(governors, AllGovernors.MAX_ROWS_RETRIEVED.getKey(), XQEIntegerPool.getInteger(this.maxRowsRetrieved));
        this.governorToString(governors, AllGovernors.MAX_TABLES_PER_QUERY.getKey(), XQEIntegerPool.getInteger(this.maxTablesPerQuery));
        this.governorToString(governors, AllGovernors.MAX_TEXT_BLOB_CHARACTERS.getKey(), XQEIntegerPool.getInteger(this.maxTextBlobChars));
        this.governorToString(governors, AllGovernors.MAX_TABLE_NAME_LENGTH.getKey(), XQEIntegerPool.getInteger(this.maxTableNameLength));
        this.governorToString(governors, AllGovernors.MEASURE_REFINER.getKey(), (Object)this.measureRefiner);
        this.governorToString(governors, AllGovernors.NO_DATA_MODE.getKey(), this.noDataMode);
        this.governorToString(governors, AllGovernors.OUTERJOIN_ALLOWED.getKey(), (Object)this.outerJoinAllowed);
        this.governorToString(governors, AllGovernors.PROCESSALLMODEL.getKey(), this.processAllModel);
        this.governorToString(governors, AllGovernors.QUERY_INTENT.getKey(), this.queryIntent);
        this.governorToString(governors, AllGovernors.QUERY_PROCESSING.getKey(), (Object)this.queryProcessing);
        this.governorToString(governors, AllGovernors.REPORT_MEASURE.getKey(), this.reportMeasure);
        this.governorToString(governors, AllGovernors.ROLLUP_PROCESSING.getKey(), (Object)this.rollupProcessing);
        this.governorToString(governors, AllGovernors.SHORTCUTPROCESSING.getKey(), (Object)this.shortcutProcessing);
        this.governorToString(governors, AllGovernors.SQLGENERATIONDETATTR.getKey(), (Object)this.sqlGenerationDetAttr);
        this.governorToString(governors, AllGovernors.SQLGENERATIONLEVATTR.getKey(), (Object)this.sqlGenerationLevAttr);
        this.governorToString(governors, AllGovernors.SQLJOINSYNTAX.getKey(), (Object)this.sqlJoinSyntax);
        this.governorToString(governors, AllGovernors.SUPPRESS.getKey(), (Object)this.suppress);
        this.governorToString(governors, AllGovernors.USE_FOR_PARAMETER_INFO.getKey(), this.useForParameterInfo);
        this.governorToString(governors, AllGovernors.USE_METADATA_CALLBACK.getKey(), this.mdCallback);
        this.governorToString(governors, AllGovernors.USE_SQL_PARAMETERS.getKey(), (Object)this.useSQLParameters);
        this.governorToString(governors, AllGovernors.SUPPRESS_DUPLICATE_MEASURE_VALUES.getKey(), (Object)this.suppressDuplicateMeasureValues);
        this.governorToString(governors, AllGovernors.USE_SQL_WITH_CLAUSE.getKey(), this.sqlWithClause);
        this.governorToString(governors, AllGovernors.USE_V4_INTERPRETATION.getKey(), this.useV4Interpretation);
        this.governorToString(governors, AllGovernors.USE_SAP_MUN_AS_BUSINESS_KEY.getKey(), this.useSAPMUNAsBusinessKey);
        this.governorToString(governors, AllGovernors.USE_AGGREGATE_CACHE.getKey(), this.useAggregateCache);
        this.governorToString(governors, AllGovernors.EXACT_NUMERIC_DIVISION.getKey(), (Object)this.exactNumericDivision);
        this.governorToString(governors, AllGovernors.GROUPBY_OPTIMIZATION.getKey(), (Object)this.groupByOptimization);
        this.governorToString(governors, AllGovernors.CACHE_POLICY_MODEL_SECURITY.getKey(), (Object)this.cachePolicyModelSecurity);
        this.governorToString(governors, AllGovernors.CACHE_POLICY_DB_ACCESS.getKey(), (Object)this.cachePolicyDBAccess);
        this.governorToString(governors, AllGovernors.CACHE_POLICY_CONNECTION_COMMAND_BLOCKS.getKey(), this.cachePolicyConnectionCommandBlocks);
        this.governorToString(governors, AllGovernors.NATIVE_SQL_IN_CTE.getKey(), (Object)this.nativeSQLInCTE);
        this.governorToString(governors, AllGovernors.SUPPRESS_MESSAGES.getKey(), this.suppressMessages);
        if (Double.compare(this.maxOrderOfMagnitudeMDXResult, 0.0) > 0) {
            this.governorToString(governors, AllGovernors.MAX_OOM_MDX_RESULT.getKey(), this.maxOrderOfMagnitudeMDXResult);
        }
        if (this.sqlWindowFunctionGeneration != SQLWindowFunctionGeneration.PARTITION_BY) {
            this.governorToString(governors, AllGovernors.SQLWINDOWFUNCTION_GENERATION.getKey(), (Object)this.sqlWindowFunctionGeneration);
        }
        if (this.summaryQueryJoinOperator != JoinOperator.IS_NOT_DISTINCT_FROM) {
            this.governorToString(governors, AllGovernors.SUMMARYQUERY_JOIN_OPERATOR.getKey(), (Object)this.summaryQueryJoinOperator);
        }
        if (this.multiFactJoinOperator != JoinOperator.IS_NOT_DISTINCT_FROM) {
            this.governorToString(governors, AllGovernors.MULTIFACT_JOIN_OPERATOR.getKey(), (Object)this.multiFactJoinOperator);
        }
        if (this.tableSamplingTable.length() > 0) {
            this.governorToString(governors, AllGovernors.TABLE_SAMPLING_TABLE.getKey(), this.tableSamplingTable);
            this.governorToString(governors, AllGovernors.TABLE_SAMPLING_METHOD.getKey(), this.tableSamplingMethod);
            this.governorToString(governors, AllGovernors.TABLE_SAMPLING_PERCENT.getKey(), this.tableSamplingPercent);
            this.governorToString(governors, AllGovernors.TABLE_SAMPLING_SEED.getKey(), this.tableSamplingSeed);
        }
        if (this.isStatsQuery) {
            this.governorToString(governors, AllGovernors.IS_STATS_QUERY.getKey(), this.isStatsQuery);
        }
        if (!this.datasetModuleType.isEmpty()) {
            this.governorToString(governors, AllGovernors.DATASET_MODULE_TYPE.getKey(), this.datasetModuleType);
        }
        if (this.ignoreFiltersNotApplicable != Boolean.FALSE) {
            this.governorToString(governors, AllGovernors.IGNORE_FILTERS_NOT_APPLICABLE.getKey(), this.ignoreFiltersNotApplicable);
        }
        if (this.treatEmptyDMRMUN != DMREmptyMUNTreatment.ASNULL) {
            this.governorToString(governors, AllGovernors.TREAT_EMPTY_DMR_MUN.getKey(), (Object)this.treatEmptyDMRMUN);
        }
        if (this.enablePushdownLevelOOM > 0.0) {
            this.governorToString(governors, AllGovernors.ENABLE_PUSHDOWN_LEVEL_LARGER_THAN.getKey(), this.enablePushdownLevelOOM);
        }
        if (this.treatRelXTabExtAggrAsListFooter != Boolean.TRUE) {
            this.governorToString(governors, AllGovernors.TREAT_RELATIONAL_XTAB_EXT_AGGR_AS_LIST_FOOTER.getKey(), this.treatRelXTabExtAggrAsListFooter);
        }
        if (this.fjoMaxKeys != null) {
            this.governorToString(governors, AllGovernors.FJO_MAX_KEYS.getKey(), this.fjoMaxKeys);
        }
        if (this.interactive == Boolean.TRUE) {
            this.governorToString(governors, AllGovernors.INTERACTIVE.getKey(), this.interactive);
        }
        if (this.generateSubqueryForCalcs != null) {
            this.governorToString(governors, AllGovernors.GENERATE_SUBQUERY_FOR_CALCS.getKey(), this.generateSubqueryForCalcs);
        }
        if (this.processNullConsumersAfterJoin != null) {
            this.governorToString(governors, AllGovernors.PROCESS_NULL_CONSUMERS_AFTER_JOIN.getKey(), this.processNullConsumersAfterJoin);
        }
        if (this.useVectorizedQueryExecution != null) {
            this.governorToString(governors, AllGovernors.USE_VECTORIZED_QUERY_EXECUTION.getKey(), this.useVectorizedQueryExecution);
        }
        governors.append(CLOSE_PARENTHESIS);
        return governors.toString();
    }

    private void governorToString(StringBuilder strBuff, String governorKey, Object governorValue) {
        String strValue;
        if (governorValue != null && (strValue = governorValue.toString()) != null && !strValue.equals("")) {
            if (!strBuff.toString().equals("Governors(")) {
                strBuff.append(STRING_COMMA);
            }
            strBuff.append(governorKey);
            strBuff.append(STRING_COLON);
            strBuff.append(strValue);
        }
    }

    public CursorMode getCursorMode() {
        return this.cursorMode;
    }

    public String getBurstKeyList() {
        return this.burstKeyList;
    }

    private void setBurstKeyList(String keyList) {
        this.burstKeyList = keyList;
    }

    public String getBurstMasterQueryName() {
        return this.burstMasterQueryName;
    }

    public void setBurstMasterQueryName(String queryName) {
        this.burstMasterQueryName = queryName;
    }

    public void setNativeSQLInCTE(String value) {
        String upperValue = value.toUpperCase();
        if (NativeSQLInCTE.AUTOMATIC.toString().equals(upperValue)) {
            this.nativeSQLInCTE = NativeSQLInCTE.AUTOMATIC;
        } else if (NativeSQLInCTE.KEEP.toString().equals(upperValue)) {
            this.nativeSQLInCTE = NativeSQLInCTE.KEEP;
        } else if (NativeSQLInCTE.DT.toString().equals(upperValue)) {
            this.nativeSQLInCTE = NativeSQLInCTE.DT;
        } else if (NativeSQLInCTE.PT.toString().equals(upperValue)) {
            this.nativeSQLInCTE = NativeSQLInCTE.PT;
        }
    }

    public NativeSQLInCTE getNativeSQLInCTE() {
        return this.nativeSQLInCTE;
    }

    public void setSuppressMessages(String value) {
        this.suppressMessages = value.split(";;");
    }

    public String[] getSuppressMessages() {
        return this.suppressMessages;
    }

    public void setMaxOrderOfMagnitudeMDXResult(String value) {
        if (value != null) {
            try {
                this.maxOrderOfMagnitudeMDXResult = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public double getMaxOrderOfMagnitudeMDXResult() {
        return this.maxOrderOfMagnitudeMDXResult;
    }

    public void setSQLWindowFunctionGeneration(String value) {
        if (value.equals(ZERO) || value.equals(SQLWindowFunctionGeneration.PARTITION_BY.toString())) {
            this.sqlWindowFunctionGeneration = SQLWindowFunctionGeneration.PARTITION_BY;
        } else if (value.equals(ONE) || value.equals(SQLWindowFunctionGeneration.GROUPBY.toString())) {
            this.sqlWindowFunctionGeneration = SQLWindowFunctionGeneration.GROUPBY;
        }
    }

    public SQLWindowFunctionGeneration getWindowFunctionGeneration() {
        return this.sqlWindowFunctionGeneration;
    }

    public void setSummaryQueryJoinOperator(String value) {
        if (value.equals(ZERO) || value.equals(JoinOperator.IS_NOT_DISTINCT_FROM.toString())) {
            this.summaryQueryJoinOperator = JoinOperator.IS_NOT_DISTINCT_FROM;
        } else if (value.equals(ONE) || value.equals(JoinOperator.EQUAL.toString())) {
            this.summaryQueryJoinOperator = JoinOperator.EQUAL;
        } else if (value.equals(TWO) || value.equals(JoinOperator.EQUAL_ALL_NOTNULL.toString())) {
            this.summaryQueryJoinOperator = JoinOperator.EQUAL_ALL_NOTNULL;
        }
    }

    public JoinOperator getSummaryQueryJoinOperator() {
        return this.summaryQueryJoinOperator;
    }

    public void setMultiFactJoinOperator(String value) {
        if (value.equals(ZERO) || value.equals(JoinOperator.IS_NOT_DISTINCT_FROM.toString())) {
            this.multiFactJoinOperator = JoinOperator.IS_NOT_DISTINCT_FROM;
        } else if (value.equals(ONE) || value.equals(JoinOperator.EQUAL.toString())) {
            this.multiFactJoinOperator = JoinOperator.EQUAL;
        } else if (value.equals(TWO) || value.equals(JoinOperator.EQUAL_ALL_NOTNULL.toString())) {
            this.multiFactJoinOperator = JoinOperator.EQUAL_ALL_NOTNULL;
        }
    }

    public JoinOperator getMultiFactJoinOperator() {
        return this.multiFactJoinOperator;
    }

    public void setDMRMembersUseRelationalCache(String value) {
        if (value.equalsIgnoreCase(DMRUseRelationalCache.NEVER.toString())) {
            this.dmrMembersUseRelationalCache = DMRUseRelationalCache.NEVER;
            return;
        }
        if (value.equalsIgnoreCase(DMRUseRelationalCache.ALWAYS.toString())) {
            this.dmrMembersUseRelationalCache = DMRUseRelationalCache.ALWAYS;
            return;
        }
        if (value.equalsIgnoreCase(DMRUseRelationalCache.CUBE_REUSE_DISABLED.getValue().toString())) {
            this.dmrMembersUseRelationalCache = DMRUseRelationalCache.CUBE_REUSE_DISABLED;
            return;
        }
        this.dmrMembersUseRelationalCache = DMRUseRelationalCache.NEVER;
    }

    public DMRUseRelationalCache getDMRMembersUseRelationalCache() {
        return this.dmrMembersUseRelationalCache;
    }

    public void setDMRCellsUseRelationalCache(String value) {
        if (value.equalsIgnoreCase(DMRUseRelationalCache.NEVER.toString())) {
            this.dmrCellsUseRelationalCache = DMRUseRelationalCache.NEVER;
            return;
        }
        if (value.equalsIgnoreCase(DMRUseRelationalCache.ALWAYS.toString())) {
            this.dmrCellsUseRelationalCache = DMRUseRelationalCache.ALWAYS;
            return;
        }
        if (value.equalsIgnoreCase(DMRUseRelationalCache.CUBE_REUSE_DISABLED.getValue().toString())) {
            this.dmrCellsUseRelationalCache = DMRUseRelationalCache.CUBE_REUSE_DISABLED;
            return;
        }
        this.dmrCellsUseRelationalCache = DMRUseRelationalCache.NEVER;
    }

    public DMRUseRelationalCache getDMRCellsUseRelationalCache() {
        return this.dmrCellsUseRelationalCache;
    }

    public void setFJOUseRelationalCache(String value) {
        if (value.equalsIgnoreCase(FJOUseRelationalCache.NEVER.toString())) {
            this.fjoUseRelationalCache = FJOUseRelationalCache.NEVER;
            return;
        }
        if (value.equalsIgnoreCase(FJOUseRelationalCache.ALWAYS.toString())) {
            this.fjoUseRelationalCache = FJOUseRelationalCache.ALWAYS;
            return;
        }
        if (value.equalsIgnoreCase(FJOUseRelationalCache.USE_LOCAL_CACHE.getValue().toString())) {
            this.fjoUseRelationalCache = FJOUseRelationalCache.USE_LOCAL_CACHE;
        }
        this.fjoUseRelationalCache = FJOUseRelationalCache.NEVER;
    }

    public FJOUseRelationalCache getFJOUseRelationalCache() {
        return this.fjoUseRelationalCache;
    }

    public void setDMRPreloadCellsExecutionMode(String value) {
        if (value.equalsIgnoreCase(DMRPreloadCellsExecutionMode.SERIALLY.toString())) {
            this.dmrPreloadCellsExecutionMode = DMRPreloadCellsExecutionMode.SERIALLY;
            return;
        }
        if (value.equalsIgnoreCase(DMRPreloadCellsExecutionMode.CONCURRENTLY.toString())) {
            this.dmrPreloadCellsExecutionMode = DMRPreloadCellsExecutionMode.CONCURRENTLY;
            return;
        }
        this.dmrPreloadCellsExecutionMode = DMRPreloadCellsExecutionMode.SERIALLY;
    }

    public DMRPreloadCellsExecutionMode getDMRPreloadCellsExecutionMode() {
        return this.dmrPreloadCellsExecutionMode;
    }

    public void setConstantFolding(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(FALSE) || valueUpper.equals(DISABLED) || valueUpper.equals(ZERO)) {
            this.constantFolding = Boolean.FALSE;
            return;
        }
        this.constantFolding = Boolean.TRUE;
    }

    public Boolean getConstantFolding() {
        return this.constantFolding;
    }

    public Boolean getTreatRelXTabExtAggrAsListFooter() {
        return this.treatRelXTabExtAggrAsListFooter;
    }

    public void setTreatRelXTabExtAggrAsListFooter(String value) {
        String valueUpper = value.toUpperCase();
        if (valueUpper.equals(FALSE) || valueUpper.equals(DISABLED) || valueUpper.equals(ZERO)) {
            this.treatRelXTabExtAggrAsListFooter = Boolean.FALSE;
            return;
        }
        this.treatRelXTabExtAggrAsListFooter = Boolean.TRUE;
    }

    public Boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive() {
        this.interactive = Boolean.TRUE;
    }

    public static enum DataCacheUsePolicy {
        ONLY_FRESH_DATA("UseOnlyFreshData"),
        ONLY_CACHE_DATA_OR_THROW("UseOnlyCachedDataOrReturnError"),
        ONLY_CACHE_DATA_OR_EMPTY_RESULT("UseOnlyCachedDataOrReturnEmptyResult"),
        USE_IT("UseIt");

        private final String value;

        private DataCacheUsePolicy(String theValue) {
            this.value = theValue;
        }

        public String getValue() {
            return this.value;
        }
    }

    class DataCacheExpiry {
        private String rawValue = null;
        private ArrayList<String> moduleExpiries = null;
        private ArrayList<String> querySubjectExpiries = null;

        DataCacheExpiry() {
        }

        public void setValue(String theRawValue) {
            if (!Governors.AUTOMATIC.equalsIgnoreCase(theRawValue)) {
                this.rawValue = theRawValue;
            }
        }

        public void setQuerySubjectExpiries(ArrayList<String> theQuerySubjectExpiries) {
            this.querySubjectExpiries = theQuerySubjectExpiries;
        }

        public void setModuleExpiries(ArrayList<String> theModuleExpiries) {
            this.moduleExpiries = theModuleExpiries;
        }

        private int evaluateValue(IPlanningEnvironment planEnv, String theRawValue) {
            String valueToEvaluate = theRawValue;
            if (theRawValue != null && !theRawValue.isEmpty() && planEnv != null && MacroExpander.isMacro(theRawValue)) {
                MacroExpander expander = new MacroExpander();
                valueToEvaluate = expander.expand(null, planEnv, theRawValue);
            }
            if (Governors.PROP_OFF.equalsIgnoreCase(valueToEvaluate) || "none".equalsIgnoreCase(valueToEvaluate) || "no".equalsIgnoreCase(valueToEvaluate) || "not".equalsIgnoreCase(valueToEvaluate) || Governors.ZERO.equalsIgnoreCase(valueToEvaluate) || valueToEvaluate == null || valueToEvaluate.isEmpty()) {
                return 0;
            }
            if (Governors.AUTOMATIC.equalsIgnoreCase(valueToEvaluate)) {
                return this.evaluateValue(planEnv, this.rawValue);
            }
            try {
                Double d = Double.parseDouble(valueToEvaluate);
                return d.intValue();
            }
            catch (NumberFormatException e) {
                return 0;
            }
        }

        public int getEffectiveExpiry(IPlanningEnvironment planEnv) {
            if (this.rawValue != null) {
                return this.evaluateValue(planEnv, this.rawValue);
            }
            ArrayList<String> expiries = this.moduleExpiries;
            if (this.querySubjectExpiries != null && !this.querySubjectExpiries.isEmpty()) {
                expiries = this.querySubjectExpiries;
            }
            if (expiries == null || expiries.isEmpty()) {
                return 0;
            }
            int smallestValue = -1;
            for (String e : expiries) {
                int expiryValue = this.evaluateValue(planEnv, e);
                if (smallestValue != -1 && expiryValue >= smallestValue) continue;
                smallestValue = expiryValue;
            }
            return smallestValue;
        }

        public boolean isDataCacheExpiryEnabled() {
            return this.rawValue != null || this.moduleExpiries != null && !this.moduleExpiries.isEmpty();
        }
    }

    public static enum DMREmptyMUNTreatment {
        ASNULL("as_null"),
        EMPTY_OR_NULL("empty_or_null"),
        EMPTY_TO_NULL("empty_to_null"),
        ASEMPTY("as_empty");

        private final String value;

        private DMREmptyMUNTreatment(String theValue) {
            this.value = theValue;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum DMRPreloadCellsExecutionMode {
        SERIALLY("serially"),
        CONCURRENTLY("concurrently");

        private final String value;

        private DMRPreloadCellsExecutionMode(String theValue) {
            this.value = theValue;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum FJOUseRelationalCache {
        NEVER("NEVER"),
        ALWAYS("ALWAYS"),
        USE_LOCAL_CACHE("useLocalCache");

        private final String value;

        private FJOUseRelationalCache(String theValue) {
            this.value = theValue;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum DMRUseRelationalCache {
        NEVER("NEVER"),
        ALWAYS("ALWAYS"),
        CUBE_REUSE_DISABLED("cubeReuseDisabled");

        private final String value;

        private DMRUseRelationalCache(String theValue) {
            this.value = theValue;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum JoinOperator {
        IS_NOT_DISTINCT_FROM,
        EQUAL,
        EQUAL_ALL_NOTNULL;

    }

    public static enum SQLWindowFunctionGeneration {
        PARTITION_BY,
        GROUPBY;

    }

    public static enum NativeSQLInCTE {
        AUTOMATIC,
        KEEP,
        DT,
        PT;

    }

    public static enum CursorMode {
        CURSOR_MODE_AUTOMATIC("0"),
        CURSOR_MODE_QUERY_PER_PAGE("1"),
        CURSOR_MODE_READ_IN_BACKGROUND("2");

        private String fmCode;

        private CursorMode(String code) {
            this.fmCode = code;
        }
    }

    public static enum MasterDetailOptimization {
        DISABLED,
        CACHE_RELATIONAL_DETAIL_QUERY;

    }

    public static enum LocalCachePolicy {
        LOWEST_SUMMARY_SUBQUERY,
        QUERY_REFERENCED_BY_LAYOUT,
        EXPLICITLY_PER_QUERY;

    }

    public static enum ContextSensitiveJoinSelection {
        DISABLED,
        EXPLICIT,
        AUTOMATIC;

    }

    public static enum FormatQueryItemsForParameterMaps {
        ON,
        OFF;

    }

    public static enum DataItemLabelBehaviour {
        SERVERDETERMINED,
        DIRECT_MODELREFS_ONLY,
        DIRECT_AND_INDIRECT_MODELREFS;

    }

    public static enum NestedAggregateHandling {
        SERVERDETERMINED,
        REMOVE,
        SETREPORTSCOPE;

    }

    public static enum AggregateOverHigherLevelAggregate {
        WARN,
        DENY,
        IGNORE;

    }

    public static enum OptimizeMasterDetailForAllRows {
        ALWAYS,
        NEVER,
        DEFAULT;

    }

    public static enum CachePolicyDBAccess {
        DB_CONNECTION_SIGNON,
        DB_CONNECTION,
        DB,
        NONE;

    }

    public static enum CachePolicyModelSecurity {
        AUTOMATIC,
        USER,
        USERCLASS,
        NONE;

    }

    public static enum GroupByOptimization {
        SERVERDETERMINED,
        DISTINCT;

    }

    public static enum ExactNumericDivision {
        CAST_TO_DOUBLE,
        CAST_TO_DOUBLE_CONDITIONAL,
        DO_NOT_ADJUST;

    }

    public static enum MeasureRefiner {
        ENABLED,
        DISABLED;

    }

    public static enum Suppress {
        NONE,
        NULLS;

    }

    public static enum ExecutionMethod {
        SEQUENTIAL,
        CONCURRENT;

    }

    public static enum RollupProcessing {
        UNKNOWN,
        LOCAL,
        DATABASE,
        EXTENDED;

    }

    public static enum QueryProcessing {
        DATABASEONLY,
        LIMITEDLOCAL,
        MINIMIZELOCAL;

    }

    public static enum ExecutionOptimization {
        FIRSTROW,
        ALLROWS;

    }

    public static enum AutoSort {
        NONE,
        MINIMAL,
        ALL;

    }

    public static enum SuppressDuplicateMeasureValues {
        SERVERDETERMINED,
        ENABLE,
        DISABLE;

    }

    public static enum UseSQLParameters {
        SERVERDETERMINED,
        MARKER,
        LITERAL;

    }

    public static enum SqlGenerationForAttr {
        SERVERDETERMINED,
        GROUPBY,
        MINIMUM;

    }

    public static enum CatByMeasureDimQi {
        SERVERDETERMINED,
        ENABLE,
        DISABLE;

    }

    public static enum SqlJoinSyntax {
        SERVERDETERMINED,
        EXPLICIT,
        IMPLICIT;

    }

    public static enum ShortCutProcessing {
        EXPLICIT,
        AUTOMATIC;

    }

    public static enum GovernorPermission {
        ALLOW,
        WARN,
        DENY;

    }

    public static enum AllGovernors {
        AGGREGATE_OVER_HIGHER_LEVEL_AGGREGATE("aggregateOverHigherLevelAggregate"),
        AUTOSORT("autoSort"),
        AVOID_ZERODIV("avoidZeroDiv"),
        CATBYMEASUREDIMQI("categorizeByMeasureDimensionQueryItems"),
        CROSS_PRODUCT_ALLOWED("crossProductAllowed"),
        DESIGN_MODE("designMode"),
        DATASET_MODE("datasetMode"),
        DYNAMICDIMINFO("dynamicDimensionInfo"),
        EXECUTION_METHOD("executionMethod"),
        EXECUTION_OPTIMIZATION("executionOptimization"),
        FORMAT_QUERYITEMS_FOR_PARAMETER_MAPS("formatQueryItemsForParameterMaps"),
        LOCAL_CACHE("localCache"),
        MAX_QUERY_EXECUTION_TIME("maxQueryExecutionTime"),
        MAX_ROWS_RETRIEVED("maxRowsRetrieved"),
        MAX_TABLES_PER_QUERY("maxTablesPerQuery"),
        MAX_TEXT_BLOB_CHARACTERS("maxTextBlobCharacters"),
        MAX_TABLE_NAME_LENGTH("maxTableNameLength"),
        MEASURE_REFINER("measureRefiner"),
        NESTED_AGGREGATE_HANDLING("nestedAggregateHandling"),
        NO_DATA_MODE("noDataMode"),
        OUTERJOIN_ALLOWED("outerJoinAllowed"),
        PROCESSALLMODEL("processAllModelWhenPublishing"),
        QUERY_INTENT("queryIntent"),
        QUERY_PROCESSING("queryProcessing"),
        REPORT_MEASURE("reportMeasure"),
        ROLLUP_PROCESSING("rollupProcessing"),
        SHORTCUTPROCESSING("shortcutProcessing"),
        SQLGENERATIONDETATTR("SQLgenerationForDeterminantAttributes"),
        SQLGENERATIONLEVATTR("SQLgenerationForLevelAttributes"),
        SQLJOINSYNTAX("useSQLJoinSyntax"),
        SUPPRESS("suppress"),
        USE_FOR_PARAMETER_INFO("useForParameterInfo"),
        USE_SQL_WITH_CLAUSE("useSQLWithClause"),
        USE_V4_INTERPRETATION("useV4Interpretation"),
        USE_METADATA_CALLBACK("useMetadataCallback"),
        USE_SQL_PARAMETERS("useSQLParameters"),
        SUPPRESS_DUPLICATE_MEASURE_VALUES("suppressDuplicateMeasureValues"),
        USE_SAP_MUN_AS_BUSINESS_KEY("useSAPMUNAsBusinessKey"),
        USE_AGGREGATE_CACHE("useAggregrateCache"),
        OPTIMIZE_MASTER_DETAIL_FOR_ALL_ROWS("optimizeMasterDetailForAllRows"),
        EXACT_NUMERIC_DIVISION("exactNumericDivision"),
        GROUPBY_OPTIMIZATION("groupByOptimization"),
        CACHE_POLICY_MODEL_SECURITY("cachePolicyModelSecurity"),
        CACHE_POLICY_DB_ACCESS("cachePolicyDBAccess"),
        CACHE_POLICY_CONNECTION_COMMAND_BLOCKS("cachePolicyConnectionCommandBlocks"),
        STRICT_GROUP_BY("strictGroupBy"),
        CONTEXT_SENSITIVE_JOIN_SELECTION("contextSensitiveJoinSelection"),
        LOCAL_CACHE_POLICY("localCachePolicy"),
        MASTER_DETAIL_OPTIMIZATION("masterDetailOptimization"),
        CURSOR_MODE("cursorMode"),
        BURST_KEY_LIST("burstKeyList"),
        BURST_MASTER_QUERY_NAME("burstMasterQuery"),
        REMOVE_AGGOP_WHEN_FLT_PAA_IS_FALSE("removeAggregateOpWhenFltPAAIsFalse"),
        REMOVE_AGGOP_WHEN_DI_AGG_IS_NONE("removeAggregateOpWhenDataItemAggIsNone"),
        ROW_STITCH_FOR_FACT_LESS_QUERY("rowStitchForFactLessQuery"),
        STITCH_WITH_NULLS("stitchWithNulls"),
        NATIVE_SQL_IN_CTE("nativeSQLInCTE"),
        SUPPRESS_MESSAGES("suppressMessages"),
        MAX_OOM_MDX_RESULT("maxOrderOfMagnitudeMDXResult"),
        REPORT_AS_DATASOURCE("rads"),
        SQLWINDOWFUNCTION_GENERATION("sqlWindowFunctionGeneration"),
        SUMMARYQUERY_JOIN_OPERATOR("summaryQueryJoinOperator"),
        MULTIFACT_JOIN_OPERATOR("multiFactJoinOperator"),
        DMR_MEMBERS_USE_RELATIONAL_CACHE("dmrMembersUseRelationalCache"),
        DMR_CELLS_USE_RELATIONAL_CACHE("dmrCellsUseRelationalCache"),
        FJO_USE_RELATIONAL_CACHE("fjoUseRelationalCache"),
        DMR_PRELOAD_CELLS_EXECUTION_MODE("dmrPreloadCellsExecutionMode"),
        CONSTANT_FOLDING("constantFolding"),
        TABLE_SAMPLING_TABLE("tableSamplingTable"),
        TABLE_SAMPLING_METHOD("tableSamplingMethod"),
        TABLE_SAMPLING_PERCENT("tableSamplingPercent"),
        TABLE_SAMPLING_ROW_COUNT("tableSamplingRowCount"),
        TABLE_SAMPLING_SEED("tableSamplingSeed"),
        TABLE_SAMPLING_THROW_ON_SUBQUERY("tableSamplingThrowOnSubquery"),
        DATASET_MODULE_TYPE("datasetModuleType"),
        IGNORE_FILTERS_NOT_APPLICABLE("ignoreFiltersNotApplicable"),
        TREAT_EMPTY_DMR_MUN("treatEmptyDMRMUN"),
        DATA_CACHE_EXPIRY("dataCacheExpiry"),
        DATA_CACHE_USE_POLICY("dataCacheUsePolicy"),
        DASHBOARD_CONTEXT("dashboard"),
        ENABLE_PUSHDOWN_LEVEL_LARGER_THAN("enablePushdownLevelLargerThan"),
        IS_STATS_QUERY("isStatsQuery"),
        TREAT_RELATIONAL_XTAB_EXT_AGGR_AS_LIST_FOOTER("treatRelationalXTabExternalAggregateAsListFooter"),
        FJO_MAX_KEYS("fjoMaxKeys"),
        INTERACTIVE("Interactive"),
        GENERATE_SUBQUERY_FOR_CALCS("generateSubqueryForCalcs"),
        PROCESS_NULL_CONSUMERS_AFTER_JOIN("processNullConsumersAfterJoin"),
        USE_VECTORIZED_QUERY_EXECUTION("useVectorizedQueryExecution"),
        DATAITEM_LABEL_BEHAVIOUR("dataItemLabelBehaviour");

        private final String govKey;

        private AllGovernors(String key) {
            this.govKey = key;
        }

        public String getKey() {
            return this.govKey;
        }
    }
}

