/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.ResourceLocator;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;

public class JarManifestResourceMatcher
implements ResourceLocator.IResourceMatcher {
    private static final Logger LOG = Logger.getLogger(JarManifestResourceMatcher.class.getName());
    private ClassLoader loader;
    private String section;
    private String header;

    public JarManifestResourceMatcher(ClassLoader theLoader, String theSection, String theHeader) {
        this.section = theSection;
        this.header = theHeader;
        this.loader = theLoader;
    }

    @Override
    public boolean contains(String resourceName) {
        throw new NotImplementedException("JarManifestResourceMatcher.contains");
    }

    @Override
    public URL getURL(String resourceName) {
        throw new NotImplementedException("JarManifestResourceMatcher.getURL");
    }

    @Override
    public Iterator<URL> getMatchingURLs(String resourceName) {
        HashSet<URL> answer = new HashSet<URL>();
        try {
            Enumeration<URL> enumeration = this.loader.getResources("META-INF/MANIFEST.MF");
            while (enumeration.hasMoreElements()) {
                String value;
                URL url = enumeration.nextElement();
                Manifest manifest = new Manifest(url.openStream());
                Attributes attributes = manifest.getAttributes(this.section);
                if (attributes == null || (value = attributes.getValue(this.header)) == null) continue;
                for (String v : StringUtils.split((String)value, (String)",")) {
                    String v2 = StringUtils.strip((String)v);
                    URL u = this.loader.getResource(v2);
                    if (LOG.isLoggable(Level.CONFIG)) {
                        LOG.config(String.format("%s", u));
                    }
                    answer.add(u);
                }
            }
            return answer.iterator();
        }
        catch (IOException e) {
            XQEDebugLog.out.printStackTrace(e);
            return IteratorUtils.emptyIterator();
        }
    }
}

