/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import java.io.IOException;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;

public class KerberosConnectionHelper {
    private String[] parameters;
    private static final String usage = " java -cp <driver jars>;xqeService.jar KerberosConnectionHelper<driver class name> <jdbc url> <principal> <password>\n jdbc-url should include the necessary kerberos-related properties for connecting using pre-authorized subject.\n principal is the client user account, not the database service.\n The tool creates a JAAS Subject from the credentials and places it in the authorization context (Subject.doAs()).\n The Kerberos implementation should retrieve it from there when the JGSS-API creates credentials.";

    public KerberosConnectionHelper(String[] theParameters) {
        this.parameters = theParameters;
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println(usage);
            return;
        }
        KerberosConnectionHelper helper = new KerberosConnectionHelper(args);
        helper.go();
    }

    public void go() {
        System.out.println("Parameters:");
        System.out.println("<driver class name>:" + this.parameters[0]);
        System.out.println("<jdbc url>:" + this.parameters[1]);
        System.out.println("<principal>:" + this.parameters[2]);
        if (System.getProperty("java.vendor").toUpperCase().contains("IBM")) {
            System.setProperty("com.ibm.security.krb5.Krb5Debug", "all");
            System.setProperty("com.ibm.security.jgss.debug", "all");
        } else {
            System.setProperty("sun.security.krb5.debug", "true");
            System.setProperty("sun.security.jgss.debug", "true");
        }
        Driver driver = null;
        try {
            driver = (Driver)Class.forName(this.parameters[0]).newInstance();
        }
        catch (Throwable e) {
            System.out.println("Can't load driver by name. " + e.getMessage());
            while (e.getCause() != null) {
                e = e.getCause();
                System.out.println("Caused by:" + e.getMessage());
            }
            return;
        }
        Subject subject = null;
        try {
            System.out.println("----------Acquiring TGT from KDC --------------------");
            class SimpleCallbackHandler
            implements CallbackHandler {
                String userId;
                String password;

                SimpleCallbackHandler(String theUserId, String thePassword) {
                    this.userId = theUserId;
                    this.password = thePassword;
                }

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (int i = 0; i < callbacks.length; ++i) {
                        if (callbacks[i] instanceof NameCallback) {
                            NameCallback nc = (NameCallback)callbacks[i];
                            nc.setName(this.userId);
                            continue;
                        }
                        if (callbacks[i] instanceof PasswordCallback) {
                            PasswordCallback pc = (PasswordCallback)callbacks[i];
                            pc.setPassword(this.password.toCharArray());
                            continue;
                        }
                        throw new UnsupportedCallbackException(callbacks[i], "Internal error - unrecognized Callback type");
                    }
                }
            }
            LoginContext lc = new LoginContext("other", null, new SimpleCallbackHandler(this.parameters[2], this.parameters[3]), new LocalConfiguration());
            lc.login();
            subject = lc.getSubject();
            System.out.println("----------Acquired TGT for principal" + subject.getPrincipals().toArray()[0].toString() + " --------------------");
        }
        catch (Throwable e) {
            System.out.println("Can't connect to KDC. " + e.getMessage());
            while (e.getCause() != null) {
                e = e.getCause();
                System.out.println("Caused by:" + e.getMessage());
            }
            return;
        }
        class ConnectTask
        implements PrivilegedAction<Exception> {
            Exception ex = null;
            String url;
            Driver driver;
            Connection connection;

            ConnectTask(Driver theDriver, String theUrl) {
                this.url = theUrl;
                this.driver = theDriver;
            }

            @Override
            public Exception run() {
                System.out.println("\n ------------ calling driver.connect()--------------------");
                try {
                    this.connection = this.driver.connect(this.url, new Properties());
                }
                catch (Exception e) {
                    this.ex = e;
                }
                return this.ex;
            }

            public Exception getException() {
                return this.ex;
            }

            public Connection getConnection() {
                return this.connection;
            }
        }
        ConnectTask t = new ConnectTask(driver, this.parameters[1]);
        Subject.doAs(subject, t);
        Connection c = t.getConnection();
        if (c == null) {
            Throwable e = t.getException();
            if (e != null) {
                System.out.println("---------------------- Can't connect to " + this.parameters[1] + ". " + e.getMessage());
                while (e.getCause() != null) {
                    e = e.getCause();
                    System.out.println("Caused by: " + e.getMessage());
                }
            } else {
                System.out.println("Driver does not recognize this url.");
            }
            return;
        }
        System.out.println("---------------------- Connection successful.");
        try {
            System.out.println("Connected to: " + c.getMetaData().getDatabaseProductName() + " " + c.getMetaData().getDatabaseProductVersion());
            System.out.println("As user: " + c.getMetaData().getUserName());
        }
        catch (SQLException e) {
            System.out.println("Caught exception while displaying database metadata.");
            System.out.println(e.getMessage());
        }
    }

    public static class LocalConfiguration
    extends Configuration {
        @Override
        public AppConfigurationEntry[] getAppConfigurationEntry(String arg0) {
            String loginModuleClass = null;
            HashMap<String, String> map = new HashMap<String, String>();
            if (System.getProperty("java.vendor").toUpperCase().contains("IBM")) {
                loginModuleClass = "com.ibm.security.auth.module.Krb5LoginModule";
                map.put("useDefaultCcache", "false");
            } else {
                loginModuleClass = "com.sun.security.auth.module.Krb5LoginModule";
                map.put("useTicketCache", "false");
            }
            AppConfigurationEntry entry = new AppConfigurationEntry(loginModuleClass, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, map);
            return new AppConfigurationEntry[]{entry};
        }
    }
}

