/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.i18n.ToolkitResources;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class LocaleConverter {
    public static final String INVALID_LOCALE = "-1";
    public static final String CCL_UNKNOWN_VALUE = "0";
    public static final Map<String, String> JAVALANGUAGE_ICULANGUAGE_MAP = new HashMap<String, String>(){
        {
            this.put("iw", "he");
            this.put("ji", "yi");
            this.put("in", "id");
        }
    };
    private static final AtomicReference<HashMap<Locale, String>> LOCALE_TO_STRING_CACHE = new AtomicReference(new HashMap());
    private static final String SEPARATOR_XML = "-";
    private static final String SEPARATOR_JAVA = "_";
    private static final String SPLIT_REGEX = "[-_]";

    public static String getLanguage(Locale locale) {
        String language = locale.getLanguage();
        String icuLanguage = JAVALANGUAGE_ICULANGUAGE_MAP.get(language);
        if (icuLanguage != null) {
            language = icuLanguage;
        }
        return language;
    }

    public static String toString(Locale locale) {
        String toString = locale.toString();
        String language = locale.getLanguage();
        String icuLanguage = JAVALANGUAGE_ICULANGUAGE_MAP.get(language);
        if (icuLanguage != null) {
            toString = toString.replaceFirst(language, icuLanguage);
        }
        return toString;
    }

    public static String toCurrCode(Integer lcid, String unknownCurrency) {
        String currency = unknownCurrency;
        String cclCurrency = ToolkitResources.getISOCurrencyCodeForLCID((String)lcid.toString());
        if (cclCurrency.length() > 0 && !cclCurrency.equals(CCL_UNKNOWN_VALUE)) {
            currency = cclCurrency;
        }
        return currency;
    }

    public static String toLCID(Locale locale) {
        String lcid = INVALID_LOCALE;
        if (locale != null && ((lcid = ToolkitResources.getLCIDForLocale((String)LocaleConverter.localeToStr(locale))).equals(CCL_UNKNOWN_VALUE) || lcid.length() == 0)) {
            lcid = INVALID_LOCALE;
        }
        return lcid;
    }

    public static String toLCID(String locale) {
        String lcid = INVALID_LOCALE;
        if (locale != null && ((lcid = ToolkitResources.getLCIDForLocale((String)locale)).equals(CCL_UNKNOWN_VALUE) || lcid.length() == 0)) {
            lcid = INVALID_LOCALE;
        }
        return lcid;
    }

    public static Locale toLocale(Integer lcid) {
        String strLocale;
        Locale locale = null;
        if (lcid > 0 && !(strLocale = ToolkitResources.getLocaleIdForLCID((String)lcid.toString())).equals(CCL_UNKNOWN_VALUE) && strLocale.length() != 0) {
            locale = LocaleConverter.strToLocale(strLocale);
        }
        return locale;
    }

    public static Locale strToLocale(String aLocale) {
        if (aLocale == null || aLocale.length() == 0) {
            return null;
        }
        String[] codes = aLocale.split(SPLIT_REGEX, 2);
        if (codes.length == 1) {
            return new Locale(codes[0].toLowerCase());
        }
        return new Locale(codes[0].toLowerCase(), codes[1].toUpperCase());
    }

    public static String localeToStr(Locale aLocale) {
        if (aLocale == null) {
            return null;
        }
        HashMap<Locale, String> localeCache = LOCALE_TO_STRING_CACHE.get();
        String strLocale = localeCache.get(aLocale);
        if (strLocale == null) {
            HashMap<Locale, String> newMap;
            HashMap<Locale, String> origMap;
            strLocale = LocaleConverter.getLanguage(aLocale);
            if (aLocale.getCountry().length() != 0) {
                strLocale = strLocale + SEPARATOR_XML + aLocale.getCountry().toLowerCase();
            }
            do {
                origMap = LOCALE_TO_STRING_CACHE.get();
                newMap = new HashMap<Locale, String>(origMap);
                newMap.put(aLocale, strLocale);
            } while (!LOCALE_TO_STRING_CACHE.compareAndSet(origMap, newMap));
        }
        return strLocale;
    }

    public static Locale resolveLocale(String localeString, List<String> localeStrings) {
        if (localeString != null && (localeStrings == null || localeStrings.isEmpty())) {
            Locale givenLocale = new Locale(localeString);
            return givenLocale;
        }
        if (localeString == null || localeString.isEmpty()) {
            return null;
        }
        Locale locale = LocaleConverter.strToLocale(localeString);
        ArrayList<Locale> locales = new ArrayList<Locale>(localeStrings.size());
        for (String localeStr : localeStrings) {
            locales.add(LocaleConverter.strToLocale(localeStr));
        }
        return LocaleConverter.resolveLocale(locale, locales);
    }

    public static Locale resolveLocale(Locale locale, List<Locale> locales) {
        if (locale == null || locales == null || locales.size() == 0) {
            return null;
        }
        Locale resolvedLocale = null;
        for (Locale localeFromList : locales) {
            if (!LocaleConverter.getLanguage(locale).equals(LocaleConverter.getLanguage(localeFromList)) || !locale.getCountry().equals(localeFromList.getCountry())) continue;
            resolvedLocale = localeFromList;
            break;
        }
        if (resolvedLocale == null) {
            for (Locale localeFromList : locales) {
                if (!localeFromList.getCountry().isEmpty() || !LocaleConverter.getLanguage(locale).equals(LocaleConverter.getLanguage(localeFromList))) continue;
                resolvedLocale = localeFromList;
                break;
            }
        }
        if (resolvedLocale == null) {
            for (Locale localeFromList : locales) {
                if (!LocaleConverter.getLanguage(locale).equals(LocaleConverter.getLanguage(localeFromList))) continue;
                resolvedLocale = localeFromList;
                break;
            }
        }
        if (resolvedLocale == null) {
            resolvedLocale = locales.get(0);
        }
        return resolvedLocale;
    }
}

