/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleConverter;
import java.util.List;
import java.util.Locale;

public class LocaleUtility {
    public static Locale getSupportedLocale(Locale requestedLocale, ILocalizedString localizedString, String defaultLocaleString) {
        String requestedLocaleString = LocaleConverter.localeToStr(requestedLocale);
        String supportedLocaleString = LocaleUtility.getSupportedLocale(requestedLocaleString, localizedString, defaultLocaleString);
        return LocaleConverter.strToLocale(supportedLocaleString);
    }

    public static String getSupportedLocale(String requestedLocaleString, ILocalizedString localizedString, String defaultLocaleString) {
        String supportedLocaleString = null;
        if (localizedString != null) {
            List<String> supportedLocaleStrings = localizedString.getAllSupportedLocales();
            Locale supportedLocale = LocaleConverter.resolveLocale(requestedLocaleString, supportedLocaleStrings);
            supportedLocaleString = LocaleConverter.localeToStr(supportedLocale);
        } else {
            supportedLocaleString = defaultLocaleString;
        }
        return supportedLocaleString;
    }
}

