/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.SingleLocaleString;
import com.cognos.xqe.util.xml.serializer.XMLElement;
import com.cognos.xqe.util.xml.serializer.XMLElementMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class LocalizedString
implements Serializable,
Comparable<Object>,
CharSequence,
ILocalizedString {
    private static final long serialVersionUID = 1L;
    public static final String DEFAULT_LOCALE_STR = "DEFAULT";
    @XMLElement(name="defaultLocale")
    private String defaultLocaleStr = null;
    @XMLElement(name="default")
    private String defaultValue = null;
    public static final String ERRORINVALIDPARAMTER = "null is not a valid inout parameter.";
    private static final LocalizedString EMPTY_LOCALIZED_STRING = new LocalizedString("", "");
    @XMLElementMap(itemName="localizedString", keyName="locale", valName="string")
    private TreeMap<String, String> localizedValues = null;
    private List<String> localesMappedToDefaultValue;
    private int cachedHashCode = Integer.MIN_VALUE;
    private boolean overrideDefault = false;

    public LocalizedString(String defaultLocaleValue) {
        if (null == defaultLocaleValue) {
            throw new IllegalArgumentException(ERRORINVALIDPARAMTER);
        }
        this.setDefaults(DEFAULT_LOCALE_STR, defaultLocaleValue);
    }

    public LocalizedString(Locale defaultLocale, String defaultLocaleValue) {
        if (null == defaultLocale || null == defaultLocaleValue) {
            throw new IllegalArgumentException(ERRORINVALIDPARAMTER);
        }
        this.setDefaults(LocaleConverter.toString(defaultLocale), defaultLocaleValue);
    }

    public LocalizedString(Locale defaultLocale, String defaultLocaleValue, boolean overrideDefault) {
        this(defaultLocale, defaultLocaleValue);
        this.overrideDefault = overrideDefault;
    }

    public LocalizedString(String defaultLocale, String defaultLocaleValue) {
        if (null == defaultLocale || null == defaultLocaleValue) {
            throw new IllegalArgumentException(ERRORINVALIDPARAMTER);
        }
        this.setDefaults(defaultLocale, defaultLocaleValue);
    }

    public LocalizedString(LocalizedString localizedStr) {
        if (null == localizedStr) {
            throw new IllegalArgumentException(ERRORINVALIDPARAMTER);
        }
        for (String localeStr : localizedStr.getSupportedLocales()) {
            this.localizeValue(localeStr, localizedStr.toString(localeStr));
        }
        this.setDefaults(localizedStr.getDefaultLocale(), localizedStr.toString());
        this.setOverrideDefault(localizedStr.isOverrideDefault());
    }

    public LocalizedString(ILocalizedString localizedStr) {
        if (null == localizedStr) {
            throw new IllegalArgumentException(ERRORINVALIDPARAMTER);
        }
        if (localizedStr instanceof LocalizedString) {
            for (String localeStr : localizedStr.getSupportedLocales()) {
                this.localizeValue(localeStr, localizedStr.toString(localeStr));
            }
        }
        this.setDefaults(localizedStr.getDefaultLocale(), localizedStr.toString());
        this.setOverrideDefault(localizedStr.isOverrideDefault());
    }

    public static LocalizedString emptyString() {
        return EMPTY_LOCALIZED_STRING;
    }

    @Override
    public void put(Locale locale, String value) {
        this.localizeValue(LocaleConverter.toString(locale), value);
    }

    @Override
    public void put(String locale, String value) {
        this.localizeValue(locale, value);
    }

    @Override
    public String toString(Locale locale) {
        return this.toString(LocaleConverter.toString(locale));
    }

    @Override
    public String toString(String locale) {
        if (!this.overrideDefault && this.getDefaultLocale().equals(locale)) {
            return this.toString();
        }
        if (this.localizedValues != null) {
            return this.localizedValues.get(locale);
        }
        return null;
    }

    @Override
    public String toString() {
        return this.defaultValue;
    }

    @Override
    public String getDefaultLocale() {
        return this.defaultLocaleStr;
    }

    @Override
    public String[] getSupportedLocales() {
        if (this.localizedValues == null) {
            return new String[0];
        }
        return this.localizedValues.keySet().toArray(new String[0]);
    }

    @Override
    public List<String> getAllSupportedLocales() {
        ArrayList<String> supportedLocalesToReturn = new ArrayList<String>();
        supportedLocalesToReturn.add(this.defaultLocaleStr);
        if (this.localizedValues != null) {
            supportedLocalesToReturn.addAll(this.localizedValues.keySet());
        }
        if (this.localesMappedToDefaultValue != null) {
            for (String localeMappedToDefaultValue : this.localesMappedToDefaultValue) {
                supportedLocalesToReturn.add(localeMappedToDefaultValue);
            }
        }
        return supportedLocalesToReturn;
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    public boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (other instanceof LocalizedString) {
            LocalizedString otherLocalizedString = (LocalizedString)other;
            if (this.localizedValues == null || otherLocalizedString.localizedValues == null) {
                return this.defaultValue.equals(otherLocalizedString.toString());
            }
            return this.defaultValue.equals(otherLocalizedString.toString()) && this.localizedValues.equals(otherLocalizedString.localizedValues);
        }
        if (other instanceof String) {
            String otherString = (String)other;
            String thisString = this.toString();
            return thisString == otherString || thisString.equals(otherString);
        }
        return false;
    }

    public int hashCode() {
        if (Integer.MIN_VALUE == this.cachedHashCode) {
            HashCodeBuilder hcb = new HashCodeBuilder();
            hcb.append((Object)this.defaultValue);
            if (this.localizedValues != null) {
                for (Map.Entry<String, String> entry : this.localizedValues.entrySet()) {
                    hcb.append((Object)entry.getKey());
                    hcb.append((Object)entry.getValue());
                }
            }
            this.cachedHashCode = hcb.toHashCode();
            if (Integer.MIN_VALUE == this.cachedHashCode) {
                this.cachedHashCode = 0;
            }
        }
        return this.cachedHashCode;
    }

    @Override
    public int compareTo(Object other) {
        if (null == other) {
            return -1;
        }
        if (this == other) {
            return 0;
        }
        if (other instanceof LocalizedString) {
            LocalizedString otherLocalizedString = (LocalizedString)other;
            int defaultComparison = this.defaultValue.compareTo(otherLocalizedString.toString());
            if (defaultComparison != 0) {
                return defaultComparison;
            }
            if (this.localizedValues != null && otherLocalizedString.localizedValues != null) {
                if (this.localizedValues.size() < otherLocalizedString.localizedValues.size()) {
                    return -1;
                }
                if (this.localizedValues.size() > otherLocalizedString.localizedValues.size()) {
                    return 1;
                }
                CompareToBuilder ctb = new CompareToBuilder();
                Iterator<Map.Entry<String, String>> thisIter = this.localizedValues.entrySet().iterator();
                Iterator<Map.Entry<String, String>> otherIter = otherLocalizedString.localizedValues.entrySet().iterator();
                while (thisIter.hasNext() && otherIter.hasNext()) {
                    ctb.append(thisIter.next(), otherIter.next());
                    if (ctb.toComparison() == 0) continue;
                    return ctb.toComparison();
                }
            }
            return 0;
        }
        if (other instanceof SingleLocaleString) {
            SingleLocaleString otherLocalizedString = (SingleLocaleString)other;
            String thisString = this.toString();
            return thisString.compareTo(otherLocalizedString.toString());
        }
        if (other instanceof String) {
            String otherString = (String)other;
            String thisString = this.toString();
            return thisString.compareTo(otherString);
        }
        return -1;
    }

    @Override
    public boolean isLocaleExist(String locale) {
        if (locale.equalsIgnoreCase(this.getDefaultLocale())) {
            return true;
        }
        for (String loc : this.getSupportedLocales()) {
            if (!loc.equalsIgnoreCase(locale)) continue;
            return true;
        }
        return false;
    }

    private void setDefaults(String defaultLocale, String defaultLocaleValue) {
        this.defaultLocaleStr = AbstractSingleLocaleString.getString(defaultLocale);
        this.defaultValue = AbstractSingleLocaleString.getString(defaultLocaleValue);
    }

    private void localizeValue(String localeStr, String localizedValue) {
        boolean isValueSameAsDefault;
        String internedLocaleStr = AbstractSingleLocaleString.getString(localeStr);
        if (internedLocaleStr == this.defaultLocaleStr) {
            if (!this.overrideDefault) {
                return;
            }
            if (localizedValue.equals(this.defaultValue)) {
                return;
            }
        }
        if (isValueSameAsDefault = localizedValue.equals(this.defaultValue)) {
            if (this.localizedValues != null) {
                this.localizedValues.remove(internedLocaleStr);
                if (this.localizedValues.isEmpty()) {
                    this.localizedValues = null;
                }
            }
            if (this.localesMappedToDefaultValue == null) {
                this.localesMappedToDefaultValue = new LinkedList<String>();
            }
            this.localesMappedToDefaultValue.add(internedLocaleStr);
            return;
        }
        if (this.localizedValues == null) {
            this.localizedValues = new TreeMap();
        }
        this.localizedValues.put(internedLocaleStr, localizedValue);
    }

    @Override
    public boolean isOverrideDefault() {
        return this.overrideDefault;
    }

    private void setOverrideDefault(boolean overrideDefault) {
        this.overrideDefault = overrideDefault;
    }
}

