/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.trace.RunStatsRecorder;

public class MemoryUtil {
    private static final String SYS_PROP_DUMP_INTERVAL = "heapdump.interval";
    private static final String ENV_VAR = "IBM_HEAPDUMP";
    private static final String WIN_CMD = "../../src/xqe/dev/Tools/heapdump/sendSignal.exe ";
    private static final String UNIX_CMD = "kill -3 ";
    private static final int DEFAULT_DUMP_INTERVAL = 102400;
    private static boolean enabled;
    private static String cmd;
    private static int dumpInterval;

    private MemoryUtil() {
    }

    private static void init() {
        String value = System.getenv(ENV_VAR);
        if (value == null || !value.toLowerCase().equals("true")) {
            enabled = false;
            dumpInterval = 102400;
        } else {
            enabled = true;
            String pid = RunStatsRecorder.getPID();
            cmd = System.getProperty("os.name").indexOf("Windows") >= 0 ? WIN_CMD + pid : UNIX_CMD + pid;
            String str = System.getProperty(SYS_PROP_DUMP_INTERVAL);
            try {
                dumpInterval = Integer.valueOf(str) * 1024;
            }
            catch (Exception e) {
                dumpInterval = 102400;
            }
        }
    }

    public static void heapDump() {
        if (enabled) {
            try {
                Runtime.getRuntime().exec(cmd);
            }
            catch (Exception e) {
                enabled = false;
            }
        }
    }

    public static int getDumpInterval() {
        return dumpInterval;
    }

    static {
        MemoryUtil.init();
    }
}

