/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.instrument.Instrumentation;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;

public class MemoryWalker {
    private static Instrumentation mInstrumentation;

    public static void deepSizeof(Object obj, MemoryStatistics stats) {
        if (mInstrumentation == null) {
            return;
        }
        stats.objsize = mInstrumentation.getObjectSize(obj);
        stats.duration = System.nanoTime();
        Stack<Object> stack = new Stack<Object>();
        stack.push(obj);
        do {
            stats.totalSize += MemoryWalker.sizeofInternal(stack.pop(), stack, stats);
        } while (!stack.isEmpty());
        stats.numObjects = stats.visited.size();
        stats.duration = System.nanoTime() - stats.duration;
    }

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        mInstrumentation = instrumentation;
    }

    public static long sizeof(Object obj) {
        if (mInstrumentation == null) {
            return 0L;
        }
        return mInstrumentation.getObjectSize(obj);
    }

    public static long deepSizeof(Object obj) {
        MemoryStatistics stats = new MemoryStatistics();
        MemoryWalker.deepSizeof(obj, stats);
        return stats.totalSize;
    }

    public static MemoryStatistics deepStatistics(Object obj) {
        MemoryStatistics stats = new MemoryStatistics();
        MemoryWalker.deepSizeof(obj, stats);
        return stats;
    }

    private static boolean isSharedFlyweight(Object obj) {
        if (obj instanceof Comparable) {
            if (obj instanceof Enum) {
                return true;
            }
            if (obj instanceof String) {
                return obj == ((String)obj).intern();
            }
            if (obj instanceof Boolean) {
                return obj == Boolean.TRUE || obj == Boolean.FALSE;
            }
            if (obj instanceof Integer) {
                return obj == Integer.valueOf((Integer)obj);
            }
            if (obj instanceof Short) {
                return obj == Short.valueOf((Short)obj);
            }
            if (obj instanceof Byte) {
                return obj == Byte.valueOf((Byte)obj);
            }
            if (obj instanceof Long) {
                return obj == Long.valueOf((Long)obj);
            }
            if (obj instanceof Character) {
                return obj == Character.valueOf(((Character)obj).charValue());
            }
        }
        return false;
    }

    private static boolean skipObject(Object obj, MemoryStatistics stats) {
        if (obj == null) {
            ++stats.numNulls;
            return true;
        }
        if (stats.skip != null && stats.skip.containsKey(obj)) {
            ++stats.numSkip;
            return true;
        }
        if (MemoryWalker.isSharedFlyweight(obj)) {
            ++stats.numSharedObjects;
            return true;
        }
        boolean skipReferences = true;
        boolean countUniqueReferences = true;
        if (obj instanceof SoftReference) {
            if (!stats.visited.containsKey(obj)) {
                stats.visited.put(obj, null);
                ++stats.numSoft;
            } else {
                ++stats.numSoft;
            }
            return true;
        }
        if (obj instanceof WeakReference) {
            if (!stats.visited.containsKey(obj)) {
                stats.visited.put(obj, null);
                ++stats.numWeak;
            } else {
                ++stats.numWeak;
            }
            return true;
        }
        if (obj instanceof PhantomReference) {
            if (!stats.visited.containsKey(obj)) {
                stats.visited.put(obj, null);
                ++stats.numPhantom;
            } else {
                ++stats.numPhantom;
            }
            return true;
        }
        if (obj instanceof ReferenceQueue) {
            if (!stats.visited.containsKey(obj)) {
                stats.visited.put(obj, null);
                ++stats.numRQ;
            } else {
                ++stats.numRQ;
            }
            return true;
        }
        if (stats.visited.containsKey(obj)) {
            return true;
        }
        if (stats.classesToSkip != null || stats.packagesToSkip != null) {
            String className = obj.getClass().getName();
            if (stats.classesToSkip != null && stats.classesToSkip.contains(className)) {
                return true;
            }
            if (stats.packagesToSkip != null) {
                for (String pkg : stats.packagesToSkip) {
                    if (!className.startsWith(pkg)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static long sizeofInternal(Object obj, Stack<Object> st, MemoryStatistics stats) {
        if (MemoryWalker.skipObject(obj, stats)) {
            return 0L;
        }
        Class<?> objClass = obj.getClass();
        if (objClass.isArray()) {
            if (!objClass.getComponentType().isPrimitive()) {
                int length = Array.getLength(obj);
                for (int i = 0; i < length; ++i) {
                    Object obj2 = Array.get(obj, i);
                    if (stats.visited.containsKey(obj2) || MemoryWalker.skipObject(obj2, stats)) continue;
                    st.add(obj2);
                }
            }
        } else {
            while (objClass != null) {
                Field[] fields;
                for (Field field : fields = objClass.getDeclaredFields()) {
                    if (Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive()) continue;
                    field.setAccessible(true);
                    try {
                        Object obj2 = field.get(obj);
                        if (stats.visited.containsKey(obj2) || MemoryWalker.skipObject(obj2, stats)) continue;
                        st.add(obj2);
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                objClass = objClass.getSuperclass();
            }
        }
        stats.visited.put(obj, null);
        long mySize = MemoryWalker.sizeof(obj);
        if ((stats.classCounter != null || stats.classSizes != null) && (objClass = obj.getClass()) != null) {
            String cn = objClass.getName();
            if (stats.classCounter != null) {
                Integer ii = stats.classCounter.get(cn);
                if (ii != null) {
                    stats.classCounter.put(cn, XQEIntegerPool.getInteger(ii + 1));
                } else {
                    stats.classCounter.put(cn, XQEIntegerPool.getInteger(1));
                }
            }
            if (stats.classSizes != null) {
                Integer ii = stats.classSizes.get(cn);
                if (ii != null) {
                    stats.classSizes.put(cn, XQEIntegerPool.getInteger((int)mySize) + ii);
                } else {
                    stats.classSizes.put(cn, XQEIntegerPool.getInteger((int)mySize));
                }
            }
        }
        return mySize;
    }

    public static Instrumentation getInstrumentation() {
        return mInstrumentation;
    }

    public static class MemoryStatistics {
        public int numObjects = 0;
        public long duration = 0L;
        public int numSharedObjects = 0;
        public long totalSize = 0L;
        public long objsize = 0L;
        public long numNulls = 0L;
        public long numSkip = 0L;
        public long numSoft = 0L;
        public long numWeak = 0L;
        public long numPhantom = 0L;
        public long numRQ = 0L;
        public IdentityHashMap<Object, Object> skip = null;
        public Map<String, Integer> classCounter = null;
        public TreeSet<String> classesToSkip = null;
        public ArrayList<String> packagesToSkip = null;
        public Map<String, Integer> classSizes = null;
        public IdentityHashMap<Object, Object> visited = new IdentityHashMap();

        public void enableCollectionOfClassStatistics() {
            this.classCounter = new HashMap<String, Integer>();
            this.classSizes = new HashMap<String, Integer>();
        }

        public void skip(Object obj) {
            if (this.skip == null) {
                this.skip = new IdentityHashMap();
            }
            this.skip.put(obj, null);
        }

        public void skipClass(String cls) {
            if (this.classesToSkip == null) {
                this.classesToSkip = new TreeSet();
            }
            this.classesToSkip.add(cls);
        }

        public void skipPackage(String pkg) {
            if (this.packagesToSkip == null) {
                this.packagesToSkip = new ArrayList();
            }
            this.packagesToSkip.add(pkg);
        }

        public String summaryToString(boolean includeDuration) {
            DecimalFormat df = new DecimalFormat();
            DecimalFormatSymbols dfs = new DecimalFormatSymbols();
            dfs.setGroupingSeparator(',');
            df.setDecimalFormatSymbols(dfs);
            String ret = "size=" + df.format(this.objsize) + " numObjects=" + df.format(this.numObjects) + " totalsize=" + df.format(this.totalSize) + " nn=" + df.format(this.numNulls) + " shr=" + df.format(this.numSharedObjects) + " nskip=" + df.format(this.numSkip) + " nsoft=" + df.format(this.numSoft) + " nweak=" + df.format(this.numWeak) + " nphan=" + df.format(this.numPhantom) + " nrefq=" + df.format(this.numRQ);
            if (includeDuration) {
                ret = ret + " milli=" + df.format(this.duration / 1000000L);
            }
            return ret;
        }

        public String summaryToString() {
            return this.summaryToString(false);
        }

        public void printStats(String msg) {
            System.out.println("MWS " + msg + " " + this.summaryToString(true));
        }

        public void writeClassStatsToCSVFile(String fileName, String headerLine, boolean createNewFile) {
            File csvFile;
            if (createNewFile && (csvFile = new File(fileName)).exists()) {
                csvFile.delete();
            }
            try {
                FileOutputStream stream = new FileOutputStream(fileName, true);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)stream, "UTF-8"));
                writer.write(headerLine);
                writer.append("\n");
                writer.append("num;size;className\n");
                writer.append(this.classStatsAsString());
                ((Writer)writer).close();
            }
            catch (IOException e) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_UnexpectedException, (Throwable)e);
            }
        }

        public String classStatsAsString() {
            StringBuilder sb = new StringBuilder();
            if (this.classCounter != null) {
                TreeSet<String> keys = new TreeSet<String>(this.classCounter.keySet());
                for (String cn : keys) {
                    sb.append(String.valueOf(this.classCounter.get(cn)));
                    sb.append(',');
                    sb.append(String.valueOf(this.classSizes.get(cn)));
                    sb.append(',');
                    sb.append(cn);
                    sb.append('\n');
                }
            }
            return sb.toString();
        }
    }
}

