/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.IParameterMaps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ParameterMapsApp
implements IParameterMaps {
    private Map<String, ArrayList<String>> parameterMap = new HashMap<String, ArrayList<String>>();
    private String mapName;
    private String defaultValue;
    int priority = 0;

    public ParameterMapsApp(String nameOfMap, int mapPriority) {
        this.mapName = nameOfMap;
        this.priority = mapPriority;
    }

    @Override
    public String get(String nameOfMap, String key) {
        if (nameOfMap.equals(this.mapName)) {
            ArrayList<String> value = this.parameterMap.get(key);
            if (value != null) {
                return value.get(0);
            }
            return null;
        }
        return null;
    }

    @Override
    public String get(String key) {
        return this.get("_env", key);
    }

    public void set(String nameOfMap, String key, String value) throws XQERuntimeException {
        if (nameOfMap.equals(this.mapName)) {
            ArrayList<Object> values = null;
            if (this.parameterMap.containsKey(key)) {
                values = this.parameterMap.get(key);
                values.add(value);
            } else {
                values = new ArrayList<String>();
                values.add(value);
                this.parameterMap.put(key, values);
            }
        } else {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Map Not Found");
        }
    }

    public void setArray(String nameOfMap, String key, ArrayList<String> values) throws XQERuntimeException {
        if (!nameOfMap.equals(this.mapName)) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Map Not Found");
        }
        this.parameterMap.put(key, values);
    }

    public void set(String key, String value) throws XQERuntimeException {
        this.set("_env", key, value);
    }

    @Override
    public Map<String, String> getAllEntries(String nameOfMap) {
        HashMap<String, String> allEntries = new HashMap<String, String>();
        if (!nameOfMap.equals(this.mapName)) {
            return allEntries;
        }
        for (Map.Entry<String, ArrayList<String>> anEntry : this.parameterMap.entrySet()) {
            if (anEntry.getKey() == null || anEntry.getValue() == null || anEntry.getValue().size() <= 0) continue;
            allEntries.put(anEntry.getKey(), anEntry.getValue().get(0));
        }
        return allEntries;
    }

    @Override
    public void setDefault(String nameOfMap, String value) {
        if (nameOfMap.equals(this.mapName)) {
            this.defaultValue = value;
        }
    }

    @Override
    public String getDefault(String nameOfMap) {
        return this.defaultValue;
    }

    @Override
    public String[] getMapNames() {
        String[] oneMap = new String[]{this.mapName};
        return oneMap;
    }

    public String getMapName() {
        return this.mapName;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newPriority) {
        this.priority = newPriority;
    }

    @Override
    public ArrayList<String> getArray(String nameOfMap, String key) throws XQERuntimeException {
        ArrayList<String> value = null;
        if (nameOfMap.equals(this.mapName)) {
            value = this.parameterMap.get(key);
        }
        return value;
    }

    @Override
    public ArrayList<String> getArray(String key) throws XQERuntimeException {
        return this.getArray("_env", key);
    }

    @Override
    public Map<String, ArrayList<String>> getArrayAllEntries(String nameOfMap) {
        if (nameOfMap.equals(this.mapName)) {
            return this.parameterMap;
        }
        return null;
    }

    public int getSize() {
        return this.parameterMap.size();
    }

    @Override
    public boolean isModelMap() {
        return false;
    }

    @Override
    public boolean isQueryItemMap() {
        return false;
    }

    @Override
    public boolean getHiddenProperty(String name) {
        return false;
    }
}

