/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.resultset.interfaces.ICellIterator;
import com.cognos.xqe.resultsets.BaseCellIterator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;

public final class PushBackIterator
extends BaseCellIterator {
    private boolean pushedBack = false;
    private ICell buffer = null;
    private ICellIterator sourceIterator;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public PushBackIterator(BaseCellIterator source) {
        super(source.getNodeId());
        this.sourceIterator = source;
    }

    @Override
    public ICell nextImpl() {
        if (this.pushedBack) {
            this.pushedBack = false;
            return this.buffer;
        }
        this.buffer = this.sourceIterator.next();
        return this.buffer;
    }

    @Override
    public long getIndex() {
        long index = this.sourceIterator.getIndex();
        if (this.pushedBack && this.buffer != null) {
            return this.buffer.getOrdinal();
        }
        return index;
    }

    public void pushBack() {
        this.pushedBack = true;
    }

    @Override
    public boolean hasNext() {
        if (this.pushedBack && this.buffer != null) {
            return true;
        }
        return this.sourceIterator.hasNext();
    }

    @Override
    public void release() {
        if (null != this.sourceIterator) {
            try {
                this.sourceIterator.release();
            }
            catch (Exception ex) {
                mErrorLogger.log(ex);
            }
            finally {
                this.sourceIterator = null;
            }
        }
    }
}

