/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;

public class SoftRefCache<K, V> {
    private ReferenceQueue<V> clearedRefs = new ReferenceQueue();
    private Map<K, CacheRef<K, V>> cacheMap = new HashMap<K, CacheRef<K, V>>();

    public int estimatedSize() {
        this.processClearedRefs();
        return this.cacheMap.size();
    }

    public V get(K key) {
        this.processClearedRefs();
        CacheRef<K, V> cacheRef = this.cacheMap.get(key);
        if (null != cacheRef) {
            return (V)cacheRef.get();
        }
        return null;
    }

    public void put(K key, V value) {
        this.processClearedRefs();
        CacheRef<K, V> newCacheRef = new CacheRef<K, V>(key, value, this.clearedRefs);
        CacheRef<K, V> oldCacheRef = this.cacheMap.put(key, newCacheRef);
        if (null != oldCacheRef) {
            oldCacheRef.setReclaimed();
        }
    }

    public void remove(K key) {
        this.processClearedRefs();
        CacheRef<K, V> cacheRef = this.cacheMap.remove(key);
        if (null != cacheRef) {
            cacheRef.setReclaimed();
        }
    }

    public void clear() {
        for (Map.Entry<K, CacheRef<K, V>> entry : this.cacheMap.entrySet()) {
            entry.getValue().setReclaimed();
        }
        this.cacheMap.clear();
    }

    private void processClearedRefs() {
        Reference<V> ref = null;
        while ((ref = this.clearedRefs.poll()) != null) {
            CacheRef cacheRef = (CacheRef)ref;
            if (cacheRef.isReclaimed()) continue;
            this.cacheMap.remove(cacheRef.getKey());
            cacheRef.setReclaimed();
        }
    }

    private static class CacheRef<K, V>
    extends SoftReference<V> {
        private final K key;
        private boolean reclaimed = false;

        CacheRef(K theKey, V referent, ReferenceQueue<V> refQueue) {
            super(referent, refQueue);
            this.key = theKey;
        }

        public final K getKey() {
            return this.key;
        }

        public final boolean isReclaimed() {
            return this.reclaimed;
        }

        public final void setReclaimed() {
            this.reclaimed = true;
        }
    }
}

