/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.BaseMember;
import com.cognos.xqe.ast.olap.MDXDateTimeConstant;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.data.providers.IDataProvider;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.INamespace;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.olap.OLAPXNodeRuntimeException;
import com.cognos.xqe.runtree.olap.XMdxLocal;
import com.cognos.xqe.runtree.olap.mdx.XMdxNode;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.DMRCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import com.cognos.xqe.util.UniqueNameParser;
import java.util.List;

public final class UniqueNameGenerator {
    public static final String OPEN_BRACE = "[";
    public static final String CLOSE_BRACE = "]";
    public static final String BRACE_DOT = "].";
    public static final String DOT_SEPARATOR = "].[";
    public static final String DOT = ".";
    public static final String ARROW = "->";
    public static final String COLON = ":";
    private static final int THREE = 3;
    private static final String PHYSICAL_NAME_PREFIX = ":[";

    private UniqueNameGenerator() {
    }

    public static String appendUniqueName(String part1, String part2) {
        StringBuilder buffer = new StringBuilder(part1);
        buffer.append(DOT);
        buffer.append(UniqueNameGenerator.createSingleNamePart(part2));
        return buffer.toString();
    }

    public static String appendUniqueName(String part1, String part2, String part3) {
        StringBuilder buffer = new StringBuilder(UniqueNameGenerator.appendUniqueName(part1, part2));
        buffer.append(DOT);
        buffer.append(UniqueNameGenerator.createSingleNamePart(part3));
        return buffer.toString();
    }

    public static String appendUniqueName(String part1, String part2, String part3, String part4) {
        StringBuilder buffer = new StringBuilder(UniqueNameGenerator.appendUniqueName(part1, part2, part3));
        buffer.append(DOT);
        buffer.append(UniqueNameGenerator.createSingleNamePart(part4));
        return buffer.toString();
    }

    public static String appendUniqueName(String part1, String part2, String part3, String part4, String part5) {
        StringBuilder buffer = new StringBuilder(UniqueNameGenerator.appendUniqueName(part1, part2, part3, part4));
        buffer.append(DOT);
        buffer.append(UniqueNameGenerator.createSingleNamePart(part5));
        return buffer.toString();
    }

    public static String createSingleNamePart(String part1) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        if (part1 != null) {
            buffer.append(UniqueNameParser.escapeSquareBrackets(part1));
        }
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createUniqueName(String part1) {
        return UniqueNameGenerator.createSingleNamePart(part1);
    }

    public static String createUniqueName(String part1, String part2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        buffer.append(part1);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part2);
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createEscapedUniqueName(String part1, String part2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        buffer.append(UniqueNameParser.escapeSquareBrackets(part1));
        buffer.append(DOT_SEPARATOR);
        buffer.append(UniqueNameParser.escapeSquareBrackets(part2));
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createUniqueName(String part1, String part2, String part3) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        buffer.append(part1);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part2);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part3);
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createEscapedUniqueName(String part1, String part2, String part3) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        buffer.append(UniqueNameParser.escapeSquareBrackets(part1));
        buffer.append(DOT_SEPARATOR);
        buffer.append(UniqueNameParser.escapeSquareBrackets(part2));
        buffer.append(DOT_SEPARATOR);
        buffer.append(UniqueNameParser.escapeSquareBrackets(part3));
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createUniqueName(String part1, String part2, String part3, String part4) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        buffer.append(part1);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part2);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part3);
        buffer.append(DOT_SEPARATOR);
        buffer.append(part4);
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createUniqueName(String[] parts) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        int lastPart = parts.length - 1;
        for (int i = 0; i < lastPart; ++i) {
            buffer.append(parts[i]);
            buffer.append(DOT_SEPARATOR);
        }
        buffer.append(parts[lastPart]);
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createEscapedUniqueName(String[] parts) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(OPEN_BRACE);
        int lastPart = parts.length - 1;
        for (int i = 0; i < lastPart; ++i) {
            buffer.append(UniqueNameParser.escapeSquareBrackets(parts[i]));
            buffer.append(DOT_SEPARATOR);
        }
        buffer.append(UniqueNameParser.escapeSquareBrackets(parts[lastPart]));
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String createEscapedUniqueNameFromDottedId(String dottedId) {
        StringBuilder buffer = new StringBuilder();
        String[] parts = dottedId.split("\\.");
        buffer.append(OPEN_BRACE);
        int lastPart = parts.length - 1;
        for (int i = 0; i < lastPart; ++i) {
            buffer.append(UniqueNameParser.escapeSquareBrackets(parts[i]));
            buffer.append(DOT_SEPARATOR);
        }
        buffer.append(UniqueNameParser.escapeSquareBrackets(parts[lastPart]));
        buffer.append(CLOSE_BRACE);
        return buffer.toString();
    }

    public static String join(String part1, String part2) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(part1);
        buffer.append(DOT);
        buffer.append(part2);
        return buffer.toString();
    }

    public static String joinModelPhysicalParts(String model, String physical) {
        StringBuilder munBuf = new StringBuilder();
        munBuf.append(model);
        munBuf.append("->:");
        munBuf.append(physical);
        return munBuf.toString();
    }

    public static String joinModelLogicalPhysicalParts(String model, String logical, String physical) {
        StringBuilder munBuf = new StringBuilder();
        munBuf.append(model);
        munBuf.append(ARROW);
        if (logical != null && logical.length() > 0) {
            munBuf.append(logical);
        }
        if (physical != null && physical.length() > 0) {
            munBuf.append(COLON);
            munBuf.append(physical);
        }
        return munBuf.toString();
    }

    public static String createV5UniqueName(ICube cube) {
        INamespace ns = cube.getNamespace();
        if (null != ns) {
            return cube.getNamespace().getV5UniqueName();
        }
        return UniqueNameGenerator.createUniqueName(cube.getName());
    }

    public static String createV5UniqueName(IDimension dimension) {
        return UniqueNameGenerator.appendUniqueName(UniqueNameGenerator.createV5UniqueName(dimension.getCube()), UniqueNameGenerator.cleanIdentifier(dimension.getName()));
    }

    public static String createV5UniqueName(ILevel level) {
        if (level.getDimension().isMeasuresDimension() || level.getHierarchy().isParentChild() || level.isAutoGenerated()) {
            return null;
        }
        return UniqueNameGenerator.appendUniqueName(level.getHierarchy().getV5UniqueName(), UniqueNameGenerator.cleanIdentifier(level.getName()));
    }

    public static String createV5UniqueName(IHierarchy hierarchy) {
        if (hierarchy.getDimension().isMeasuresDimension()) {
            return hierarchy.getDimension().getV5UniqueName();
        }
        if (!hierarchy.isAutoGenerated()) {
            String dimensionV5UN = hierarchy.getDimension().getV5UniqueName();
            if (dimensionV5UN.charAt(0) != '[') {
                dimensionV5UN = UniqueNameGenerator.createUniqueName(dimensionV5UN);
            }
            return UniqueNameGenerator.appendUniqueName(dimensionV5UN, UniqueNameGenerator.cleanIdentifier(hierarchy.getName()));
        }
        return null;
    }

    public static String createMemberV5ModelPart(ILevel level) {
        return UniqueNameGenerator.createMemberV5ModelPart(null, level);
    }

    public static String createMemberV5ModelPart(String cubeName, ILevel level) {
        String v5UniqueName;
        if (level.getDimension().isMeasuresDimension()) {
            v5UniqueName = level.getHierarchy().getDimension().getV5UniqueName();
        } else if (level instanceof IROLAPLevel) {
            v5UniqueName = ((IROLAPLevel)level).getV5UniqueName(cubeName);
            if (v5UniqueName == null && (v5UniqueName = ((IROLAPHierarchy)level.getHierarchy()).getV5UniqueName(cubeName)) == null) {
                v5UniqueName = ((IROLAPDimension)level.getHierarchy().getDimension()).getV5UniqueName(cubeName);
            }
        } else {
            v5UniqueName = level.getV5UniqueName();
            if (v5UniqueName == null && (v5UniqueName = level.getHierarchy().getV5UniqueName()) == null) {
                v5UniqueName = level.getHierarchy().getDimension().getV5UniqueName();
            }
        }
        return v5UniqueName;
    }

    public static String createMemberV5ModelPart(IHierarchy hierarchy) {
        String v5UniqueName;
        if (hierarchy.getDimension().isMeasuresDimension()) {
            v5UniqueName = hierarchy.getDimension().getV5UniqueName();
        } else {
            v5UniqueName = hierarchy.getV5UniqueName();
            if (v5UniqueName == null) {
                v5UniqueName = hierarchy.getDimension().getV5UniqueName();
            }
        }
        return v5UniqueName;
    }

    public static String getProviderInterfaceIdentifier(IMetadata metadata) {
        ICube cube = MetadataUtil.getCube(metadata);
        return UniqueNameGenerator.createUniqueName(cube.getModelDataSource().getInterface());
    }

    public static String cleanIdentifier(String identifier) {
        return identifier;
    }

    public static String createMemberV5UniqueName(ILevel level, String externalName) {
        return UniqueNameGenerator.createMemberV5UniqueName(null, level, externalName);
    }

    public static String createMemberV5UniqueName(String cubeName, ILevel level, String externalName) {
        String v5UniqueName = null;
        if (level.getDimension().isMeasuresDimension()) {
            IMember measure = level.getMember(UniqueNameGenerator.cleanIdentifier(externalName));
            if (measure != null) {
                v5UniqueName = measure.getV5UniqueName();
            }
        } else {
            ICube cube;
            String providerType = null;
            IDimension dim = level.getHierarchy().getDimension();
            providerType = dim instanceof IROLAPDimension ? "RO" : ((cube = level.getHierarchy().getDimension().getCube()) instanceof DMRCube ? ((DMRCube)cube).getDatasourceType() : cube.getModelDataSource().getInterface());
            v5UniqueName = UniqueNameGenerator.joinModelPhysicalParts(UniqueNameGenerator.createMemberV5ModelPart(cubeName, level), UniqueNameGenerator.createMemberV5PhysicalPart(providerType, externalName));
        }
        return v5UniqueName;
    }

    public static String createMemberV5UniqueName(IHierarchy hierarchy, String externalName) {
        String v5UniqueName = null;
        if (hierarchy == null) {
            v5UniqueName = externalName;
        } else if (hierarchy.getDimension().isMeasuresDimension()) {
            IMember measure = hierarchy.getMember(UniqueNameGenerator.cleanIdentifier(externalName));
            if (measure != null) {
                v5UniqueName = measure.getV5UniqueName();
            }
        } else {
            String providerType = hierarchy.getDimension().getCube().getModelDataSource().getInterface();
            v5UniqueName = UniqueNameGenerator.joinModelPhysicalParts(UniqueNameGenerator.createMemberV5ModelPart(hierarchy), UniqueNameGenerator.createMemberV5PhysicalPart(providerType, externalName));
        }
        return v5UniqueName;
    }

    public static String createMemberV5PhysicalPart(String providerCode, String externalName) {
        IDataProvider provider = ProviderManager.getInstance().getProvider(providerCode);
        if (provider == null) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_DataProviderNotFound, providerCode);
        }
        String physicalPart = provider.nativeUNToCognosUN(providerCode, externalName);
        return UniqueNameGenerator.join(UniqueNameGenerator.createUniqueName(providerCode), physicalPart);
    }

    public static String createMemberExternalName(IHierarchy hierarchy, String v5NamePart) {
        String providerType;
        int pos;
        String memberUniquename = null;
        if (v5NamePart == null || v5NamePart.isEmpty() || hierarchy == null) {
            return memberUniquename;
        }
        String trimmedName = v5NamePart;
        if (v5NamePart.startsWith(PHYSICAL_NAME_PREFIX) && (pos = v5NamePart.indexOf(DOT_SEPARATOR)) > 0) {
            trimmedName = v5NamePart.substring(pos + 2);
        }
        if ((providerType = hierarchy.getDimension().getCube().getModelDataSource().getInterface()) == null) {
            memberUniquename = hierarchy.getUniqueName() + DOT + trimmedName;
        } else {
            IDataProvider provider = ProviderManager.getInstance().getProvider(providerType);
            if (provider == null) {
                throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_DataProviderNotFound, providerType);
            }
            memberUniquename = provider.cognosUNToNativeUN(providerType, hierarchy, trimmedName);
        }
        return memberUniquename;
    }

    public static String createProviderMemberUniqueName(String providerType, String v5NamePart) {
        int pos;
        if (v5NamePart == null || providerType == null) {
            return null;
        }
        IDataProvider provider = ProviderManager.getInstance().getProvider(providerType);
        if (provider == null) {
            throw new OLAPXNodeRuntimeException(XQEMessageKeys.EXE_DataProviderNotFound, providerType);
        }
        String trimmedName = v5NamePart;
        if (v5NamePart.startsWith(OPEN_BRACE) && (pos = v5NamePart.indexOf(DOT_SEPARATOR)) > 0) {
            trimmedName = v5NamePart.substring(pos + 2, v5NamePart.length());
        }
        return trimmedName;
    }

    public static String createProviderMemberUniqueName(IHierarchy hierarchy, String v5NamePart) {
        if (v5NamePart == null || hierarchy == null) {
            return null;
        }
        String providerType = hierarchy.getDimension().getCube().getModelDataSource().getInterface();
        return UniqueNameGenerator.createProviderMemberUniqueName(providerType, v5NamePart);
    }

    public static String extractLeftPartFromCognosMUN(String cognosMUN) {
        String leftName = null;
        if (null != cognosMUN) {
            int index = cognosMUN.indexOf("]->:[");
            if (index == -1) {
                index = cognosMUN.indexOf("]->[");
            }
            if (index != -1) {
                leftName = cognosMUN.substring(0, index + 1);
            }
        }
        return leftName;
    }

    public static String extractRightPartFromCognosMUN(String cognosMUN) {
        String rightName = null;
        if (null != cognosMUN) {
            int index = cognosMUN.indexOf("]->:[");
            if (index != -1) {
                rightName = cognosMUN.substring(index + "]->:[".length() - 1, cognosMUN.length());
            } else {
                index = cognosMUN.indexOf("]->[");
                if (index != -1) {
                    rightName = cognosMUN.substring(index + "]->[".length() - 1, cognosMUN.length());
                }
            }
        }
        return rightName;
    }

    public static String extractPhysicalPartFromCognosMUN(String cognosMUN) {
        int index;
        String rightName = null;
        if (null != cognosMUN && (index = cognosMUN.indexOf(PHYSICAL_NAME_PREFIX)) != -1) {
            rightName = cognosMUN.substring(index + 1, cognosMUN.length());
        }
        return rightName;
    }

    public static String extractLogicalPartFromCognosMUN(String cognosMUN) {
        int index;
        String rightName = null;
        if (null != cognosMUN && (index = cognosMUN.indexOf("]->[")) != -1 && (index = (rightName = cognosMUN.substring(index + "]->[".length() - 1, cognosMUN.length())).indexOf(PHYSICAL_NAME_PREFIX)) != -1) {
            rightName = rightName.substring(0, index);
        }
        return rightName;
    }

    public static String resolveExternalNameForMUN(V5MemberUniqueName v5MemberUniqueName, PlanningEnvironment environment) {
        String externalName = null;
        PlannedV5QuerySet v5QuerySet = V5SubQueryBuilder.planSingleExpressionQuery(v5MemberUniqueName.getNativeName(), environment, false);
        if (v5QuerySet == null) {
            return null;
        }
        List<IXQEQueryNode> mdxQueries = v5QuerySet.getDescendantsOfCategory(501017, true);
        if (mdxQueries.size() == 1) {
            if (mdxQueries.get(0).getType() == 501017) {
                IXQEQueryNode[] mdxBaseMembers = v5QuerySet.getDescendantsOfType(1067, true);
                if (mdxBaseMembers.length != 1) {
                    v5MemberUniqueName.throwInternalError("Sub-Query planning did not result in exactly 1 base member.");
                }
                BaseMember baseMember = (BaseMember)mdxBaseMembers[0];
                externalName = baseMember.getExternalName();
            } else if (mdxQueries.get(0).getType() == 501053) {
                XMdxLocal xMdxLocal = (XMdxLocal)mdxQueries.get(0);
                MDXQuery mdxQuery = xMdxLocal.getMDXQuery();
                List<IXQEQueryNode> mdxBaseMembers = mdxQuery.getDescendantsOfTypeOrdered(1067, true);
                if (mdxBaseMembers.size() != 1) {
                    v5MemberUniqueName.throwInternalError("Sub-Query planning did not request for exactly 1 base member.");
                }
                BaseMember baseMember = (BaseMember)mdxBaseMembers.get(0);
                externalName = baseMember.getExternalName();
            } else {
                v5MemberUniqueName.throwInternalError("Sub-Query planning did not result in a known query type.");
            }
        } else {
            v5MemberUniqueName.throwInternalError("Sub-Query planning did not result in exactly 1 query.");
        }
        return externalName;
    }

    public static String resolveExternalNameForDateTimeConstant(String expression, PlanningEnvironment environment) {
        PlannedV5QuerySet v5QuerySet = V5SubQueryBuilder.planSingleExpressionQuery(expression, environment, false);
        if (v5QuerySet == null) {
            return null;
        }
        String externalName = expression;
        List<IXQEQueryNode> mdxQueries = v5QuerySet.getDescendantsOfCategory(501017, true);
        if (mdxQueries.size() == 1) {
            if (mdxQueries.get(0).getType() == 501017) {
                IXQEQueryNode[] mdxConstant = v5QuerySet.getDescendantsOfType(1151, true);
                if (mdxConstant.length != 1) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Sub-Query planning did not result in exactly 1 constant.");
                }
                MDXDateTimeConstant constant = (MDXDateTimeConstant)mdxConstant[0];
                externalName = constant.getConstantValue().getString();
            } else if (mdxQueries.get(0).getType() == 501053) {
                IXQEQueryNode[] xMdxStringPrimary = v5QuerySet.getDescendantsOfType(501073, true);
                if (xMdxStringPrimary.length != 1) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Sub-Query planning did not result in exactly 1 constant in LOLAP mode.");
                }
                XMdxNode literal = (XMdxNode)xMdxStringPrimary[0];
                externalName = literal.getPropertyValue("stringValue").toString();
            }
        }
        return externalName;
    }

    public static String getSAPBusinessKeyFromMUN(String propertyValue) {
        int partTwoEndInx;
        String memberUniqueNameKey = propertyValue;
        int partTwoStartInx = propertyValue.lastIndexOf(DOT_SEPARATOR);
        if (partTwoStartInx != -1 && (partTwoEndInx = propertyValue.indexOf(CLOSE_BRACE, partTwoStartInx += 3)) != -1 && ((memberUniqueNameKey = propertyValue.substring(partTwoStartInx, partTwoEndInx)) == null || memberUniqueNameKey.length() == 0)) {
            memberUniqueNameKey = "#";
        }
        return memberUniqueNameKey;
    }

    public static boolean hasOutterBraces(String name) {
        return name.startsWith(OPEN_BRACE) && name.endsWith(CLOSE_BRACE);
    }

    private static String createROLAPV5UniqueName(ICube cube, String locale) {
        INamespace ns = cube.getNamespace();
        if (null != ns) {
            return cube.getNamespace().getV5UniqueName();
        }
        return UniqueNameGenerator.createUniqueName(((IROLAPCube)((Object)cube)).getName(locale));
    }

    public static String createROLAPV5UniqueName(ICube cube, String locale, IROLAPDimension dimension) {
        return UniqueNameGenerator.appendUniqueName(UniqueNameGenerator.createROLAPV5UniqueName(cube, locale), UniqueNameGenerator.cleanIdentifier(dimension.getName(locale)));
    }

    public static String createROLAPV5UniqueName(String cubeName, String locale, IROLAPHierarchy hierarchy) {
        if (hierarchy.getDimension().isMeasuresDimension()) {
            return hierarchy.getDimension().getV5UniqueName();
        }
        if (!hierarchy.isAutoGenerated()) {
            String dimensionV5UN = ((IROLAPDimension)hierarchy.getDimension()).getV5UniqueName(cubeName);
            if (dimensionV5UN.charAt(0) != '[') {
                dimensionV5UN = UniqueNameGenerator.createUniqueName(dimensionV5UN);
            }
            return UniqueNameGenerator.appendUniqueName(dimensionV5UN, UniqueNameGenerator.cleanIdentifier(hierarchy.getName(locale)));
        }
        return null;
    }

    public static String createROLAPV5UniqueName(String cubeName, String locale, IROLAPLevel level) {
        if (level.getDimension().isMeasuresDimension() || level.getHierarchy().isParentChild() || level.isAutoGenerated()) {
            return null;
        }
        return UniqueNameGenerator.appendUniqueName(((IROLAPHierarchy)level.getHierarchy()).getV5UniqueName(cubeName), UniqueNameGenerator.cleanIdentifier(level.getName(locale)));
    }
}

