/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class WeakHashSet<E>
extends AbstractSet<E>
implements Set<E> {
    private static final Object DUMMY_VALUE = new Object();
    private final Map<E, Object> mBackingMap = new WeakHashMap<E, Object>();

    public WeakHashSet() {
    }

    public WeakHashSet(Collection<? extends E> c) {
        this.addAll(c);
    }

    @Override
    public boolean add(E o) {
        if (this.mBackingMap.containsKey(o)) {
            return false;
        }
        this.mBackingMap.put(o, DUMMY_VALUE);
        return true;
    }

    @Override
    public void clear() {
        this.mBackingMap.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.mBackingMap.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.mBackingMap.keySet().containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.mBackingMap.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.mBackingMap.keySet().iterator();
    }

    @Override
    public boolean remove(Object o) {
        return this.mBackingMap.keySet().remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.mBackingMap.keySet().removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.mBackingMap.keySet().retainAll(c);
    }

    @Override
    public int size() {
        return this.mBackingMap.size();
    }

    @Override
    public Object[] toArray() {
        return this.mBackingMap.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.mBackingMap.keySet().toArray(a);
    }

    @Override
    public String toString() {
        return this.mBackingMap.keySet().toString();
    }
}

