/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.bean;

import com.cognos.xqe.data.values.ValueConversionException;
import com.cognos.xqe.data.values.ValueRuntimeException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.util.bean.BeanClassIntrospection;
import com.cognos.xqe.util.bean.BeanException;
import com.cognos.xqe.util.bean.BeanMethodIntrospection;
import com.cognos.xqe.util.bean.BeanPropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.TreeMap;

public final class BeanPropertySupport {
    private static final String ERRMSG_BEAN_WAS_NULL = "bean was null";
    private static final String ERRMSG_PROPERTY_NAME_WAS_NULL = "propertyName was null";
    private static final String GET = "get";
    private static final String SET = "set";
    private static final String IS = "is";
    private static final int TWO = 2;
    private static final int THREE = 3;
    private final Class<?> beanClass;
    private final TreeMap<String, BeanPropertyDescriptor> propertyDescriptorMap = new TreeMap();

    public BeanPropertySupport(Class<?> theBeanClass) {
        this.beanClass = theBeanClass;
        this.introspectBeanProperties();
    }

    public String[] getPropertyNames() {
        return this.propertyDescriptorMap.keySet().toArray(new String[0]);
    }

    public BeanPropertyDescriptor[] getPropertyDescriptors() {
        return this.propertyDescriptorMap.values().toArray(new BeanPropertyDescriptor[0]);
    }

    public BeanPropertyDescriptor getPropertyDescriptor(String propertyName) {
        return this.propertyDescriptorMap.get(propertyName);
    }

    public boolean supportsProperty(String propertyName) {
        return this.propertyDescriptorMap.containsKey(propertyName);
    }

    public Object getPropertyValue(Object bean, String propertyName) throws BeanException, NullPointerException {
        if (null == bean) {
            throw new NullPointerException(ERRMSG_BEAN_WAS_NULL);
        }
        if (null == propertyName) {
            throw new NullPointerException(ERRMSG_PROPERTY_NAME_WAS_NULL);
        }
        if (!this.beanClass.isAssignableFrom(bean.getClass())) {
            throw BeanException.createUnexpectedBeanTypeException(bean.getClass(), this.beanClass);
        }
        BeanPropertyDescriptor descriptor = this.propertyDescriptorMap.get(propertyName);
        if (null == descriptor) {
            throw BeanException.createUnsupportedBeanPropertyException(propertyName, this.beanClass);
        }
        if (null == descriptor.getAccessorMethod()) {
            throw BeanException.createMissingBeanPropertyAccessorException(propertyName, this.beanClass);
        }
        Object result = null;
        try {
            result = descriptor.getAccessorMethod().invoke(bean, new Object[0]);
        }
        catch (Exception cause) {
            throw BeanException.createBeanAccessErrorException(cause, propertyName, this.beanClass);
        }
        return result;
    }

    public void setPropertyValue(Object bean, String propertyName, Object value) throws BeanException, NullPointerException, ValueRuntimeException {
        if (null == bean) {
            throw new NullPointerException(ERRMSG_BEAN_WAS_NULL);
        }
        if (null == propertyName) {
            throw new NullPointerException(ERRMSG_PROPERTY_NAME_WAS_NULL);
        }
        if (!this.beanClass.isAssignableFrom(bean.getClass())) {
            throw BeanException.createUnexpectedBeanTypeException(bean.getClass(), this.beanClass);
        }
        BeanPropertyDescriptor descriptor = this.propertyDescriptorMap.get(propertyName);
        if (null == descriptor) {
            throw BeanException.createUnsupportedBeanPropertyException(propertyName, this.beanClass);
        }
        if (null == value && !descriptor.isNullable()) {
            throw new ValueConversionException(XQEMessageKeys.DAT_NullValueNotAllowed);
        }
        if (null == descriptor.getMutatorMethod()) {
            throw BeanException.createMissingBeanPropertyMutatorException(propertyName, this.beanClass);
        }
        try {
            descriptor.getMutatorMethod().invoke(bean, value);
        }
        catch (Exception cause) {
            throw BeanException.createBeanAccessErrorException(cause, propertyName, this.beanClass);
        }
    }

    private void introspectBeanProperties() {
        Method[] methods = this.beanClass.getMethods();
        BeanClassIntrospection classHint = this.beanClass.getAnnotation(BeanClassIntrospection.class);
        boolean introspectAll = true;
        if (classHint != null) {
            introspectAll = classHint.enabled();
        }
        for (int i = 0; i < methods.length; ++i) {
            BeanPropertyDescriptor descriptor;
            String propertyName;
            Class<?> returnType;
            Method currentMethod = methods[i];
            BeanMethodIntrospection methodHint = currentMethod.getAnnotation(BeanMethodIntrospection.class);
            boolean introspectMethod = introspectAll;
            if (methodHint != null) {
                introspectMethod = methodHint.enabled();
            }
            if (!introspectMethod || !Modifier.isPublic(currentMethod.getModifiers()) || currentMethod.getDeclaringClass().equals(Object.class)) continue;
            String methodName = currentMethod.getName();
            if (methodName.startsWith(GET)) {
                returnType = currentMethod.getReturnType();
                if (returnType.equals(Void.TYPE) || currentMethod.getParameterTypes().length != 0 || (propertyName = methodName.substring(3)).length() == 0) continue;
                propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
                if (methodHint != null && methodHint.propertyName() != null && methodHint.propertyName().length() > 0) {
                    propertyName = methodHint.propertyName();
                }
                if (null == (descriptor = this.propertyDescriptorMap.get(propertyName))) {
                    descriptor = new BeanPropertyDescriptor();
                    descriptor.setName(propertyName);
                    descriptor.setDataType(returnType);
                    descriptor.setNullable(!returnType.isPrimitive());
                    descriptor.setAccessorMethod(currentMethod);
                    this.propertyDescriptorMap.put(propertyName, descriptor);
                    continue;
                }
                descriptor.setAccessorMethod(currentMethod);
                continue;
            }
            if (methodName.startsWith(IS)) {
                returnType = currentMethod.getReturnType();
                if (!returnType.equals(Boolean.TYPE) && !returnType.equals(Boolean.class) || currentMethod.getParameterTypes().length != 0 || (propertyName = methodName.substring(2)).length() == 0) continue;
                propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
                if (methodHint != null && methodHint.propertyName() != null && methodHint.propertyName().length() > 0) {
                    propertyName = methodHint.propertyName();
                }
                if (null == (descriptor = this.propertyDescriptorMap.get(propertyName))) {
                    descriptor = new BeanPropertyDescriptor();
                    descriptor.setName(propertyName);
                    descriptor.setDataType(returnType);
                    descriptor.setNullable(!returnType.isPrimitive());
                    descriptor.setAccessorMethod(currentMethod);
                    this.propertyDescriptorMap.put(propertyName, descriptor);
                    continue;
                }
                descriptor.setAccessorMethod(currentMethod);
                continue;
            }
            if (!methodName.startsWith(SET) || !currentMethod.getReturnType().equals(Void.TYPE) || currentMethod.getParameterTypes().length != 1) continue;
            Class<?> parameterType = currentMethod.getParameterTypes()[0];
            propertyName = methodName.substring(3);
            if (propertyName.length() == 0) continue;
            propertyName = Character.toLowerCase(propertyName.charAt(0)) + propertyName.substring(1);
            if (methodHint != null && methodHint.propertyName() != null && methodHint.propertyName().length() > 0) {
                propertyName = methodHint.propertyName();
            }
            if (null == (descriptor = this.propertyDescriptorMap.get(propertyName))) {
                descriptor = new BeanPropertyDescriptor();
                descriptor.setName(propertyName);
                descriptor.setDataType(parameterType);
                descriptor.setNullable(!parameterType.isPrimitive());
                descriptor.setMutatorMethod(currentMethod);
                this.propertyDescriptorMap.put(propertyName, descriptor);
                continue;
            }
            descriptor.setMutatorMethod(currentMethod);
        }
    }

    public String beanToString(Object bean) throws BeanException, NullPointerException {
        if (null == bean) {
            throw new NullPointerException(ERRMSG_BEAN_WAS_NULL);
        }
        if (!this.beanClass.isAssignableFrom(bean.getClass())) {
            throw BeanException.createUnexpectedBeanTypeException(bean.getClass(), this.beanClass);
        }
        StringBuilder buffer = new StringBuilder();
        for (String propertyName : this.getPropertyNames()) {
            Object propertyValue = this.getPropertyValue(bean, propertyName);
            buffer.append(propertyName).append("=");
            if (null == propertyValue) {
                buffer.append("null");
            } else if (bean == propertyValue) {
                buffer.append("this");
            } else {
                buffer.append(propertyValue.toString());
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }
}

