/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.concurrent;

import com.cognos.xqe.trace.XQEDebugLog;
import java.util.concurrent.atomic.AtomicInteger;

final class ThreadPoolTask
extends Thread {
    private static final AtomicInteger CREATED = new AtomicInteger();
    private static final AtomicInteger ALIVE = new AtomicInteger();

    ThreadPoolTask(Runnable r, String name) {
        super(r, name + "-" + CREATED.incrementAndGet());
    }

    @Override
    public void run() {
        XQEDebugLog.out.println("Created " + this.getName());
        try {
            ALIVE.incrementAndGet();
            super.run();
        }
        finally {
            ALIVE.decrementAndGet();
            XQEDebugLog.out.println("Exiting " + this.getName());
        }
    }

    public static int getThreadsCreated() {
        return CREATED.get();
    }

    public static int getThreadsAlive() {
        return ALIVE.get();
    }
}

