/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.concurrent.locks;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.concurrent.locks.CannotAcquireLockInExclusiveModeException;
import com.cognos.xqe.util.concurrent.locks.CannotAcquireLockInSharedModeException;
import com.cognos.xqe.util.concurrent.locks.InterruptibleReadWriteLock;
import com.cognos.xqe.util.concurrent.locks.LockInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LockManager {
    private static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "LockManagement", LogLevel.TRACE);
    private ConcurrentMap<String, ReadWriteLock> lockMap = new ConcurrentHashMap<String, ReadWriteLock>();
    private ConcurrentMap<Thread, List<LockInfo>> threadLockInfoMap = new ConcurrentHashMap<Thread, List<LockInfo>>();

    public void createLocks(String ... resources) {
        for (String resource : resources) {
            this.throwExceptionIfResourceIsInvalid(resource, false);
            InterruptibleReadWriteLock lock = new InterruptibleReadWriteLock(true);
            this.lockMap.put(resource, lock);
            LOGGER.log(String.format("The lock on the resource %s was created.", resource));
        }
    }

    public void removeLocks(String ... resources) {
        for (String resource : resources) {
            this.throwExceptionIfResourceIsInvalid(resource, true);
            this.lockMap.remove(resource);
            LOGGER.log(String.format("The lock on the resource %s was removed.", resource));
        }
    }

    public void acquireLockInSharedMode(String resource, long waitTime) throws CannotAcquireLockInSharedModeException {
        this.throwExceptionIfResourceIsInvalid(resource, true);
        LOGGER.log(String.format("The lock on the resource %s was requested in shared mode.", resource));
        boolean acquired = false;
        InterruptedException ie = null;
        Lock lock = this.getLockInSharedMode(resource);
        try {
            acquired = lock.tryLock(waitTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            ie = e;
        }
        if (!acquired) {
            LOGGER.log(String.format("The lock on the resource %s was not acquired in shared mode (%s)", resource, this.getLockInfo(resource)));
            this.traceAllThreadLocks();
            throw new CannotAcquireLockInSharedModeException(ie, resource);
        }
        LOGGER.log(String.format("The lock on the resource %s was acquired in shared mode.", resource));
        this.addThreadLock(resource, lock);
    }

    public void releaseLockInSharedMode(String resource) {
        this.throwExceptionIfResourceIsInvalid(resource, true);
        Lock lock = this.getLockInSharedMode(resource);
        lock.unlock();
        LOGGER.log(String.format("The lock on the resource %s was released in shared mode.", resource));
        this.removeThreadLock(resource, lock);
    }

    public void acquireLockInExclusiveMode(String resource, long waitTime) throws CannotAcquireLockInExclusiveModeException {
        this.throwExceptionIfResourceIsInvalid(resource, true);
        LOGGER.log(String.format("The lock on the resource %s was requested in exclusive mode.", resource));
        boolean acquired = false;
        InterruptedException ie = null;
        Lock lock = this.getLockInExclusiveMode(resource);
        try {
            acquired = lock.tryLock(waitTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            ie = e;
        }
        if (!acquired) {
            LOGGER.log(String.format("The lock on the resource %s was not acquired in exclusive mode (%s)", resource, this.getLockInfo(resource)));
            this.traceAllThreadLocks();
            throw new CannotAcquireLockInExclusiveModeException(ie, resource);
        }
        LOGGER.log(String.format("The lock on the resource %s was acquired in exclusive mode.", resource));
        this.addThreadLock(resource, lock);
    }

    public void releaseLockInExclusiveMode(String resource) {
        this.throwExceptionIfResourceIsInvalid(resource, true);
        Lock lock = this.getLockInExclusiveMode(resource);
        lock.unlock();
        LOGGER.log(String.format("The lock on the resource %s was released in exclusive mode.", resource));
        this.removeThreadLock(resource, lock);
    }

    public Condition newCondition(String resource) {
        this.throwExceptionIfResourceIsInvalid(resource, true);
        Lock lock = this.getLockInExclusiveMode(resource);
        return lock.newCondition();
    }

    private Lock getLockInSharedMode(String resource) {
        ReadWriteLock readWriteLock = (ReadWriteLock)this.lockMap.get(resource);
        return readWriteLock.readLock();
    }

    private Lock getLockInExclusiveMode(String resource) {
        ReadWriteLock readWriteLock = (ReadWriteLock)this.lockMap.get(resource);
        return readWriteLock.writeLock();
    }

    private void throwExceptionIfResourceIsInvalid(String resource, boolean isExpectedToExist) {
        if (resource == null) {
            throw new IllegalArgumentException("The resource is null.");
        }
        if (isExpectedToExist && !this.lockMap.containsKey(resource)) {
            throw new IllegalArgumentException(String.format("A lock on the resource \"%s\" does not exist.", resource));
        }
        if (!isExpectedToExist && this.lockMap.containsKey(resource)) {
            throw new IllegalArgumentException(String.format("A lock on the resource \"%s\" already exists.", resource));
        }
    }

    private void addThreadLock(String resource, Lock lock) {
        if (!LOGGER.isOn(LogLevel.TRACE)) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        ArrayList<LockInfo> lockInfoList = (ArrayList<LockInfo>)this.threadLockInfoMap.get(currentThread);
        if (lockInfoList == null) {
            lockInfoList = new ArrayList<LockInfo>();
            this.threadLockInfoMap.put(currentThread, lockInfoList);
        }
        lockInfoList.add(new LockInfo(resource, lock));
        this.traceCurrentThreadLocks();
    }

    private void removeThreadLock(String resource, Lock lock) {
        if (!LOGGER.isOn(LogLevel.TRACE)) {
            return;
        }
        Thread currentThread = Thread.currentThread();
        List lockInfoList = (List)this.threadLockInfoMap.get(currentThread);
        int lockInfoCount = lockInfoList.size();
        for (int lockInfoIndex = lockInfoCount - 1; lockInfoIndex >= 0; --lockInfoIndex) {
            LockInfo lockInfo = (LockInfo)lockInfoList.get(lockInfoIndex);
            if (lock != lockInfo.getLock() || !resource.equals(lockInfo.getResource())) continue;
            lockInfoList.remove(lockInfoIndex);
            break;
        }
        if (lockInfoList.isEmpty()) {
            this.threadLockInfoMap.remove(currentThread);
        }
        this.traceCurrentThreadLocks();
    }

    private void traceCurrentThreadLocks() {
        if (!LOGGER.isOn(LogLevel.TRACE)) {
            return;
        }
        this.traceThreadLocks(Thread.currentThread());
    }

    private void traceAllThreadLocks() {
        if (!LOGGER.isOn(LogLevel.TRACE)) {
            return;
        }
        for (Thread thread : this.threadLockInfoMap.keySet()) {
            this.traceThreadLocks(thread);
        }
    }

    private void traceThreadLocks(Thread thread) {
        List lockInfoList = (List)this.threadLockInfoMap.get(thread);
        StringBuilder lockInfoBuffer = new StringBuilder();
        if (lockInfoList == null || lockInfoList.isEmpty()) {
            lockInfoBuffer.append("[]");
        } else {
            lockInfoBuffer.append("[ ");
            Iterator lockInfoListIterator = lockInfoList.iterator();
            while (lockInfoListIterator.hasNext()) {
                LockInfo lockInfo = (LockInfo)lockInfoListIterator.next();
                String resource = lockInfo.getResource();
                Lock lock = lockInfo.getLock();
                lockInfoBuffer.append(resource);
                lockInfoBuffer.append("-");
                if (lock instanceof ReentrantReadWriteLock.ReadLock) {
                    lockInfoBuffer.append("S");
                } else {
                    lockInfoBuffer.append("X");
                }
                if (!lockInfoListIterator.hasNext()) continue;
                lockInfoBuffer.append(", ");
            }
            lockInfoBuffer.append(" ]");
        }
        String lockInfoString = lockInfoBuffer.toString();
        String current = "";
        if (thread == Thread.currentThread()) {
            current = "(current) ";
        }
        LOGGER.log(String.format("The thread %s %sholds locks on the resources: %s ", thread.getName(), current, lockInfoString));
    }

    private String getLockInfo(String resource) {
        InterruptibleReadWriteLock lock = (InterruptibleReadWriteLock)this.lockMap.get(resource);
        return lock.toString();
    }
}

