/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.context;

import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.context.ContextStack;
import com.cognos.xqe.util.context.ContextTransfer;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class Context {
    private static final boolean DEBUG_TRACE_ENTER_EXIT = false;
    private static final String HAS_NO_CONTEXT_TO_EXIT_FROM = " has no context to exit from";
    private static final ThreadLocal<ContextBinding> BINDING = new ThreadLocal<ContextBinding>(){

        @Override
        public ContextBinding initialValue() {
            return new ContextBinding();
        }
    };
    private volatile Thread owner = null;
    private Context next = null;
    private String enterStackTrace = null;
    private String exitStackTrace = null;

    protected Context() {
    }

    public final Thread getOwner() {
        return this.owner;
    }

    protected final Context getNext() {
        return this.next;
    }

    protected abstract boolean isTransferable();

    protected abstract Context transferableClone() throws UnsupportedOperationException;

    protected abstract void onEnter();

    protected abstract void onExit();

    protected static Context enter(Context ctx) throws IllegalStateException {
        if (null != ctx.owner) {
            throw new IllegalStateException("Context was in use by thread " + ctx.owner.toString());
        }
        ctx.owner = Thread.currentThread();
        BINDING.get().pushContext(ctx);
        ctx.onEnter();
        return ctx;
    }

    protected static Context exit(Class<? extends Context> ctxClass) {
        Context ctx = BINDING.get().currentContext(ctxClass);
        if (null == ctx) {
            throw new IllegalStateException(Thread.currentThread() + HAS_NO_CONTEXT_TO_EXIT_FROM);
        }
        try {
            ctx.onExit();
        }
        finally {
            ctx = BINDING.get().popContext(ctxClass);
            ctx.owner = null;
        }
        return ctx;
    }

    protected void exitContext(Class<? extends Context> ctxClass) {
        Context ctx = BINDING.get().currentContext(ctxClass);
        if (null == ctx) {
            throw new IllegalStateException(Thread.currentThread() + HAS_NO_CONTEXT_TO_EXIT_FROM);
        }
        if (ctx != this) {
            throw new IllegalStateException(Thread.currentThread() + " context mismatch");
        }
        try {
            this.onExit();
        }
        finally {
            BINDING.get().popContext(ctxClass);
            this.owner = null;
        }
    }

    public static String emptyAll() {
        ContextBinding contextBinding = BINDING.get();
        String nonEmptyStacks = null != contextBinding ? contextBinding.emptyAll() : null;
        return nonEmptyStacks;
    }

    static void pushTransfer(Context ctx) {
        ctx.owner = Thread.currentThread();
        BINDING.get().pushContext(ctx);
    }

    static void popTransfer(Class<? extends Context> ctxClass) {
        Context ctx = BINDING.get().popContext(ctxClass);
        ctx.owner = null;
    }

    public static ContextTransfer createTransfer(Class<? extends Context> ctxClass) {
        return new ContextTransfer(ctxClass, BINDING.get().contextIterator(ctxClass));
    }

    protected static <T extends Context> T getCurrent(Class<T> ctxClass) {
        return BINDING.get().currentContext(ctxClass);
    }

    public static void printStackTrace() {
        Context.printStackTrace(XQEDebugLog.out);
    }

    public static void printStackTrace(PrintStream stream) {
        Map stacks = Context.BINDING.get().getContextStacks();
        for (Class cls : stacks.keySet()) {
            ContextStack stack = (ContextStack)stacks.get(cls);
            Iterator<Context> contextIter = stack.iterator();
            stream.print("Context stack for class ");
            stream.print(cls.getSimpleName());
            stream.print(" and thread ");
            stream.println(Thread.currentThread());
            stream.println('{');
            while (contextIter.hasNext()) {
                stream.println(contextIter.next());
            }
            stream.println('}');
        }
    }

    private static String getStackTrace() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        StringBuilder buffer = new StringBuilder();
        for (StackTraceElement e : stack) {
            buffer.append(e.toString()).append(" at\n");
        }
        return buffer.toString();
    }

    private static class ContextBinding {
        private final HashMap<Class<? extends Context>, ContextStack> keyedContexts = new HashMap();

        private ContextBinding() {
        }

        public Iterator<Context> contextIterator(Class<? extends Context> ctxClass) {
            ContextStack aStack = this.keyedContexts.get(ctxClass);
            if (aStack == null) {
                return new ContextStack().iterator();
            }
            return aStack.iterator();
        }

        private Map<Class<? extends Context>, ContextStack> getContextStacks() {
            return this.keyedContexts;
        }

        public <T extends Context> T currentContext(Class<T> ctxClass) {
            ContextStack aStack = this.keyedContexts.get(ctxClass);
            if (aStack == null) {
                return null;
            }
            return (T)aStack.peek();
        }

        public Context popContext(Class<? extends Context> ctxClass) {
            ContextStack aStack = this.keyedContexts.get(ctxClass);
            if (aStack == null) {
                return null;
            }
            return aStack.pop();
        }

        public void pushContext(Context ctx) {
            Class<?> key = ctx.getClass();
            ContextStack aStack = this.keyedContexts.get(key);
            if (aStack != null) {
                Context oldTop = aStack.peek();
                ctx.next = oldTop;
            } else {
                aStack = new ContextStack();
                this.keyedContexts.put(key, aStack);
            }
            aStack.push(ctx);
        }

        public String emptyAll() {
            StringBuilder stringBuilder = null;
            for (Map.Entry<Class<? extends Context>, ContextStack> entry : this.keyedContexts.entrySet()) {
                ContextStack contextStack = entry.getValue();
                if (null == contextStack || contextStack.isEmpty()) continue;
                if (null == stringBuilder) {
                    stringBuilder = new StringBuilder();
                }
                stringBuilder.append(entry.getKey().getSimpleName());
                stringBuilder.append("\n");
                contextStack.emptyAll();
            }
            String nonEmptyStacks = null == stringBuilder ? null : stringBuilder.toString();
            return nonEmptyStacks;
        }
    }
}

