/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.context;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.context.Context;
import com.cognos.xqe.util.context.ContextTransfer;

public class ExecutionEnvironmentContext
extends Context {
    private static final String LOG_ENDDING_STRING = ").";
    private final IExecutionEnvironment env;
    private static XQELogger logger = null;

    protected ExecutionEnvironmentContext(IExecutionEnvironment theEnv) {
        if (null == theEnv) {
            throw new NullPointerException("theEnv was null");
        }
        this.env = theEnv;
    }

    @Override
    protected boolean isTransferable() {
        return true;
    }

    @Override
    protected Context transferableClone() throws UnsupportedOperationException {
        return new ExecutionEnvironmentContext(this.env);
    }

    @Override
    protected void onEnter() {
        if (logger == null) {
            logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ExecutionEnvironmentContext", LogLevel.INFO);
        }
        if (logger.isOn()) {
            logger.log("Enter ExecutionEnvironmentContext (" + this.env + LOG_ENDDING_STRING);
        }
    }

    @Override
    protected void onExit() {
        if (logger.isOn()) {
            logger.log("Exit ExecutionEnvironmentContext (" + this.env + LOG_ENDDING_STRING);
        }
    }

    public static ExecutionEnvironmentContext enter(IExecutionEnvironment env) {
        ExecutionEnvironmentContext ctx = new ExecutionEnvironmentContext(env);
        Context.enter(ctx);
        return ctx;
    }

    public void exit() {
        this.exitContext(ExecutionEnvironmentContext.class);
    }

    public static IExecutionEnvironment getExecutionEnvironment() {
        ExecutionEnvironmentContext context = ExecutionEnvironmentContext.getCurrent(ExecutionEnvironmentContext.class);
        if (context == null) {
            return null;
        }
        return context.env;
    }

    public static ContextTransfer createTransfer() {
        return Context.createTransfer(ExecutionEnvironmentContext.class);
    }

    public String toString() {
        return this.env.toString();
    }
}

