/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.context;

import com.cognos.xqe.util.context.Context;
import com.cognos.xqe.util.usage.UsageTrackingService;
import com.cognos.xqe.util.usage.indicators.UsageIndicatorCategory;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class UsageSummaryContext
extends Context {
    String reportName = null;
    Map<UsageIndicatorCategory, Map<String, AtomicLong>> categoryMap = new HashMap<UsageIndicatorCategory, Map<String, AtomicLong>>();

    public static UsageSummaryContext enter() {
        UsageSummaryContext ctx = new UsageSummaryContext();
        Context.enter(ctx);
        return ctx;
    }

    public void exit() {
        this.exitContext(UsageSummaryContext.class);
    }

    @Override
    protected boolean isTransferable() {
        return false;
    }

    @Override
    protected Context transferableClone() throws UnsupportedOperationException {
        return null;
    }

    @Override
    protected void onEnter() {
    }

    @Override
    protected void onExit() {
        if (this.reportName == null && this.categoryMap.size() > 0) {
            this.reportName = "unknown";
        }
        for (Map.Entry<UsageIndicatorCategory, Map<String, AtomicLong>> mapEntry : this.categoryMap.entrySet()) {
            UsageIndicatorCategory category = mapEntry.getKey();
            for (Map.Entry<String, AtomicLong> indEntry : mapEntry.getValue().entrySet()) {
                String indicator = indEntry.getKey();
                UsageTrackingService.updatePerReportValue(this.reportName, category, indicator, indEntry.getValue().getAndSet(0L));
            }
        }
    }

    public static String getReportName() {
        UsageSummaryContext ctx = UsageSummaryContext.getCurrent(UsageSummaryContext.class);
        if (ctx == null) {
            return null;
        }
        return ctx.reportName;
    }

    public static void setReportName(String reportName) {
        UsageSummaryContext ctx = UsageSummaryContext.getCurrent(UsageSummaryContext.class);
        if (ctx == null) {
            return;
        }
        ctx.reportName = reportName;
    }

    public static AtomicLong getOrCreateReportValue(UsageIndicatorCategory category, String indicator) {
        AtomicLong val;
        UsageSummaryContext ctx = UsageSummaryContext.getCurrent(UsageSummaryContext.class);
        if (ctx == null) {
            return null;
        }
        Map<String, AtomicLong> indicatorToLongMap = ctx.categoryMap.get((Object)category);
        if (indicatorToLongMap == null) {
            indicatorToLongMap = new HashMap<String, AtomicLong>();
            ctx.categoryMap.put(category, indicatorToLongMap);
        }
        if ((val = indicatorToLongMap.get(indicator)) == null) {
            val = new AtomicLong(0L);
            indicatorToLongMap.put(indicator, val);
        }
        return val;
    }
}

