/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.datasets;

import com.cognos.xqe.config.ConfigService;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.SingletonHelper;
import com.cognos.xqe.util.datasets.FlintServerManager;
import com.cognos.xqe.util.datasets.FlintUtils;
import com.cognos.xqe.util.datasets.IDatasetManager;
import com.cognos.xqe.util.datasets.IFlintServerManager;
import com.cognos.xqe.util.datasets.MetadataInfo;
import com.cognos.xqe.util.datasets.MetadataInfoFactory;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;

public final class DatasetManager
implements IDatasetManager {
    private static SingletonHelper<DatasetManager> singletonHelper = new SingletonHelper<DatasetManager>(){

        @Override
        protected DatasetManager newInstance() {
            return new DatasetManager();
        }

        @Override
        protected void initializeImpl(DatasetManager theInstance) {
            theInstance.initializeImpl();
        }

        @Override
        protected void releaseImpl(DatasetManager theInstance) {
            theInstance.releaseImpl();
        }
    };
    public static final String META_DIR_PREFIX = "meta_";
    private static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "DatasetManager", LogLevel.WARN);
    private Map<String, MetadataInfo> storeId2MetadataInfo = new HashMap<String, MetadataInfo>();
    private Map<String, ReadWriteLock> storeId2ReadWriteLock = new ConcurrentHashMap<String, ReadWriteLock>();
    private Map<String, ReentrantLock> flintDatasetName2PQConversionLock = new ConcurrentHashMap<String, ReentrantLock>();
    private Set<String> legacyPQStoreIds = new HashSet<String>();
    private ConcurrentHashMap<String, ReentrantLock> legacyPQStoreId2PQUpgradeLock = new ConcurrentHashMap();
    private final AtomicBoolean hasFlintServerManagerBeenInitialized = new AtomicBoolean(false);
    private FlintServerManager theFlintManager = new FlintServerManager();

    private DatasetManager() {
    }

    protected void initializeImpl() {
        String datasetDir = ConfigService.getInstance().getDatasetCacheDirectory();
        File datasetDirF = new File(datasetDir);
        if (!datasetDirF.exists()) {
            return;
        }
        for (File f : datasetDirF.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(DatasetManager.META_DIR_PREFIX);
            }
        })) {
            MetadataInfo mdInfo;
            if (!f.isDirectory() || (mdInfo = MetadataInfoFactory.readMetadataInfo(f.getAbsolutePath())) == null) continue;
            this.storeId2MetadataInfo.put(mdInfo.getStoreID(), mdInfo);
        }
        DatasetManager.eraseSelfJoinDatasetFiles(datasetDirF);
    }

    protected void releaseImpl() {
        this.theFlintManager.release();
        if (!this.storeId2MetadataInfo.isEmpty()) {
            this.storeId2MetadataInfo.clear();
        }
        if (!this.legacyPQStoreIds.isEmpty()) {
            this.legacyPQStoreIds.clear();
        }
    }

    public static IDatasetManager getInstance() {
        return singletonHelper.getInstance();
    }

    public static IDatasetManager getInstanceNoInit() {
        return singletonHelper.getInstance(true);
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    private static void eraseSelfJoinDatasetFiles(File rootDir) {
        try (Stream<Path> ls = Files.walk(rootDir.toPath(), 3, new FileVisitOption[0]);){
            ((Stream)ls.parallel()).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                String fileName = path.getFileName().toString();
                Matcher matcher = FlintUtils.HARD_LINK_PATTERN.matcher(fileName);
                if (!matcher.matches()) {
                    matcher = FlintUtils.COPY_FILE_PATTERN.matcher(fileName);
                }
                if (matcher.matches() && !FileUtils.deleteQuietly((File)path.toFile())) {
                    LOGGER.log(String.format("Cannot delete file: %s.", path));
                }
            });
        }
        catch (Exception e) {
            LOGGER.log(String.format("Cannot walk the dataset cache directory: %s.", rootDir), (Throwable)e);
        }
    }

    @Override
    public void initializeFlintServerManager() {
        XQEConfiguration xqeConfig;
        if (this.hasFlintServerManagerBeenInitialized.compareAndSet(false, true) && Boolean.parseBoolean((xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE)).getStringProperty("queryExecution.flintServer[@enabled]", "true"))) {
            this.theFlintManager.initialize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetadataInfo getMetadataInfo(String storeID) {
        this.storeId2ReadWriteLock.putIfAbsent(storeID, new ReentrantReadWriteLock());
        ReadWriteLock lock = this.storeId2ReadWriteLock.get(storeID);
        lock.readLock().lock();
        try {
            MetadataInfo metadataInfo = this.storeId2MetadataInfo.get(storeID);
            return metadataInfo;
        }
        finally {
            lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataInfo putMetadataInfo(String storeID, MetadataInfo mdInfo) {
        this.storeId2ReadWriteLock.putIfAbsent(storeID, new ReentrantReadWriteLock());
        ReadWriteLock lock = this.storeId2ReadWriteLock.get(storeID);
        lock.writeLock().lock();
        try {
            MetadataInfo metadataInfo = this.storeId2MetadataInfo.put(storeID, mdInfo);
            return metadataInfo;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean persistMetadataInfo(String storeID, MetadataInfo mdInfo) {
        boolean hasSucceded = false;
        this.storeId2ReadWriteLock.putIfAbsent(storeID, new ReentrantReadWriteLock());
        ReadWriteLock lock = this.storeId2ReadWriteLock.get(storeID);
        lock.writeLock().lock();
        try {
            String metadataDir = ConfigService.getInstance().getDatasetCacheDirectory() + META_DIR_PREFIX + storeID;
            hasSucceded = MetadataInfoFactory.persistMetadataInfoToLocalFS(metadataDir, mdInfo);
            if (hasSucceded) {
                this.storeId2MetadataInfo.put(storeID, mdInfo);
            }
        }
        finally {
            lock.writeLock().unlock();
        }
        return hasSucceded;
    }

    @Override
    public ReentrantLock getPQConversionLock(String flintDSName) {
        this.flintDatasetName2PQConversionLock.putIfAbsent(flintDSName, new ReentrantLock());
        return this.flintDatasetName2PQConversionLock.get(flintDSName);
    }

    @Override
    public IFlintServerManager getFlintServerManagerInstance() {
        return this.theFlintManager;
    }

    public ReentrantLock getPQUpgradeRequestToMoserLock(String storeID) {
        this.legacyPQStoreId2PQUpgradeLock.putIfAbsent(storeID, new ReentrantLock());
        return this.legacyPQStoreId2PQUpgradeLock.get(storeID);
    }

    public boolean hasConversionBeenRequested(String storeId) {
        return this.legacyPQStoreIds.contains(storeId);
    }

    public void markForConversion(String storeId) {
        this.legacyPQStoreIds.add(storeId);
    }
}

