/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.datasets;

import com.cognos.cm.plugin.Interface.CMDataSetPlugin;
import com.cognos.xqe.ast.sql.parser.SQLProcessor;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.RowValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.relational.dataset.RowTypeHelper;
import com.cognos.xqe.util.datasets.DatasetUtilHelper;
import com.cognos.xqe.util.datasets.FlintUtils;
import com.cognos.xqe.util.io.TempFileUtil;
import com.cognos.xqebifw.config.CCLConfigurationFactoryImpl;
import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import com.ibm.bi.org.apache.hadoop.io.ICryptoProvider;
import com.ibm.bi.platform.datasetutils.converters.ConverterOptions;
import com.ibm.bi.platform.datasetutils.metadata.Column;
import com.ibm.bi.platform.datasetutils.metadata.ColumnMetadata;
import com.ibm.bi.platform.datasetutils.metadata.RowSchema;
import com.ibm.bi.platform.datasetutils.metadata.TabularRowSchema;
import com.ibm.bi.platform.datasetutils.metadata.types.DecimalType;
import com.ibm.bi.platform.datasetutils.metadata.types.EIntrinsicType;
import com.ibm.bi.platform.datasetutils.metadata.types.Type;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetReadHelper;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetReaderBuilder;
import com.ibm.bi.platform.datasetutils.parquet.DatasetParquetWriterBuilder;
import com.ibm.bi.platform.datasetutils.parquet.ParquetVersionEnum;
import com.ibm.bi.platform.datasetutils.utils.ArrayRecord;
import com.ibm.bi.platform.datasetutils.utils.MetadataUtils;
import com.ibm.bi.platform.datasetutils.utils.ReadableRecord;
import com.ibm.bi.platform.datasetutils.utils.WritableRecord;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.format.FileMetaData;
import org.apache.parquet.format.Util;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import shaded.org.apache.hadoop.conf.Configuration;
import shaded.org.apache.hadoop.fs.Path;

public class DatasetUtil
implements CMDataSetPlugin {
    private static final String PARQUET = ".parquet";
    private final XQEConfiguration configuration;

    public DatasetUtil() {
        XQECCLConfigurationFactory.initialize(new CCLConfigurationFactoryImpl());
        this.configuration = XQEConfigurationManager.getInstance().getOrCreateXQEConfiguration();
        try {
            String className = this.configuration.getStringProperty("DependencyInjection.CryptoProvider[@name]", null);
            Class<?> clazz = Class.forName(className);
            CryptoProvider.initialize((ICryptoProvider)((ICryptoProvider)clazz.newInstance()));
        }
        catch (Exception e) {
            throw new XQERuntimeException(e);
        }
    }

    public void decrypt(InputStream inpStream, OutputStream outStream) throws Exception {
        File file = DatasetUtil.writeStreamToTempFile(inpStream);
        Path hadoopPath = new Path(file.getAbsolutePath());
        Configuration hadoopConf = FlintUtils.getHadoopConfiguration();
        DatasetParquetReadHelper readHelper = new DatasetParquetReadHelper();
        readHelper.readFooter(hadoopPath, hadoopConf);
        RowSchema recordSchema = readHelper.getRecordSchema();
        Map kvMetadata = readHelper.getKeyValueMetadata();
        RowType rowType = RowTypeHelper.resolveRowType(kvMetadata, recordSchema);
        DatasetUtilHelper.ValueAssigner[] assigners = new DatasetUtilHelper.ValueAssigner[recordSchema.getNumOfColumns()];
        for (int fieldIndex = 0; fieldIndex < assigners.length; ++fieldIndex) {
            ColumnMetadata fieldMeta = recordSchema.getColumnMetadata(fieldIndex);
            assigners[fieldIndex] = DatasetUtilHelper.createValueAssigner(fieldMeta);
        }
        ParquetReader recordReader = new DatasetParquetReaderBuilder(hadoopPath).withConf(hadoopConf).build();
        try (DataOutputStream oStream = new DataOutputStream(new GZIPOutputStream(outStream));){
            ReadableRecord record;
            ParquetMetadataConverter metadataConverter = new ParquetMetadataConverter();
            Util.writeFileMetaData((FileMetaData)metadataConverter.toParquetMetadata(1, readHelper.getParquetMetadata()), (OutputStream)oStream);
            oStream.writeUTF(rowType.getSQLText());
            RowValue row = DataValueFactory.createRowValue(rowType);
            long rowCount = 0L;
            while ((record = (ReadableRecord)recordReader.read()) != null) {
                DatasetUtilHelper.convertRecordToRow(++rowCount, row, record, assigners);
                row.encode(null, oStream);
            }
        }
        recordReader.close();
        TempFileUtil.deleteTempFile(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void encrypt(InputStream inpStream, OutputStream outStream) throws Exception {
        int blockSize = this.configuration.getIntegerProperty("dataset.parquet.blockSize[@value]", 0xA00000);
        int pageSize = this.configuration.getIntegerProperty("dataset.parquet.pageSize[@value]", 0x100000);
        CompressionCodecName codec = CompressionCodecName.valueOf((String)this.configuration.getStringProperty("dataset.parquet.compression[@codec]", "GZIP"));
        ParquetVersionEnum parquetVersion = ParquetVersionEnum.valueOf((String)this.configuration.getStringProperty("dataset.parquet.parquetVersion[@value]", "VERSION_1"));
        DataInputStream iStream = new DataInputStream(new GZIPInputStream(inpStream));
        DatasetParquetReadHelper helper = new DatasetParquetReadHelper();
        Configuration hadoopConf = FlintUtils.getHadoopConfiguration();
        helper.readFileMetadata((InputStream)iStream, hadoopConf);
        String rowTypeAsString = iStream.readUTF();
        RowType rowType = (RowType)SQLProcessor.parseDataType(rowTypeAsString);
        File file = TempFileUtil.getTempFile("datasetutil_encrypt_temp", PARQUET);
        Path hadoopPath = new Path(file.getAbsolutePath());
        RowSchema originalSchema = helper.getRecordSchema();
        ConverterOptions converterOpts = new ConverterOptions();
        HashMap<Integer, DecimalType> column2OriginalDecType = new HashMap<Integer, DecimalType>(originalSchema.getNumOfColumns());
        TabularRowSchema adjustedSchema = new TabularRowSchema();
        for (int fieldIndex = 0; fieldIndex < originalSchema.getNumOfColumns(); ++fieldIndex) {
            ColumnMetadata fieldMeta = originalSchema.getColumnMetadata(fieldIndex);
            Type originalType = fieldMeta.getType();
            if (ParquetVersionEnum.LEGACY != parquetVersion && EIntrinsicType.DECIMAL == originalType.getIntrinsicType()) {
                DecimalType adjustedType = MetadataUtils.adjustDecimalType((String)fieldMeta.getName(), (DecimalType)((DecimalType)originalType), (ConverterOptions)converterOpts);
                if (!adjustedType.equals((Object)originalType)) {
                    column2OriginalDecType.put(fieldIndex, (DecimalType)originalType);
                    adjustedSchema.appendColumn((ColumnMetadata)new Column(fieldMeta.getName(), fieldMeta.isNullable(), (Type)adjustedType));
                    continue;
                }
                adjustedSchema.appendColumn(fieldMeta);
                continue;
            }
            adjustedSchema.appendColumn(fieldMeta);
        }
        DatasetUtilHelper.RecordAssigner[] assigners = new DatasetUtilHelper.RecordAssigner[adjustedSchema.getNumOfColumns()];
        boolean shouldRemoveTrailingSpaces = ParquetVersionEnum.LEGACY != parquetVersion && converterOpts.shouldRemoveTrailingSpaces();
        for (int fieldIndex = 0; fieldIndex < assigners.length; ++fieldIndex) {
            ColumnMetadata fieldMeta = adjustedSchema.getColumnMetadata(fieldIndex);
            assigners[fieldIndex] = DatasetUtilHelper.createRecordAssigner(fieldMeta, shouldRemoveTrailingSpaces, converterOpts.getDecimalPolicy(), (DecimalType)column2OriginalDecType.get(fieldIndex));
        }
        ParquetWriter recordWriter = ((DatasetParquetWriterBuilder)((DatasetParquetWriterBuilder)((DatasetParquetWriterBuilder)((DatasetParquetWriterBuilder)((DatasetParquetWriterBuilder)new DatasetParquetWriterBuilder(hadoopPath, (RowSchema)adjustedSchema).withParquetVersion(parquetVersion).withTimeZoneId(parquetVersion != ParquetVersionEnum.LEGACY ? ZoneId.of("UTC") : null).withConf(hadoopConf)).withCompressionCodec(codec)).withRowGroupSize(blockSize)).withPageSize(pageSize)).withWriterVersion(ParquetProperties.WriterVersion.PARQUET_1_0)).build();
        RowValue row = DataValueFactory.createRowValue(rowType);
        ArrayRecord record = new ArrayRecord(originalSchema.getNumOfColumns());
        long rowCount = 0L;
        try {
            while (DatasetUtil.decodeRow(row, iStream)) {
                DatasetUtilHelper.convertRowToRecord(++rowCount, (WritableRecord)record, row, assigners);
                recordWriter.write((Object)record);
            }
        }
        finally {
            recordWriter.close();
            iStream.close();
        }
        try (FileInputStream fis = new FileInputStream(file);){
            IOUtils.copy((InputStream)fis, (OutputStream)outStream);
        }
        TempFileUtil.deleteTempFile(file);
    }

    private static File writeStreamToTempFile(InputStream in) throws IOException {
        File file = TempFileUtil.createTempFile("datasetutils_decrypt_temp", PARQUET);
        try (FileOutputStream fos = new FileOutputStream(file);){
            IOUtils.copy((InputStream)in, (OutputStream)fos);
        }
        return file;
    }

    private static boolean decodeRow(IRow targetRow, DataInputStream sourceStream) throws IOException {
        try {
            targetRow.decode(null, sourceStream);
            return true;
        }
        catch (EOFException ex) {
            return false;
        }
    }
}

