/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.datasets;

import com.cognos.xqe.data.values.IRow;
import com.cognos.xqe.data.values.Value;
import com.ibm.bi.platform.datasetutils.converters.DecimalPolicy;
import com.ibm.bi.platform.datasetutils.metadata.ColumnMetadata;
import com.ibm.bi.platform.datasetutils.metadata.types.DecimalType;
import com.ibm.bi.platform.datasetutils.metadata.types.TemporalType;
import com.ibm.bi.platform.datasetutils.metadata.types.Type;
import com.ibm.bi.platform.datasetutils.utils.DecimalUtils;
import com.ibm.bi.platform.datasetutils.utils.ReadableRecord;
import com.ibm.bi.platform.datasetutils.utils.WritableRecord;
import java.math.BigDecimal;
import java.util.regex.Pattern;

public class DatasetUtilHelper {
    private static final Pattern STRING_TRIM_PATTERN = Pattern.compile("\\s++$");
    private static final String SINGLE_SPACE = " ";

    static ValueAssigner createValueAssigner(ColumnMetadata fieldMeta) {
        switch (fieldMeta.getType().getIntrinsicType()) {
            case BINARY: {
                return (target, record, index, rowNum) -> target.set(record.getBinary(index));
            }
            case BOOLEAN: {
                return (target, record, index, rowNum) -> target.set(record.getBoolean(index));
            }
            case BYTE: {
                return (target, record, index, rowNum) -> target.set(record.getByte(index));
            }
            case DATE: {
                return (target, record, index, rowNum) -> target.set(record.getDate(index));
            }
            case DECIMAL: {
                return (target, record, index, rowNum) -> target.set(record.getDecimal(index));
            }
            case DOUBLE: {
                return (target, record, index, rowNum) -> target.set(record.getDouble(index));
            }
            case FLOAT: {
                return (target, record, index, rowNum) -> target.set(record.getFloat(index));
            }
            case INT: {
                return (target, record, index, rowNum) -> target.set(record.getInt(index));
            }
            case LONG: {
                return (target, record, index, rowNum) -> target.set(record.getLong(index));
            }
            case SHORT: {
                return (target, record, index, rowNum) -> target.set(record.getShort(index));
            }
            case STRING: {
                return (target, record, index, rowNum) -> target.set(record.getString(index));
            }
            case TIME: {
                if (((TemporalType)fieldMeta.getType()).hasTimeZone()) {
                    return (target, record, index, rowNum) -> target.set(record.getOffsetTime(index));
                }
                return (target, record, index, rowNum) -> target.set(record.getTime(index));
            }
            case TIMESTAMP: {
                if (((TemporalType)fieldMeta.getType()).hasTimeZone()) {
                    return (target, record, index, rowNum) -> target.set(record.getOffsetDateTime(index));
                }
                return (target, record, index, rowNum) -> target.set(record.getDateTime(index));
            }
        }
        throw new UnsupportedOperationException("Unsupported type for value assignment: " + fieldMeta.getType().toString());
    }

    static RecordAssigner createRecordAssigner(ColumnMetadata fieldMeta, boolean shouldRemoveTrailingSpaces, DecimalPolicy decimalPolicy, DecimalType originalDecType) {
        Type dataType = fieldMeta.getType();
        switch (dataType.getIntrinsicType()) {
            case BINARY: {
                return (target, index, value, rowNum) -> target.setBinary(index, value.getByteArray());
            }
            case BOOLEAN: {
                return (target, index, value, rowNum) -> target.setBoolean(index, value.getBoolean());
            }
            case BYTE: {
                return (target, index, value, rowNum) -> target.setByte(index, value.getByte());
            }
            case DATE: {
                return (target, index, value, rowNum) -> target.setDate(index, value.getLocalDate());
            }
            case DECIMAL: {
                if (null != originalDecType) {
                    if (DecimalPolicy.LEAST_SIGNIFICANT_DIGITS_REMOVAL == decimalPolicy) {
                        return (target, index, value, rowNum) -> target.setDecimal(index, DecimalUtils.truncateDecimalValue((BigDecimal)value.getBigDecimal(), (int)originalDecType.getPrecision(), (int)((DecimalType)dataType).getScale()));
                    }
                    return (target, index, value, rowNum) -> target.setDecimal(index, DecimalUtils.fitDecimalValue((String)fieldMeta.getName(), (long)rowNum, (BigDecimal)value.getBigDecimal()));
                }
                return (target, index, value, rowNum) -> target.setDecimal(index, value.getBigDecimal());
            }
            case DOUBLE: {
                return (target, index, value, rowNum) -> target.setDouble(index, value.getDouble());
            }
            case FLOAT: {
                return (target, index, value, rowNum) -> target.setFloat(index, value.getFloat());
            }
            case INT: {
                return (target, index, value, rowNum) -> target.setInt(index, value.getInteger());
            }
            case LONG: {
                return (target, index, value, rowNum) -> target.setLong(index, value.getLong());
            }
            case SHORT: {
                return (target, index, value, rowNum) -> target.setShort(index, value.getShort());
            }
            case STRING: {
                if (shouldRemoveTrailingSpaces) {
                    return (target, index, value, rowNum) -> {
                        String trimmed = STRING_TRIM_PATTERN.matcher(value.getString()).replaceFirst("");
                        if (trimmed.isEmpty() && !value.getString().isEmpty()) {
                            trimmed = SINGLE_SPACE;
                        }
                        target.setString(index, trimmed);
                    };
                }
                return (target, index, value, rowNum) -> target.setString(index, value.getString());
            }
            case TIME: {
                if (((TemporalType)fieldMeta.getType()).hasTimeZone()) {
                    return (target, index, value, rowNum) -> target.setOffsetTime(index, value.getOffsetTime());
                }
                return (target, index, value, rowNum) -> target.setTime(index, value.getLocalTime());
            }
            case TIMESTAMP: {
                if (((TemporalType)fieldMeta.getType()).hasTimeZone()) {
                    return (target, index, value, rowNum) -> target.setOffsetDateTime(index, value.getOffsetDateTime());
                }
                return (target, index, value, rowNum) -> target.setDateTime(index, value.getLocalDateTime());
            }
        }
        throw new UnsupportedOperationException("Unsupported type for record assignment: " + fieldMeta.getType().toString());
    }

    static void convertRecordToRow(long rowNum, IRow targetRow, ReadableRecord sourceRecord, ValueAssigner[] assigners) {
        for (int fieldIndex = 0; fieldIndex < sourceRecord.size(); ++fieldIndex) {
            Value rowValue = (Value)targetRow.getColumn(fieldIndex);
            if (sourceRecord.isNull(fieldIndex)) {
                rowValue.setNull();
                continue;
            }
            assigners[fieldIndex].assign(rowValue, sourceRecord, fieldIndex, rowNum);
        }
    }

    static void convertRowToRecord(long rowNum, WritableRecord targetRecord, IRow sourceRow, RecordAssigner[] assigners) {
        for (int fieldIndex = 0; fieldIndex < sourceRow.getNumColumns(); ++fieldIndex) {
            Value rowValue = (Value)sourceRow.getColumn(fieldIndex);
            if (rowValue.isNull()) {
                targetRecord.setNull(fieldIndex);
                continue;
            }
            assigners[fieldIndex].assign(targetRecord, fieldIndex, rowValue, rowNum);
        }
    }

    @FunctionalInterface
    static interface RecordAssigner {
        public void assign(WritableRecord var1, int var2, Value var3, long var4);
    }

    @FunctionalInterface
    static interface ValueAssigner {
        public void assign(Value var1, ReadableRecord var2, int var3, long var4);
    }
}

