/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.datasets;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.datasets.FlintProcessExitCode;
import com.cognos.xqe.util.datasets.FlintServerManagerConfig;
import com.cognos.xqe.util.datasets.IFlintServerManager;
import com.cognos.xqe.util.primitive.HashSetLong;
import com.ibm.ba.flint.client.FlintClientPool;
import com.ibm.ba.flint.launcher.JavaProcessLauncher;
import com.ibm.ba.flint.launcher.Launcher;
import com.ibm.ba.flint.launcher.LauncherListener;
import com.ibm.ba.flint.launcher.SslParams;
import com.ibm.bi.platform.commons.crypto.JCAMCrypto;
import com.ibm.bi.platform.commons.crypto.api.CAMKeyPair;
import com.ibm.bi.platform.commons.crypto.internal.session.JavaKeyStoreSession;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class FlintServerManager
implements IFlintServerManager {
    private static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "FlintManager", LogLevel.INFO);
    private static final String FOUND_PATH_FORMATTER = "Found Path: \"%s\"";
    private static final String PATH_NOT_FOUND_FORMATTER = "Path \"%s\" not found!";
    private static final String INSTALL_DIR_PROPERTY_NOT_INIT_MSG = "System property -Dinstall.dir has not been initialized.";
    private static final String SNAPPY_TEMPDIR_PROPERTY_NOT_INIT_MSG = "System property -Dorg.xerial.snappy.tempdir has not been initialized.";
    private static final String INSTALL_DIR_PROPERTY_VALUE_FORMATTER = "The -Dinstall.dir system property is set to: %s.";
    public static final String FLINT_CONNECTION_STR_FORMATTER = ";LOCAL;FLINT;URL=thrift://%s:%d";
    private static final String FLINT_SERVER_NOT_RUNNING_MSG = "Flint Server is not running.";
    private static final String FLINT_SERVER_MANAGER_NOT_INIT_MSG = "Flint  Server Manager has not been initialized properly.";
    private static final String THREAD_INTERRUPTED_FORMATTER_MSG = "Thread {%s} is interrupted.";
    private static final String MD_CONNECTIONS_NOT_PROMOTED_MSG = "Metadata connections not promoted due to Flint Server not running: %d.";
    private static final long RUNNING_THREAD_SLEEP_MILLIS = 1000L;
    private volatile FlintServerManagerConfig flintServerMgrCnfg;
    private final FlintServerListener flintServerListener;
    private volatile CAMKeyPair camKeyPair;
    private volatile SslParams sslParams;
    private volatile JavaProcessLauncher flintServerLauncher = null;
    private volatile FlintServerState flintServerState = null;
    private volatile Instant lastReportedUnhealthyTS = Instant.EPOCH;
    private volatile Instant lastReportedHealthyTS = Instant.EPOCH;
    private volatile Instant lastActiveRequestTS = Instant.EPOCH;
    private volatile FlintProcessExitCode exitCode = FlintProcessExitCode.NORMAL;
    private AtomicBoolean isStartupThreadAlreadyRunning = new AtomicBoolean(false);
    private volatile boolean canBeRestarted = true;
    private final CountDownLatch initLatch = new CountDownLatch(1);
    private final AtomicBoolean isAlreadyInitialized = new AtomicBoolean(false);
    private static final int INIT_LATCH_AWAIT_TIME_SECS = 30;
    private volatile long lastLoggingReportTS = 0L;
    private AtomicLong loggingIDGenerator = new AtomicLong(0L);
    private HashSetLong loggingIDSet = new HashSetLong();
    private ReentrantLock loggingLock = new ReentrantLock();
    private static final long LOGGING_INTERVAL = TimeUnit.MINUTES.toNanos(5L);

    public FlintServerManager() {
        this.flintServerListener = new FlintServerListener();
    }

    public boolean isFlintServerEnabled() {
        return this.getConfig().isFlintEnabled();
    }

    @Override
    public FlintServerState getFlintServerState() {
        return this.flintServerState;
    }

    @Override
    public String getHostName() {
        if (FlintServerState.RUNNING == this.flintServerState) {
            return this.flintServerLauncher.getBindHost();
        }
        throw new IllegalStateException(FLINT_SERVER_NOT_RUNNING_MSG);
    }

    @Override
    public int getHostPort() {
        if (FlintServerState.RUNNING == this.flintServerState) {
            return this.flintServerLauncher.getBindPort();
        }
        throw new IllegalStateException(FLINT_SERVER_NOT_RUNNING_MSG);
    }

    @Override
    public long getUniqueLoggingId() {
        return this.loggingIDGenerator.incrementAndGet();
    }

    @Override
    public String constructConnectionString(long loggingID) {
        this.lastActiveRequestTS = Instant.now();
        if (FlintServerState.RUNNING == this.flintServerState) {
            this.purgeLoggingIDSetDueToFlintRecovery();
            return String.format(FLINT_CONNECTION_STR_FORMATTER, this.getHostName(), this.getHostPort());
        }
        if (Long.MIN_VALUE != loggingID) {
            this.purgeLoggingIDSetByLoggingInterval(loggingID);
        }
        throw new IllegalStateException(FLINT_SERVER_NOT_RUNNING_MSG);
    }

    private void purgeLoggingIDSetDueToFlintRecovery() {
        this.loggingLock.lock();
        try {
            if (this.loggingIDSet.size() > 0) {
                LOGGER.log(LogLevel.WARN, String.format(MD_CONNECTIONS_NOT_PROMOTED_MSG, this.loggingIDSet.size()));
                this.loggingIDGenerator.set(0L);
                this.loggingIDSet.clear();
                this.lastLoggingReportTS = System.nanoTime();
            }
        }
        finally {
            this.loggingLock.unlock();
        }
    }

    private void purgeLoggingIDSetByLoggingInterval(long loggingID) {
        this.loggingLock.lock();
        try {
            if (!this.loggingIDSet.contains(loggingID)) {
                this.loggingIDSet.add(loggingID);
                if (System.nanoTime() - this.lastLoggingReportTS >= LOGGING_INTERVAL) {
                    LOGGER.log(LogLevel.WARN, String.format(MD_CONNECTIONS_NOT_PROMOTED_MSG, this.loggingIDSet.size()));
                    this.loggingIDGenerator.set(0L);
                    this.loggingIDSet.clear();
                    this.lastLoggingReportTS = System.nanoTime();
                }
            }
        }
        finally {
            this.loggingLock.unlock();
        }
    }

    @Override
    public String getCAMKeyPairID() {
        return this.camKeyPair.id;
    }

    @Override
    public FlintServerManagerConfig getConfig() {
        try {
            if (this.initLatch.await(30L, TimeUnit.SECONDS)) {
                return this.flintServerMgrCnfg;
            }
        }
        catch (InterruptedException ie) {
            throw new IllegalStateException(FLINT_SERVER_MANAGER_NOT_INIT_MSG, ie);
        }
        throw new IllegalStateException(FLINT_SERVER_MANAGER_NOT_INIT_MSG);
    }

    @Override
    public FlintClientPool getClientPool() {
        if (FlintServerState.RUNNING == this.flintServerState) {
            return this.flintServerLauncher.getClientPool();
        }
        throw new IllegalStateException(FLINT_SERVER_NOT_RUNNING_MSG);
    }

    @Override
    public FlintProcessExitCode getExitCode(long millis) {
        if (millis > 0L) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException ie) {
                LOGGER.log(LogLevel.WARN, String.format(THREAD_INTERRUPTED_FORMATTER_MSG, Thread.currentThread().getName()), (Throwable)ie);
            }
        }
        return this.exitCode;
    }

    public void initialize() {
        if (this.isAlreadyInitialized.compareAndSet(false, true)) {
            this.flintServerMgrCnfg = FlintServerManagerConfig.load();
            this.initLatch.countDown();
            this.flintServerState = FlintServerState.DOWN;
            if (this.flintServerMgrCnfg.isFlintEnabled() && FlintServerManagerConfig.FlintServerLoadingPolicy.EAGER == this.flintServerMgrCnfg.getFlintServerLoadingPolicy()) {
                FlintServerStartupThread t = new FlintServerStartupThread();
                t.start();
            }
        } else {
            throw new IllegalStateException("Flint Server Manager has already been initialized.");
        }
    }

    public void release() {
        this.canBeRestarted = false;
        this.stopFlintServer();
    }

    public void startFlintServer() {
        if (FlintServerManagerConfig.FlintServerLoadingPolicy.LAZY != this.getConfig().getFlintServerLoadingPolicy()) {
            throw new IllegalStateException("Cannot start Flint Server outside of the scope of FlintServerManager instance when FlintServerLoadingPolicy is set to EAGER.");
        }
        if (!this.isFlintServerEnabled()) {
            throw new IllegalStateException("Cannot start Flint Server. It is disabled.");
        }
        FlintServerStartupThread t = new FlintServerStartupThread();
        t.start();
    }

    private void stopFlintServer() {
        if (this.flintServerLauncher != null) {
            if (FlintServerState.RUNNING == this.flintServerState) {
                boolean stopped = this.flintServerLauncher.quiesceAndShutdown(this.flintServerMgrCnfg.getInitInterval().getSeconds());
                try {
                    stopped = this.flintServerLauncher.waitForTerminate(this.flintServerMgrCnfg.getInitInterval().toMillis());
                }
                catch (InterruptedException ie) {
                    LOGGER.log(LogLevel.INFO, (Throwable)ie);
                }
                if (!stopped) {
                    this.flintServerLauncher.shutdown(true);
                }
            } else if (FlintServerState.INIT == this.flintServerState) {
                this.flintServerLauncher.shutdown(true);
            }
            this.flintServerLauncher.removeListener((LauncherListener)this.flintServerListener);
        }
        this.flintServerState = FlintServerState.DOWN;
    }

    private class FlintServerRunningThread
    extends Thread {
        FlintServerRunningThread() {
            this.setDaemon(true);
            this.setName("FlintServerManager.FlintServerRunningThread");
        }

        @Override
        public void run() {
            Instant lastKnownConfLoadTime = FlintServerManager.this.flintServerMgrCnfg.getLastLoadTime();
            boolean needsRestart = false;
            boolean configChanged = false;
            while (FlintServerState.RUNNING == FlintServerManager.this.flintServerState) {
                try {
                    FlintServerRunningThread.sleep(1000L);
                    Instant now = Instant.now();
                    if (FlintServerManager.this.lastReportedUnhealthyTS.isAfter(FlintServerManager.this.lastReportedHealthyTS) && now.isAfter(FlintServerManager.this.lastReportedUnhealthyTS.plus(FlintServerManager.this.flintServerMgrCnfg.getDownInterval()))) {
                        LOGGER.log(LogLevel.ERROR, "Flint Server has been reported to be unhealthy for more time than the specified DownInterval. Time to restart it.");
                        FlintServerManager.this.stopFlintServer();
                        needsRestart = true;
                        continue;
                    }
                    if (FlintServerManagerConfig.FlintServerLoadingPolicy.LAZY == FlintServerManager.this.flintServerMgrCnfg.getFlintServerLoadingPolicy() && !FlintServerManager.this.flintServerMgrCnfg.getInactiveInterval().isZero() && FlintServerManager.this.lastReportedHealthyTS.isAfter(FlintServerManager.this.lastReportedUnhealthyTS) && now.isAfter(FlintServerManager.this.lastActiveRequestTS.plus(FlintServerManager.this.flintServerMgrCnfg.getInactiveInterval()))) {
                        LOGGER.log(LogLevel.WARN, "Flint Server is inactive for a time duration which is bigger than the specified InactiveInterval. Time to shut it down.");
                        FlintServerManager.this.stopFlintServer();
                        continue;
                    }
                    if (!FlintServerManager.this.flintServerMgrCnfg.isRestartOnConfChangeEnabled() || !FlintServerManager.this.flintServerMgrCnfg.getLastLoadTime().isAfter(lastKnownConfLoadTime)) continue;
                    LOGGER.log(LogLevel.WARN, "Flint Server has been reconfigured. Time to restart it.");
                    lastKnownConfLoadTime = FlintServerManager.this.flintServerMgrCnfg.getLastLoadTime();
                    configChanged = true;
                    needsRestart = true;
                    FlintServerManager.this.stopFlintServer();
                }
                catch (InterruptedException ie) {
                    LOGGER.log(LogLevel.WARN, String.format(FlintServerManager.THREAD_INTERRUPTED_FORMATTER_MSG, this.getName()), (Throwable)ie);
                    break;
                }
            }
            if (needsRestart && (configChanged || FlintServerManager.this.canBeRestarted)) {
                FlintServerStartupThread t = new FlintServerStartupThread();
                t.start();
            }
        }
    }

    private class FlintServerStartupThread
    extends Thread {
        public static final String FLINT_SERVER_FAILED_TO_START_FORMATTER = "Failed to start Flint Server for the %d time.";
        public static final String FLINT_SERVER_INIT_TIMEOUT_FORMATTER = "Initialization phase took %.2f secs, while init interval is set to %.2f secs.";
        private final long oneSecondToNanos = TimeUnit.SECONDS.toNanos(1L);

        FlintServerStartupThread() {
            this.setDaemon(true);
            this.setName("FlintServerManager.FlintServerStartupThread");
        }

        private Path relativizePath(Path target, Path base) {
            return base.toAbsolutePath().normalize().relativize(target.toAbsolutePath().normalize());
        }

        private SslParams buildSSLParameters() throws com.ibm.bi.platform.commons.crypto.CAMCryptoException, CAMCryptoException {
            String jksPassword = JCAMCrypto.createPassword();
            JavaKeyStoreSession jksSession = JCAMCrypto.createJavaKeyStoreSession();
            jksSession.createKeystoreWithKeyAndSelfSignedCert(FlintServerManager.this.flintServerMgrCnfg.getFlintJKSKeystorePath(), jksPassword);
            return SslParams.newBuilder().setProtocol(FlintServerManager.this.flintServerMgrCnfg.getSSLProtocol()).setAllowedCiphers(FlintServerManager.this.flintServerMgrCnfg.getSupportedCiphers()).setKeyStorePath(FlintServerManager.this.flintServerMgrCnfg.getFlintJKSKeystorePath()).setKeyStorePassword(jksPassword).setTrustStorePath(FlintServerManager.this.flintServerMgrCnfg.getFlintJKSKeystorePath()).setTrustStorePassword(jksPassword).setRequiresClientAuth(true).build();
        }

        private JavaProcessLauncher.Builder createFlintLauncherBuilder() throws com.ibm.bi.platform.commons.crypto.CAMCryptoException, NoSuchAlgorithmException, CAMCryptoException {
            boolean isVendorIBM;
            String configDir;
            String appConfFilePath;
            File appConfFile;
            JavaProcessLauncher.Builder builder = new JavaProcessLauncher.Builder(FlintServerManagerConfig.FLINTJAR_FILEPATH).addExtraClasspath(FlintServerManagerConfig.FLINT_CLASSPATH_LIBS).setBindHost(FlintServerManager.this.flintServerMgrCnfg.getHost()).setMinHeapMB(FlintServerManager.this.flintServerMgrCnfg.getMinHeapSize()).setMaxHeapMB(FlintServerManager.this.flintServerMgrCnfg.getMaxHeapSize()).setMaxDirectMB(FlintServerManager.this.flintServerMgrCnfg.getMaxDirectSize()).setMinWorkers(FlintServerManager.this.flintServerMgrCnfg.getMinThriftWorkers()).setMaxWorkers(FlintServerManager.this.flintServerMgrCnfg.getMaxThriftWorkers()).setKeepAliveByStdIn(true).setLoggingOverStdOut(true).setUserTimezone("UTC").setScratchDir(FlintServerManager.this.flintServerMgrCnfg.getScratchDir()).setWarehouseDir(FlintServerManager.this.flintServerMgrCnfg.getWarehouseDir()).setBuffersDir(FlintServerManager.this.flintServerMgrCnfg.getBuffersDir()).setResultCacheDir(FlintServerManager.this.flintServerMgrCnfg.getResultCacheDir());
            String installDir = System.getProperty("install.dir");
            if (null == installDir) {
                LOGGER.log(LogLevel.CRITICAL, FlintServerManager.INSTALL_DIR_PROPERTY_NOT_INIT_MSG);
            }
            LOGGER.log(LogLevel.INFO, String.format(FlintServerManager.INSTALL_DIR_PROPERTY_VALUE_FORMATTER, installDir));
            builder.addExtraSysProp("install.dir", installDir);
            String tempDir = System.getProperty("org.xerial.snappy.tempdir");
            if (null == tempDir) {
                LOGGER.log(LogLevel.WARN, FlintServerManager.SNAPPY_TEMPDIR_PROPERTY_NOT_INIT_MSG);
            } else {
                builder.addExtraSysProp("org.xerial.snappy.tempdir", tempDir);
            }
            if (-1 != FlintServerManager.this.flintServerMgrCnfg.getSparkThreads()) {
                builder.setNumSparkThreads(FlintServerManager.this.flintServerMgrCnfg.getSparkThreads());
            }
            builder.addJavaAgent(FlintServerManagerConfig.ASPECTJWEAVER_PATH);
            if (FlintServerManager.this.flintServerMgrCnfg.getPort() != 0) {
                builder.setBindPort(FlintServerManager.this.flintServerMgrCnfg.getPort());
            } else {
                builder.setEphemeralBindPort(FlintServerManager.this.flintServerMgrCnfg.getFlintEphemeralPortFilePath());
            }
            if (FlintServerManager.this.flintServerMgrCnfg.useEncryptionForTempFiles()) {
                builder.setSparkIOEncryption(true, Integer.valueOf(FlintServerManager.this.flintServerMgrCnfg.getKeySizeLengthForTempFilesEncryption()), StringUtils.substringBefore((String)"AES/CTR/NoPadding", (String)"/"));
                builder.setResultCacheEncrypted(true);
            }
            if (FlintServerManager.this.flintServerMgrCnfg.useSSLMutualAuthentication()) {
                FlintServerManager.this.sslParams = this.buildSSLParameters();
                builder.setServerSslParams(FlintServerManager.this.sslParams);
                builder.setClientSslParams(FlintServerManager.this.sslParams);
                builder.setSparkHttps(true);
                builder.setSparkAuthenticate(true, JCAMCrypto.createPassword());
                builder.setSparkSasl(true);
            }
            if ((appConfFile = new File(appConfFilePath = (configDir = FlintServerManagerConfig.CONFIG.getConfigDirectory()) + File.separator + "flint-app.properties")).exists()) {
                builder.addAppConfFile(appConfFile.getAbsolutePath());
                LOGGER.log(String.format(FlintServerManager.FOUND_PATH_FORMATTER, appConfFile));
            } else {
                LOGGER.log(LogLevel.WARN, String.format(FlintServerManager.PATH_NOT_FOUND_FORMATTER, appConfFile));
            }
            String logConfFilePath = configDir + File.separator + "flint-logging.xml";
            File logConfFile = new File(logConfFilePath);
            if (logConfFile.exists()) {
                builder.setLog4jConfFile(logConfFile.getAbsolutePath());
                LOGGER.log(String.format(FlintServerManager.FOUND_PATH_FORMATTER, logConfFile));
            } else {
                LOGGER.log(LogLevel.WARN, String.format(FlintServerManager.PATH_NOT_FOUND_FORMATTER, logConfFile));
                logConfFilePath = configDir + File.separator + "flint-logging.properties";
                logConfFile = new File(logConfFilePath);
                if (logConfFile.exists()) {
                    builder.setLog4jConfFile(logConfFile.getAbsolutePath());
                    LOGGER.log(String.format(FlintServerManager.FOUND_PATH_FORMATTER, logConfFile));
                } else {
                    LOGGER.log(LogLevel.WARN, String.format(FlintServerManager.PATH_NOT_FOUND_FORMATTER, logConfFile));
                }
            }
            if (FlintServerManager.this.flintServerMgrCnfg.isMetricsEnabled()) {
                String metricsConfFilePath = configDir + File.separator + "flint-metrics.properties";
                File metricsConfFile = new File(metricsConfFilePath);
                if (metricsConfFile.exists()) {
                    builder.setMetricsConfFile(metricsConfFile.getAbsolutePath());
                    LOGGER.log(String.format(FlintServerManager.FOUND_PATH_FORMATTER, metricsConfFile));
                } else {
                    LOGGER.log(LogLevel.WARN, String.format(FlintServerManager.PATH_NOT_FOUND_FORMATTER, metricsConfFile));
                }
                if (FlintServerManager.this.flintServerMgrCnfg.isJmxPrometheusEnabled()) {
                    int jmxPrometheusPort = FlintServerManager.this.flintServerMgrCnfg.getJmxPrometheusPort();
                    String jmxPrometheusFilePath = configDir + File.separator + "flint-jmx-prometheus.yaml";
                    jmxPrometheusFilePath = this.relativizePath(Paths.get(jmxPrometheusFilePath, new String[0]), Paths.get(".", new String[0])).toString();
                    builder.addJavaAgent(FlintServerManagerConfig.JMX_PROMETHEUS_JAVAAGENT_PATH + "=" + jmxPrometheusPort + ":" + jmxPrometheusFilePath);
                }
            }
            String verboseGCLogPath = (isVendorIBM = System.getProperty("java.vendor").contains("IBM")) ? Paths.get(FlintServerManagerConfig.CONFIG.getXqeLogsDirectory(), "flint_verbosegc_%Y%m%d.%H%M%S.%pid.log,1,1000").toString() : Paths.get(FlintServerManagerConfig.CONFIG.getXqeLogsDirectory(), "flint_verbosegc_%t.%p.log").toString();
            builder.setVerboseGC(isVendorIBM, verboseGCLogPath);
            if (!FlintServerManager.this.flintServerMgrCnfg.getExtraJavaOptions().isEmpty()) {
                builder.addExtraJavaOpts(FlintServerManager.this.flintServerMgrCnfg.getExtraJavaOptions());
            }
            if (!FlintServerManager.this.flintServerMgrCnfg.getExtraFlintConf().isEmpty()) {
                for (Map.Entry<String, String> e : FlintServerManager.this.flintServerMgrCnfg.getExtraFlintConf().entrySet()) {
                    builder.addAppConfStdIn(e.getKey(), e.getValue());
                }
            }
            return builder;
        }

        private void cleanupFlintServerTempDirectories() {
            LOGGER.log("Cleaning Flint temp directories.");
            File buffersDirF = new File(FlintServerManager.this.flintServerMgrCnfg.getBuffersDirAsPlainPath());
            File scratchDirF = new File(FlintServerManager.this.flintServerMgrCnfg.getScratchDir());
            if (buffersDirF.exists() && buffersDirF.isDirectory()) {
                FileUtils.deleteQuietly((File)buffersDirF);
            }
            if (scratchDirF.exists() && scratchDirF.isDirectory()) {
                FileUtils.deleteQuietly((File)scratchDirF);
            }
        }

        @Override
        public void run() {
            if (FlintServerManager.this.isStartupThreadAlreadyRunning.compareAndSet(false, true)) {
                int currentAttempt = 0;
                while (FlintServerState.RUNNING != FlintServerManager.this.flintServerState && currentAttempt < FlintServerManager.this.flintServerMgrCnfg.getRetryAttempts()) {
                    this.cleanupFlintServerTempDirectories();
                    ++currentAttempt;
                    try {
                        FlintServerManager.this.flintServerLauncher = this.createFlintLauncherBuilder().build();
                        FlintServerManager.this.flintServerLauncher.addListener((LauncherListener)FlintServerManager.this.flintServerListener);
                        LOGGER.log("Flint Server Launcher created successfully with the following command line arguments: " + FlintServerManager.this.flintServerLauncher.getCommandArgs().toString());
                        LOGGER.log(String.format("Starting Flint Server for the %d time", currentAttempt));
                        FlintServerManager.this.flintServerLauncher.launch();
                        FlintServerManager.this.flintServerState = FlintServerState.INIT;
                        long startTime = System.nanoTime();
                        if (FlintServerManager.this.flintServerLauncher.waitForServing(FlintServerManager.this.flintServerMgrCnfg.getInitInterval().toMillis())) {
                            FlintServerManager.this.flintServerState = FlintServerState.RUNNING;
                            FlintServerRunningThread t = new FlintServerRunningThread();
                            t.start();
                            continue;
                        }
                        long failedInitTime = System.nanoTime() + this.oneSecondToNanos;
                        String initFailureMsg = String.format(FLINT_SERVER_FAILED_TO_START_FORMATTER, currentAttempt);
                        String initTimeoutMsg = String.format(FLINT_SERVER_INIT_TIMEOUT_FORMATTER, (double)(failedInitTime - startTime) * 1.0 / (double)this.oneSecondToNanos, (double)FlintServerManager.this.flintServerMgrCnfg.getInitInterval().toNanos() * 1.0 / (double)this.oneSecondToNanos);
                        LOGGER.log(LogLevel.WARN, initFailureMsg + System.lineSeparator() + initTimeoutMsg);
                        FlintServerManager.this.stopFlintServer();
                    }
                    catch (Exception e) {
                        LOGGER.log(LogLevel.WARN, String.format(FLINT_SERVER_FAILED_TO_START_FORMATTER, currentAttempt), (Throwable)e);
                        FlintServerManager.this.stopFlintServer();
                    }
                }
                if (FlintServerState.RUNNING != FlintServerManager.this.flintServerState) {
                    LOGGER.log(LogLevel.ERROR, String.format("Reached max number of attempts (%d) trying to start Flint Server. Giving up now...", currentAttempt));
                    if (null != FlintServerManager.this.flintServerLauncher) {
                        LOGGER.log(LogLevel.ERROR, "The constructed command line arguments were: " + FlintServerManager.this.flintServerLauncher.getCommandArgs().toString());
                    }
                }
                FlintServerManager.this.isStartupThreadAlreadyRunning.set(false);
            }
        }
    }

    private class FlintServerListener
    implements LauncherListener {
        private FlintServerListener() {
        }

        public void onServerStarted(Launcher launcher) {
            LOGGER.log("Listener: Flint Server started successfully!");
        }

        public void onServerConnectionUp(Launcher launcher) {
            LOGGER.log("Listener: Flint Server onServerConnectionUp event.");
            FlintServerManager.this.lastReportedHealthyTS = Instant.now();
        }

        public void onServerConnectionDown(Launcher launcher) {
            LOGGER.log("Listener: Flint Server onServerConnectionDown event.");
            FlintServerManager.this.lastReportedUnhealthyTS = Instant.now();
        }

        public void onServerConsoleOut(Launcher launcher, String line) {
            LOGGER.log(LogLevel.TRACE, line);
        }

        public void onServerTerminated(Launcher launcher, int exitValue) {
            if (FlintProcessExitCode.NORMAL.getExitCode() == exitValue) {
                FlintServerManager.this.exitCode = FlintProcessExitCode.NORMAL;
            } else if (FlintProcessExitCode.OOM.getExitCode() == exitValue) {
                FlintServerManager.this.exitCode = FlintProcessExitCode.OOM;
            } else {
                FlintServerManager.this.exitCode = FlintProcessExitCode.UNKNOWN;
            }
            LOGGER.log("Listener: Flint Server terminated with exit value: " + exitValue);
            FlintServerManager.this.lastReportedUnhealthyTS = Instant.now();
        }
    }

    public static enum FlintServerState {
        INIT("init"),
        RUNNING("running"),
        DOWN("down");

        private String state;

        private FlintServerState(String theState) {
            this.state = theState;
        }

        public String getStateValue() {
            return this.state;
        }
    }
}

