/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.datasets;

import com.cognos.accman.jcam.crypto.CAMCryptoException;
import com.cognos.accman.jcam.crypto.misc.Configuration;
import com.cognos.accman.jcam.crypto.misc.IConfiguration;
import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationEvent;
import com.cognos.xqe.config.XQEConfigurationListener;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.datasets.FlintUtils;
import com.cognos.xqe.util.datasets.IFlintServerManagerConfig;
import com.ibm.bi.platform.commons.crypto.JCAMCrypto;
import java.io.File;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import javax.crypto.Cipher;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;

public final class FlintServerManagerConfig
implements IFlintServerManagerConfig {
    private static final String COMMA_STR = ",";
    private static final String ASTERISK_STR = "*";
    private static final String FLINT_HOST_FORMATTER = "Flint Host is set to: %s";
    private static final String FLINT_PORT_FORMATTER = "Flint Port is set to: %s";
    private static final String PORT_NUMBER_NOT_CONFIGURED = "No port number configured. Flint Server will use dynamic port assignment.";
    private static final String INVALID_PORT_NUMBER_FORMATTER = "Invalid port number detected: %s. Flint Server will use dynamic port assignment instead.";
    private static final String FLINT_SERVER_POLICY_FORMATTER = "Flint Server Policy set to: %s";
    private static final String INVALID_FLINT_SERVER_POLICY_FORMATTER = "Invalid Flint Server Policy detected: %s. Falling back to default value: %s";
    private static final String FLINT_CONNECTIONS_POLICY_FORMATTER = "Flint Connections Policy set to: %s";
    private static final String INVALID_FLINT_CONNECTIONS_POLICY_FORMATTER = "Invalid Flint Connections Policy detected: %s. Falling back to default value: %s";
    private static final String FLINT_CONNECTIONS_WAIT_TIME_FORMATTER = "Flint Connections Wait Time is set to: %s seconds.";
    private static final String INVALID_FLINT_CONNECTIONS_MAX_WAIT_TIME_FORMATTER = "Invalid Flint Connections Max Wait Time value detected: %s. Falling back to default value %s seconds.";
    private static final String FLINT_INIT_INTERVAL_FORMATTER = "Flint Initialization Interval is set to: %s seconds.";
    private static final String INVALID_FLINT_INIT_INTERVAL_FORMATTER = "Invalid Flint Initialization Interval value detected: %s. Falling back to default value %s seconds.";
    private static final String FLINT_RETRY_ATTEMPTS_FORMATTER = "Flint Retry Attempts is set to: %s.";
    private static final String INVALID_FLINT_RETRY_ATTEMPTS_FORMATTER = "Invalid Flint Retry Attempts value detected: %s. Falling back to default value %s.";
    private static final String FLINT_DOWN_INTERVAL_FORMATTER = "Flint Down Interval is set to: %s seconds.";
    private static final String INVALID_FLINT_DOWN_INTERVAL_FORMATTER = "Invalid Flint Down Interval value detected: %s. Falling back to default value %s seconds.";
    private static final String FLINT_INACTIVE_INTERVAL_FORMATTER = "Flint Inactive Interval is set to: %s hours.";
    private static final String INVALID_FLINT_INACTIVE_INTERVAL_FORMATTER = "Invalid Flint Inactive Interval value detected: %s. Falling back to default value %s hours.";
    private static final String FLINT_SCRATCH_DIR_FORMATTER = "Flint Server Scratch Dir set to: %s.";
    private static final String FLINT_RESULT_CACHE_DIR_FORMATTER = "Flint Server Result Cache Dir URI set to: %s.";
    private static final String FLINT_WAREHOUSE_DIR_FORMATTER = "Flint Server Warehouse Dir URI set to: %s.";
    private static final String FLINT_BUFFERS_DIR_FORMATTER = "Flint Server Buffers Dir URI set to: %s.";
    private static final String CAM_CONFIG_NOT_INIT_ERROR = "CAM Configuration cannot be initialized properly.";
    private static final String ENCRYPT_TEMP_FILES_FORMATTER = "Encrypting temporary files is set to: %s.";
    private static final String ENCRYPT_TEMP_FILES_KEYSIZELENGTH_FORMATTER = "The key size length is set to: %d";
    private static final String USE_SSL_MUTUAL_AUTHENTICATION_FORMATTER = "Using SSL Mutual Authentication is set to: %s.";
    private static final String INVALID_MIN_HEAP_FORMATTER = "Invalid Min Heap value detected: %s (MB). Falling back to default value: %s (MB).";
    private static final String INVALID_MAX_HEAP_FORMATTER = "Invalid Max Heap value detected: %s (MB). Falling back to default value: %s (MB).";
    private static final String INVALID_MAX_DIRECT_FORMATTER = "Invalid Max Direct value detected: %s (MB). Falling back to default value: %s (MB).";
    private static final String MIN_HEAP_BIGGER_THAN_MAX_HEAP_FORMATTER = "Min Heap value (%s MB) is bigger than Max Heap value (%s MB). Falling back to defaults...";
    private static final String FINAL_MEMORY_ASSIGNMENT_FORMATTER = "(Min Heap, Max Heap, Max Direct) is set to: (%s, %s, %s) [MB].";
    private static final String INVALID_SPARK_THREADS_FORMATTER = "Invalid Spark Threads value detected: %s. Falling back to default value: %s.";
    private static final String SPARK_THREADS_FORMATTER = "Spark Threads set to: %s.";
    private static final String INVALID_MIN_THRIFT_WORKERS_FORMATTER = "Invalid Mininum Thrift Workers value detected: %s. Falling back to default value: %s.";
    private static final String INVALID_MAX_THRIFT_WORKERS_FORMATTER = "Invalid Maximum Thrift Workers value detected: %s. Falling back to default value: %s.";
    private static final String MIN_THRIFT_WORKERS_BIGGER_THAN_MAX_THRIFT_WORKERS_FORMATTER = "Min Thrift Workers value (%s) is bigger than Max Thrift Workers value (%s). Falling back to defaults...";
    private static final String MIN_MAX_THRIFT_WORKERS_FORMATTER = "(Min Thrift Workers, Max Thrift Workers) is set to: (%s, %s).";
    private static final String INVALID_MANAGED_DATASETS_LIMIT_FORMATTER = "Invalid Managed Datasets Limit value detected: %s. Falling back to default value: %s.";
    private static final String MANAGED_DATASETS_LIMIT_FORMATTER = "Managed Datasets Limit set to: %s.";
    private static final String EXTRA_JAVA_OPTIONS_FORMATTER = "Extra Java Options detected: %s";
    private static final String EXTRA_FLINT_CONF_FORMATTER = "Extra Flint Configurations detected: %s";
    public static final XQEConfiguration CONFIG = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
    private static final ICCLConfiguration ICCLCONFIG = XQECCLConfigurationFactory.getInstance();
    private static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "FlintManager", LogLevel.INFO);
    private static final String PARENT_DIR = "..";
    private static final String FLINT_DIR = "flint";
    private static final String LIBS_DIR = "libs";
    public static final String FLINTJAR_FILEPATH = ".." + File.separator + "flint" + File.separator + "flint-server-jar-with-dependencies.jar";
    public static final String FLINT_CLASSPATH_LIBS = ".." + File.separator + "flint" + File.separator + "libs" + File.separator + "*";
    public static final String ASPECTJWEAVER_PATH = ".." + File.separator + "flint" + File.separator + "libs" + File.separator + "aspectjweaver-1.8.10.jar";
    public static final String JMX_PROMETHEUS_JAVAAGENT_PATH = ".." + File.separator + "flint" + File.separator + "libs" + File.separator + "jmx_prometheus_javaagent-0.2.0.jar";
    public static final String INSTALL_DIR_SYS_PROPERTY = "install.dir";
    public static final String SNAPPY_TEMPDIR_SYS_PROPERTY = "org.xerial.snappy.tempdir";
    private static final String FLINT_SERVER_LOADING_POLICY_KEY = "queryExecution.flintServer.loadingPolicy[@value]";
    private static final String FLINT_CONNECTIONS_ON_FLINT_NOT_RUNNING_POLICY_KEY = "queryExecution.flintServer.flintConnectionsOnFlintNotRunningPolicy[@value]";
    private static final String FLINT_CONNECTIONS_MAX_WAIT_TIME_KEY = "queryExecution.flintServer.flint.flintConnectionsMaxWaitTime[@value]";
    private static final String INIT_INTERVAL_KEY = "queryExecution.flintServer.initInterval[@value]";
    private static final String RETRY_ATTEMPTS_KEY = "queryExecution.flintServer.retryAttempts[@value]";
    private static final String DOWN_INTERVAL_KEY = "queryExecution.flintServer.downInterval[@value]";
    private static final String INACTIVE_INTERVAL_KEY = "queryExecution.flintServer.inactiveInterval[@value]";
    private static final String METRICS_ENABLED_KEY = "queryExecution.flintServer.metrics[@enabled]";
    private static final String METRICS_JMX_PROMETHEUS_ENABLED_KEY = "queryExecution.flintServer.metrics.jmxPrometheus[@enabled]";
    private static final String METRICS_JMX_PROMETHEUS_PORT_KEY = "queryExecution.flintServer.metrics.jmxPrometheus[@port]";
    private static final String DEFAULT_FLINT_SERVER_ENABLED = "true";
    private static final String DEFAULT_FLINT_SERVER_RESTART_ON_CONF_CHANGE_ENABLED = "false";
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 0;
    private static final FlintServerLoadingPolicy DEFAULT_FLINT_SERVER_LOADING_POLICY = FlintServerLoadingPolicy.EAGER;
    private static final FlintConnectionsPolicy DEFAULT_FLINT_CONNECTIONS_POLICY = FlintConnectionsPolicy.FALLBACK;
    private static final int DEFAULT_FLINT_CONNECTIONS_MAX_WAIT_TIME_SECONDS = 11;
    private static final int DEFAULT_INIT_INTERVAL_SECONDS = 30;
    private static final int DEFAULT_MAX_NUMBER_OF_RETRIES = 3;
    private static final int DEFAULT_MAX_DOWN_INTERVAL_SECONDS = 4;
    private static final int DEFAULT_INACTIVE_INTERVAL_HOURS = 0;
    private static final boolean DEFAULT_ENCRYPT_TEMP_FILES = false;
    private static final boolean DEFAULT_USE_SSL_MUTUAL_AUTHENTICATION = false;
    private static final String DEFAULT_EPHEMERAL_PORT_RELATIVE_FILE = "../flint/flint.port";
    private static final String DEFAULT_FLINT_KEYSTORE_RELATIVE_PATH = "../flint/keystore.jks";
    private static final int DEFAULT_MIN_HEAP = 1024;
    private static final int DEFAULT_MAX_HEAP = 8192;
    private static final int DEFAULT_MAX_DIRECT = 512;
    private static final String DEFAULT_SPARK_THREADS = "*";
    private static final int DEFAULT_MIN_THRIFT_WORKERS = 5;
    private static final int DEFAULT_MAX_THRIFT_WORKERS = 1500;
    private static final int DEFAULT_MANAGED_DATASETS_LIMIT = -1;
    private static final String[] DEFAULT_EXTRA_JAVA_OPTIONS = new String[]{""};
    private static final boolean DEFAULT_METRICS_ENABLED = false;
    private static final boolean DEFAULT_JMX_PROMETHEUS_ENABLED = false;
    private static final int DEFAULT_JMX_PROMETHEUS_PORT = 8080;
    private static final int KEY_SIZE_FOR_ENCRYPTION_AT_REST = 256;
    public static final String CIPHER_FOR_ENCRYPTION_AT_REST = "AES/CTR/NoPadding";
    private static final int PORT_NUMBER_UPPER_BOUND = 65535;
    private boolean isFlintServerEnabled;
    private boolean isRestartOnConfChangeEnabled;
    private String host;
    private int port;
    private FlintServerLoadingPolicy flintServerLoadingPolicy;
    private FlintConnectionsPolicy flintConnectionsPolicy;
    private Duration flintConnectionsMaxWaitTime;
    private Duration initInterval;
    private int retryAttempts;
    private Duration downInterval;
    private Duration inactiveInterval;
    private String scratchDir;
    private String warehouseDir;
    private String buffersDirAsPlainPath;
    private String buffersDir;
    private String resultCacheDir;
    private boolean useTempEncryption;
    private boolean useSSLMutualAuthentication;
    private int keySizeLength;
    private int minHeapSize;
    private int maxHeapSize;
    private int maxDirectSize;
    private int minWorkers;
    private int maxWorkers;
    private int maxSparkThreads = -1;
    private String extraJavaOptions = "";
    private final Map<String, String> extraFlintConf = new HashMap<String, String>();
    private boolean isMetricsEnabled;
    private boolean isJmxPrometheusEnabled;
    private int jmxPrometheusPort;
    private volatile Instant lastLoadTime = Instant.now();

    private FlintServerManagerConfig() {
    }

    public static FlintServerManagerConfig load() {
        return new FlintServerManagerConfig().setFlintEnabled().setRestartOnConfChangeEnabled().setHost().setPort().setMemory().setSparkThreads().setThriftWorkers().setFlintServerLoadingPolicy().setFlintConnectionsPolicy().setFlintConnectionsMaxWaitTime().setInitInterval().setRetryAttempts().setDownInterval().setInactiveInterval().setEncryptTempFiles().setUseSSLMutualAuth().setScratchDir().setWarehouseDir().setBuffersDir().setResultCacheDir().setMetricsEnabled().setJmxPrometheus().setExtraJavaOptions().setExtraFlintConf();
    }

    public synchronized void reload() {
        this.setFlintEnabled().setRestartOnConfChangeEnabled().setHost().setPort().setMemory().setSparkThreads().setThriftWorkers().setFlintServerLoadingPolicy().setFlintConnectionsPolicy().setFlintConnectionsMaxWaitTime().setInitInterval().setRetryAttempts().setDownInterval().setInactiveInterval().setEncryptTempFiles().setUseSSLMutualAuth().setScratchDir().setWarehouseDir().setBuffersDir().setResultCacheDir().setMetricsEnabled().setJmxPrometheus().setExtraJavaOptions().setExtraFlintConf();
        this.lastLoadTime = Instant.now();
    }

    public Instant getLastLoadTime() {
        return this.lastLoadTime;
    }

    public boolean isFlintEnabled() {
        return this.isFlintServerEnabled;
    }

    public boolean isRestartOnConfChangeEnabled() {
        return this.isRestartOnConfChangeEnabled;
    }

    public boolean isMetricsEnabled() {
        return this.isMetricsEnabled;
    }

    public boolean isJmxPrometheusEnabled() {
        return this.isJmxPrometheusEnabled;
    }

    public int getJmxPrometheusPort() {
        return this.jmxPrometheusPort;
    }

    @Override
    public boolean useEncryptionForTempFiles() {
        return this.useTempEncryption;
    }

    @Override
    public boolean useSSLMutualAuthentication() {
        return this.useSSLMutualAuthentication;
    }

    public String getFlintEphemeralPortFilePath() {
        return ICCLCONFIG.resolveEffectivePath(DEFAULT_EPHEMERAL_PORT_RELATIVE_FILE);
    }

    public String getFlintJKSKeystorePath() {
        return ICCLCONFIG.resolveEffectivePath(DEFAULT_FLINT_KEYSTORE_RELATIVE_PATH);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public FlintServerLoadingPolicy getFlintServerLoadingPolicy() {
        return this.flintServerLoadingPolicy;
    }

    @Override
    public FlintConnectionsPolicy getFlintConnectionsPolicy() {
        return this.flintConnectionsPolicy;
    }

    public Duration getFlintConnectionsMaxWaitTime() {
        return this.flintConnectionsMaxWaitTime;
    }

    public Duration getInitInterval() {
        return this.initInterval;
    }

    public int getRetryAttempts() {
        return this.retryAttempts;
    }

    public Duration getDownInterval() {
        return this.downInterval;
    }

    public Duration getInactiveInterval() {
        return this.inactiveInterval;
    }

    public String getScratchDir() {
        return this.scratchDir;
    }

    public String getWarehouseDir() {
        return this.warehouseDir;
    }

    public String getBuffersDir() {
        return this.buffersDir;
    }

    public String getBuffersDirAsPlainPath() {
        return this.buffersDirAsPlainPath;
    }

    public String getResultCacheDir() {
        return this.resultCacheDir;
    }

    public int getKeySizeLengthForTempFilesEncryption() {
        return this.keySizeLength;
    }

    public String getSSLProtocol() throws CAMCryptoException {
        IConfiguration camConfiguration = Configuration.getInstanceWithDefaultConfig((boolean)false);
        return camConfiguration.getJSSEProtocolName();
    }

    public String getSupportedCiphers() {
        String[] cipherSuites = JCAMCrypto.getSupportedCipherSuites((SSLContext)JCAMCrypto.getSSLContext());
        StringJoiner sj = new StringJoiner(COMMA_STR);
        for (String cipher : cipherSuites) {
            sj.add(cipher);
        }
        return sj.toString();
    }

    public int getMinHeapSize() {
        return this.minHeapSize;
    }

    public int getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public int getMaxDirectSize() {
        return this.maxDirectSize;
    }

    public int getSparkThreads() {
        return this.maxSparkThreads;
    }

    public int getMinThriftWorkers() {
        return this.minWorkers;
    }

    public int getMaxThriftWorkers() {
        return this.maxWorkers;
    }

    public String getExtraJavaOptions() {
        return this.extraJavaOptions;
    }

    public Map<String, String> getExtraFlintConf() {
        return Collections.unmodifiableMap(this.extraFlintConf);
    }

    FlintServerManagerConfig setFlintEnabled() {
        this.isFlintServerEnabled = Boolean.parseBoolean(CONFIG.getStringProperty("queryExecution.flintServer[@enabled]", DEFAULT_FLINT_SERVER_ENABLED));
        LOGGER.log(String.format("Flint Server Enabled is set to: %s", this.isFlintServerEnabled));
        return this;
    }

    FlintServerManagerConfig setRestartOnConfChangeEnabled() {
        this.isRestartOnConfChangeEnabled = Boolean.parseBoolean(CONFIG.getStringProperty("queryExecution.flintServer.restartOnConfChange[@enabled]", DEFAULT_FLINT_SERVER_RESTART_ON_CONF_CHANGE_ENABLED));
        LOGGER.log(String.format("Restart on Configuration Change is set to: %s", this.isRestartOnConfChangeEnabled));
        return this;
    }

    FlintServerManagerConfig setHost() {
        this.host = CONFIG.getStringProperty("queryExecution.flintServer.host[@value]", DEFAULT_HOST);
        LOGGER.log(String.format(FLINT_HOST_FORMATTER, this.host));
        return this;
    }

    FlintServerManagerConfig setPort() {
        String portInput = Integer.toString(0);
        try {
            portInput = CONFIG.getStringProperty("queryExecution.flintServer.port[@value]", ICCLCONFIG.getValue("computeServicePort", false));
            if (portInput.length() == 0) {
                portInput = Integer.toString(0);
            }
        }
        catch (CCLConfigurationException e) {
            portInput = Integer.toString(0);
            LOGGER.log(LogLevel.WARN, PORT_NUMBER_NOT_CONFIGURED);
        }
        try {
            this.port = Integer.parseInt(portInput);
            if (this.port < 0 || this.port > 65535) {
                this.port = 0;
                LOGGER.log(LogLevel.WARN, String.format(INVALID_PORT_NUMBER_FORMATTER, portInput));
            }
        }
        catch (NumberFormatException nfe) {
            this.port = 0;
            LOGGER.log(LogLevel.WARN, String.format(INVALID_PORT_NUMBER_FORMATTER, portInput), (Throwable)nfe);
        }
        LOGGER.log(String.format(FLINT_PORT_FORMATTER, this.port));
        return this;
    }

    FlintServerManagerConfig setFlintServerLoadingPolicy() {
        String flintServerLoadingPolicyInput = CONFIG.getStringProperty(FLINT_SERVER_LOADING_POLICY_KEY, DEFAULT_FLINT_SERVER_LOADING_POLICY.getPolicyValue());
        if (FlintServerLoadingPolicy.EAGER.getPolicyValue().compareTo(flintServerLoadingPolicyInput) == 0) {
            this.flintServerLoadingPolicy = FlintServerLoadingPolicy.EAGER;
        } else if (FlintServerLoadingPolicy.LAZY.getPolicyValue().compareTo(flintServerLoadingPolicyInput) == 0) {
            this.flintServerLoadingPolicy = FlintServerLoadingPolicy.LAZY;
        } else {
            this.flintServerLoadingPolicy = DEFAULT_FLINT_SERVER_LOADING_POLICY;
            LOGGER.log(LogLevel.WARN, String.format(INVALID_FLINT_SERVER_POLICY_FORMATTER, flintServerLoadingPolicyInput, DEFAULT_FLINT_SERVER_LOADING_POLICY.getPolicyValue()));
        }
        LOGGER.log(String.format(FLINT_SERVER_POLICY_FORMATTER, this.flintServerLoadingPolicy.getPolicyValue()));
        return this;
    }

    FlintServerManagerConfig setFlintConnectionsPolicy() {
        String flintConnectionsPolicyInput = CONFIG.getStringProperty(FLINT_CONNECTIONS_ON_FLINT_NOT_RUNNING_POLICY_KEY, DEFAULT_FLINT_CONNECTIONS_POLICY.getPolicyValue());
        if (FlintConnectionsPolicy.FALLBACK.getPolicyValue().compareTo(flintConnectionsPolicyInput) == 0) {
            this.flintConnectionsPolicy = FlintConnectionsPolicy.FALLBACK;
        } else if (FlintConnectionsPolicy.ERROR.getPolicyValue().compareTo(flintConnectionsPolicyInput) == 0) {
            this.flintConnectionsPolicy = FlintConnectionsPolicy.ERROR;
        } else if (FlintConnectionsPolicy.WAIT.getPolicyValue().compareTo(flintConnectionsPolicyInput) == 0) {
            this.flintConnectionsPolicy = FlintConnectionsPolicy.WAIT;
        } else {
            this.flintConnectionsPolicy = DEFAULT_FLINT_CONNECTIONS_POLICY;
            LOGGER.log(LogLevel.WARN, String.format(INVALID_FLINT_CONNECTIONS_POLICY_FORMATTER, flintConnectionsPolicyInput, DEFAULT_FLINT_CONNECTIONS_POLICY.getPolicyValue()));
        }
        LOGGER.log(String.format(FLINT_CONNECTIONS_POLICY_FORMATTER, this.flintConnectionsPolicy.getPolicyValue()));
        return this;
    }

    FlintServerManagerConfig setFlintConnectionsMaxWaitTime() {
        String flintConnectionsMaxWaitTimeSecondsInput = CONFIG.getStringProperty(FLINT_CONNECTIONS_MAX_WAIT_TIME_KEY, Integer.toString(11));
        int flintConnectionsMaxWaitTimeSeconds = 0;
        try {
            flintConnectionsMaxWaitTimeSeconds = Integer.parseInt(flintConnectionsMaxWaitTimeSecondsInput);
            if (flintConnectionsMaxWaitTimeSeconds < 0) {
                flintConnectionsMaxWaitTimeSeconds = 11;
                LOGGER.log(LogLevel.WARN, String.format(INVALID_FLINT_CONNECTIONS_MAX_WAIT_TIME_FORMATTER, flintConnectionsMaxWaitTimeSecondsInput, 11));
            }
        }
        catch (NumberFormatException nfe) {
            flintConnectionsMaxWaitTimeSeconds = 11;
            LOGGER.log(LogLevel.WARN, String.format(INVALID_FLINT_CONNECTIONS_MAX_WAIT_TIME_FORMATTER, flintConnectionsMaxWaitTimeSecondsInput, 11), (Throwable)nfe);
        }
        LOGGER.log(String.format(FLINT_CONNECTIONS_WAIT_TIME_FORMATTER, flintConnectionsMaxWaitTimeSeconds));
        this.flintConnectionsMaxWaitTime = Duration.ofSeconds(flintConnectionsMaxWaitTimeSeconds);
        return this;
    }

    FlintServerManagerConfig setInitInterval() {
        String initIntervalSecondsInput = CONFIG.getStringProperty(INIT_INTERVAL_KEY, Integer.toString(30));
        int initIntervalSeconds = 0;
        try {
            initIntervalSeconds = Integer.parseInt(initIntervalSecondsInput);
            if (initIntervalSeconds <= 0) {
                initIntervalSeconds = 30;
                LOGGER.log(LogLevel.WARN, String.format(INVALID_FLINT_INIT_INTERVAL_FORMATTER, initIntervalSecondsInput, 30));
            }
        }
        catch (NumberFormatException nfe) {
            initIntervalSeconds = 30;
            LOGGER.log(LogLevel.WARN, String.format(INVALID_FLINT_INIT_INTERVAL_FORMATTER, initIntervalSecondsInput, 30), (Throwable)nfe);
        }
        LOGGER.log(String.format(FLINT_INIT_INTERVAL_FORMATTER, initIntervalSeconds));
        this.initInterval = Duration.ofSeconds(initIntervalSeconds);
        return this;
    }

    FlintServerManagerConfig setRetryAttempts() {
        String retryAttemptsInput = CONFIG.getStringProperty(RETRY_ATTEMPTS_KEY, Integer.toString(3));
        try {
            this.retryAttempts = Integer.parseInt(retryAttemptsInput);
            if (this.retryAttempts <= 0) {
                this.retryAttempts = 3;
                LOGGER.log(LogLevel.WARN, String.format(INVALID_FLINT_RETRY_ATTEMPTS_FORMATTER, retryAttemptsInput, 3));
            }
        }
        catch (NumberFormatException nfe) {
            this.retryAttempts = 3;
            LOGGER.log(LogLevel.WARN, String.format(INVALID_FLINT_RETRY_ATTEMPTS_FORMATTER, retryAttemptsInput, 3), (Throwable)nfe);
        }
        LOGGER.log(String.format(FLINT_RETRY_ATTEMPTS_FORMATTER, this.retryAttempts));
        return this;
    }

    FlintServerManagerConfig setDownInterval() {
        String downIntervalSecondsInput = CONFIG.getStringProperty(DOWN_INTERVAL_KEY, Integer.toString(4));
        int downIntervalSeconds = 0;
        try {
            downIntervalSeconds = Integer.parseInt(downIntervalSecondsInput);
            if (downIntervalSeconds < 0) {
                downIntervalSeconds = 4;
                LOGGER.log(LogLevel.WARN, String.format(INVALID_FLINT_DOWN_INTERVAL_FORMATTER, downIntervalSecondsInput, 4));
            }
        }
        catch (NumberFormatException nfe) {
            downIntervalSeconds = 4;
            LOGGER.log(LogLevel.WARN, String.format(INVALID_FLINT_DOWN_INTERVAL_FORMATTER, downIntervalSeconds, 4), (Throwable)nfe);
        }
        LOGGER.log(String.format(FLINT_DOWN_INTERVAL_FORMATTER, downIntervalSeconds));
        this.downInterval = Duration.ofSeconds(downIntervalSeconds);
        return this;
    }

    FlintServerManagerConfig setInactiveInterval() {
        String inactiveIntervalHoursInput = CONFIG.getStringProperty(INACTIVE_INTERVAL_KEY, Integer.toString(0));
        int inactiveIntervalHours = 0;
        try {
            inactiveIntervalHours = Integer.parseInt(inactiveIntervalHoursInput);
            if (inactiveIntervalHours < 0) {
                inactiveIntervalHours = 0;
                LOGGER.log(LogLevel.WARN, String.format(INVALID_FLINT_INACTIVE_INTERVAL_FORMATTER, inactiveIntervalHoursInput, 0));
            }
        }
        catch (NumberFormatException nfe) {
            inactiveIntervalHours = 0;
            LOGGER.log(LogLevel.WARN, String.format(INVALID_FLINT_INACTIVE_INTERVAL_FORMATTER, inactiveIntervalHoursInput, 0), (Throwable)nfe);
        }
        LOGGER.log(String.format(FLINT_INACTIVE_INTERVAL_FORMATTER, inactiveIntervalHours));
        this.inactiveInterval = Duration.ofHours(inactiveIntervalHours);
        return this;
    }

    FlintServerManagerConfig setScratchDir() {
        this.scratchDir = CONFIG.getXqeTempDirectory() + File.separator + FLINT_DIR + File.separator + "scratch";
        LOGGER.log(String.format(FLINT_SCRATCH_DIR_FORMATTER, this.scratchDir));
        return this;
    }

    FlintServerManagerConfig setWarehouseDir() {
        String warehouseDirPath = CONFIG.getXqeTempDirectory() + File.separator + FLINT_DIR + File.separator + "warehouse";
        this.warehouseDir = FlintUtils.getUnencryptedHadoopURIString(warehouseDirPath);
        LOGGER.log(String.format(FLINT_WAREHOUSE_DIR_FORMATTER, this.warehouseDir));
        return this;
    }

    FlintServerManagerConfig setBuffersDir() {
        String buffersDirPath;
        this.buffersDirAsPlainPath = buffersDirPath = CONFIG.getXqeTempDirectory() + File.separator + FLINT_DIR + File.separator + "buffers";
        this.buffersDir = FlintUtils.getUnencryptedHadoopURIString(buffersDirPath);
        LOGGER.log(String.format(FLINT_BUFFERS_DIR_FORMATTER, this.buffersDir));
        return this;
    }

    FlintServerManagerConfig setResultCacheDir() {
        String resultCacheDirPath = CONFIG.getXqeTempDirectory() + File.separator + FLINT_DIR + File.separator + "resultCache";
        this.resultCacheDir = FlintUtils.getUnencryptedHadoopURIString(resultCacheDirPath);
        LOGGER.log(String.format(FLINT_RESULT_CACHE_DIR_FORMATTER, this.resultCacheDir));
        return this;
    }

    FlintServerManagerConfig setEncryptTempFiles() {
        this.useTempEncryption = false;
        this.keySizeLength = 256;
        String value = null;
        try {
            value = ICCLCONFIG.getValue("encryptTemporaryFiles", false);
            this.useTempEncryption = Boolean.valueOf(value);
        }
        catch (CCLConfigurationException ccle) {
            LOGGER.log(LogLevel.WARN, String.format("Detected invalid value for 'encryptTemporaryFiles' cclconfig property: %s", value), (Throwable)ccle);
        }
        if (this.useTempEncryption) {
            try {
                int maxAllowedKeyLength = Cipher.getMaxAllowedKeyLength(CIPHER_FOR_ENCRYPTION_AT_REST);
                if (maxAllowedKeyLength < 256) {
                    this.keySizeLength = 128;
                    LOGGER.log(LogLevel.WARN, String.format("CCLConfig property 'encryptTemporaryFiles' is set to 'True' but the requirement to use KEY SIZE of '%s' is not met.\nIt is highly recommended for you\nto install the unrestricted JRE/JVM policy files.", 256));
                }
            }
            catch (NoSuchAlgorithmException nsae) {
                this.useTempEncryption = false;
                LOGGER.log(LogLevel.WARN, String.format("CCLConfig property 'encryptTemporaryFiles' is set to 'True' but '%s' cipher is not supported.\nCCLConfig property will be ignored.", CIPHER_FOR_ENCRYPTION_AT_REST), (Throwable)nsae);
            }
        }
        LOGGER.log(String.format(ENCRYPT_TEMP_FILES_FORMATTER, this.useTempEncryption));
        LOGGER.log(String.format(ENCRYPT_TEMP_FILES_KEYSIZELENGTH_FORMATTER, this.keySizeLength));
        return this;
    }

    FlintServerManagerConfig setUseSSLMutualAuth() {
        this.useSSLMutualAuthentication = false;
        try {
            IConfiguration camConfiguration = Configuration.getInstanceWithDefaultConfig((boolean)false);
            String internalDispatcherURI = camConfiguration.getInternalDispatcherURI();
            if (null != internalDispatcherURI && internalDispatcherURI.startsWith("https")) {
                this.useSSLMutualAuthentication = true;
            }
        }
        catch (CAMCryptoException came) {
            LOGGER.log(LogLevel.ERROR, CAM_CONFIG_NOT_INIT_ERROR, (Throwable)came);
        }
        LOGGER.log(String.format(USE_SSL_MUTUAL_AUTHENTICATION_FORMATTER, this.useSSLMutualAuthentication));
        return this;
    }

    FlintServerManagerConfig setMemory() {
        String minHeapValue = CONFIG.getStringProperty("queryExecution.flintServer.memory[@minHeap]", String.valueOf(1024));
        String maxHeapValue = CONFIG.getStringProperty("queryExecution.flintServer.memory[@maxHeap]", String.valueOf(8192));
        String maxDirectValue = CONFIG.getStringProperty("queryExecution.flintServer.memory[@maxDirect]", String.valueOf(512));
        boolean isMinHeapValueValid = true;
        boolean isMaxHeapValueValid = true;
        boolean isMaxDirectValueValid = true;
        try {
            this.minHeapSize = Integer.parseInt(minHeapValue);
            if (this.minHeapSize <= 0) {
                isMinHeapValueValid = false;
            }
        }
        catch (NumberFormatException nfe) {
            isMinHeapValueValid = false;
        }
        try {
            this.maxHeapSize = Integer.parseInt(maxHeapValue);
            if (this.maxHeapSize <= 0) {
                isMaxHeapValueValid = false;
            }
        }
        catch (NumberFormatException nfe) {
            isMaxHeapValueValid = false;
        }
        try {
            this.maxDirectSize = Integer.parseInt(maxDirectValue);
            if (this.maxDirectSize <= 0) {
                isMaxDirectValueValid = false;
            }
        }
        catch (NumberFormatException nfe) {
            isMaxDirectValueValid = false;
        }
        if (!isMinHeapValueValid) {
            this.minHeapSize = 1024;
            LOGGER.log(LogLevel.WARN, String.format(INVALID_MIN_HEAP_FORMATTER, minHeapValue, this.minHeapSize));
        }
        if (!isMaxHeapValueValid) {
            this.maxHeapSize = 8192;
            LOGGER.log(LogLevel.WARN, String.format(INVALID_MAX_HEAP_FORMATTER, maxHeapValue, this.maxHeapSize));
        }
        if (!isMaxDirectValueValid) {
            this.maxDirectSize = 512;
            LOGGER.log(LogLevel.WARN, String.format(INVALID_MAX_DIRECT_FORMATTER, maxDirectValue, this.maxDirectSize));
        }
        if (this.maxHeapSize < this.minHeapSize) {
            LOGGER.log(LogLevel.WARN, String.format(MIN_HEAP_BIGGER_THAN_MAX_HEAP_FORMATTER, this.minHeapSize, this.maxHeapSize));
            this.minHeapSize = 1024;
            this.maxHeapSize = 8192;
        }
        LOGGER.log(LogLevel.INFO, String.format(FINAL_MEMORY_ASSIGNMENT_FORMATTER, this.minHeapSize, this.maxHeapSize, this.maxDirectSize));
        return this;
    }

    FlintServerManagerConfig setSparkThreads() {
        String value = CONFIG.getStringProperty("queryExecution.flintServer.sparkThreads[@value]", "*");
        if (!"*".equals(value)) {
            try {
                this.maxSparkThreads = Integer.parseInt(value);
                if (this.maxSparkThreads <= 0) {
                    this.maxSparkThreads = -1;
                    LOGGER.log(LogLevel.WARN, String.format(INVALID_SPARK_THREADS_FORMATTER, value, "*"));
                }
            }
            catch (NumberFormatException nfe) {
                LOGGER.log(LogLevel.WARN, String.format(INVALID_SPARK_THREADS_FORMATTER, value, "*"));
            }
        }
        LOGGER.log(LogLevel.INFO, String.format(SPARK_THREADS_FORMATTER, value));
        return this;
    }

    FlintServerManagerConfig setThriftWorkers() {
        String minWorkersValue = CONFIG.getStringProperty("queryExecution.flintServer.thriftWorkers[@min]", String.valueOf(5));
        String maxWorkersValue = CONFIG.getStringProperty("queryExecution.flintServer.thriftWorkers[@max]", String.valueOf(1500));
        boolean isMinWorkersValueValid = true;
        boolean isMaxWorkersValueValid = true;
        try {
            this.minWorkers = Integer.parseInt(minWorkersValue);
            if (this.minWorkers <= 0) {
                isMinWorkersValueValid = false;
            }
        }
        catch (NumberFormatException nfe) {
            isMinWorkersValueValid = false;
        }
        try {
            this.maxWorkers = Integer.parseInt(maxWorkersValue);
            if (this.maxWorkers <= 0) {
                isMaxWorkersValueValid = false;
            }
        }
        catch (NumberFormatException nfe) {
            isMaxWorkersValueValid = false;
        }
        if (!isMinWorkersValueValid) {
            this.minWorkers = 5;
            LOGGER.log(LogLevel.WARN, String.format(INVALID_MIN_THRIFT_WORKERS_FORMATTER, minWorkersValue, this.minWorkers));
        }
        if (!isMaxWorkersValueValid) {
            this.maxWorkers = 1500;
            LOGGER.log(LogLevel.WARN, String.format(INVALID_MAX_THRIFT_WORKERS_FORMATTER, maxWorkersValue, this.maxWorkers));
        }
        if (this.maxWorkers < this.minWorkers) {
            LOGGER.log(LogLevel.WARN, String.format(MIN_THRIFT_WORKERS_BIGGER_THAN_MAX_THRIFT_WORKERS_FORMATTER, this.minWorkers, this.maxWorkers));
            this.minWorkers = 5;
            this.maxWorkers = 1500;
        }
        LOGGER.log(LogLevel.INFO, String.format(MIN_MAX_THRIFT_WORKERS_FORMATTER, this.minWorkers, this.maxWorkers));
        return this;
    }

    FlintServerManagerConfig setMetricsEnabled() {
        this.isMetricsEnabled = CONFIG.getBooleanProperty(METRICS_ENABLED_KEY, false);
        if (this.isMetricsEnabled) {
            LOGGER.log("Spark metrics are enabled.");
        } else {
            LOGGER.log("Spark metrics are not enabled.");
        }
        return this;
    }

    FlintServerManagerConfig setJmxPrometheus() {
        this.isJmxPrometheusEnabled = CONFIG.getBooleanProperty(METRICS_JMX_PROMETHEUS_ENABLED_KEY, false);
        if (this.isJmxPrometheusEnabled) {
            this.jmxPrometheusPort = CONFIG.getIntProperty(METRICS_JMX_PROMETHEUS_PORT_KEY, 8080);
            LOGGER.log(String.format("JMX Prometheus is enabled on port %d.", this.jmxPrometheusPort));
        }
        return this;
    }

    FlintServerManagerConfig setExtraJavaOptions() {
        String[] input = CONFIG.getStringArrayProperty("queryExecution.flintServer.extraJavaOptions[@value]", DEFAULT_EXTRA_JAVA_OPTIONS);
        StringJoiner sj = new StringJoiner(COMMA_STR);
        for (String in : input) {
            sj.add(in);
        }
        this.extraJavaOptions = sj.toString().trim();
        if (this.extraJavaOptions.isEmpty()) {
            LOGGER.log("No extra java options provided.");
        } else {
            LOGGER.log(String.format(EXTRA_JAVA_OPTIONS_FORMATTER, this.extraJavaOptions));
        }
        return this;
    }

    FlintServerManagerConfig setExtraFlintConf() {
        String input = CONFIG.getStringProperty("queryExecution.flintServer.extraFlintConf", null);
        this.extraFlintConf.clear();
        if (StringUtils.isEmpty((String)input)) {
            LOGGER.log("No extra Flint configuration provided.");
        } else {
            for (String kv : StringUtils.split((String)input, (String)";")) {
                String[] parts = StringUtils.split((String)StringUtils.stripStart((String)kv, null), (String)"=");
                if (parts.length != 2 || !StringUtils.isNotEmpty((String)parts[0])) continue;
                this.extraFlintConf.put(parts[0], parts[1]);
            }
            LOGGER.log(String.format(EXTRA_FLINT_CONF_FORMATTER, this.extraFlintConf));
        }
        this.extraFlintConf.put("flint.datasets.cache.limit", String.valueOf(FlintServerManagerConfig.extractManagedDatasetsLimit()));
        return this;
    }

    private FlintServerManagerConfig registerReloadListener() {
        CONFIG.registerConfigurationListener(new XQEConfigurationListener(){

            @Override
            public void configurationChanged(XQEConfigurationEvent event) {
                String propName = event.getPropertyName();
                if (propName.startsWith("queryExecution.flintServer.")) {
                    LOGGER.log(LogLevel.WARN, String.format("Detected a change to Flint server configuration (property: %s).", event.getPropertyName()));
                    FlintServerManagerConfig.this.reload();
                }
            }
        });
        return this;
    }

    static int extractManagedDatasetsLimit() {
        int managedDatasetsLimit = -1;
        String value = CONFIG.getStringProperty("queryExecution.flintServer.managedDatasetsLimit[@value]", String.valueOf(-1));
        try {
            managedDatasetsLimit = Integer.parseInt(value);
            if (0 >= managedDatasetsLimit) {
                managedDatasetsLimit = -1;
            }
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(LogLevel.WARN, String.format(INVALID_MANAGED_DATASETS_LIMIT_FORMATTER, value, -1));
            managedDatasetsLimit = -1;
        }
        LOGGER.log(LogLevel.INFO, String.format(MANAGED_DATASETS_LIMIT_FORMATTER, managedDatasetsLimit));
        return managedDatasetsLimit;
    }

    public static enum FlintConnectionsPolicy {
        FALLBACK("fallback"),
        ERROR("error"),
        WAIT("wait");

        private String policy;

        private FlintConnectionsPolicy(String thePolicy) {
            this.policy = thePolicy;
        }

        public String getPolicyValue() {
            return this.policy;
        }
    }

    public static enum FlintServerLoadingPolicy {
        EAGER("eager"),
        LAZY("lazy");

        private String policy;

        private FlintServerLoadingPolicy(String thePolicy) {
            this.policy = thePolicy;
        }

        public String getPolicyValue() {
            return this.policy;
        }
    }
}

