/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.datasets;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.RowType;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.relational.vectorization.TimestampColumnVector;
import com.cognos.xqe.util.primitive.ArrayListInt;
import com.ibm.ba.flint.thrift.types.DataType;
import com.ibm.ba.flint.thrift.types.Schema;
import com.ibm.ba.flint.thrift.types.SchemaField;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.Type;
import shaded.org.apache.hadoop.conf.Configuration;

public abstract class FlintUtils {
    public static final String HARD_LINK_FORMATTER = "_hl%02d";
    public static final String COPY_FILE_FORMATTER = "_cp%02d";
    public static final Pattern HARD_LINK_PATTERN = Pattern.compile("(.*)(_hl)([0-9]+)(\\.)(parquet|data)");
    public static final Pattern COPY_FILE_PATTERN = Pattern.compile("(.*)(_cp)([0-9]+)(\\.)(parquet|data)");
    public static final char DOT_CHAR = '.';
    private static final int TWO = 2;
    private static final int THREE = 3;
    private static final String SLASH_STR = "/";
    private static final char SLASH_CHAR = '/';
    private static final String ESCAPED_SLASH_STR = "//";
    private static final String UNDERSCORE = "_";
    private static final String BACKTICK = "`";
    public static final String JSON_ISTIME_TRUE = "{\"isTime\":true}";
    private static final String INVALID_FLINT_TYPE_MSG = "Invalid CA to FLINT data type conversion.";
    private static final String NULL_EMPTY_FLINT_CONN_STR_MSG = "The connection string cannot be null or an empty string.";
    private static final String INVALID_FLINT_CONN_STR_FORMATTER_MSG = "The provided flint connection string is illegal: %s.";
    public static final String FLINT_CONNECTION_STR_FORMATTER = ";LOCAL;FLINT;URL=thrift://%s:%d";
    public static final int MAX_PORT_NUMBER = 65535;
    public static final String FLINT_DATASET_NAME_PREFIX = "ft";
    private static final boolean IS_WINDOWS = System.getProperty("os.name").contains("indows");
    private static final Pattern HAS_DRIVE_LETTER_SPECIFIER = Pattern.compile("^/?[a-zA-Z]:");
    private static final Pattern VALID_FLINT_CONN_STR = Pattern.compile("^;LOCAL;FLINT;URL=thrift://(.+):(\\d+)");
    private static final String FILE_SCHEME = "file";
    private static final String EFILE_SCHEME = "efile";
    private static final String DEFAULT_LOGICAL_DS_NAME = "__flint__";
    private static final int DEFAULT_FLINT_QUERY_TIMEOUT_INTERVAL_VALUE = (int)TimeUnit.MINUTES.toSeconds(5L);
    private static final int MAX_FLINT_QUERY_TIMEOUT_INTERVAL_VALUE = (int)TimeUnit.HOURS.toSeconds(1L);
    private static final Configuration DEFAULT_HADOOP_CONF = FlintUtils.createDefaultHadoopConfiguration();

    private FlintUtils() {
    }

    public static Configuration getHadoopConfiguration() {
        return new Configuration(DEFAULT_HADOOP_CONF);
    }

    public static String constructConnectionString(String host, int port) {
        if (null == host || host.isEmpty()) {
            throw new IllegalArgumentException("host must be non-null and non-empty");
        }
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("port must be > 0 and <= 65535");
        }
        return String.format(FLINT_CONNECTION_STR_FORMATTER, host, port);
    }

    public static String getHostFromFlintConnectionString(String connString) {
        if (connString == null || connString.isEmpty()) {
            throw new IllegalArgumentException(NULL_EMPTY_FLINT_CONN_STR_MSG);
        }
        Matcher matcher = VALID_FLINT_CONN_STR.matcher(connString.trim());
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException(String.format(INVALID_FLINT_CONN_STR_FORMATTER_MSG, connString));
    }

    public static int getPortFromFlintConnectionString(String connString) {
        if (connString == null || connString.isEmpty()) {
            throw new IllegalArgumentException(NULL_EMPTY_FLINT_CONN_STR_MSG);
        }
        Matcher matcher = VALID_FLINT_CONN_STR.matcher(connString.trim());
        if (matcher.matches()) {
            return Integer.valueOf(matcher.group(2));
        }
        throw new IllegalArgumentException(String.format(INVALID_FLINT_CONN_STR_FORMATTER_MSG, connString));
    }

    public static String generateFlintDatasetName(String id, String logicalName) {
        StringBuilder result = new StringBuilder(FLINT_DATASET_NAME_PREFIX);
        result.append(id);
        if (null != logicalName) {
            result.insert(0, BACKTICK);
            result.append(UNDERSCORE);
            result.append(logicalName);
            result.append(BACKTICK);
        }
        return result.toString().replaceAll("\\.", UNDERSCORE).replaceAll("\\s+", UNDERSCORE);
    }

    public static String getLogicalDSName() {
        String logicalDSName = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getStringProperty("queryExecution.flintServer.logicalDataSourceName[@value]", DEFAULT_LOGICAL_DS_NAME);
        if (StringUtils.isEmpty((CharSequence)logicalDSName)) {
            logicalDSName = DEFAULT_LOGICAL_DS_NAME;
        }
        return logicalDSName;
    }

    public static int getQueryTimeoutInterval() {
        int queryTimeoutInterval = DEFAULT_FLINT_QUERY_TIMEOUT_INTERVAL_VALUE;
        try {
            String queryTimeoutIntervalInput = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getStringProperty("queryExecution.flintServer.queryTimeoutInterval[@value]", "");
            queryTimeoutInterval = Integer.parseInt(queryTimeoutIntervalInput);
        }
        catch (Exception e) {
            queryTimeoutInterval = DEFAULT_FLINT_QUERY_TIMEOUT_INTERVAL_VALUE;
        }
        if (queryTimeoutInterval <= 0 || queryTimeoutInterval > MAX_FLINT_QUERY_TIMEOUT_INTERVAL_VALUE) {
            queryTimeoutInterval = DEFAULT_FLINT_QUERY_TIMEOUT_INTERVAL_VALUE;
        }
        return queryTimeoutInterval;
    }

    public static Schema generateFlintSchema(MessageType pqSchema, RowType xqeRowType, ArrayListInt dateColIdxs, ArrayListInt timestampColIdxs) {
        Schema schema = new Schema();
        for (int index = 0; index < pqSchema.getFieldCount(); ++index) {
            DataType flintDataType;
            Type field = pqSchema.getType(index);
            String fieldName = field.getName();
            boolean isNullable = !field.isRepetition(Type.Repetition.REQUIRED);
            IDataType dataType = xqeRowType.getFieldDataType(index);
            String flintMetadata = null;
            switch (dataType.getCCLTypeCode()) {
                case 51: {
                    flintDataType = DataType.BOOLEAN;
                    break;
                }
                case 2: 
                case 4: {
                    flintDataType = DataType.SHORT;
                    break;
                }
                case 6: {
                    flintDataType = DataType.INT;
                    break;
                }
                case 8: {
                    flintDataType = DataType.LONG;
                    break;
                }
                case 12: {
                    flintDataType = DataType.DECIMAL;
                    break;
                }
                case 10: {
                    flintDataType = DataType.FLOAT;
                    break;
                }
                case 11: {
                    flintDataType = DataType.DOUBLE;
                    break;
                }
                case 57: {
                    if (dateColIdxs != null) {
                        dateColIdxs.add(index);
                    }
                    flintDataType = DataType.DATE;
                    break;
                }
                case 52: 
                case 58: {
                    if (timestampColIdxs != null) {
                        timestampColIdxs.add(index);
                    }
                    flintDataType = DataType.TIMESTAMP;
                    flintMetadata = JSON_ISTIME_TRUE;
                    break;
                }
                case 53: 
                case 59: {
                    if (timestampColIdxs != null) {
                        timestampColIdxs.add(index);
                    }
                    flintDataType = DataType.TIMESTAMP;
                    break;
                }
                case 45: 
                case 55: 
                case 56: {
                    flintDataType = DataType.STRING;
                    break;
                }
                case 23: {
                    flintDataType = DataType.BINARY;
                    break;
                }
                default: {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, INVALID_FLINT_TYPE_MSG);
                }
            }
            SchemaField schemaField = new SchemaField(fieldName, flintDataType, isNullable);
            schemaField.setMetadata(flintMetadata);
            if (flintDataType == DataType.DECIMAL) {
                schemaField.setPrecision(dataType.getPrecision());
                schemaField.setScale(dataType.getScale());
            }
            schema.addToFields(schemaField);
        }
        return schema;
    }

    public static void convertPQRowToFlintRow(Object[] pqRow, ArrayListInt dateColIdxs, ArrayListInt timestampColIdxs) {
        int index;
        int i;
        for (i = 0; i < dateColIdxs.size(); ++i) {
            index = dateColIdxs.get(i);
            Long msDate = (Long)pqRow[index];
            if (msDate == null) continue;
            Date dateValue = new Date(msDate);
            pqRow[index] = dateValue;
        }
        for (i = 0; i < timestampColIdxs.size(); ++i) {
            index = timestampColIdxs.get(i);
            TimestampColumnVector.UnixTimestamp uxTimestamp = (TimestampColumnVector.UnixTimestamp)pqRow[index];
            if (uxTimestamp == null) continue;
            Timestamp tsValue = new Timestamp(0L);
            tsValue.setTime(uxTimestamp.milliseconds);
            tsValue.setNanos(uxTimestamp.nanoseconds);
            pqRow[index] = tsValue;
        }
    }

    public static String getUnencryptedHadoopURIString(String pathAsString) {
        Path path = Paths.get(pathAsString, new String[0]).toAbsolutePath().normalize();
        return FlintUtils.generateHadoopURIString(FILE_SCHEME, null, path.toString(), null);
    }

    public static String getEncryptedHadoopURIString(String pathAsString) {
        Path path = Paths.get(pathAsString, new String[0]).toAbsolutePath().normalize();
        return FlintUtils.generateHadoopURIString(EFILE_SCHEME, null, path.toString(), null);
    }

    private static Configuration createDefaultHadoopConfiguration() {
        Configuration hadoopConf = new Configuration();
        hadoopConf.set("fs.file.impl", "shaded.org.apache.hadoop.fs.RawLocalFileSystem");
        hadoopConf.size();
        return hadoopConf;
    }

    private static String generateHadoopURIString(String scheme, String authority, String path, String fragment) {
        try {
            if (FlintUtils.hasWindowsDrive(path) && path.charAt(0) != '/') {
                path = SLASH_STR + path;
            }
            if (!IS_WINDOWS && path.charAt(0) != '/') {
                path = "./" + path;
            }
            URI uri = new URI(scheme, authority, FlintUtils.normalizePath(scheme, path), null, fragment).normalize();
            StringBuilder buffer = new StringBuilder();
            if (uri.getScheme() != null) {
                buffer.append(uri.getScheme());
                buffer.append(":");
            }
            if (uri.getAuthority() != null) {
                buffer.append(ESCAPED_SLASH_STR);
                buffer.append(uri.getAuthority());
            }
            if (uri.getPath() != null) {
                path = uri.getPath();
                if (path.indexOf(47) == 0 && FlintUtils.hasWindowsDrive(path) && uri.getScheme() == null && uri.getAuthority() == null) {
                    path = path.substring(1);
                }
                buffer.append(path);
            }
            if (uri.getFragment() != null) {
                buffer.append("#");
                buffer.append(uri.getFragment());
            }
            return buffer.toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static String normalizePath(String scheme, String path) {
        path = StringUtils.replace((String)path, (String)ESCAPED_SLASH_STR, (String)SLASH_STR);
        if (IS_WINDOWS && (FlintUtils.hasWindowsDrive(path) || scheme == null || scheme.isEmpty() || scheme.equals(FILE_SCHEME))) {
            path = StringUtils.replace((String)path, (String)"\\", (String)SLASH_STR);
        }
        int minLength = FlintUtils.startPositionWithoutWindowsDrive(path) + 1;
        if (path.length() > minLength && path.endsWith(SLASH_STR)) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static int startPositionWithoutWindowsDrive(String path) {
        if (FlintUtils.hasWindowsDrive(path)) {
            if (path.charAt(0) == '/') {
                return 3;
            }
            return 2;
        }
        return 0;
    }

    private static boolean hasWindowsDrive(String path) {
        return IS_WINDOWS && HAS_DRIVE_LETTER_SPECIFIER.matcher(path).find();
    }
}

