/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.datasets;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.datasets.MetadataInfo;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.FileDeleteStrategy;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public abstract class MetadataInfoFactory {
    public static final String MD_FILE_NAME = "metadataInfo.json";
    public static final String SUCCESS_FILE_NAME = "_SUCCESS";
    public static final String PATH_SEPARATOR = "/";
    public static final DateFormat DATE_FORMAT_UTC = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final XQELogger LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "DatasetManager", LogLevel.WARN);

    private MetadataInfoFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetadataInfo readMetadataInfo(String metadataDir) {
        MetadataInfo result;
        block9: {
            result = null;
            File successF = new File(metadataDir + PATH_SEPARATOR + SUCCESS_FILE_NAME);
            File metaInfoF = new File(metadataDir + PATH_SEPARATOR + MD_FILE_NAME);
            if (successF.exists() && metaInfoF.exists()) {
                FileInputStream metaInfoStream = null;
                try {
                    metaInfoStream = new FileInputStream(metaInfoF);
                    result = MetadataInfo.fromJSON(metaInfoStream);
                }
                catch (FileNotFoundException fe) {
                    block8: {
                        try {
                            if (!LOGGER.isOn(LogLevel.WARN)) break block8;
                            LOGGER.log("Cannot read metadataInfo.json file.", (Throwable)fe);
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(metaInfoStream);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((InputStream)metaInfoStream);
                }
                IOUtils.closeQuietly((InputStream)metaInfoStream);
            }
            if (result == null) {
                try {
                    FileUtils.deleteDirectory((File)new File(metadataDir));
                }
                catch (IOException ioe) {
                    if (!LOGGER.isOn(LogLevel.WARN)) break block9;
                    LOGGER.log("Deleting metadata directory due to corrupt contents during READ operation failed.", (Throwable)ioe);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean persistMetadataInfoToLocalFS(String metadataDir, MetadataInfo mdInfo) {
        boolean result = false;
        File mdDirectory = new File(metadataDir);
        if (!mdDirectory.exists()) {
            mdDirectory.mkdirs();
        }
        File successF = new File(metadataDir + PATH_SEPARATOR + SUCCESS_FILE_NAME);
        File metaInfoF = new File(metadataDir + PATH_SEPARATOR + MD_FILE_NAME);
        BufferedWriter writer = null;
        try {
            if (successF.exists()) {
                FileDeleteStrategy.FORCE.delete(successF);
            }
            if (metaInfoF.exists()) {
                FileDeleteStrategy.FORCE.delete(metaInfoF);
            }
            writer = Files.newBufferedWriter(metaInfoF.toPath(), new OpenOption[0]);
            writer.write(mdInfo.toJSONString());
            result = successF.createNewFile();
            IOUtils.closeQuietly((Writer)writer);
        }
        catch (IOException e) {
            if (LOGGER.isOn(LogLevel.WARN)) {
                LOGGER.log("Deleting contents of metadata directory during PERSIST operation failed.", (Throwable)e);
            }
        }
        finally {
            IOUtils.closeQuietly(writer);
        }
        return result;
    }
}

