/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.fds;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.xqe.ast.v5.query.V5DataItem;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTFunction;
import com.cognos.xqe.ast.v5Exp_new2.parser.ASTMultiPartIdentifier;
import com.cognos.xqe.ast.v5Exp_new2.parser.Node;
import com.cognos.xqe.ast.v5Exp_new2.visitor.V5ExpressionValidationVisitor;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.fds.FDSDataTypeEnum;
import com.cognos.xqe.util.fds.FDSException;
import com.cognos.xqe.util.fds.FunctionDLL;
import com.cognos.xqe.util.fds.FunctionNode;
import com.cognos.xqe.util.fds.FunctionPool;
import com.cognos.xqe.util.fds.FunctionPoolDLL;
import com.cognos.xqe.util.fds.FunctionPoolNode;
import com.cognos.xqe.util.fds.IFunctionDLL;
import com.cognos.xqe.util.fds.IFunctionDefinition;
import com.cognos.xqe.util.fds.IFunctionNode;
import com.cognos.xqe.util.fds.IFunctionParameter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class FunctionDefinition
implements IFunctionDefinition {
    private static final String EN_US = "en-us";
    private static final String EN = "en";
    private static final String DYNAMIC = "dynamic";
    private Locale locale;
    private FunctionNode root;
    private TreeMap<String, FunctionDLL> dlls = new TreeMap();
    private boolean dllsWereCreated = false;
    private boolean showHidden = false;
    private boolean showOnlyDimensional = false;
    private TreeMap<String, IFunctionNode> appFunctionIdToNode = new TreeMap();
    private TreeMap<String, IFunctionNode> appFunctionNameToNode = new TreeMap();
    private ArrayList<String> contextFilters = new ArrayList();
    private ArrayList<String> queryModeFilters = new ArrayList();
    private ArrayList<String> vendorFunctionSetFilters = new ArrayList();
    private ArrayList<IFunctionNode.FDSFunctionTypeEnum> typeFilters = new ArrayList();
    private TreeMap<String, IFunctionNode.FDSQoSLevelEnum> modelQosOverrides = new TreeMap();
    private TreeMap<String, IFunctionNode.FDSQoSLevelEnum> packageQosOverrides = new TreeMap();
    private TreeMap<String, String> modelQosReasonOverrides = new TreeMap();
    private TreeMap<String, String> packageQosReasonOverrides = new TreeMap();
    private TreeMap<FunctionPoolNode, FunctionNode> nodes = new TreeMap();
    TreeSet<String> modelDatasourceQueryTypeFilters = new TreeSet();
    TreeSet<String> modelDatasourceInterfaceIDFilters = new TreeSet();
    private static ICCLConfiguration gCCLCONFIG = null;

    public FunctionDefinition(Locale desiredLocale) {
        this.locale = desiredLocale;
        this.dllsWereCreated = false;
        this.showHidden = false;
        this.showOnlyDimensional = false;
        this.queryModeFilters.add(DYNAMIC);
        this.loadFunctionDefinitions();
        this.calculateEffectiveLocale(desiredLocale);
        this.loadFunctionDescriptionStrings();
    }

    public FunctionDefinition() {
        this.dllsWereCreated = false;
        this.showHidden = false;
        this.showOnlyDimensional = false;
        this.queryModeFilters.add(DYNAMIC);
        this.loadFunctionDefinitions();
        this.locale = null;
        FunctionPool.getInstance();
    }

    static FDSDataTypeEnum getFunctionReturnType(String fname) {
        FunctionPool pool = FunctionPool.getInstance();
        ArrayList<FunctionPoolNode> fnList = pool.findByName(fname);
        int size = fnList.size();
        if (0 == size) {
            String errorMsg = String.format("FDS: The function %s could not be found.", fname);
            throw new FDSException(errorMsg);
        }
        if (1 == size) {
            return fnList.get(0).getReturnType();
        }
        for (int i = 0; i < size; ++i) {
            FDSDataTypeEnum returnType = fnList.get(i).getReturnType();
            if (returnType.toFDSKeyword().contains("crx")) continue;
            return returnType;
        }
        return fnList.get(0).getReturnType();
    }

    static String getFunctionFormatType(String fname) {
        FunctionPool pool = FunctionPool.getInstance();
        ArrayList<FunctionPoolNode> fpList = pool.findByName(fname);
        int size = fpList.size();
        for (int i = 0; i < size; ++i) {
            String formatType = fpList.get(i).getFormatType();
            if (formatType.length() == 0) continue;
            return formatType;
        }
        return "";
    }

    static String getFunctionFormatTypeBasedOnVendorID(String fname, MetadataConnection mdc) {
        IFunctionDefinition funcDef = IFunctionDefinition.Factory.createFDAllLocales();
        funcDef.addContextFiltersForCQE();
        funcDef.showHidden();
        List<String> vendorIDList = mdc.getModelFunctionSetVendorIDs();
        for (String vendorID : vendorIDList) {
            funcDef.addVendorFunctionSetFilter(vendorID);
        }
        ArrayList<IFunctionNode> functionList = funcDef.findFuncListByName(fname);
        int size = functionList.size();
        for (int i = 0; i < size; ++i) {
            String formatType = functionList.get(i).getFormatType();
            if (formatType.length() == 0) continue;
            return formatType;
        }
        return "";
    }

    static String getFormatForSpec(String formatSpec) {
        FunctionPool pool = FunctionPool.getInstance();
        FunctionPoolNode format = pool.findById(formatSpec);
        if (format == null) {
            return "";
        }
        return format.getFormatType();
    }

    static TreeSet<String> getInterfaceIDs(IFunctionDefinition.InterfaceIDType idType) {
        return FunctionPoolNode.getInterfaceIDs(idType);
    }

    static boolean isInterfaceIDSupported(IFunctionDefinition.InterfaceIDType interfaceIDType, String interfaceID) {
        return FunctionPoolNode.isInterfaceIDSupported(interfaceIDType, interfaceID);
    }

    @Override
    public void addContextFilter(String theContext) {
        this.contextFilters.add(theContext);
    }

    @Override
    public void addContextFiltersForCQE() {
        this.contextFilters.add("tabular");
        this.contextFilters.add("crosstab");
    }

    @Override
    public void addModelDatasourceInterfaceIDFilter(String inputInterfaceID) {
        TreeSet<String> relInterfaceIDs;
        String interfaceID = inputInterfaceID;
        if (interfaceID != null && !this.modelDatasourceInterfaceIDFilters.contains(interfaceID = interfaceID.toUpperCase())) {
            this.modelDatasourceInterfaceIDFilters.add(interfaceID);
        }
        if ((relInterfaceIDs = FunctionDefinition.getInterfaceIDs(IFunctionDefinition.InterfaceIDType.eRelationalInterfaceIDs)).contains(interfaceID)) {
            this.addModelDatasourceQueryTypeFilter("relational");
        } else {
            this.addModelDatasourceQueryTypeFilter("multidimensional");
        }
    }

    @Override
    public void addModelDatasourceQueryTypeFilter(String qtName) {
        this.modelDatasourceQueryTypeFilters.add(qtName);
    }

    @Override
    public void addTypeFilter(String theTypeName) {
        IFunctionNode.FDSFunctionTypeEnum ftype = IFunctionNode.FDSFunctionTypeEnum.lookup(theTypeName);
        if (ftype != IFunctionNode.FDSFunctionTypeEnum.UNKNOWN) {
            this.typeFilters.add(ftype);
        }
    }

    @Override
    public void addVendorFunctionSetFilter(String id) {
        ArrayList<String> vendorFunctionSetIds = new ArrayList<String>();
        FunctionPool pool = FunctionPool.getInstance();
        pool.getVendorFunctionSetIds(vendorFunctionSetIds);
        if (vendorFunctionSetIds.contains(id)) {
            vendorFunctionSetIds.isEmpty();
        }
        this.vendorFunctionSetFilters.add(id);
    }

    @Override
    public IFunctionNode findById(String functionId) {
        FunctionPool pool = FunctionPool.getInstance();
        FunctionPoolNode node = pool.findById(functionId);
        if (node != null) {
            FunctionNode fnode = this.getNodeForPoolNode(node);
            return fnode;
        }
        IFunctionNode aNode = this.appFunctionIdToNode.get(functionId);
        if (aNode != null) {
            return aNode;
        }
        return null;
    }

    @Override
    public IFunctionNode findByName(String name) {
        FunctionPool pool = FunctionPool.getInstance();
        ArrayList<FunctionPoolNode> poolNodes = pool.findByName(name);
        for (int i = 0; i < poolNodes.size(); ++i) {
            FunctionPoolNode fpNode = poolNodes.get(i);
            if (!this.passesHiddenFilter(fpNode) || !this.passesDimensionalFilter(fpNode) || !this.passesTypeFilter(fpNode) || !this.passesContextFilter(fpNode) || !this.passesVendorFunctionSetFilter(fpNode) || !this.passesQueryModeFilter(fpNode)) continue;
            FunctionNode fnode = this.getNodeForPoolNode(fpNode);
            return fnode;
        }
        IFunctionNode aNode = this.appFunctionNameToNode.get(name);
        if (aNode != null) {
            return aNode;
        }
        return null;
    }

    @Override
    public ArrayList<IFunctionNode> findFuncListByName(String name) {
        FunctionPool pool = FunctionPool.getInstance();
        ArrayList<FunctionPoolNode> poolNodes = pool.findByName(name);
        ArrayList<IFunctionNode> funNodes = new ArrayList<IFunctionNode>();
        for (int i = 0; i < poolNodes.size(); ++i) {
            FunctionPoolNode fpNode = poolNodes.get(i);
            if (!this.passesHiddenFilter(fpNode) || !this.passesDimensionalFilter(fpNode) || !this.passesTypeFilter(fpNode) || !this.passesContextFilter(fpNode) || !this.passesVendorFunctionSetFilter(fpNode) || !this.passesQueryModeFilter(fpNode)) continue;
            FunctionNode fnode = this.getNodeForPoolNode(fpNode);
            funNodes.add(fnode);
        }
        IFunctionNode aNode = this.appFunctionNameToNode.get(name);
        if (aNode != null) {
            funNodes.add(aNode);
        }
        return funNodes;
    }

    @Override
    public IFunctionDefinition.MatchedFunction findFuncListByNameAndParameterTypes(ASTFunction function, String name, List<FDSDataTypeEnum> parameterTypes, boolean validateOLAPParameters) {
        FunctionPool pool = FunctionPool.getInstance();
        ArrayList<FunctionPoolNode> poolNodes = pool.findByName(name);
        ArrayList<IFunctionNode> funNodes = new ArrayList<IFunctionNode>();
        for (int i = 0; i < poolNodes.size(); ++i) {
            FunctionPoolNode fpNode = poolNodes.get(i);
            if (!this.passesHiddenFilter(fpNode) || !this.passesDimensionalFilter(fpNode) || !this.passesTypeFilter(fpNode) || !this.passesContextFilter(fpNode) || !this.passesVendorFunctionSetFilter(fpNode) || !this.passesQueryModeFilter(fpNode)) continue;
            FunctionNode fnode = this.getNodeForPoolNode(fpNode);
            funNodes.add(fnode);
        }
        IFunctionNode aNode = this.appFunctionNameToNode.get(name);
        if (aNode != null) {
            funNodes.add(aNode);
        }
        IFunctionDefinition.MatchedFunction matchedFunctions = new IFunctionDefinition.MatchedFunction();
        for (IFunctionNode functionNode : funNodes) {
            int functionMinOccurs = 0;
            int functionMaxOccurs = 0;
            for (IFunctionParameter functionParameter : functionNode.getParameters()) {
                List<FDSDataTypeEnum> types = functionParameter.getTypes();
                if (types.size() == 1 && types.get(0) == FDSDataTypeEnum.KEYWORD) continue;
                functionMinOccurs += functionParameter.getMinOccurs();
                if (functionMaxOccurs != -1) {
                    functionMaxOccurs += functionParameter.getMaxOccurs();
                }
                if (functionParameter.getMaxOccurs() != -1) continue;
                functionMaxOccurs = -1;
            }
            boolean countMatch = parameterTypes.size() >= functionMinOccurs && (functionMaxOccurs == -1 || parameterTypes.size() <= functionMaxOccurs);
            List<IFunctionDefinition.ParameterMismatch> mismatched = null;
            if (countMatch && (mismatched = functionNode.matchParameters(parameterTypes)) != null && !validateOLAPParameters) {
                for (int i = mismatched.size() - 1; i >= 0; --i) {
                    IFunctionDefinition.ParameterMismatch mismatch = mismatched.get(i);
                    if (!mismatch.isOLAPParameter()) continue;
                    boolean remove = true;
                    if (function != null) {
                        List<FDSDataTypeEnum> typeList = mismatch.getExpectedParameter().getTypes();
                        Node childNode = function.jjtGetChild(mismatch.getPosition());
                        if (typeList.contains((Object)FDSDataTypeEnum.MEMBERSET)) {
                            boolean bl = remove = !FunctionDefinition.hasCountDistinct(childNode);
                            if (remove) {
                                boolean bl2 = remove = V5ExpressionValidationVisitor.isTopBottomFunction(function) && !V5ExpressionValidationVisitor.isMeasure(childNode);
                            }
                        }
                    }
                    if (!remove) continue;
                    mismatched.remove(i);
                }
                if (mismatched.size() == 0) {
                    mismatched = null;
                }
            }
            if (countMatch && mismatched == null) {
                matchedFunctions.addExactMatch(functionNode);
                continue;
            }
            if (countMatch) {
                matchedFunctions.addNameCountMatch(functionNode, mismatched);
                continue;
            }
            matchedFunctions.addNameMatch(functionNode, functionMinOccurs);
        }
        return matchedFunctions;
    }

    public static boolean hasCountDistinct(Node childNode) {
        V5DataItem di;
        boolean result = false;
        if (childNode instanceof ASTMultiPartIdentifier && (di = (V5DataItem)((ASTMultiPartIdentifier)childNode).getPropertyValue("refDataItem")) != null && "countDistinct".equals(di.getAggregateProperty())) {
            result = true;
        }
        return result;
    }

    @Override
    public ArrayList<IFunctionDLL> getDLLs() {
        this.createDLLObjects();
        ArrayList<IFunctionDLL> theDlls = new ArrayList<IFunctionDLL>();
        Iterator<Map.Entry<String, FunctionDLL>> it = this.dlls.entrySet().iterator();
        if (it.hasNext()) {
            Map.Entry<String, FunctionDLL> pairs = it.next();
            FunctionDLL aDll = pairs.getValue();
            theDlls.add(aDll);
            return theDlls;
        }
        return null;
    }

    @Override
    public Locale getEffectiveLocale() {
        if (this.locale == null) {
            Locale enUsLocale = new Locale(EN_US);
            this.calculateEffectiveLocale(enUsLocale);
        }
        return this.locale;
    }

    @Override
    public TreeSet<String> getSupportedLocaleNames() {
        FunctionPool pool = FunctionPool.getInstance();
        TreeSet<String> supLocales = new TreeSet();
        supLocales = pool.getSupportedLocaleNames();
        return supLocales;
    }

    @Override
    public void getSupportedVendorFunctionSets(ArrayList<String> ids, ArrayList<String> names) {
        FunctionPool pool = FunctionPool.getInstance();
        pool.getVendorFunctionSets(this.getEffectiveLocale(), ids, names);
    }

    @Override
    public String getVendorFunctionSetName(String id) {
        ArrayList<String> vendorFunctionSetIds = new ArrayList<String>();
        ArrayList<String> vendorFunctionSetNames = new ArrayList<String>();
        Locale aLocale = new Locale(EN);
        FunctionPool pool = FunctionPool.getInstance();
        pool.getVendorFunctionSets(aLocale, vendorFunctionSetIds, vendorFunctionSetNames);
        if (!vendorFunctionSetIds.contains(id)) {
            return "";
        }
        return pool.getString(this.getEffectiveLocale(), id);
    }

    @Override
    public ArrayList<String> getSupportedModelDatasourceInterfaceIDs() {
        FunctionPool pool = FunctionPool.getInstance();
        ArrayList<String> functIds = pool.getSupportedModelDatasourceInterfaceIDs();
        return functIds;
    }

    @Override
    public IFunctionNode getRoot() {
        return this.root;
    }

    @Override
    public void addAppGroup(String functionId, IFunctionNode node) {
        if (!this.appFunctionIdToNode.containsKey(functionId)) {
            this.appFunctionIdToNode.put(functionId, node);
        }
    }

    public void addAppFunction(String functionId, String name, IFunctionNode node) {
        if (!this.appFunctionIdToNode.containsKey(functionId)) {
            this.appFunctionIdToNode.put(functionId, node);
        }
        if (!this.appFunctionNameToNode.containsKey(name)) {
            this.appFunctionNameToNode.put(name, node);
        }
    }

    @Override
    public void overrideModelQoSLevel(String functionId, IFunctionNode.FDSQoSLevelEnum qosLevel, String reason) {
        this.modelQosOverrides.put(functionId, qosLevel);
        if (reason.length() > 0) {
            this.modelQosReasonOverrides.put(functionId, reason);
        }
    }

    @Override
    public void overridePackageQoSLevel(String functionId, IFunctionNode.FDSQoSLevelEnum qosLevel, String reason) {
        if (!this.packageQosOverrides.containsKey(functionId)) {
            this.packageQosOverrides.put(functionId, qosLevel);
            if (reason != null && !reason.isEmpty()) {
                this.packageQosReasonOverrides.put(functionId, reason);
            }
            return;
        }
        IFunctionNode.FDSQoSLevelEnum existingQosLevel = this.packageQosOverrides.get(functionId);
        IFunctionNode.FDSQoSLevelEnum consolidatedLevel = IFunctionDefinition.Util.consolidateQosLevels(existingQosLevel, qosLevel);
        this.packageQosOverrides.put(functionId, consolidatedLevel);
        if (reason != null && !reason.isEmpty()) {
            String oldReason = this.packageQosReasonOverrides.get(functionId);
            String newReason = oldReason + "\n" + reason;
            this.packageQosReasonOverrides.put(functionId, newReason);
        }
    }

    @Override
    public void showHidden() {
        this.showHidden = true;
    }

    @Override
    public void showOnlyDimensional() {
        this.showOnlyDimensional = true;
    }

    IFunctionDLL getDLL(String dllName) {
        this.createDLLObjects();
        FunctionDLL functDll = null;
        if (this.dlls.containsKey(dllName)) {
            functDll = this.dlls.get(dllName);
        }
        return functDll;
    }

    IFunctionNode.FDSQoSLevelEnum getQoSLevel(String functionId) {
        IFunctionNode.FDSQoSLevelEnum qosLevel = IFunctionNode.FDSQoSLevelEnum.UNSPECIFIED;
        if (this.packageQosOverrides.containsKey(functionId)) {
            qosLevel = this.packageQosOverrides.get(functionId);
            return qosLevel;
        }
        if (this.modelQosOverrides.containsKey(functionId)) {
            qosLevel = this.modelQosOverrides.get(functionId);
            return qosLevel;
        }
        return null;
    }

    String getQoSReasonOverride(String functionId) {
        if (this.packageQosReasonOverrides.containsKey(functionId)) {
            return this.packageQosReasonOverrides.get(functionId);
        }
        if (this.modelQosReasonOverrides.containsKey(functionId)) {
            return this.modelQosReasonOverrides.get(functionId);
        }
        return "";
    }

    private void calculateEffectiveLocale(Locale desiredLocale) {
        TreeSet<String> supportedLocales = this.getSupportedLocaleNames();
        String effectLocaleName = this.resolveLocale(LocaleConverter.toString(desiredLocale), supportedLocales);
        if (effectLocaleName == null) {
            effectLocaleName = this.resolveLocale(LocaleConverter.getLanguage(desiredLocale), supportedLocales);
        }
        if (effectLocaleName == null) {
            effectLocaleName = this.resolveLocale(EN_US, supportedLocales);
        }
        if (effectLocaleName == null) {
            effectLocaleName = this.resolveLocale(EN, supportedLocales);
        }
        if (effectLocaleName == null) {
            String errorMsg = String.format("FDS: '%s' locale is not supported.", desiredLocale);
            throw new FDSException(errorMsg);
        }
        this.locale = new Locale(effectLocaleName);
    }

    private String resolveLocale(String userLocale, Set<String> supportedLocales) {
        String validatedLocale = "";
        String normalizedLocale = "";
        boolean isValid = false;
        try {
            normalizedLocale = gCCLCONFIG.normalizeLocale(userLocale);
            isValid = gCCLCONFIG.validateContentLocale(normalizedLocale);
        }
        catch (CCLConfigurationException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (isValid) {
            for (String supportedLocale : supportedLocales) {
                String tmpNormalizedLocale = null;
                try {
                    tmpNormalizedLocale = gCCLCONFIG.normalizeLocale(supportedLocale);
                }
                catch (CCLConfigurationException e) {
                    throw new RuntimeException(e.getMessage());
                }
                if (normalizedLocale.compareTo(tmpNormalizedLocale) != 0) continue;
                validatedLocale = normalizedLocale;
                return validatedLocale;
            }
            try {
                validatedLocale = gCCLCONFIG.mapContentLocale(normalizedLocale, false);
            }
            catch (CCLConfigurationException e) {
                return null;
            }
            if (supportedLocales.contains(validatedLocale)) {
                return validatedLocale;
            }
            for (String supportedLocale : supportedLocales) {
                try {
                    if (validatedLocale != gCCLCONFIG.mapContentLocale(supportedLocale.trim(), false)) continue;
                    validatedLocale = supportedLocale;
                    return validatedLocale;
                }
                catch (CCLConfigurationException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
        return null;
    }

    private void createDLLObjects() {
        if (!this.dllsWereCreated) {
            this.dllsWereCreated = true;
            FunctionPool pool = FunctionPool.getInstance();
            Map<String, FunctionPoolDLL> theDlls = pool.getDLLs();
            for (Map.Entry<String, FunctionPoolDLL> pairs : theDlls.entrySet()) {
                FunctionPoolDLL poolDLL = pairs.getValue();
                FunctionDLL fd = new FunctionDLL(poolDLL, this);
                this.dlls.put(poolDLL.getDLLName(), fd);
            }
        }
    }

    private void loadFunctionDefinitions() {
        FunctionPool pool = FunctionPool.getInstance();
        this.root = this.getNodeForPoolNode(pool.getRoot());
    }

    private void loadFunctionDescriptionStrings() {
        FunctionPool pool = FunctionPool.getInstance();
        pool.loadFunctionDescriptionStrings(this.getEffectiveLocale());
    }

    public FunctionNode getNodeForPoolNode(FunctionPoolNode thePoolNode) {
        if (null == thePoolNode) {
            return null;
        }
        if (this.nodes.containsKey(thePoolNode)) {
            return this.nodes.get(thePoolNode);
        }
        FunctionNode newNode = new FunctionNode(this, thePoolNode);
        this.nodes.put(thePoolNode, newNode);
        return newNode;
    }

    public boolean passesHiddenFilter(FunctionPoolNode fpNode) {
        if (fpNode.isHidden()) {
            return this.showHidden;
        }
        return true;
    }

    public boolean passesDimensionalFilter(FunctionPoolNode fpNode) {
        if (this.showOnlyDimensional) {
            return fpNode.isDimensional();
        }
        return true;
    }

    public boolean passesContextFilter(FunctionPoolNode fpNode) {
        if (this.contextFilters.isEmpty()) {
            return true;
        }
        FunctionPoolNode currentNode = fpNode;
        ArrayList<String> fcontexts = currentNode.getContexts();
        if (fcontexts.isEmpty()) {
            for (currentNode = currentNode.getParent(); currentNode != null && (fcontexts = currentNode.getContexts()).isEmpty(); currentNode = currentNode.getParent()) {
            }
        }
        if (fcontexts.isEmpty()) {
            return true;
        }
        for (String contextFilter : this.contextFilters) {
            if (!fcontexts.contains(contextFilter)) continue;
            return true;
        }
        return false;
    }

    public boolean passesQueryModeFilter(FunctionPoolNode fpNode) {
        FunctionPoolNode currentNode = fpNode;
        ArrayList<String> fQueryModes = currentNode.getQueryModes();
        if (fQueryModes.isEmpty()) {
            for (currentNode = currentNode.getParent(); currentNode != null && (fQueryModes = currentNode.getQueryModes()).isEmpty(); currentNode = currentNode.getParent()) {
            }
        }
        if (fQueryModes.isEmpty()) {
            return true;
        }
        for (String queryModeFilter : this.queryModeFilters) {
            if (!fQueryModes.contains(queryModeFilter)) continue;
            return true;
        }
        return false;
    }

    public boolean passesVendorFunctionSetFilter(FunctionPoolNode fpNode) {
        if (this.vendorFunctionSetFilters.isEmpty()) {
            return true;
        }
        ArrayList<String> fVendors = new ArrayList<String>();
        for (FunctionPoolNode currentNode = fpNode; currentNode != null; currentNode = currentNode.getParent()) {
            ArrayList<String> vendors = currentNode.getVendorFunctionSetIds();
            fVendors.addAll(vendors);
        }
        if (fVendors.isEmpty()) {
            return true;
        }
        for (int k = 0; k < this.vendorFunctionSetFilters.size(); ++k) {
            if (!fVendors.contains(this.vendorFunctionSetFilters.get(k))) continue;
            return true;
        }
        return false;
    }

    public boolean passesTypeFilter(FunctionPoolNode fpNode) {
        if (fpNode.getType() == IFunctionNode.FDSFunctionTypeEnum.FORMAT && this.typeFilters.isEmpty()) {
            return false;
        }
        if (this.typeFilters.isEmpty()) {
            return true;
        }
        if (IFunctionNode.FDSFunctionTypeEnum.GROUP == fpNode.getType()) {
            for (int k = 0; k < this.typeFilters.size(); ++k) {
                if (null == fpNode.countByType) {
                    return false;
                }
                if (fpNode.countByType.elementAt(this.typeFilters.get(k).getOrdinal()) == 0) continue;
                return true;
            }
            return false;
        }
        return this.typeFilters.contains((Object)fpNode.getType());
    }

    static {
        try {
            gCCLCONFIG = XQECCLConfigurationFactory.getInstance();
            if (gCCLCONFIG == null) {
                gCCLCONFIG = XQECCLConfigurationFactory.createConfiguration();
                gCCLCONFIG.init();
            }
        }
        catch (CCLConfigurationException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

