/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.fds;

import com.cognos.cclcfgapi.CCLConfigurationFactory;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.util.ResourceLocator;
import com.cognos.xqe.util.fds.FDSDataTypeEnum;
import com.cognos.xqe.util.fds.FDSException;
import com.cognos.xqe.util.fds.FunctionPool;
import com.cognos.xqe.util.fds.FunctionPoolDLL;
import com.cognos.xqe.util.fds.FunctionPoolParameter;
import com.cognos.xqe.util.fds.IFunctionDefinition;
import com.cognos.xqe.util.fds.IFunctionNode;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FunctionPoolNode
implements Comparable<FunctionPoolNode> {
    static Set<String> relInterfaceIDs = null;
    static Set<String> olapInterfaceIDs = null;
    static boolean interfaceIDsLoaded = false;
    private FunctionPoolNode parent;
    private String id;
    private String nameForLabel;
    private IFunctionNode.FDSFunctionTypeEnum functionType;
    private String canonicalName;
    private String canonicalExpression;
    private FDSDataTypeEnum returnType;
    private String formatType;
    private String usage;
    private ArrayList<FunctionPoolNode> children = null;
    private FunctionPoolDLL inDLL;
    private ArrayList<FunctionPoolParameter> parameters = new ArrayList();
    private IFunctionNode.FDSQoSLevelEnum qosLevel;
    boolean isHidden;
    boolean mayBeSupportedByAnotherModelDatasourceInterfaceID;
    boolean isMemberRelativeFunction;
    boolean dimensional;
    private ArrayList<String> vendorFunctionSetIds = new ArrayList();
    private ArrayList<String> contexts = new ArrayList();
    private ArrayList<String> queryModes = new ArrayList();
    private ArrayList<String> modelDatasourceInterfaceIDs = new ArrayList();
    private TreeMap<String, String> otherProperties = null;
    FunctionPool thePool;
    Vector<Integer> countByType = null;
    ArrayList<QosRule> gosRules = new ArrayList();

    public FunctionPoolNode(FunctionPool pool, IFunctionNode.FDSFunctionTypeEnum type) {
        this.functionType = type;
        this.qosLevel = IFunctionNode.FDSQoSLevelEnum.OK;
        this.isHidden = false;
        this.mayBeSupportedByAnotherModelDatasourceInterfaceID = false;
        this.isMemberRelativeFunction = false;
        this.dimensional = false;
        this.parent = null;
        this.children = null;
        this.thePool = pool;
        this.inDLL = null;
        this.otherProperties = null;
        this.countByType = null;
        this.canonicalExpression = "";
        this.canonicalName = "";
        this.returnType = null;
        this.formatType = "";
        this.usage = "";
    }

    public FunctionPoolNode(FunctionPool pool, FunctionPoolNode theParent, IFunctionNode.FDSFunctionTypeEnum type) {
        this.functionType = type;
        this.qosLevel = IFunctionNode.FDSQoSLevelEnum.OK;
        this.isHidden = false;
        this.mayBeSupportedByAnotherModelDatasourceInterfaceID = false;
        this.isMemberRelativeFunction = false;
        this.dimensional = false;
        this.parent = theParent;
        this.children = null;
        this.thePool = pool;
        this.inDLL = null;
        this.otherProperties = null;
        this.countByType = null;
        this.canonicalExpression = "";
        this.canonicalName = "";
        this.returnType = null;
        this.formatType = "";
        this.usage = "";
        if (this.parent != null) {
            this.parent.addChild(this);
        }
    }

    void addChild(FunctionPoolNode theChild) {
        if (IFunctionNode.FDSFunctionTypeEnum.GROUP != this.functionType) {
            return;
        }
        if (this.children == null) {
            this.children = new ArrayList();
            this.countByType = new Vector();
            int capasitySize = IFunctionNode.FDSFunctionTypeEnum.FT_LAST.getOrdinal() + 1;
            this.countByType.ensureCapacity(capasitySize);
            for (int i = 0; i < capasitySize; ++i) {
                this.countByType.add(0);
            }
        }
        this.children.add(theChild);
        IFunctionNode.FDSFunctionTypeEnum t = theChild.getType();
        Integer ordinal = t.getOrdinal();
        for (FunctionPoolNode goingUp = this; goingUp != null; goingUp = goingUp.getParent()) {
            int i = goingUp.countByType.get(ordinal);
            goingUp.countByType.set(ordinal, new Integer(++i));
        }
    }

    void addContext(String theContext) {
        this.contexts.add(theContext);
    }

    void addQueryMode(String theQueryMode) {
        this.queryModes.add(theQueryMode);
    }

    static synchronized void loadRelAndOlapInterfaceIDs() {
        if (interfaceIDsLoaded) {
            return;
        }
        XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String functionDir = xqeConfig.getConfigDirectory() + "/functions";
        ICCLConfiguration config = CCLConfigurationFactory.getInstance();
        File dir = new File(config.resolveEffectivePath(functionDir));
        ResourceLocator.IResourceMatcher[] paths = new ResourceLocator.IResourceMatcher[]{new ResourceLocator.DirectoryResourceMatcher(dir), new ResourceLocator.ClassResourceMatcher(FunctionPoolNode.class, "/META-INF/xqe/configuration/functions")};
        URL url = ResourceLocator.findURL("FuncTree.xsd", paths);
        if (url == null) {
            throw new FDSException("FDS: The file FuncTree.xsd is missing.");
        }
        Document doc = FunctionPool.parseXmlFile(url);
        relInterfaceIDs = new HashSet<String>();
        olapInterfaceIDs = new HashSet<String>();
        NodeList domSimpleTypeList = doc.getElementsByTagName("xs:simpleType");
        for (int i = 0; i < domSimpleTypeList.getLength(); ++i) {
            Element simpleTypeElem = (Element)domSimpleTypeList.item(i);
            String idAttrValue = simpleTypeElem.getAttribute("id");
            boolean isRelInterface = idAttrValue.equals("relational");
            boolean isMDInterface = idAttrValue.equals("multidimensional");
            if (!isRelInterface && !isMDInterface) continue;
            NodeList restrictionNodeList = simpleTypeElem.getElementsByTagName("xs:restriction");
            if (restrictionNodeList.getLength() > 0) {
                Element restrictionElem = (Element)restrictionNodeList.item(0);
                NodeList enumNodeList = restrictionElem.getElementsByTagName("xs:enumeration");
                for (int j = 0; j < enumNodeList.getLength(); ++j) {
                    Element enumerationElement = (Element)enumNodeList.item(j);
                    String interfaceIDValue = enumerationElement.getAttribute("value");
                    if (interfaceIDValue.length() <= 0) continue;
                    if (isRelInterface) {
                        relInterfaceIDs.add(interfaceIDValue);
                        continue;
                    }
                    if (!isMDInterface) continue;
                    olapInterfaceIDs.add(interfaceIDValue);
                }
            }
            if (!relInterfaceIDs.isEmpty() && !olapInterfaceIDs.isEmpty()) break;
        }
        interfaceIDsLoaded = true;
    }

    void addModelDatasourceInterfaceID(String theModelDatasourceInterfaceID) {
        FunctionPoolNode.loadRelAndOlapInterfaceIDs();
        if (theModelDatasourceInterfaceID.compareToIgnoreCase("all_rel") == 0) {
            for (String theIntId : relInterfaceIDs) {
                this.modelDatasourceInterfaceIDs.add(theIntId);
                this.thePool.registerModelDatasourceInterfaceID(theIntId);
            }
            return;
        }
        if (theModelDatasourceInterfaceID.compareToIgnoreCase("all_olap") == 0) {
            for (String theIntId : olapInterfaceIDs) {
                this.modelDatasourceInterfaceIDs.add(theIntId);
                this.thePool.registerModelDatasourceInterfaceID(theIntId);
            }
            return;
        }
        if (theModelDatasourceInterfaceID.indexOf(33, 0) != -1) {
            HashSet<String> allInterfaceIdsExceptOne = new HashSet<String>();
            allInterfaceIdsExceptOne.addAll(relInterfaceIDs);
            allInterfaceIdsExceptOne.addAll(olapInterfaceIDs);
            String idToExclude = theModelDatasourceInterfaceID.substring(1);
            for (String intID : allInterfaceIdsExceptOne) {
                if (!this.id.equals(idToExclude)) continue;
                allInterfaceIdsExceptOne.remove(intID);
                break;
            }
            for (String intID : allInterfaceIdsExceptOne) {
                this.modelDatasourceInterfaceIDs.add(intID);
                this.thePool.registerModelDatasourceInterfaceID(intID);
            }
            return;
        }
        this.modelDatasourceInterfaceIDs.add(theModelDatasourceInterfaceID);
        this.thePool.registerModelDatasourceInterfaceID(theModelDatasourceInterfaceID);
    }

    void addParameterType(FDSDataTypeEnum type) {
        FunctionPoolParameter fpParm = new FunctionPoolParameter(this.thePool, this);
        this.addParameter(fpParm);
        fpParm.addType(type);
    }

    void addParameter(FunctionPoolParameter theParm) {
        this.parameters.add(theParm);
    }

    void addProperty(String thePropertyName, String thePropertyValue) {
        if (this.otherProperties == null) {
            this.otherProperties = new TreeMap();
        }
        this.otherProperties.put(thePropertyName, thePropertyValue);
    }

    void addVendorFunctionSetId(String theVendorFunctionSetId) {
        this.vendorFunctionSetIds.add(theVendorFunctionSetId);
        this.thePool.registerVendorFunctionSetId(theVendorFunctionSetId);
    }

    ArrayList<FunctionPoolNode> getChildList() {
        return this.children;
    }

    String getCanonical() {
        return this.canonicalName;
    }

    String getCanonicalExpression() {
        return this.canonicalExpression;
    }

    ArrayList<String> getContexts() {
        return this.contexts;
    }

    ArrayList<String> getQueryModes() {
        return this.queryModes;
    }

    FunctionPoolDLL getDLL() {
        return this.inDLL;
    }

    public String getId() {
        return this.id;
    }

    String getNameForLabel() {
        return this.nameForLabel;
    }

    String getName(Locale loc) {
        String stringId = this.id;
        return this.thePool.getString(loc, stringId);
    }

    FunctionPoolNode getParent() {
        return this.parent;
    }

    FDSDataTypeEnum getReturnType() {
        return this.returnType;
    }

    String getFormatType() {
        return this.formatType;
    }

    String getUsage() {
        return this.usage;
    }

    FunctionPoolNode getSubgroupById(String groupId) {
        if (null == this.children) {
            return null;
        }
        for (FunctionPoolNode fNode : this.children) {
            if (!fNode.getId().equals(groupId)) continue;
            return fNode;
        }
        return null;
    }

    String getSyntax(Locale loc) {
        String stringId = this.id + ".syntax";
        return this.thePool.getString(loc, stringId);
    }

    String getTip(Locale loc) {
        String stringId = this.id + ".tip";
        return this.thePool.getString(loc, stringId);
    }

    ArrayList<String> getVendorFunctionSetIds() {
        return this.vendorFunctionSetIds;
    }

    ArrayList<String> getModelDatasourceInterfaceIDs() {
        return this.modelDatasourceInterfaceIDs;
    }

    IFunctionNode.FDSFunctionTypeEnum getType() {
        return this.functionType;
    }

    ArrayList<FunctionPoolParameter> getParameters() {
        return this.parameters;
    }

    IFunctionNode.FDSQoSLevelEnum getQoSLevel() {
        return this.qosLevel;
    }

    String getProperty(Locale loc, String prop) {
        boolean isLanguageSensitiveProperty = false;
        String myProp = "";
        String output = "";
        if (prop.length() != 0 && prop.substring(0, 1).equals("^")) {
            isLanguageSensitiveProperty = true;
            myProp = prop.substring(1);
        } else if (prop.length() == 0 || prop.equals("tip") || prop.equals("syntax") || prop.contains("resultdata.") || prop.contains("example.") || prop.contains("result.")) {
            isLanguageSensitiveProperty = true;
            myProp = prop;
        } else {
            isLanguageSensitiveProperty = false;
            myProp = prop;
        }
        if (isLanguageSensitiveProperty) {
            String stringId = this.id + "." + myProp;
            if (myProp.length() == 0) {
                stringId = this.id;
            }
            if (this.thePool.getString(loc, stringId) != null) {
                output = this.thePool.getString(loc, stringId);
            }
            return output;
        }
        if (prop.equals("type")) {
            IFunctionNode.FDSFunctionTypeEnum t = this.getType();
            return t.name().toLowerCase();
        }
        if (prop.equals("qosLevel")) {
            IFunctionNode.FDSQoSLevelEnum theQosLevel = this.getQoSLevel();
            return theQosLevel.name().toLowerCase();
        }
        if (this.otherProperties != null) {
            if (this.otherProperties.get(myProp) != null) {
                output = this.otherProperties.get(myProp);
            }
            return output;
        }
        return "";
    }

    boolean isGroup() {
        return this.children != null;
    }

    boolean isHidden() {
        return this.isHidden;
    }

    boolean mayBeSupportedByAnotherModelDatasourceInterfaceID() {
        for (FunctionPoolNode currentNode = this; currentNode != null; currentNode = currentNode.getParent()) {
            if (!currentNode.mayBeSupportedByAnotherModelDatasourceInterfaceID) continue;
            return true;
        }
        return false;
    }

    boolean isMemberRelativeFunction() {
        return this.isMemberRelativeFunction;
    }

    boolean isDimensional() {
        return this.dimensional;
    }

    void setCanonical(String canonical) {
        this.canonicalName = canonical;
    }

    void setCanonicalExpression(String canonExpression) {
        this.canonicalExpression = canonExpression;
    }

    void setDLL(FunctionPoolDLL dll) {
        this.inDLL = dll;
    }

    void setId(String funcID) {
        this.id = funcID;
    }

    void setName(String text) {
        this.nameForLabel = text;
    }

    void setReturnType(FDSDataTypeEnum type) {
        this.returnType = type;
    }

    void setFormatType(String text) {
        this.formatType = text;
    }

    void setUsage(String text) {
        this.usage = text;
    }

    void setQoSLevel(IFunctionNode.FDSQoSLevelEnum value) {
        this.qosLevel = value;
    }

    static TreeSet<String> getInterfaceIDs(IFunctionDefinition.InterfaceIDType interfaceIDType) {
        Iterator<String> iter;
        FunctionPoolNode.loadRelAndOlapInterfaceIDs();
        TreeSet<String> ids = new TreeSet<String>();
        if (interfaceIDType == IFunctionDefinition.InterfaceIDType.eRelationalInterfaceIDs || interfaceIDType == IFunctionDefinition.InterfaceIDType.eAll) {
            iter = relInterfaceIDs.iterator();
            while (iter.hasNext()) {
                ids.add(iter.next());
            }
        }
        if (interfaceIDType == IFunctionDefinition.InterfaceIDType.eMultidimensionalInterfaceIDs || interfaceIDType == IFunctionDefinition.InterfaceIDType.eAll) {
            iter = olapInterfaceIDs.iterator();
            while (iter.hasNext()) {
                ids.add(iter.next());
            }
        }
        return ids;
    }

    static boolean isInterfaceIDSupported(IFunctionDefinition.InterfaceIDType interfaceIDType, String interfaceID) {
        FunctionPoolNode.loadRelAndOlapInterfaceIDs();
        switch (interfaceIDType) {
            case eAll: {
                if (!relInterfaceIDs.contains(interfaceID) && !olapInterfaceIDs.contains(interfaceID)) break;
                return true;
            }
            case eRelationalInterfaceIDs: {
                if (!relInterfaceIDs.contains(interfaceID)) break;
                return true;
            }
            case eMultidimensionalInterfaceIDs: {
                if (!olapInterfaceIDs.contains(interfaceID)) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    void addQosRule(QosRule rule) {
        this.gosRules.add(rule);
    }

    @Override
    public int compareTo(FunctionPoolNode otherObject) {
        if (null == otherObject) {
            return -1;
        }
        if (this == otherObject) {
            return 0;
        }
        if (!(otherObject instanceof FunctionPoolNode)) {
            return -1;
        }
        String otherObjectId = otherObject.getId();
        String thisObjectId = this.getId();
        return thisObjectId.compareTo(otherObjectId);
    }

    class QosRule {
        private QosRuleType ruleType;
        private String ruleKey;
        private IFunctionNode.FDSQoSLevelEnum qosValue;

        QosRule(QosRuleType type, String rKey, IFunctionNode.FDSQoSLevelEnum value) {
            this.ruleType = type;
            this.ruleKey = rKey;
            this.qosValue = value;
        }

        QosRuleType getQosRuleType() {
            return this.ruleType;
        }

        String getQosRuleKey() {
            return this.ruleKey;
        }

        IFunctionNode.FDSQoSLevelEnum getQosRuleValue() {
            return this.qosValue;
        }
    }

    public static enum QosRuleType {
        eRDefault,
        eRDatasourceQueryType,
        eRDatasourceInterfaceID;

    }
}

