/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.fds;

import com.cognos.xqe.util.fds.FDSDataTypeEnum;
import com.cognos.xqe.util.fds.FunctionPool;
import com.cognos.xqe.util.fds.FunctionPoolNode;
import java.util.ArrayList;
import java.util.List;

public class FunctionPoolParameter {
    private List<FDSDataTypeEnum> parameterTypes;
    private int minOccurs = 1;
    private int maxOccurs = 1;
    private ENullableValue nullable = ENullableValue.kUnSpecified;

    static boolean isCompatibleWithNull(FDSDataTypeEnum parmType) {
        return !parmType.isOLAP() && parmType != FDSDataTypeEnum.KEYWORD;
    }

    FunctionPoolParameter(FunctionPool pool, FunctionPoolNode theFunction) {
        this.parameterTypes = new ArrayList<FDSDataTypeEnum>();
    }

    public String getTypeString() {
        StringBuilder buffer = new StringBuilder();
        boolean firstType = true;
        for (FDSDataTypeEnum dataType : this.parameterTypes) {
            if (firstType) {
                firstType = false;
            } else {
                buffer.append(" | ");
            }
            buffer.append(dataType.toFDSKeyword());
        }
        return buffer.toString();
    }

    List<FDSDataTypeEnum> getTypes() {
        return this.parameterTypes;
    }

    boolean getIsOptional() {
        return 0 == this.minOccurs;
    }

    int getMinOccurs() {
        return this.minOccurs;
    }

    int getMaxOccurs() {
        return this.maxOccurs;
    }

    boolean getIsNullable() {
        switch (this.nullable) {
            case kTrue: {
                return true;
            }
            case kFalse: {
                return false;
            }
        }
        for (FDSDataTypeEnum paramType : this.parameterTypes) {
            if (FunctionPoolParameter.isCompatibleWithNull(paramType)) continue;
            return false;
        }
        return true;
    }

    void setIsOptional(boolean opt) {
        if (opt) {
            this.minOccurs = 0;
        } else if (0 == this.minOccurs) {
            this.minOccurs = 1;
        }
    }

    void addType(FDSDataTypeEnum theParameterType) {
        this.parameterTypes.add(theParameterType);
    }

    void setType(FDSDataTypeEnum theParameterType) {
        this.parameterTypes.clear();
        this.parameterTypes.add(theParameterType);
    }

    void setMinOccurs(int minOccurrences) {
        this.minOccurs = minOccurrences;
    }

    void setMaxOccurs(int maxOccurrences) {
        if (maxOccurrences == 0) {
            maxOccurrences = -1;
        }
        this.maxOccurs = maxOccurrences;
    }

    void setIsNullable(ENullableValue nullableValue) {
        this.nullable = nullableValue;
    }

    public static enum ENullableValue {
        kUnSpecified,
        kTrue,
        kFalse;

    }
}

