/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.fsm;

import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.concurrent.locks.LockManager;
import com.cognos.xqe.util.fsm.IStateGovernor;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class StateMachine<StateType, ContextType> {
    private static final long WAIT_STEP = 1000L;
    private final AtomicReference<StateType> mState = new AtomicReference<Object>(null);
    private final ConcurrentLinkedQueue<IStateGovernor<StateType, ContextType>> mGovernors = new ConcurrentLinkedQueue();
    protected LockManager mLockManager;
    protected long lockWaitTime;
    protected String stateUniqueName;

    public StateMachine(StateType initialState, ContextType ctx, LockManager lockManager, long waitTime) {
        this.mState.set(initialState);
        this.mLockManager = lockManager;
        this.lockWaitTime = waitTime;
        this.stateUniqueName = UniqueNameGenerator.createUniqueName(ctx.toString(), "state");
        this.mLockManager.createLocks(this.stateUniqueName);
    }

    public final StateType getState() {
        return this.mState.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(StateType state) {
        this.acquireLock(this.stateUniqueName, true, this.lockWaitTime);
        try {
            this.mState.set(state);
        }
        finally {
            this.releaseLock(this.stateUniqueName, true);
        }
        AtomicReference<StateType> atomicReference = this.mState;
        synchronized (atomicReference) {
            this.mState.notifyAll();
        }
    }

    public final boolean canTransition(StateType to, ContextType ctx) {
        StateType from = this.mState.get();
        for (IStateGovernor<StateType, ContextType> governor : this.mGovernors) {
            if (governor.canTransition(from, to, ctx)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean extendedTransition(StateType to, ContextType ctx) {
        block23: {
            boolean stateChanged = false;
            IStateGovernor<StateType, ContextType>[] governors = this.getGovernors();
            try {
                this.acquireLock(this.stateUniqueName, true, ctx);
                try {
                    StateType from = this.mState.get();
                    for (IStateGovernor<StateType, ContextType> governor : governors) {
                        if (governor.canTransition(from, to, ctx)) continue;
                        boolean bl = false;
                        return bl;
                    }
                    for (IStateGovernor<StateType, ContextType> governor : governors) {
                        governor.beforeTransition(from, to, ctx);
                    }
                    if (this.mState.compareAndSet(from, to)) {
                        stateChanged = true;
                        for (IStateGovernor<StateType, ContextType> governor : governors) {
                            governor.afterTransition(from, to, ctx);
                        }
                        break block23;
                    }
                    for (IStateGovernor<StateType, ContextType> governor : governors) {
                        governor.failedTransition(from, to, ctx);
                    }
                    throw new IllegalStateException(String.format("Illegal state transition from \"%s\" to \"%s\"", from.toString(), to.toString()));
                }
                finally {
                    this.releaseLock(this.stateUniqueName, true);
                }
            }
            finally {
                if (stateChanged) {
                    AtomicReference<StateType> atomicReference = this.mState;
                    synchronized (atomicReference) {
                        this.mState.notifyAll();
                    }
                }
            }
        }
        return true;
    }

    public final boolean testAndExecuteAtomically(StateType expected, Runnable runnable, ContextType ctx) {
        HashSet<StateType> set = new HashSet<StateType>();
        set.add(expected);
        return this.testAndExecuteAtomically((Set<StateType>)set, runnable, ctx);
    }

    public final boolean testAndExecuteAtomically(Set<StateType> expected, Runnable runnable, ContextType ctx) {
        return this.testAndExecuteAtomically(expected, runnable, ctx, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean testAndExecuteAtomically(Set<StateType> expected, Runnable runnable, ContextType ctx, boolean exclusive) {
        if (!expected.contains(this.mState.get())) {
            return false;
        }
        this.acquireLock(this.stateUniqueName, exclusive, ctx);
        try {
            if (!expected.contains(this.mState.get())) {
                boolean bl = false;
                return bl;
            }
            runnable.run();
        }
        finally {
            this.releaseLock(this.stateUniqueName, exclusive);
        }
        return true;
    }

    public final void acquireStateLock(ContextType ctx) {
        this.acquireLock(this.stateUniqueName, false, ctx);
    }

    public final void releaseStateLock() {
        this.releaseLock(this.stateUniqueName, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForTransition(StateType from, StateType to, long timeout, TimeUnit unit, ContextType ctx) throws InterruptedException {
        StateType currentState;
        long timeLeft = unit.toNanos(timeout);
        while ((currentState = this.mState.get()) != to) {
            if (currentState != from) {
                throw new IllegalStateException("Unexpected state: " + currentState);
            }
            if (timeLeft <= 0L) {
                return false;
            }
            long start = System.nanoTime();
            AtomicReference<StateType> atomicReference = this.mState;
            synchronized (atomicReference) {
                try {
                    this.mState.wait(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            timeLeft -= System.nanoTime() - start;
        }
        return true;
    }

    private IStateGovernor<StateType, ContextType>[] getGovernors() {
        return this.mGovernors.toArray(new IStateGovernor[0]);
    }

    public final void addGovernor(IStateGovernor<StateType, ContextType> governor) {
        this.mGovernors.add(governor);
    }

    public final void removeGovernor(IStateGovernor<StateType, ContextType> governor) {
        this.mGovernors.remove(governor);
    }

    public void removeLocks() {
        if (this.mLockManager != null) {
            this.mLockManager.removeLocks(this.stateUniqueName);
            this.mLockManager = null;
        }
    }

    private static <StateType> void throwIllegalStateTransition(IStateGovernor<?, ?> governor, StateType from, StateType to) {
        throw new IllegalStateException(String.format("Illegal state transition from \"%s\" to \"%s\" reported by governor %s.", from.toString(), to.toString(), governor.toString()));
    }

    protected void acquireLock(String resource, boolean exclusive, ContextType ctx) {
        this.acquireLock(resource, exclusive, this.lockWaitTime);
    }

    protected void acquireLock(String resource, boolean exclusive, long waitTime) {
        if (exclusive) {
            this.mLockManager.acquireLockInExclusiveMode(resource, waitTime);
        } else {
            this.mLockManager.acquireLockInSharedMode(resource, waitTime);
        }
    }

    protected void releaseLock(String resource, boolean exclusive) {
        if (exclusive) {
            this.mLockManager.releaseLockInExclusiveMode(resource);
        } else {
            this.mLockManager.releaseLockInSharedMode(resource);
        }
    }
}

