/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.io;

import com.cognos.xqe.util.pool.DirectByteBufferPool;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public final class FileChannelInputStream
extends InputStream {
    private static final int BYTE_MASK = 255;
    private final FileChannel mChannel;
    private final DirectByteBufferPool mBufferPool;
    private ByteBuffer mBuffer;
    private boolean mEOF = false;

    public FileChannelInputStream(FileChannel channel, DirectByteBufferPool bufferPool) throws IOException {
        this.mChannel = channel;
        this.mBufferPool = bufferPool;
        this.mBuffer = this.mBufferPool.borrowBuffer();
        this.mBuffer.position(this.mBuffer.limit());
    }

    @Override
    public int read() throws IOException {
        if (this.mEOF) {
            return -1;
        }
        if (!this.mBuffer.hasRemaining() && !this.fillBuffer()) {
            return -1;
        }
        return 0xFF & this.mBuffer.get();
    }

    @Override
    public int read(byte[] buf) throws IOException {
        if (this.mEOF) {
            return -1;
        }
        if (!this.mBuffer.hasRemaining() && !this.fillBuffer()) {
            return -1;
        }
        int len = Math.min(this.mBuffer.remaining(), buf.length);
        this.mBuffer.get(buf, 0, len);
        return len;
    }

    @Override
    public int read(byte[] buf, int offset, int length) throws IOException {
        if (this.mEOF) {
            return -1;
        }
        if (!this.mBuffer.hasRemaining() && !this.fillBuffer()) {
            return -1;
        }
        int len = Math.min(this.mBuffer.remaining(), length);
        this.mBuffer.get(buf, offset, len);
        return len;
    }

    @Override
    public void close() throws IOException {
        if (null != this.mBuffer) {
            this.mBufferPool.returnBuffer(this.mBuffer);
            this.mBuffer = null;
            this.mEOF = true;
            this.mChannel.close();
        }
    }

    public long getPosition() throws IOException {
        return this.mChannel.position() - (long)this.mBuffer.remaining();
    }

    public void setPosition(long pos) throws IOException {
        this.mChannel.position(pos);
        this.mBuffer.limit(this.mBuffer.capacity());
        this.mBuffer.position(this.mBuffer.limit());
        this.mEOF = false;
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    private boolean fillBuffer() throws IOException {
        this.mBuffer.clear();
        this.mChannel.read(this.mBuffer);
        this.mBuffer.flip();
        if (this.mBuffer.hasRemaining()) {
            return true;
        }
        this.mEOF = true;
        return false;
    }
}

