/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.util.io;

import com.cognos.xqe.util.pool.DirectByteBufferPool;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public final class FileChannelOutputStream
extends OutputStream {
    private static final int LOW_BYTE_MASK = 255;
    private final FileChannel mChannel;
    private final DirectByteBufferPool mBufferPool;
    private ByteBuffer mBuffer;

    public FileChannelOutputStream(FileChannel channel, DirectByteBufferPool bufferPool) throws IOException {
        this.mChannel = channel;
        this.mBufferPool = bufferPool;
        this.mBuffer = this.mBufferPool.borrowBuffer();
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.mBuffer.hasRemaining()) {
            this.flush();
        }
        this.mBuffer.put((byte)(b & 0xFF));
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int offset, int length) throws IOException {
        while (length > 0) {
            if (!this.mBuffer.hasRemaining()) {
                this.flush();
            }
            int bytesToWrite = Math.min(length, this.mBuffer.remaining());
            this.mBuffer.put(buf, offset, bytesToWrite);
            offset += bytesToWrite;
            length -= bytesToWrite;
        }
    }

    @Override
    public void close() throws IOException {
        if (null != this.mBuffer) {
            this.flush();
            this.mBufferPool.returnBuffer(this.mBuffer);
            this.mBuffer = null;
            this.mChannel.close();
        }
    }

    public long getPosition() throws IOException {
        return this.mChannel.position() + (long)this.mBuffer.position();
    }

    @Override
    public void flush() throws IOException {
        this.mBuffer.flip();
        if (this.mBuffer.hasRemaining()) {
            while (this.mChannel.write(this.mBuffer) <= 0) {
                Thread.yield();
            }
            this.mBuffer.compact();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }
}

